/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.spi;

import ceylon.modules.spi.ArgumentType;

public enum Argument {
    EXECUTABLE("executable", ArgumentType.IMPL, 1, new String[0]),
    CACHE_CONTENT("cache_content", ArgumentType.IMPL, 0, new String[0]),
    IMPLEMENTATION("impl", ArgumentType.IMPL, 2, new String[0]),
    RUN("run", ArgumentType.CEYLON, 1, new String[0]),
    CWD("cwd", ArgumentType.CEYLON, 1, new String[0]),
    REPOSITORY("rep", ArgumentType.CEYLON, 1, new String[0]),
    SYSTEM_REPOSITORY("sysrep", ArgumentType.CEYLON, 1, new String[0]),
    CACHE_REPOSITORY("cacherep", ArgumentType.CEYLON, 1, new String[0]),
    MAVEN_OVERRIDES("maven-overrides", ArgumentType.CEYLON, 1, new String[0]),
    OVERRIDES("overrides", ArgumentType.CEYLON, 1, new String[0]),
    DOWNGRADE_DIST("downgrade-dist", ArgumentType.CEYLON, 0, new String[0]),
    NO_DEFAULT_REPOSITORIES("nodefreps", ArgumentType.CEYLON, 0, new String[0]),
    SOURCE("src", ArgumentType.CEYLON, 1, new String[0]),
    VERBOSE("verbose", ArgumentType.CEYLON, 1, new String[0]),
    OFFLINE("offline", ArgumentType.CEYLON, 0, new String[0]),
    AUTO_EXPORT_MAVEN_DEPENDENCIES("auto-export-maven-dependencies", ArgumentType.CEYLON, 0, new String[0]),
    HELP("help", ArgumentType.CEYLON, 0, "h", "-help"),
    VERSION("version", ArgumentType.CEYLON, 0, "v", "-version");

    private String value;
    private int requiredValues = 0;
    private ArgumentType argumentType;
    private String[] aliases;

    private Argument(String value, ArgumentType type, int requiredValues, String ... aliases) {
        this.value = value;
        this.argumentType = type;
        this.requiredValues = requiredValues;
        this.aliases = aliases;
    }

    public int getRequiredValues() {
        return this.requiredValues;
    }

    public static Argument forArgumentName(String name, ArgumentType type) {
        for (Argument argument : Argument.values()) {
            if (argument.argumentType != type) continue;
            if (argument.value.equals(name)) {
                return argument;
            }
            for (String alias : argument.aliases) {
                if (!alias.equals(name)) continue;
                return argument;
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

