/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.log.Logger;

public class CeylondLogger
implements Logger {
    private boolean richFormatting;
    private boolean verbose;
    private int errors;

    public CeylondLogger(boolean richFormatting, boolean verbose) {
        this.richFormatting = richFormatting;
        this.verbose = verbose;
    }

    public int getErrors() {
        return this.errors;
    }

    @Override
    public void error(String str) {
        ++this.errors;
        if (this.richFormatting) {
            System.err.println(OSUtil.color("Error", OSUtil.Color.red) + ": " + str);
        } else {
            System.err.println("Error: " + str);
        }
    }

    @Override
    public void warning(String str) {
        if (this.richFormatting) {
            System.err.println(OSUtil.color("Warning", OSUtil.Color.yellow) + ": " + str);
        } else {
            System.err.println("Warning: " + str);
        }
    }

    @Override
    public void info(String str) {
        if (this.richFormatting) {
            System.err.println(OSUtil.color("Note", OSUtil.Color.green) + ": " + str);
        } else {
            System.err.println("Note: " + str);
        }
    }

    @Override
    public void debug(String str) {
        if (this.verbose) {
            System.err.println("Debug: " + str);
        }
    }
}

