/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import java.io.IOException;
import java.io.Writer;

public class Markup {
    protected final Writer writer;

    public Markup(Writer writer) {
        this.writer = writer;
    }

    protected void write(String ... text) throws IOException {
        for (String s : text) {
            this.writer.append(s);
        }
    }

    protected void tag(String ... tags) throws IOException {
        for (String tag : tags) {
            this.writer.append("<").append(tag).append("/>\n");
        }
    }

    protected void around(String tag, String ... text) throws IOException {
        this.open(tag);
        for (String s : text) {
            this.writer.append(s);
        }
        int space = tag.indexOf(" ");
        if (space > -1) {
            tag = tag.substring(0, space);
        }
        this.close(tag);
    }

    protected void close(String ... tags) throws IOException {
        for (String tag : tags) {
            this.writer.append("</").append(tag).append(">");
        }
    }

    protected void open(String ... tags) throws IOException {
        for (String tag : tags) {
            this.writer.append("<").append(tag).append(">");
        }
    }

    protected void openTable(String id, String title, int columnCount, boolean isBodyExpanded) throws IOException {
        this.open("table id='" + id + "' class='table table-condensed table-bordered table-hover'");
        this.open("thead");
        this.open("tr class='table-header' title='Click for expand/collapse'");
        this.open("td colspan='" + columnCount + "'");
        if (isBodyExpanded) {
            this.around("i class='icon-expand'", new String[0]);
        } else {
            this.around("i class='icon-collapse'", new String[0]);
        }
        this.write(title);
        this.close("td");
        this.close("tr");
        this.close("thead");
        if (isBodyExpanded) {
            this.open("tbody");
        } else {
            this.open("tbody style='display: none'");
        }
    }

    protected void closeTable() throws IOException {
        this.close("tbody", "table");
    }

    protected void text(String ... text) throws IOException {
        for (String s : text) {
            this.write(s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
        }
    }
}

