/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractNodeRepositoryManager;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.SimpleRepositoryManager;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CachingRepositoryManager
extends AbstractNodeRepositoryManager {
    private RepositoryManager caching;
    private final File cachingDir;

    public CachingRepositoryManager(StructureBuilder root, File cachingDir, Logger log) {
        super(log, null);
        if (root == null) {
            throw new IllegalArgumentException("Null structure builder!");
        }
        this.setAddCacheAsRoot(true);
        this.setCache(new DefaultRepository(root.createRoot()));
        this.caching = new SimpleRepositoryManager(new FileContentStore(cachingDir), log);
        this.cachingDir = cachingDir;
    }

    public CachingRepositoryManager(CmrRepository root, File cachingDir, Logger log) {
        super(log, null);
        if (root == null) {
            throw new IllegalArgumentException("Null root!");
        }
        this.setAddCacheAsRoot(true);
        this.setCache(root);
        this.caching = new SimpleRepositoryManager(new FileContentStore(cachingDir), log);
        this.cachingDir = cachingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArtifactResult getArtifactResult(ArtifactContext context, Node node) throws RepositoryException {
        try {
            ArtifactResult result = this.caching.getArtifactResult(context);
            if (result != null) {
                boolean valid = false;
                File file = result.artifact();
                if (file.exists()) {
                    long lm = node.getLastModified();
                    boolean bl = valid = lm == -1L || lm < file.lastModified();
                }
                if (valid) {
                    return result;
                }
            }
            boolean previous = context.isForceOperation();
            context.setForceOperation(true);
            try {
                context.setSuffixes(ArtifactContext.getSuffixFromNode(node));
                this.caching.putArtifact(context, node.getInputStream());
            }
            finally {
                context.setForceOperation(previous);
            }
            return this.caching.getArtifactResult(context);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void putArtifact(ArtifactContext context, InputStream content) throws RepositoryException {
        this.caching.putArtifact(context, content);
        File file = this.caching.getArtifact(context);
        try {
            super.putArtifact(context, new FileInputStream(file));
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    public String toString() {
        return "CachingRepositoryManager: " + this.getCache();
    }

    public File getCacheFolder() {
        return this.cachingDir;
    }
}

