/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolverAndModuleInfoReader;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.DependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyResolvers;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.BytecodeUtils;
import com.redhat.ceylon.cmr.impl.MavenRepository;
import com.redhat.ceylon.cmr.impl.OSGiDependencyResolver;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import java.util.logging.Logger;

public class Configuration {
    private static DependencyResolver mavenResolver;
    private static AbstractDependencyResolverAndModuleInfoReader jsResolver;
    private static AbstractDependencyResolverAndModuleInfoReader npmResolver;
    public static final String MAVEN_RESOLVER_CLASS = "com.redhat.ceylon.cmr.maven.MavenDependencyResolver";
    public static final String JS_RESOLVER_CLASS = "com.redhat.ceylon.cmr.impl.JSUtils";
    public static final String NPM_RESOLVER_CLASS = "com.redhat.ceylon.cmr.impl.NpmUtils";

    public static DependencyResolver getMavenResolver() {
        if (mavenResolver == null) {
            mavenResolver = Configuration.getResolver(MAVEN_RESOLVER_CLASS);
        }
        return mavenResolver;
    }

    public static AbstractDependencyResolverAndModuleInfoReader getJavaScriptResolver() {
        if (jsResolver == null) {
            jsResolver = (AbstractDependencyResolverAndModuleInfoReader)Configuration.getResolver(JS_RESOLVER_CLASS);
        }
        return jsResolver;
    }

    public static AbstractDependencyResolverAndModuleInfoReader getNpmResolver() {
        if (npmResolver == null) {
            npmResolver = (AbstractDependencyResolverAndModuleInfoReader)Configuration.getResolver(NPM_RESOLVER_CLASS);
        }
        return npmResolver;
    }

    public static DependencyResolvers getResolvers(RepositoryManager manager) {
        AbstractDependencyResolverAndModuleInfoReader npmResolver;
        DependencyResolver mavenResolver;
        DependencyResolvers resolvers = new DependencyResolvers();
        resolvers.addResolver(BytecodeUtils.INSTANCE);
        AbstractDependencyResolverAndModuleInfoReader jsResolver = Configuration.getJavaScriptResolver();
        if (jsResolver != null) {
            resolvers.addResolver(jsResolver);
        }
        resolvers.addResolver(PropertiesDependencyResolver.INSTANCE);
        resolvers.addResolver(XmlDependencyResolver.INSTANCE);
        resolvers.addResolver(OSGiDependencyResolver.INSTANCE);
        if (Configuration.usesMaven(manager) && (mavenResolver = Configuration.getMavenResolver()) != null) {
            resolvers.addResolver(mavenResolver);
        }
        if ((npmResolver = Configuration.getNpmResolver()) != null) {
            resolvers.addResolver(npmResolver);
        }
        return resolvers;
    }

    private static boolean usesMaven(RepositoryManager manager) {
        if (manager != null) {
            for (CmrRepository repo : manager.getRepositories()) {
                if (!(repo instanceof MavenRepository)) continue;
                return true;
            }
        }
        return false;
    }

    private static DependencyResolver getResolver(String className) {
        try {
            ClassLoader cl = Configuration.class.getClassLoader();
            DependencyResolver resolver = (DependencyResolver)cl.loadClass(className).newInstance();
            return resolver;
        }
        catch (Throwable t) {
            Logger.getLogger(Configuration.class.getName()).warning(String.format("Cannot add resolver %s - %s", className, t));
            return null;
        }
    }
}

