/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.MavenRepository;
import com.redhat.ceylon.cmr.impl.RemoteContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.net.Proxy;

public class MavenRepositoryHelper {
    static File getMavenHome() {
        File mvnHome = new File(System.getProperty("user.home"), ".m2/repository");
        if (mvnHome.exists()) {
            return mvnHome;
        }
        String property = System.getProperty("maven.home");
        if (property != null && (mvnHome = new File(property, "repository")).exists()) {
            return mvnHome;
        }
        throw new IllegalArgumentException("No Maven repository found!");
    }

    public static CmrRepository getMavenRepository() {
        return new MavenRepository(new MavenContentStore().createRoot());
    }

    public static CmrRepository getMavenRepository(File mvnRepository) {
        return new MavenRepository(new MavenContentStore(mvnRepository).createRoot());
    }

    public static CmrRepository getMavenRepository(String repositoryURL, Logger log, boolean offline, int timeout, Proxy proxy) {
        return new MavenRepository(new RemoteContentStore(repositoryURL, log, offline, timeout, proxy).createRoot());
    }

    public static CmrRepository getMavenRepository(StructureBuilder structureBuilder) {
        return new MavenRepository(structureBuilder.createRoot());
    }

    private static class MavenContentStore
    extends FileContentStore {
        private MavenContentStore() {
            this(MavenRepositoryHelper.getMavenHome());
        }

        private MavenContentStore(File root) {
            super(root);
        }

        @Override
        protected void delete(File file, Node node) {
        }

        @Override
        public boolean canHandleFolders() {
            return false;
        }
    }
}

