/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class ModulesDependencyResolver
extends AbstractDependencyResolver {
    private final String descriptorName;

    protected ModulesDependencyResolver(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        ArtifactResult result = context.result();
        File mod = result.artifact();
        if (mod != null && mod.getName().toLowerCase().endsWith(".jar")) {
            String descriptorPath;
            InputStream descriptor;
            if (!context.ignoreInner() && (descriptor = IOUtils.findDescriptor(result, descriptorPath = this.getQualifiedMetaInfDescriptorName(result.name(), result.version()))) != null) {
                try {
                    ModuleInfo moduleInfo = this.augment(result, this.resolveFromInputStream(descriptor, result.name(), result.version(), overrides));
                    return moduleInfo;
                }
                finally {
                    IOUtils.safeClose(descriptor);
                }
            }
            if (!context.ignoreExternal()) {
                File artifact = result.artifact();
                File mp = new File(artifact.getParent(), this.descriptorName);
                if (!mp.exists()) {
                    String qualifiedDescriptorName = this.getQualifiedToplevelDescriptorName(result.name(), result.version());
                    mp = new File(artifact.getParent(), qualifiedDescriptorName);
                }
                return this.augment(result, this.resolveFromFile(mp, result.name(), result.version(), overrides));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModuleInfo augment(ArtifactResult result, ModuleInfo ret) {
        if (ret == null) {
            return null;
        }
        if (ret.getGroupId() != null) {
            return ret;
        }
        if (result.artifact() == null) return ret;
        try (ZipFile zf = new ZipFile(result.artifact());){
            String part;
            int sep;
            ZipEntry entry;
            String path;
            Enumeration<? extends ZipEntry> entries = zf.entries();
            do {
                if (!entries.hasMoreElements()) return ret;
            } while (!(path = (entry = entries.nextElement()).getName()).startsWith("META-INF/maven/") || !path.endsWith("/pom.xml") || (sep = (part = path.substring(15, path.length() - 8)).indexOf(47)) == -1);
            String groupId = part.substring(0, sep);
            String artifactId = part.substring(sep + 1);
            ModuleInfo moduleInfo = new ModuleInfo(ret.getName(), ret.getVersion(), groupId, artifactId, ret.getFilter(), ret.getDependencies());
            return moduleInfo;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public String getQualifiedMetaInfDescriptorName(String module, String version2) {
        return String.format("META-INF/jbossmodules/%s/%s/" + this.descriptorName, module.replace('.', '/'), version2);
    }

    public String getQualifiedToplevelDescriptorName(String module, String version2) {
        return String.format("%s-%s-" + this.descriptorName, module, version2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModuleInfo resolveFromFile(File mp, String name, String version2, Overrides overrides) {
        if (!mp.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(mp);){
            ModuleInfo moduleInfo = this.resolveFromInputStream(is, name, version2, overrides);
            return moduleInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Node descriptor(Node artifact) {
        return NodeUtils.firstParent(artifact).getChild(this.descriptorName);
    }
}

