/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResourceArtifactCreatorImpl
implements ArtifactCreator {
    private final RepositoryManager repoManager;
    private final Iterable<? extends File> sourcePaths;
    private final Iterable<? extends File> resourcePaths;
    private final String resourceRootName;
    private final String moduleName;
    private final String moduleVersion;
    private boolean verbose;
    private Logger log;

    public ResourceArtifactCreatorImpl(RepositoryManager repoManager, Iterable<? extends File> sourcePaths, Iterable<? extends File> resourcePaths, String resourceRootName, String moduleName, String moduleVersion, boolean verbose, Logger log) throws IOException {
        this.repoManager = repoManager;
        this.sourcePaths = sourcePaths;
        this.resourcePaths = resourcePaths;
        this.resourceRootName = resourceRootName;
        this.moduleName = moduleName;
        this.moduleVersion = moduleVersion;
        this.verbose = verbose;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> copy(Collection<String> resFiles) throws IOException {
        if (resFiles == null || resFiles.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<String, File> toCopy = new HashMap<String, File>();
        for (String res : resFiles) {
            File relRes = this.getDestinationFile(this.moduleName, res);
            if (relRes == null) continue;
            toCopy.put(res, relRes);
        }
        if (toCopy.isEmpty()) {
            return Collections.emptySet();
        }
        ArtifactContext ac = new ArtifactContext(null, this.moduleName, this.moduleVersion, "module-resources");
        ac.setThrowErrorIfMissing(false);
        File resDir = Files.createTempDirectory("ceylon-resources-", new FileAttribute[0]).toFile();
        try {
            for (Map.Entry res : toCopy.entrySet()) {
                FileUtil.copy(null, new File((String)res.getKey()), resDir, (File)res.getValue());
            }
            this.repoManager.putArtifact(ac, resDir);
        }
        finally {
            FileUtil.deleteQuietly(resDir);
        }
        return new HashSet<String>(resFiles);
    }

    private File getDestinationFile(String moduleName, String file) {
        File relRes = new File(FileUtil.relativeFile(this.resourcePaths, file));
        String resModName = ModuleUtil.moduleName(this.sourcePaths, relRes);
        if (resModName.equals(moduleName)) {
            return this.handleRoot(moduleName, relRes);
        }
        return null;
    }

    private File handleRoot(String moduleName, File relRes) {
        if (!ModuleUtil.isDefaultModule(moduleName)) {
            String rootName = this.resourceRootName;
            if (rootName == null) {
                rootName = "ROOT";
            }
            if (!rootName.isEmpty()) {
                File modulePath = ModuleUtil.moduleToPath(moduleName);
                File rrp = new File(modulePath, rootName);
                if (relRes.toPath().startsWith(rrp.toPath())) {
                    relRes = rrp.toPath().relativize(relRes.toPath()).toFile();
                }
            }
        }
        return relRes;
    }

    @Override
    public Iterable<? extends File> getPaths() {
        return this.resourcePaths;
    }
}

