/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import com.redhat.ceylon.cmr.api.ArtifactCallbackStream;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.AbstractNodeRepositoryManager;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileArtifactResult;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.RootNode;
import com.redhat.ceylon.cmr.impl.VerifiedDownload;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.Repositories;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class RootRepositoryManager
extends AbstractNodeRepositoryManager {
    private final FileContentStore fileContentStore;

    private static File getRootDir() {
        Repositories.Repository rootRepo = Repositories.get().getCacheRepository();
        return new File(rootRepo.getUrl());
    }

    public RootRepositoryManager(Logger log, Overrides overrides) {
        this(RootRepositoryManager.getRootDir(), log, overrides);
    }

    public RootRepositoryManager(Logger log, Overrides overrides, boolean upgradeDist) {
        this(RootRepositoryManager.getRootDir(), log, overrides, upgradeDist);
    }

    public RootRepositoryManager(File rootDir, Logger log, Overrides overrides) {
        this(rootDir, log, overrides, true);
    }

    public RootRepositoryManager(File rootDir, Logger log, Overrides overrides, boolean upgradeDist) {
        super(log, overrides, upgradeDist);
        if (rootDir != null) {
            this.fileContentStore = new FileContentStore(rootDir);
            DefaultRepository aaca = new DefaultRepository(new RootNode(this.fileContentStore, this.fileContentStore));
            this.setCache(aaca);
        } else {
            this.fileContentStore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArtifactResult getArtifactResult(ArtifactContext context, Node node) throws RepositoryException {
        if (node.isRemote()) {
            boolean forceOp = context.isForceOperation();
            try {
                FileArtifactResult fileArtifactResult;
                context.setForceOperation(true);
                this.log.debug("Looking up artifact " + context + " from " + node + " to cache it");
                SizedInputStream sizedInputStream = node.getSizedInputStream();
                if (sizedInputStream == null) {
                    throw new RepositoryException("Node " + node + " for repository " + this + " returned a null stream");
                }
                try {
                    this.log.debug(" -> Found it, now caching it");
                    File file = this.putContent(context, node, sizedInputStream.getInputStream(), sizedInputStream.getSize());
                    this.log.debug("    Caching done: " + file);
                    String repositoryDisplayString = NodeUtils.getRepositoryDisplayString(node);
                    File originalRepoFile = new File(file.getParentFile(), file.getName().concat(".origin"));
                    FileWriter writer = new FileWriter(originalRepoFile, false);
                    try {
                        writer.write(repositoryDisplayString);
                        writer.close();
                    }
                    catch (IOException e) {
                        this.log.error(e.toString());
                    }
                    fileArtifactResult = new FileArtifactResult(NodeUtils.getRepository(node), this, context.getName(), context.getVersion(), file, repositoryDisplayString);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.safeClose(sizedInputStream.getInputStream());
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RepositoryException(e);
                    }
                }
                IOUtils.safeClose(sizedInputStream.getInputStream());
                return fileArtifactResult;
            }
            finally {
                context.setForceOperation(forceOp);
            }
        }
        return this.toArtifactResult(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArtifactResult artifactNotFound(ArtifactContext context) throws RepositoryException {
        block21: {
            Node parent;
            boolean hasRemote = false;
            StringBuilder reps = new StringBuilder();
            for (CmrRepository rep : this.getRepositories()) {
                if (!rep.getRoot().isRemote() || this.isOffline(rep)) continue;
                hasRemote = true;
                reps.append(rep.getDisplayString());
                reps.append('\n');
            }
            if (hasRemote && this.cache != null && (parent = this.cache.findParent(context)) != null) {
                context.toNode(parent);
                try {
                    File parentDir = this.fileContentStore.getFile(parent);
                    String[] names = this.cache.getArtifactNames(context);
                    File missingFile = new File(parentDir, names[0].concat(".missing"));
                    if (missingFile.exists()) break block21;
                    if (context.getSearchRepository() == this.cache) {
                        ArtifactContext unpreferred = new ArtifactContext(context.getNamespace(), context.getName(), context.getVersion(), context.getSuffixes());
                        unpreferred.copySettingsFrom(context);
                        ArtifactResult artifactResult = this.getArtifactResult(unpreferred);
                        return artifactResult;
                    }
                    FileUtil.mkdirs(parentDir);
                    try (FileWriter writer = new FileWriter(missingFile, false);){
                        writer.write(reps.toString());
                    }
                    catch (IOException e) {
                        this.log.error(e.toString());
                    }
                }
                finally {
                    ArtifactContext.removeNode(parent);
                }
            }
        }
        return super.artifactNotFound(context);
    }

    private boolean isOffline(CmrRepository repo) {
        ContentStore cs = repo.getRoot().getService(ContentStore.class);
        return cs != null && cs.isOffline();
    }

    private File putContent(ArtifactContext context, Node node, InputStream stream, long length) throws IOException {
        File finalFile;
        this.log.debug("  Creating local copy of external node: " + node + " at repo: " + (this.fileContentStore != null ? this.fileContentStore.getDisplayString() : null));
        if (this.fileContentStore == null) {
            throw new IOException("No location to place node at: fileContentStore is null");
        }
        ArtifactCallback callback = context.getCallback();
        if (callback == null) {
            callback = ArtifactCallbackStream.getCallback();
        }
        VerifiedDownload dl = new VerifiedDownload(this.log, context, this.fileContentStore, node);
        try {
            Node descriptor;
            dl.fetch(callback, stream, length);
            if ((".jar".equals(context.getSingleSuffix()) || context.forceDescriptorCheck()) && (descriptor = Configuration.getResolvers(this).descriptor(node)) != null && descriptor.hasBinaries()) {
                VerifiedDownload descriptorDl = new VerifiedDownload(this.log, context, this.fileContentStore, descriptor);
                try {
                    descriptorDl.fetch(callback, descriptor.getInputStream(), 40L);
                    descriptorDl.commit();
                }
                catch (RuntimeException e) {
                    dl.rollback(e);
                    throw e;
                }
                catch (IOException e) {
                    dl.rollback(e);
                    throw e;
                }
            }
            finalFile = dl.commit();
        }
        catch (RuntimeException e) {
            dl.rollback(e);
            throw e;
        }
        catch (IOException e) {
            dl.rollback(e);
            throw e;
        }
        if (this.getCache() != null) {
            List<String> paths = NodeUtils.toLabelPath(node);
            OpenNode current = this.getCache();
            for (String path : paths) {
                if (current == null) break;
                current.refresh(false);
                OpenNode tmp = current.peekChild(path);
                current = tmp instanceof OpenNode ? (OpenNode)OpenNode.class.cast(tmp) : null;
            }
        }
        return finalFile;
    }

    @Override
    protected void addContent(ArtifactContext context, Node parent, String label, InputStream content) throws IOException {
        Node child;
        if (parent instanceof OpenNode) {
            OpenNode on = (OpenNode)parent;
            child = on.peekChild(label);
            if (child == null) {
                child = on.addNode(label);
            }
        } else {
            child = parent.getChild(label);
        }
        if (child == null) {
            throw new IOException("Cannot add child [" + label + "] content [" + content + "] on parent node: " + parent);
        }
        this.putContent(context, child, content, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNode(Node parent, String child) throws IOException {
        Node node = parent.getChild(child);
        if (this.fileContentStore != null) {
            try {
                if (node != null) {
                    Node descriptor;
                    Node origin;
                    Node sl = parent.getChild(child + ".sha1" + ".local");
                    if (sl != null) {
                        this.fileContentStore.removeFile(sl);
                    }
                    if ((origin = parent.getChild(child + ".origin")) != null) {
                        this.fileContentStore.removeFile(origin);
                    }
                    if ((descriptor = Configuration.getResolvers(this).descriptor(node)) != null) {
                        this.fileContentStore.removeFile(descriptor);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            super.removeNode(parent, child);
        }
        finally {
            if (node != null) {
                this.fileContentStore.removeFile(node);
            }
        }
    }

    public String toString() {
        return "RootRepositoryManager: " + this.fileContentStore;
    }
}

