/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.MavenRepository;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.AetherContentStore;
import com.redhat.ceylon.cmr.maven.AetherUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.util.List;

public class AetherRepository
extends MavenRepository {
    private final AetherUtils utils;

    private AetherRepository(AetherContentStore acs) {
        super(acs.createRoot());
        this.utils = acs.getUtils();
    }

    public static CmrRepository createRepository(Logger log, boolean offline, int timeout) {
        return AetherRepository.createRepository(log, null, offline, timeout, null);
    }

    public static CmrRepository createRepository(Logger log, String settingsXml, boolean offline, int timeout, String currentDirectory) {
        AetherContentStore acs = new AetherContentStore(log, settingsXml, offline, timeout, currentDirectory);
        return new AetherRepository(acs);
    }

    @Override
    public String[] getArtifactNames(ArtifactContext context) {
        String name = context.getName();
        int p = name.contains(":") ? name.lastIndexOf(":") : name.lastIndexOf(".");
        return AetherRepository.getArtifactNames(p >= 0 ? name.substring(p + 1) : name, context.getVersion(), context.getSuffixes());
    }

    @Override
    protected String toModuleName(Node node) {
        ArtifactContext context = ArtifactContext.fromNode(node);
        if (context != null) {
            return context.getName();
        }
        String moduleName = node.getLabel();
        Node parent = NodeUtils.firstParent(node);
        String groupId = NodeUtils.getFullPath(parent, ".");
        if (groupId.startsWith(".")) {
            groupId = groupId.substring(1);
        }
        moduleName = groupId != null ? groupId + ":" + moduleName : moduleName;
        return moduleName;
    }

    @Override
    protected List<String> getDefaultParentPathInternal(ArtifactContext context) {
        return MavenRepository.getParentPath(context);
    }

    @Override
    public Node findParent(ArtifactContext context) {
        if (context.getName().startsWith("ceylon.")) {
            return null;
        }
        return super.findParent(context);
    }

    @Override
    public ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        return this.utils.findDependencies(manager, node);
    }

    @Override
    public void completeVersions(ModuleVersionQuery lookup, ModuleVersionResult result) {
        if (lookup.getType() != ModuleQuery.Type.ALL && lookup.getType() != null) {
            boolean ok = false;
            for (String suffix : lookup.getType().getSuffixes()) {
                if (!suffix.equals(".jar")) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
        }
        if (!ModuleUtil.isMavenModule(lookup.getName())) {
            return;
        }
        String[] groupArtifactIds = this.utils.nameToGroupArtifactIds(lookup.getName());
        if (groupArtifactIds == null) {
            return;
        }
        this.utils.search(groupArtifactIds[0], groupArtifactIds[1], lookup.getVersion(), lookup.isExactVersionMatch(), result, this.getOverrides(), this.getDisplayString());
    }
}

