/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.util;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;

public final class JarUtils {
    public static void finishUpdatingJar(File originalFile, File outputFile, ArtifactContext context, JarOutputStream jarOutputStream, JarEntryFilter filter, RepositoryManager repoManager, boolean verbose, Logger log, Set<String> folders) throws IOException {
        JarUtils.finishUpdatingJar(originalFile, outputFile, context, jarOutputStream, filter, repoManager, verbose, log, folders, false);
    }

    public static void finishUpdatingJar(File originalFile, File outputFile, ArtifactContext context, JarOutputStream jarOutputStream, JarEntryFilter filter, RepositoryManager repoManager, boolean verbose, Logger log, Set<String> foldersToAdd, boolean pack200) throws IOException {
        JarUtils.finishUpdatingJar(originalFile, outputFile, context, jarOutputStream, filter, repoManager, verbose, log, foldersToAdd, new HashSet<String>(), pack200);
    }

    public static void finishUpdatingJar(File originalFile, File outputFile, ArtifactContext context, JarOutputStream jarOutputStream, JarEntryFilter filter, RepositoryManager repoManager, boolean verbose, Logger log, Set<String> foldersToAdd, Set<String> foldersAlreadyAdded, boolean pack200) throws IOException {
        JarUtils.copyMissingFromOriginal(originalFile, jarOutputStream, filter, foldersToAdd);
        for (String folder : foldersToAdd) {
            if (foldersAlreadyAdded.contains(folder)) continue;
            ZipEntry dir = new ZipEntry(folder);
            jarOutputStream.putNextEntry(dir);
            jarOutputStream.closeEntry();
            foldersAlreadyAdded.add(folder);
        }
        jarOutputStream.flush();
        jarOutputStream.close();
        if (pack200) {
            JarUtils.repack(outputFile, log);
        }
        File sha1File = ShaSigner.sign(outputFile, log, verbose);
        JarUtils.publish(outputFile, sha1File, context, repoManager, log);
    }

    public static void publish(File outputFile, File sha1File, ArtifactContext context, RepositoryManager repoManager, Logger log) {
        try {
            context.setForceOperation(true);
            repoManager.putArtifact(context, outputFile);
            ArtifactContext sha1Context = context.getSha1Context();
            sha1Context.setForceOperation(true);
            repoManager.putArtifact(sha1Context, sha1File);
        }
        catch (RuntimeException x) {
            log.error("Failed to write module to repository: " + x.getMessage());
            throw x;
        }
        finally {
            outputFile.delete();
            sha1File.delete();
        }
    }

    public static void makeFolder(Set<String> foldersAlreadyAdded, JarOutputStream jarOutputStream, String folder) throws IOException {
        if (!foldersAlreadyAdded.contains(folder)) {
            ZipEntry dir = new ZipEntry(folder);
            jarOutputStream.putNextEntry(dir);
            jarOutputStream.closeEntry();
            foldersAlreadyAdded.add(folder);
        }
    }

    protected static void copyMissingFromOriginal(File originalFile, JarOutputStream jarOutputStream, JarEntryFilter filter, Set<String> folders) throws IOException {
        JarFile jarFile = JarUtils.validJar(originalFile);
        if (jarFile != null) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (filter.avoid(entry.getName()) || entry.isDirectory() && folders.contains(entry.getName())) continue;
                ZipEntry copiedEntry = new ZipEntry(entry.getName());
                copiedEntry.setTime(entry.getTime());
                copiedEntry.setComment(entry.getComment());
                jarOutputStream.putNextEntry(copiedEntry);
                if (!entry.isDirectory()) {
                    InputStream inputStream = jarFile.getInputStream(entry);
                    JarUtils.copy(inputStream, jarOutputStream);
                    inputStream.close();
                }
                jarOutputStream.closeEntry();
            }
            jarFile.close();
        }
    }

    public static JarFile validJar(File originalFile) {
        if (originalFile != null && originalFile.isFile() && originalFile.canRead()) {
            try {
                return new JarFile(originalFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isValidJar(File originalFile) {
        JarFile jarFile = JarUtils.validJar(originalFile);
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(File outputFile, Logger log) throws IOException, FileNotFoundException {
        Pack200.Packer packer = Pack200.newPacker();
        packer.properties().put("pack.effort", "9");
        packer.properties().put("pack.keep.file.order", "false");
        packer.properties().put("pack.deflate.hint", "true");
        packer.properties().put("pack.segment.limit", "-1");
        packer.properties().put("pack.modification.time", "latest");
        File tmp = File.createTempFile("ceylon-jarutils-", ".pack200", outputFile.getParentFile());
        try {
            try (FileOutputStream out = new FileOutputStream(tmp);
                 JarFile in = new JarFile(outputFile);){
                packer.pack(in, (OutputStream)out);
            }
            var5_5 = null;
            try (JarOutputStream outStream = new JarOutputStream(new FileOutputStream(outputFile));){
                outStream.setLevel(9);
                Pack200.Unpacker unpacker = Pack200.newUnpacker();
                unpacker.unpack(tmp, outStream);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        finally {
            tmp.delete();
        }
        log.debug("[repacked jar: " + outputFile.getPath() + "]");
    }

    public static String toPlatformIndependentPath(Iterable<? extends File> sourcePaths, String prefixedSourceFile) {
        String sourceFile = FileUtil.relativeFile(sourcePaths, prefixedSourceFile);
        sourceFile = sourceFile.replace(File.separatorChar, '/');
        return sourceFile;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long oldestFileTime(File file) {
        long mtime = Long.MAX_VALUE;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.getTime() >= mtime) continue;
                mtime = entry.getTime();
            }
        }
        catch (Exception ex) {
            mtime = Long.MIN_VALUE;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mtime;
    }

    public static String getFolder(String fileName) {
        int lastSep = fileName.lastIndexOf(47);
        if (lastSep == -1) {
            return null;
        }
        return fileName.substring(0, lastSep + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getMetaInfProperties(File jarFile, String propFileName) throws IOException {
        JarFile jar = JarUtils.validJar(jarFile);
        if (jar != null) {
            try {
                JarEntry entry = jar.getJarEntry(propFileName);
                if (entry != null) {
                    Properties properties;
                    InputStream inputStream = jar.getInputStream(entry);
                    try {
                        Properties previousMapping = new Properties();
                        previousMapping.load(inputStream);
                        properties = previousMapping;
                    }
                    catch (Throwable throwable) {
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    return properties;
                }
            }
            finally {
                jar.close();
            }
        }
        return null;
    }

    public static interface JarEntryFilter {
        public boolean avoid(String var1);
    }
}

