/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class AndroidUtil {
    private static Boolean isRunningAndroid;

    public static boolean isRunningAndroid() {
        if (isRunningAndroid != null) {
            return isRunningAndroid;
        }
        try {
            Object app = Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
            isRunningAndroid = app != null;
        }
        catch (IllegalAccessException e) {
            isRunningAndroid = false;
        }
        catch (IllegalArgumentException e) {
            isRunningAndroid = false;
        }
        catch (InvocationTargetException e) {
            isRunningAndroid = false;
        }
        catch (NoSuchMethodException e) {
            isRunningAndroid = false;
        }
        catch (SecurityException e) {
            isRunningAndroid = false;
        }
        catch (ClassNotFoundException e) {
            isRunningAndroid = false;
        }
        return isRunningAndroid;
    }

    public static List<String> getDexEntries() {
        try {
            Object app = Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
            Object codePath = Class.forName("android.app.Application").getMethod("getPackageCodePath", new Class[0]).invoke(app, new Object[0]);
            Class<?> dexFileClass = Class.forName("dalvik.system.DexFile");
            Object dexFile = dexFileClass.getConstructor(String.class).newInstance(codePath);
            Enumeration entries = (Enumeration)dexFileClass.getMethod("entries", new Class[0]).invoke(dexFile, new Object[0]);
            LinkedList<String> dexEntries = new LinkedList<String>();
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                entry = entry.replace('.', '/') + ".class";
                dexEntries.add(entry);
            }
            dexFileClass.getMethod("close", new Class[0]).invoke(dexFile, new Object[0]);
            return dexEntries;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

