/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

import com.redhat.ceylon.common.CeylonVersionComparator;
import com.redhat.ceylon.common.CommonMessages;
import com.redhat.ceylon.common.MiscUtil;
import com.redhat.ceylon.common.ModuleUtil;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class ModuleSpec
implements Comparable<ModuleSpec> {
    public static final ModuleSpec DEFAULT_MODULE = new ModuleSpec(null, "default", "");
    private final String namespace;
    private final String name;
    private final String version;

    public ModuleSpec(String namespace, String name, String version2) {
        this.namespace = namespace != null ? namespace.trim() : null;
        this.name = name.trim();
        if (name.isEmpty()) {
            throw new IllegalArgumentException(CommonMessages.msg("modspec.name.missing", new Object[0]));
        }
        this.version = version2.trim();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isVersioned() {
        return !this.version.isEmpty();
    }

    public String toString() {
        return ModuleUtil.makeModuleName(this.namespace, this.name, this.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleSpec other = (ModuleSpec)obj;
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    public int compareTo(ModuleSpec o) {
        int result = MiscUtil.compare(this.namespace, o.namespace);
        if (result == 0 && (result = MiscUtil.compare(this.name, o.name)) == 0) {
            result = CeylonVersionComparator.compareVersions(this.version, o.version);
        }
        return result;
    }

    public static List<ModuleSpec> parseEachList(Iterable<String> moduleSpecs, Option ... option) {
        LinkedList<ModuleSpec> modules = new LinkedList<ModuleSpec>();
        for (String moduleSpec : moduleSpecs) {
            ModuleSpec spec = ModuleSpec.parse(moduleSpec, option);
            modules.add(spec);
        }
        return modules;
    }

    public static LinkedHashSet<ModuleSpec> parseEachSet(Iterable<String> moduleSpecs, Option ... options) {
        LinkedHashSet<ModuleSpec> modules = new LinkedHashSet<ModuleSpec>();
        return ModuleSpec.parseEach(moduleSpecs, modules, options);
    }

    private static LinkedHashSet<ModuleSpec> parseEach(Iterable<String> moduleSpecs, LinkedHashSet<ModuleSpec> into, Option ... options) {
        for (String moduleSpec : moduleSpecs) {
            ModuleSpec spec = ModuleSpec.parse(moduleSpec, options);
            into.add(spec);
        }
        return into;
    }

    public static ModuleSpec parse(String moduleSpec, Option ... options) {
        int sep = moduleSpec.indexOf("/");
        String name = sep != -1 ? moduleSpec.substring(0, sep) : moduleSpec;
        name = name.trim();
        String namespace = ModuleUtil.getNamespaceFromUri(name);
        name = ModuleUtil.getModuleNameFromUri(name);
        String version2 = sep != -1 && sep < moduleSpec.length() - 1 ? moduleSpec.substring(sep + 1) : "";
        version2 = version2.trim();
        if (name.equals(ModuleSpec.DEFAULT_MODULE.name)) {
            if (ModuleSpec.contains(options, Option.DEFAULT_MODULE_PROHIBITED)) {
                throw new IllegalArgumentException(CommonMessages.msg("modspec.default.prohibited", new Object[0]));
            }
            if (version2.equals(ModuleSpec.DEFAULT_MODULE.version)) {
                return DEFAULT_MODULE;
            }
            throw new IllegalArgumentException(CommonMessages.msg("modspec.default.no.version", new Object[0]));
        }
        if (version2.isEmpty() && ModuleSpec.contains(options, Option.VERSION_REQUIRED)) {
            throw new IllegalArgumentException(CommonMessages.msg("modspec.version.required", moduleSpec));
        }
        if ((!version2.isEmpty() || sep != -1) && ModuleSpec.contains(options, Option.VERSION_PROHIBITED)) {
            throw new IllegalArgumentException(CommonMessages.msg("modspec.version.prohibited", moduleSpec));
        }
        ModuleSpec spec = new ModuleSpec(namespace, name, version2);
        return spec;
    }

    private static boolean contains(Option[] options, Option opt) {
        for (Option o : options) {
            if (o != opt) continue;
            return true;
        }
        return false;
    }

    public static enum Option {
        VERSION_REQUIRED,
        VERSION_PROHIBITED,
        DEFAULT_MODULE_PROHIBITED;

    }
}

