/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.config.CeylonConfigFinder;
import com.redhat.ceylon.common.config.ConfigWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class CeylonConfig {
    private HashMap<String, String[]> options = new LinkedHashMap<String, String[]>();
    private HashMap<String, HashSet<String>> sectionNames = new LinkedHashMap<String, HashSet<String>>();
    private HashMap<String, HashSet<String>> optionNames;
    private static final ThreadLocal<CeylonConfig> localInstance = new InheritableThreadLocal<CeylonConfig>();

    public static CeylonConfig get() {
        CeylonConfig instance = localInstance.get();
        if (instance == null) {
            instance = CeylonConfig.createFromLocalDir(new File("."));
            localInstance.set(instance);
        }
        return instance;
    }

    public static CeylonConfig set(CeylonConfig config) {
        CeylonConfig old = localInstance.get();
        localInstance.set(config);
        return old;
    }

    public static String get(String key) {
        return CeylonConfig.get().getOption(key);
    }

    public static String get(String key, String defaultValue) {
        return CeylonConfig.get().getOption(key, defaultValue);
    }

    public static CeylonConfig createFromLocalDir(File localDir) {
        return CeylonConfigFinder.loadDefaultConfig(localDir);
    }

    public CeylonConfig() {
        this.sectionNames.put("", new LinkedHashSet());
        this.optionNames = new LinkedHashMap<String, HashSet<String>>();
    }

    public static boolean isValidKey(String key) {
        if (key == null) {
            return false;
        }
        String[] parts = key.split("\\.");
        return parts.length >= 2;
    }

    private void initLookupKey(String key) {
        Key k = new Key(key);
        if (!k.getParentSectionName().isEmpty()) {
            this.initLookupKey(k.getParentSectionName() + ".#");
        }
        HashSet<String> psn = this.sectionNames.get(k.getParentSectionName());
        psn.add(k.getSubsectionName());
        HashSet<String> sn = this.sectionNames.get(k.getSectionName());
        if (sn == null) {
            sn = new LinkedHashSet<String>();
            this.sectionNames.put(k.getSectionName(), sn);
        }
        if (!"#".equals(k.getOptionName())) {
            HashSet<String> on = this.optionNames.get(k.getSectionName());
            if (on == null) {
                on = new LinkedHashSet<String>();
                this.optionNames.put(k.getSectionName(), on);
            }
            on.add(k.getOptionName());
        }
    }

    public synchronized int size() {
        return this.options.size();
    }

    public synchronized boolean isOptionDefined(String key) {
        return this.options.containsKey(key);
    }

    public synchronized String[] getOptionValues(String key) {
        return this.options.get(key);
    }

    public synchronized void setOptionValues(String key, String[] values) {
        if (values != null && values.length > 0) {
            for (String val : values) {
                if (val != null) continue;
                throw new IllegalArgumentException("Option value cannot be null");
            }
            this.options.put(key, values);
            this.initLookupKey(key);
        } else {
            this.removeOption(key);
        }
    }

    public String getOption(String key) {
        String[] result = this.getOptionValues(key);
        return result != null ? result[0] : null;
    }

    public String getOption(String key, String defaultValue) {
        String result = this.getOption(key);
        return result != null ? result : defaultValue;
    }

    public void setOption(String key, String value) {
        if (value != null) {
            this.setOptionValues(key, new String[]{value});
        } else {
            this.removeOption(key);
        }
    }

    public Long getNumberOption(String key) {
        String result = this.getOption(key);
        if (result != null) {
            try {
                return Long.valueOf(result);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public long getNumberOption(String key, long defaultValue) {
        String result = this.getOption(key);
        if (result != null) {
            try {
                return Long.parseLong(result);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public void setNumberOption(String key, long value) {
        this.setOption(key, Long.toString(value));
    }

    public Boolean getBoolOption(String key) {
        String result = this.getOption(key);
        if (result != null) {
            return CeylonConfig.isTrueish(result);
        }
        return null;
    }

    public static boolean isTrueish(String value) {
        return value != null && ("true".equals(value) || "on".equals(value) || "yes".equals(value) || "1".equals(value));
    }

    public static boolean isFalsish(String value) {
        return value != null && ("false".equals(value) || "off".equals(value) || "no".equals(value) || "0".equals(value));
    }

    public boolean getBoolOption(String key, boolean defaultValue) {
        Boolean result = this.getBoolOption(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public void setBoolOption(String key, boolean value) {
        this.setOption(key, Boolean.toString(value));
    }

    public synchronized void removeOption(String key) {
        Key k = new Key(key);
        this.options.remove(key);
        HashSet<String> on = this.optionNames.get(k.getSectionName());
        if (on != null) {
            on.remove(k.getOptionName());
            if (on.isEmpty()) {
                this.cleanupSection(k.getSectionName());
            }
        }
    }

    private void cleanupSection(String sectionName) {
        HashSet<String> sn;
        HashSet<String> on = this.optionNames.get(sectionName);
        if (on != null && on.isEmpty()) {
            this.optionNames.remove(sectionName);
        }
        if ((sn = this.sectionNames.get(sectionName)) != null && sn.isEmpty()) {
            this.sectionNames.remove(sectionName);
        }
        if (!this.optionNames.containsKey(sectionName) && !this.sectionNames.containsKey(sectionName)) {
            Key k = new Key(sectionName + ".dummy");
            HashSet<String> psn = this.sectionNames.get(k.getParentSectionName());
            psn.remove(k.getSubsectionName());
            if (!k.getParentSectionName().isEmpty()) {
                this.cleanupSection(k.getParentSectionName());
            }
        }
    }

    public synchronized boolean isSectionDefined(String section) {
        return this.sectionNames.containsKey(section);
    }

    public synchronized void removeSection(String section) {
        String sectionDot = section + ".";
        if (this.isSectionDefined(section)) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>(this.options.keySet());
            for (String key : keys) {
                if (!key.startsWith(sectionDot)) continue;
                this.removeOption(key);
            }
        }
    }

    public synchronized String[] getSectionNames(String section) {
        HashSet<String> sn;
        if (section != null) {
            sn = this.sectionNames.get(section);
        } else {
            sn = new LinkedHashSet<String>(this.sectionNames.keySet());
            sn.remove("");
        }
        String[] res = new String[sn.size()];
        return sn.toArray(res);
    }

    public synchronized String[] getOptionNames(String section) {
        if (section == null) {
            String[] res = new String[this.options.keySet().size()];
            return this.options.keySet().toArray(res);
        }
        if (this.isSectionDefined(section)) {
            HashSet<String> on = this.optionNames.get(section);
            if (on != null) {
                String[] res = new String[on.size()];
                return on.toArray(res);
            }
            return new String[0];
        }
        return null;
    }

    public synchronized CeylonConfig merge(CeylonConfig other) {
        for (String key : other.getOptionNames(null)) {
            String[] values = other.getOptionValues(key);
            this.setOptionValues(key, values);
        }
        return this;
    }

    public CeylonConfig copy() {
        CeylonConfig cfg = new CeylonConfig();
        cfg.merge(this);
        return cfg;
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ConfigWriter.instance().write(this, out);
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    static class Key {
        private String subsectionName;
        private String optionName;
        private String sectionName;
        private String parentSectionName;

        public String getSubsectionName() {
            return this.subsectionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public String getSectionName() {
            return this.sectionName;
        }

        public String getParentSectionName() {
            return this.parentSectionName;
        }

        public Key(String key) {
            if (key == null) {
                throw new IllegalArgumentException("Illegal key");
            }
            String[] parts = key.split("\\.");
            if (parts.length < 2) {
                throw new IllegalArgumentException("Illegal key '" + key + "', needs a section name");
            }
            this.subsectionName = parts[parts.length - 2];
            this.optionName = parts[parts.length - 1];
            this.parentSectionName = "";
            if (parts.length > 2) {
                for (int i = 0; i < parts.length - 2; ++i) {
                    if (i > 0) {
                        this.parentSectionName = this.parentSectionName + '.';
                    }
                    this.parentSectionName = this.parentSectionName + parts[i];
                }
                this.sectionName = this.parentSectionName + '.' + this.subsectionName;
            } else {
                this.sectionName = this.subsectionName;
            }
        }
    }
}

