/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.config.ConfigReaderListener;
import com.redhat.ceylon.common.config.MemoPushbackReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.InvalidPropertiesFormatException;

public class ConfigReader {
    private ConfigReaderListener listener;
    private InputStream in;
    private LineNumberReader counterdr;
    private MemoPushbackReader reader;
    private String section;

    public ConfigReader(InputStream in, ConfigReaderListener listener) {
        this.in = in;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        this.section = null;
        try {
            Token tok;
            this.counterdr = new LineNumberReader(new BufferedReader(new InputStreamReader(this.in, Charset.forName("UTF-8"))));
            this.reader = new MemoPushbackReader(this.counterdr);
            this.listener.setup();
            this.skipWhitespace(true);
            this.flushWhitespace();
            while ((tok = this.peekToken()) != Token.eof) {
                switch (tok) {
                    case section: {
                        this.handleSection();
                        break;
                    }
                    case option: {
                        if (this.section != null) {
                            this.handleOption();
                            break;
                        }
                        throw new InvalidPropertiesFormatException("Option without section in configuration file at line " + (this.counterdr.getLineNumber() + 1));
                    }
                    case comment: {
                        this.skipToNextLine();
                        this.listener.onComment(this.reader.getAndClearMemo());
                        break;
                    }
                    case eol: {
                        this.skipToNextLine();
                        this.listener.onWhitespace(this.reader.getAndClearMemo());
                        break;
                    }
                    default: {
                        throw new InvalidPropertiesFormatException("Unexpected token in configuration file at line " + (this.counterdr.getLineNumber() + 1));
                    }
                }
                this.skipWhitespace(true);
                this.flushWhitespace();
            }
            this.listener.cleanup();
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private void handleSection() throws IOException {
        this.expect(91);
        this.section = this.readName(true);
        if (!this.section.matches("[\\p{L}\\p{Nd}]+(\\.[\\p{L}\\p{Nd}]+)*")) {
            throw new InvalidPropertiesFormatException("Invalid section name in configuration file at line " + (this.counterdr.getLineNumber() + 1));
        }
        this.skipWhitespace(false);
        if (this.reader.peek() == 34) {
            String subSection = this.readString();
            this.expect(34);
            this.section = this.section + "." + subSection;
            this.skipWhitespace(false);
        }
        this.expect(93);
        this.listener.onSection(this.section, this.reader.getAndClearMemo());
    }

    private void handleOption() throws IOException {
        String option = this.readName(false);
        String optName = this.section + "." + option;
        this.skipWhitespace(false);
        Token tok = this.peekToken();
        if (tok == Token.assign) {
            this.expect(61);
            this.handleOptionValue(optName);
        } else {
            if (tok == Token.error) {
                throw new InvalidPropertiesFormatException("Unexpected token in configuration file at line " + (this.counterdr.getLineNumber() + 1));
            }
            this.listener.onOption(optName, "true", this.reader.getAndClearMemo());
        }
    }

    private String readName(boolean forSection) throws IOException {
        int c;
        StringBuilder str = new StringBuilder();
        while ((c = this.reader.read()) != -1) {
            if (!forSection && this.isOptionNameChar(c) || forSection && this.isSectionNameChar(c)) {
                str.append((char)c);
                continue;
            }
            this.reader.unread(c);
            break;
        }
        return str.toString();
    }

    private String readString() throws IOException {
        int c;
        StringBuilder str = new StringBuilder();
        this.gobble(34);
        while ((c = this.reader.read()) != -1) {
            int c2;
            if (c == 34) {
                this.reader.unread(c);
                break;
            }
            if (c == 92 && (c2 = this.reader.read()) != 92) {
                if (c2 == 34) {
                    c = c2;
                } else {
                    throw new InvalidPropertiesFormatException("Illegal escape character in configuration file at line " + (this.counterdr.getLineNumber() + 1));
                }
            }
            str.append((char)c);
        }
        return str.toString();
    }

    private void handleOptionValue(String optName) throws IOException {
        int c;
        StringBuilder str = new StringBuilder();
        this.skipWhitespace(false);
        boolean hasQuote = this.gobble(34);
        while ((c = this.reader.read()) != -1) {
            int c2;
            if (c == 34) {
                this.reader.unread(c);
                break;
            }
            if (this.isNewLineChar(c)) {
                this.reader.unread(c);
                break;
            }
            if (this.isCommentChar(c) && !hasQuote) {
                this.reader.unread(c);
                break;
            }
            if (c == 92 && (c2 = this.reader.read()) != 92) {
                if (c2 == 34) {
                    c = c2;
                } else if (c2 == 116) {
                    c = 9;
                } else if (c2 == 110) {
                    c = 10;
                } else if (this.isNewLineChar(c2)) {
                    this.skipNewLine(c2);
                    c = 10;
                } else {
                    throw new InvalidPropertiesFormatException("Illegal escape character in configuration file at line " + (this.counterdr.getLineNumber() + 1));
                }
            }
            str.append((char)c);
        }
        String res = str.toString();
        if (hasQuote) {
            this.expect(34);
            this.listener.onOption(optName, res, this.reader.getAndClearMemo());
        } else {
            String memo = this.reader.getAndClearMemo();
            String ws = this.rightTrimmings(res);
            if (!ws.isEmpty()) {
                this.listener.onOption(optName, res.trim(), memo.trim());
                this.listener.onWhitespace(ws);
            } else {
                this.listener.onOption(optName, res.trim(), memo);
            }
        }
    }

    private String rightTrimmings(String txt) {
        int st;
        char[] val = txt.toCharArray();
        for (st = txt.length(); st > 0 && val[st - 1] <= ' '; --st) {
        }
        return st > 0 ? txt.substring(st) : txt;
    }

    private void expect(int expected) throws IOException {
        int c = this.reader.read();
        if (c != expected) {
            throw new InvalidPropertiesFormatException("Unexpected token in configuration file at line " + (this.counterdr.getLineNumber() + 1) + ", expected '" + Character.valueOf((char)expected) + "' but got '" + Character.valueOf((char)c) + "'");
        }
    }

    private void skipWhitespace(boolean multiline) throws IOException {
        int c;
        while ((c = this.reader.read()) != -1) {
            if (Character.isWhitespace(c) && (multiline || !this.isNewLineChar(c))) continue;
            this.reader.unread(c);
            break;
        }
    }

    private void skipToNextLine() throws IOException {
        int c;
        while ((c = this.reader.read()) != -1) {
            if (!this.isNewLineChar(c)) continue;
            this.skipNewLine(c);
            break;
        }
    }

    private Token peekToken() throws IOException {
        int c = this.reader.peek();
        if (this.isCommentChar(c)) {
            return Token.comment;
        }
        if (c == 91) {
            return Token.section;
        }
        if (c == 61) {
            return Token.assign;
        }
        if (this.isNewLineChar(c)) {
            return Token.eol;
        }
        if (this.isOptionNameChar(c)) {
            return Token.option;
        }
        if (c == -1) {
            return Token.eof;
        }
        return Token.error;
    }

    private boolean gobble(int chr) throws IOException {
        int c = this.reader.read();
        if (c != chr) {
            this.reader.unread(c);
            return false;
        }
        return true;
    }

    private void skipNewLine(int c) throws IOException {
        if (c == 13 && (c = this.reader.read()) != 10) {
            this.reader.unread(c);
        }
    }

    private void flushWhitespace() throws IOException {
        String ws = this.reader.getAndClearMemo();
        while (!ws.isEmpty()) {
            String txt;
            int p = ws.indexOf(10);
            if (p >= 0) {
                txt = ws.substring(0, p + 1);
                ws = ws.substring(p + 1);
            } else {
                txt = ws;
                ws = "";
            }
            this.listener.onWhitespace(txt);
        }
    }

    private boolean isOptionNameChar(int c) {
        return Character.isLetterOrDigit(c) || c == 45;
    }

    private boolean isSectionNameChar(int c) {
        return this.isOptionNameChar(c) || c == 46;
    }

    private boolean isCommentChar(int c) {
        return c == 59 || c == 35;
    }

    private boolean isNewLineChar(int c) {
        return c == 10 || c == 13;
    }

    private static enum Token {
        section,
        option,
        assign,
        comment,
        eol,
        error,
        eof;

    }
}

