/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.ToolMessages;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public abstract class EnumUtil {
    public static <ENUM extends Enum<ENUM>> ENUM valueOf(Class<ENUM> enumClass, String name) {
        try {
            return Enum.valueOf(enumClass, name);
        }
        catch (IllegalArgumentException e) {
            StringBuffer sb = new StringBuffer();
            for (String n : EnumUtil.possibilities(enumClass)) {
                sb.append("'").append(n.replace('_', '-')).append("', ");
            }
            sb.setLength(sb.length() - 2);
            throw new IllegalArgumentException(ToolMessages.msg("argument.enum.invalid.option", enumClass.getSimpleName(), sb.toString()));
        }
    }

    public static <ENUM extends Enum<ENUM>> Iterable<String> possibilities(Class<ENUM> enumClass) {
        EnumSet<Enum> values = EnumSet.allOf(enumClass);
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (Enum value : values) {
            result.add(value.toString());
        }
        return result;
    }

    public static <ENUM extends Enum<ENUM>> EnumSet<ENUM> enumsFromStrings(Class<ENUM> enumClass, List<String> elems) {
        return EnumUtil.enumsFromStrings(enumClass, elems, false);
    }

    public static <ENUM extends Enum<ENUM>> EnumSet<ENUM> enumsFromPossiblyInvalidStrings(Class<ENUM> enumClass, List<String> elems) {
        return EnumUtil.enumsFromStrings(enumClass, elems, true);
    }

    private static <ENUM extends Enum<ENUM>> EnumSet<ENUM> enumsFromStrings(Class<ENUM> enumClass, List<String> elems, boolean skipErrors) {
        if (elems != null) {
            EnumSet<ENUM> result = EnumSet.noneOf(enumClass);
            for (String elem : elems) {
                elem = elem.trim();
                elem = elem.replace('-', '_');
                for (Enum e : EnumSet.allOf(enumClass)) {
                    if (!e.name().equalsIgnoreCase(elem)) continue;
                    elem = e.name();
                }
                if (skipErrors) {
                    try {
                        result.add(EnumUtil.valueOf(enumClass, elem));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                result.add(EnumUtil.valueOf(enumClass, elem));
            }
            return result;
        }
        return null;
    }

    public static <ENUM extends Enum<ENUM>> String enumsToString(EnumSet<ENUM> elems) {
        if (elems != null) {
            StringBuilder buf = new StringBuilder();
            for (Enum e : elems) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(e.name());
            }
            return buf.toString();
        }
        return null;
    }
}

