/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonToolMessages;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SourceArgumentsResolver {
    private final Iterable<File> sourceDirs;
    private final Iterable<File> resourceDirs;
    private final String[] sourceSuffixes;
    private File cwd;
    private boolean expandSingleSources;
    private List<String> srcModules;
    private List<String> resModules;
    private Collection<String> allModules;
    private List<File> srcFiles;
    private List<File> resFiles;
    private Collection<File> allFiles;
    private Map<String, List<File>> srcModuleFiles;
    private Map<String, List<File>> resModuleFiles;
    private Map<String, List<File>> allModuleFiles;

    public SourceArgumentsResolver(Iterable<File> sourceDirs, Iterable<File> resourceDirs, String ... sourceSuffixes) {
        this.sourceDirs = sourceDirs;
        this.resourceDirs = resourceDirs;
        this.sourceSuffixes = sourceSuffixes;
        this.srcModules = new LinkedList<String>();
        this.resModules = new LinkedList<String>();
        this.srcFiles = new LinkedList<File>();
        this.resFiles = new LinkedList<File>();
        this.srcModuleFiles = new HashMap<String, List<File>>();
        this.resModuleFiles = new HashMap<String, List<File>>();
    }

    public SourceArgumentsResolver cwd(File cwd) {
        this.cwd = cwd;
        return this;
    }

    public SourceArgumentsResolver expandSingleSources(boolean expandSingleSources) {
        this.expandSingleSources = expandSingleSources;
        return this;
    }

    public List<String> getSourceModules() {
        return this.srcModules;
    }

    public List<String> getResourceModules() {
        return this.resModules;
    }

    public Collection<String> getModules() {
        if (this.allModules == null) {
            this.allModules = new LinkedHashSet<String>(this.srcModules.size() + this.resModules.size());
            this.allModules.addAll(this.srcModules);
            this.allModules.addAll(this.resModules);
        }
        return this.allModules;
    }

    public List<File> getSourceFiles() {
        return this.srcFiles;
    }

    public List<File> getResourceFiles() {
        return this.resFiles;
    }

    public Collection<File> getFiles() {
        if (this.allFiles == null) {
            this.allFiles = new ArrayList<File>(this.srcFiles.size() + this.resFiles.size());
            this.allFiles.addAll(this.srcFiles);
            this.allFiles.addAll(this.resFiles);
        }
        return this.allFiles;
    }

    public Map<String, List<File>> getSourceFilesByModule() {
        return this.srcModuleFiles;
    }

    public Map<String, List<File>> getResourceFilesByModule() {
        return this.resModuleFiles;
    }

    public Map<String, List<File>> getFilesByModule() {
        if (this.allModuleFiles == null) {
            this.allModuleFiles = new HashMap<String, List<File>>();
            this.allModuleFiles.putAll(this.srcModuleFiles);
            for (Map.Entry<String, List<File>> entry : this.resModuleFiles.entrySet()) {
                List<File> files = this.allModuleFiles.get(entry.getKey());
                if (files == null) {
                    this.allModuleFiles.put(entry.getKey(), entry.getValue());
                    continue;
                }
                ArrayList<File> newFiles = new ArrayList<File>(files.size() + entry.getValue().size());
                newFiles.addAll(files);
                newFiles.addAll((Collection)entry.getValue());
                this.allModuleFiles.put(entry.getKey(), newFiles);
            }
        }
        return this.allModuleFiles;
    }

    public void expandAndParse(Collection<String> modulesOrFiles, Backend forBackend) throws IOException {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        List<String> expandedModulesOrFiles = ModuleWildcardsHelper.expandWildcards(srcs, modulesOrFiles, forBackend);
        this.parse(expandedModulesOrFiles);
    }

    public void parse(Collection<String> modulesOrFiles) throws IOException {
        HashSet<String> srcMods = new HashSet<String>();
        HashSet<String> resMods = new HashSet<String>();
        HashSet<String> singleFileMods = new HashSet<String>();
        this.srcFiles = new LinkedList<File>();
        this.resFiles = new LinkedList<File>();
        this.allFiles = null;
        this.srcModuleFiles = new HashMap<String, List<File>>();
        this.resModuleFiles = new HashMap<String, List<File>>();
        this.allModuleFiles = null;
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        Iterable<File> resrcs = FileUtil.applyCwd(this.cwd, this.resourceDirs);
        for (String moduleOrFile : modulesOrFiles) {
            File file = FileUtil.applyCwd(this.cwd, new File(moduleOrFile));
            if (file.isFile()) {
                String relFileName;
                String module;
                File path;
                if (SourceArgumentsResolver.hasAcceptedSuffix(file, this.sourceSuffixes)) {
                    path = FileUtil.selectPath(srcs, file.getPath());
                    if (path == null) {
                        String srcPath = this.sourceDirs.toString();
                        throw new ToolUsageError(CeylonToolMessages.msg("error.not.in.source.path", moduleOrFile, srcPath));
                    }
                    module = this.moduleName(srcs, path, file);
                    if (!this.expandSingleSources) {
                        relFileName = FileUtil.relativeFile(srcs, file.getPath());
                        this.addFile(this.srcFiles, this.srcModuleFiles, module, new File(path, relFileName));
                    } else {
                        singleFileMods.add(module);
                    }
                    srcMods.add(module);
                } else if (resrcs != null) {
                    path = FileUtil.selectPath(resrcs, moduleOrFile);
                    if (path == null) {
                        String resrcPath = this.resourceDirs.toString();
                        throw new ToolUsageError(CeylonToolMessages.msg("error.not.in.resource.path", moduleOrFile, resrcPath));
                    }
                    module = this.moduleName(srcs, path, file);
                    relFileName = FileUtil.relativeFile(resrcs, file.getPath());
                    this.addFile(this.resFiles, this.resModuleFiles, module, new File(path, relFileName));
                    resMods.add(module);
                }
            } else {
                this.visitModuleFiles(this.srcFiles, this.srcModuleFiles, srcs, moduleOrFile, this.sourceSuffixes);
                srcMods.add(moduleOrFile);
                if (resrcs != null) {
                    this.visitModuleFiles(this.resFiles, this.resModuleFiles, resrcs, moduleOrFile, null);
                    resMods.add(moduleOrFile);
                }
            }
            if (!this.srcFiles.isEmpty() || !this.resFiles.isEmpty()) continue;
            throw new ToolUsageError(CeylonToolMessages.msg("error.no.files", moduleOrFile));
        }
        for (String modName : singleFileMods) {
            this.visitModuleFiles(this.srcFiles, this.srcModuleFiles, srcs, modName, this.sourceSuffixes);
        }
        this.srcModules = new ArrayList<String>(srcMods);
        this.resModules = new ArrayList<String>(resMods);
        this.allModules = null;
    }

    private void addFile(List<File> files, Map<String, List<File>> moduleFiles, String module, File file) {
        files.add(file);
        List<File> mfiles = moduleFiles.get(module);
        if (mfiles == null) {
            mfiles = new ArrayList<File>();
            moduleFiles.put(module, mfiles);
        }
        mfiles.add(file);
    }

    private void visitModuleFiles(List<File> files, Map<String, List<File>> moduleFiles, Iterable<File> paths, String modName, String[] suffixes) throws IOException {
        if (ModuleUtil.isDefaultModule(modName)) {
            SourceArgumentsResolver.visitFiles(paths, null, new RootedFileVisitor(files, moduleFiles, true, suffixes));
        } else {
            File modPath = ModuleUtil.moduleToPath(modName);
            if (this.isModuleFolder(modPath)) {
                SourceArgumentsResolver.visitFiles(paths, modPath, new RootedFileVisitor(files, moduleFiles, false, suffixes));
            } else {
                File dir = this.searchModulePath(modPath);
                if (dir == null || !dir.isDirectory()) {
                    if (modName.contains("/")) {
                        throw new ToolUsageError(CeylonToolMessages.msg("error.invalid.module.or.file", modName));
                    }
                    for (String suffix : suffixes) {
                        if (!modName.endsWith(suffix)) continue;
                        throw new ToolUsageError(CeylonToolMessages.msg("error.file.not.found", modName));
                    }
                    String ps = this.sourceDirs.toString();
                    ps = ps.substring(1, ps.length() - 1);
                    throw new ToolUsageError(CeylonToolMessages.msg("error.module.not.found", modName, ps));
                }
                throw new ToolUsageError(CeylonToolMessages.msg("error.not.module", modName));
            }
        }
    }

    private static void visitFiles(Iterable<File> dirs, File modPath, RootedFileVisitor visitor) throws IOException {
        for (File dir : dirs) {
            SourceArgumentsResolver.visitFiles(dir, modPath, visitor);
        }
    }

    private static void visitFiles(File dir, File modPath, RootedFileVisitor visitor) throws IOException {
        File moduleDir = dir;
        if (modPath != null) {
            moduleDir = new File(dir, modPath.getPath());
        }
        visitor.rootPath = dir;
        if (moduleDir.isDirectory()) {
            Files.walkFileTree(moduleDir.toPath(), visitor);
        }
    }

    private static boolean hasAcceptedSuffix(File file, String ... suffixes) {
        for (String ext : suffixes) {
            if (!file.toString().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private boolean isModuleFolder(File rootPath, File modPath) {
        File relPath = FileUtil.relativeFile(rootPath, modPath);
        return this.isModuleFolder(relPath);
    }

    private boolean isModuleFolder(File modPath) {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        return ModuleUtil.isModuleFolder(srcs, modPath);
    }

    private File searchModulePath(File modPath) {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        return FileUtil.searchPaths(srcs, modPath.getPath());
    }

    private String moduleName(File rootPath, File file) {
        Iterable<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceDirs);
        return this.moduleName(srcs, rootPath, file);
    }

    private String moduleName(Iterable<File> srcs, File rootPath, File file) {
        File relFile = FileUtil.relativeFile(rootPath, file);
        return ModuleUtil.moduleName(srcs, relFile);
    }

    private class RootedFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<File> files;
        private final Map<String, List<File>> moduleFiles;
        private final boolean excludeModules;
        private final String[] acceptedSuffixes;
        private String module;
        public File rootPath;

        public RootedFileVisitor(List<File> files, Map<String, List<File>> moduleFiles, boolean excludeModules, String[] acceptedFiles) {
            this.files = files;
            this.moduleFiles = moduleFiles;
            this.excludeModules = excludeModules;
            this.acceptedSuffixes = acceptedFiles;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (SourceArgumentsResolver.this.isModuleFolder(this.rootPath, dir.toFile())) {
                if (this.excludeModules) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                this.module = SourceArgumentsResolver.this.moduleName(this.rootPath, dir.toFile());
            }
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
            if (SourceArgumentsResolver.this.isModuleFolder(this.rootPath, dir.toFile())) {
                this.module = "default";
            }
            return super.postVisitDirectory(dir, ex);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            boolean add = true;
            if (this.acceptedSuffixes != null) {
                add = SourceArgumentsResolver.hasAcceptedSuffix(file.toFile(), this.acceptedSuffixes);
            }
            if (add) {
                SourceArgumentsResolver.this.addFile(this.files, this.moduleFiles, this.module, file.toFile());
            }
            return super.visitFile(file, attrs);
        }
    }
}

