/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tools.ModuleVersionReader;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class SourceDependencyResolver {
    private final ModuleVersionReader moduleVersionReader;
    private final Iterable<File> sourceDirs;
    private final Backends forBackends;
    private Set<ModuleVersionDetails> originalModules;
    private Set<ModuleVersionDetails> allModules;
    private Set<ModuleVersionDetails> additionalModules;

    public SourceDependencyResolver(ModuleVersionReader moduleVersionReader, Iterable<File> sourceDirs, Backends forBackends) {
        this.moduleVersionReader = moduleVersionReader;
        this.sourceDirs = sourceDirs;
        this.forBackends = forBackends;
    }

    public Set<ModuleVersionDetails> getOriginalModules() {
        return this.originalModules;
    }

    public Set<ModuleVersionDetails> getAllModules() {
        return this.allModules;
    }

    public Set<ModuleVersionDetails> getAdditionalModules() {
        return this.additionalModules;
    }

    public boolean traverseDependencies(Iterable<File> sourceFiles) {
        this.originalModules = this.collectModulesFromSources(sourceFiles);
        this.allModules = new HashSet<ModuleVersionDetails>(this.originalModules);
        for (ModuleVersionDetails module : this.originalModules) {
            this.collectModulesFromDependencies(this.allModules, module);
        }
        this.additionalModules = new HashSet<ModuleVersionDetails>(this.allModules);
        this.additionalModules.removeAll(this.originalModules);
        return !this.additionalModules.isEmpty();
    }

    private void collectModulesFromDependencies(Set<ModuleVersionDetails> modules, String moduleName) {
        ModuleVersionDetails mvd = this.moduleVersionReader.fromSource(moduleName);
        if (mvd != null) {
            modules.add(mvd);
            this.collectModulesFromDependencies(modules, mvd);
        }
    }

    private void collectModulesFromDependencies(Set<ModuleVersionDetails> modules, ModuleVersionDetails mvd) {
        for (ModuleDependencyInfo dep : mvd.getDependencies()) {
            if (dep.getNamespace() != null || modules.contains(dep) || !this.hasSources(dep.getName()) || !ModelUtil.isForBackend(dep.getNativeBackends(), this.forBackends)) continue;
            this.collectModulesFromDependencies(modules, dep.getName());
        }
    }

    private boolean hasSources(String moduleName) {
        for (File srcDir : this.sourceDirs) {
            File descriptor;
            File moduleDir = ModuleUtil.moduleToPath(srcDir, moduleName);
            if (!moduleDir.isDirectory() || !moduleDir.canRead() || !(descriptor = new File(moduleDir, "module.ceylon")).isFile() || !descriptor.canRead()) continue;
            return true;
        }
        return false;
    }

    private Set<ModuleVersionDetails> collectModulesFromSources(Iterable<File> sourceFiles) {
        HashSet<ModuleVersionDetails> modules = new HashSet<ModuleVersionDetails>();
        Set<File> descriptors = this.collectModuleDescriptorsFromSources(sourceFiles);
        for (File d : descriptors) {
            String moduleName = this.moduleNameFromDescriptorFile(d);
            ModuleVersionDetails mvd = this.moduleVersionReader.fromSource(moduleName);
            if (mvd == null) continue;
            modules.add(mvd);
        }
        return modules;
    }

    private String moduleNameFromDescriptorFile(File descriptor) {
        String rel = FileUtil.relativeFile(this.sourceDirs, descriptor.getParentFile().getPath());
        return ModuleUtil.pathToModule(new File(rel));
    }

    private Set<File> collectModuleDescriptorsFromSources(Iterable<File> sourceFiles) {
        HashSet<File> files = new HashSet<File>();
        for (File f : sourceFiles) {
            if (!"module.ceylon".equals(f.getName())) continue;
            files.add(f);
        }
        return files;
    }
}

