/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.tool.AnnotatedToolModel;
import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Multiplicity;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.PluginToolModel;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.ScriptToolModel;
import com.redhat.ceylon.common.tool.SubtoolModel;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.Tools;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.help.CeylonHelpToolMessages;
import com.redhat.ceylon.common.tools.help.Markdown;
import com.redhat.ceylon.common.tools.help.model.DescribedSection;
import com.redhat.ceylon.common.tools.help.model.Doc;
import com.redhat.ceylon.common.tools.help.model.Option;
import com.redhat.ceylon.common.tools.help.model.OptionsSection;
import com.redhat.ceylon.common.tools.help.model.SubtoolVisitor;
import com.redhat.ceylon.common.tools.help.model.SummarySection;
import com.redhat.ceylon.common.tools.help.model.SynopsesSection;
import com.redhat.ceylon.common.tools.help.model.Synopsis;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Node;

public class DocBuilder {
    protected ToolLoader toolLoader;
    protected boolean includeHidden = false;

    public DocBuilder(ToolLoader toolLoader) {
        this.toolLoader = toolLoader;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public void setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
    }

    public Doc buildDoc(ToolModel<?> model, boolean specialRoot) {
        this.checkModel(model);
        boolean rootHack = specialRoot && model instanceof AnnotatedToolModel && CeylonTool.class.isAssignableFrom(((AnnotatedToolModel)model).getToolClass());
        Doc doc = new Doc();
        doc.setVersion("1.3.2 754a09a (Smile Tolerantly)");
        doc.setToolModel(model);
        doc.setInvocation(this.getCeylonInvocation(model));
        doc.setSummary(this.buildSummary(model));
        doc.setSynopses(rootHack ? this.buildRootSynopsis(model) : this.buildSynopsis(model));
        doc.setDescription(rootHack ? this.buildRootDescription(model) : this.buildDescription(model));
        doc.setOptions(this.buildOptions(model));
        if (model.getSubtoolModel() != null) {
            // empty if block
        }
        doc.setAdditionalSections(this.buildAdditionalSections(model));
        return doc;
    }

    private void checkModel(ToolModel<?> model) {
        new SubtoolVisitor(model){

            @Override
            protected void visit(ToolModel<?> model, SubtoolModel<?> subtoolModel) {
                if (model != this.root) {
                    if (DocBuilder.getSummary(model) != null) {
                        System.err.println("@Summary not supported on subtools: " + model.getName());
                    }
                    if (!DocBuilder.this.getSections(model).isEmpty()) {
                        System.err.println("@RemainingSections not supported on subtools: " + model.getName());
                    }
                }
            }
        }.accept();
    }

    private SynopsesSection buildRootSynopsis(ToolModel<?> model) {
        SynopsesSection synopsis = new SynopsesSection();
        synopsis.setTitle(CeylonHelpToolMessages.msg("section.SYNOPSIS", new Object[0]));
        ArrayList<Synopsis> synopsisList = new ArrayList<Synopsis>();
        Synopsis s1 = new Synopsis();
        s1.setInvocation(Tools.progName());
        OptionModel option = new OptionModel();
        option.setLongName("version");
        option.setArgumentType(OptionModel.ArgumentType.BOOLEAN);
        ArgumentModel<Boolean> argument = new ArgumentModel<Boolean>();
        argument.setMultiplicity(Multiplicity._1);
        argument.setType(Boolean.TYPE);
        option.setArgument(argument);
        s1.setOptionsAndArguments(Collections.singletonList(option));
        synopsisList.add(s1);
        Synopsis s2 = new Synopsis();
        s2.setInvocation(Tools.progName());
        ArrayList args = new ArrayList(model.getOptions());
        args.remove(model.getOption("version"));
        ArgumentModel command = new ArgumentModel();
        command.setMultiplicity(Multiplicity._1);
        command.setName("command");
        args.add((OptionModel<?>)((Object)command));
        ArgumentModel commandOptions = new ArgumentModel();
        commandOptions.setMultiplicity(Multiplicity._0_OR_MORE);
        commandOptions.setName("command\u2011options");
        args.add((OptionModel<?>)((Object)commandOptions));
        ArgumentModel commandArgs = new ArgumentModel();
        commandArgs.setMultiplicity(Multiplicity._0_OR_MORE);
        commandArgs.setName("command\u2011args");
        args.add((OptionModel<?>)((Object)commandArgs));
        s2.setOptionsAndArguments(args);
        synopsisList.add(s2);
        synopsis.setSynopses(synopsisList);
        return synopsis;
    }

    private DescribedSection buildRootDescription(ToolModel<?> rootModel) {
        StringBuilder sb = new StringBuilder();
        String newline = "\n";
        sb.append("\n");
        sb.append("\n");
        for (String toolName : this.toolLoader.getToolNames()) {
            ToolModel model = this.toolLoader.loadToolModel(toolName);
            if (model == null) {
                throw new RuntimeException(toolName);
            }
            if (!model.isPorcelain() && !this.includeHidden) continue;
            sb.append("* `").append(toolName).append("` - ");
            String summary = DocBuilder.getSummaryValue(model);
            if (summary != null) {
                sb.append(summary);
            }
            sb.append("\n");
            sb.append("\n");
        }
        sb.append("\n");
        sb.append(CeylonHelpToolMessages.getMoreInfo());
        sb.append("\n");
        sb.append("\n");
        String both = DocBuilder.getDescription(rootModel) + sb.toString();
        DescribedSection description = this.buildDescription(rootModel, both);
        return description;
    }

    public Doc buildDoc(ToolModel<?> model) {
        return this.buildDoc(model, false);
    }

    private List<DescribedSection> buildAdditionalSections(ToolModel<?> model) {
        ArrayList<DescribedSection> additionalSections = new ArrayList<DescribedSection>();
        String sections = this.getSections(model);
        if (sections != null && !sections.isEmpty()) {
            Document doc = Markdown.markdown(sections);
            List<Markdown.Section> markdownSections = Markdown.extractSections(doc);
            for (Markdown.Section sect : markdownSections) {
                DescribedSection ds = new DescribedSection();
                ds.setRole(DescribedSection.Role.ADDITIONAL);
                Document sectionDoc = sect.getDoc();
                if (sect.getHeading() == null) continue;
                Markdown.adjustHeadings(sectionDoc, 2 - sect.getHeading().getLevel());
                ds.setTitle((Node)sect.getHeading());
                ds.setDescription((Node)sectionDoc);
                additionalSections.add(ds);
            }
        }
        return additionalSections;
    }

    private OptionsSection buildOptions(ToolModel<?> model) {
        if (!(model instanceof AnnotatedToolModel)) {
            return null;
        }
        final HashMap map = new HashMap();
        new SubtoolVisitor(model){

            @Override
            protected void visit(ToolModel<?> model, SubtoolModel<?> subtoolModel) {
                OptionsSection optionsSection = new OptionsSection();
                map.put(model, optionsSection);
                if (model == this.root) {
                    optionsSection.setTitle((Node)Markdown.markdown("##" + CeylonHelpToolMessages.msg("section.OPTIONS", new Object[0])));
                } else {
                    optionsSection.setTitle((Node)Markdown.markdown("###" + CeylonHelpToolMessages.msg("section.OPTIONS.sub", model.getName())));
                }
                ArrayList<Option> options = new ArrayList<Option>();
                for (OptionModel opt : DocBuilder.this.sortedOptions(model.getOptions())) {
                    Option option = new Option();
                    option.setOption(opt);
                    String descriptionMd = DocBuilder.getOptionDescription(model, opt);
                    if (descriptionMd == null || descriptionMd.isEmpty()) {
                        descriptionMd = CeylonHelpToolMessages.msg("option.undocumented", new Object[0]);
                    }
                    option.setDescription((Node)Markdown.markdown(descriptionMd));
                    options.add(option);
                }
                optionsSection.setOptions(options);
                if (model != this.root && !options.isEmpty()) {
                    OptionsSection parent = (OptionsSection)map.get(((SubtoolVisitor.ToolModelAndSubtoolModel)this.ancestors.lastElement()).getModel());
                    ArrayList<OptionsSection> parentSubsections = new ArrayList<OptionsSection>(parent.getSubsections());
                    parentSubsections.add(optionsSection);
                    parent.setSubsections(parentSubsections);
                }
            }
        }.accept();
        return (OptionsSection)map.get(model);
    }

    private DescribedSection buildDescription(ToolModel<?> model) {
        final HashMap map = new HashMap();
        new SubtoolVisitor(model){

            @Override
            protected void visit(ToolModel<?> model, SubtoolModel<?> subtoolModel) {
                if (model == this.root) {
                    map.put(model, DocBuilder.this.buildDescription(model, DocBuilder.getDescription(model)));
                } else if (model.getSubtoolModel() == null) {
                    DescribedSection section = new DescribedSection();
                    section.setRole(DescribedSection.Role.DESCRIPTION);
                    StringBuilder sb = new StringBuilder();
                    for (SubtoolVisitor.ToolModelAndSubtoolModel subtool : this.ancestors.subList(1, this.ancestors.size())) {
                        sb.append(subtool.getModel().getName()).append(" ");
                    }
                    sb.append(model.getName());
                    section.setTitle((Node)Markdown.markdown("###" + CeylonHelpToolMessages.msg("section.DESCRIPTION.sub", sb.toString())));
                    section.setDescription((Node)Markdown.markdown(DocBuilder.getDescription(model)));
                    section.setAbout(model);
                    ArrayList<DescribedSection> rootSubsections = new ArrayList<DescribedSection>(((DescribedSection)map.get(this.root)).getSubsections());
                    rootSubsections.add(section);
                    ((DescribedSection)map.get(this.root)).setSubsections(rootSubsections);
                }
            }
        }.accept();
        return (DescribedSection)map.get(model);
    }

    private DescribedSection buildDescription(ToolModel<?> model, String description) {
        DescribedSection section = null;
        if (!description.isEmpty()) {
            section = new DescribedSection();
            section.setRole(DescribedSection.Role.DESCRIPTION);
            section.setTitle((Node)Markdown.markdown("## " + CeylonHelpToolMessages.msg("section.DESCRIPTION", new Object[0]) + "\n"));
            section.setDescription((Node)Markdown.markdown(description));
        }
        return section;
    }

    private DescribedSection buildSubcommands(ToolModel<?> model) {
        return null;
    }

    private SynopsesSection buildSynopsis(ToolModel<?> model) {
        SynopsesSection synopsesSection = new SynopsesSection();
        synopsesSection.setTitle(CeylonHelpToolMessages.msg("section.SYNOPSIS", new Object[0]));
        final ArrayList<Synopsis> synopsisList = new ArrayList<Synopsis>();
        new SubtoolVisitor(model){

            @Override
            protected void visit(ToolModel<?> model, SubtoolModel<?> subtoolModel) {
                if (model.getSubtoolModel() == null) {
                    List optionsAndArguments;
                    Synopsis synopsis = new Synopsis();
                    synopsis.setInvocation(DocBuilder.this.getCeylonInvocationForSynopsis(this.root));
                    if (this.ancestors.isEmpty()) {
                        optionsAndArguments = DocBuilder.this.optionsAndArguments(model);
                    } else {
                        optionsAndArguments = new ArrayList();
                        for (SubtoolVisitor.ToolModelAndSubtoolModel ancestor : this.ancestors) {
                            List subOptAndArgs = DocBuilder.this.optionsAndArguments(ancestor.getModel());
                            if (ancestor.getModel() != this.root) {
                                subOptAndArgs.add(0, ancestor);
                            }
                            optionsAndArguments.addAll(subOptAndArgs);
                        }
                        List subOptAndArgs = DocBuilder.this.optionsAndArguments(model);
                        subOptAndArgs.add(0, new SubtoolVisitor.ToolModelAndSubtoolModel(model, subtoolModel));
                        optionsAndArguments.addAll(subOptAndArgs);
                    }
                    synopsis.setOptionsAndArguments(optionsAndArguments);
                    synopsisList.add(synopsis);
                }
            }
        }.accept();
        synopsesSection.setSynopses(synopsisList);
        return synopsesSection;
    }

    private <E> List<E> optionsAndArguments(ToolModel<?> model) {
        ArrayList<OptionModel<?>> optionsAndArguments = this.sortedOptions(model.getOptions());
        optionsAndArguments.addAll(model.getArguments());
        return optionsAndArguments;
    }

    private boolean skipHiddenOption(OptionModel<?> option) {
        return option.getArgument().getSetter().getAnnotation(Hidden.class) != null && !this.includeHidden;
    }

    private ArrayList<OptionModel<?>> sortedOptions(Collection<OptionModel<?>> options2) {
        ArrayList options = new ArrayList(options2);
        Iterator<OptionModel<?>> iter = options.iterator();
        while (iter.hasNext()) {
            OptionModel<?> option = iter.next();
            if (!this.skipHiddenOption(option)) continue;
            iter.remove();
        }
        Collections.sort(options, new Comparator<OptionModel<?>>(){

            @Override
            public int compare(OptionModel<?> o1, OptionModel<?> o2) {
                return o1.getLongName().compareTo(o2.getLongName());
            }
        });
        return options;
    }

    private SummarySection buildSummary(ToolModel<?> model) {
        SummarySection summary = new SummarySection();
        summary.setTitle((Node)Markdown.markdown("##" + CeylonHelpToolMessages.msg("section.NAME", new Object[0]) + "\n"));
        summary.setSummary(DocBuilder.getSummaryValue(model));
        return summary;
    }

    private String getName(ToolModel<?> model) {
        return model.getName();
    }

    private static String msg(ResourceBundle toolBundle, String key) {
        String msg;
        if (toolBundle != null && toolBundle.containsKey(key) && (msg = toolBundle.getString(key)) != null) {
            return MessageFormat.format(msg, new Object[0]);
        }
        return "";
    }

    public static String getSummaryValue(ToolModel<?> model) {
        Summary summary;
        if (model instanceof ScriptToolModel) {
            return DocBuilder.invokeScript((ScriptToolModel)model, "--_print-summary");
        }
        if (model instanceof PluginToolModel) {
            return ((PluginToolModel)model).getToolSummary();
        }
        ResourceBundle toolBundle = DocBuilder.getToolBundle(model);
        String msg = DocBuilder.msg(toolBundle, "summary");
        if (msg.isEmpty() && (summary = DocBuilder.getSummary(model)) != null) {
            msg = summary.value();
        }
        return msg;
    }

    private static String invokeScript(ScriptToolModel<?> model, String arg) {
        ProcessBuilder processBuilder = OSUtil.isWindows() ? new ProcessBuilder("cmd.exe", "/C", model.getScriptName(), arg) : new ProcessBuilder(model.getScriptName(), arg);
        CeylonTool.setupScriptEnvironment(processBuilder, model.getScriptName());
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            String line;
            Process process = processBuilder.start();
            process.getOutputStream().close();
            InputStream stream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuffer strbuf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                strbuf.append(line + "\n");
            }
            reader.close();
            int exit = process.waitFor();
            if (exit != 0) {
                return "";
            }
            return strbuf.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static ResourceBundle getToolBundle(ToolModel<?> model) {
        ResourceBundle toolBundle;
        if (!(model instanceof AnnotatedToolModel)) {
            return null;
        }
        AnnotatedToolModel amodel = (AnnotatedToolModel)model;
        try {
            toolBundle = ResourceBundle.getBundle(amodel.getToolClass().getName());
        }
        catch (MissingResourceException e) {
            toolBundle = null;
        }
        return toolBundle;
    }

    private static Summary getSummary(ToolModel<?> model) {
        if (!(model instanceof AnnotatedToolModel)) {
            return null;
        }
        AnnotatedToolModel amodel = (AnnotatedToolModel)model;
        return amodel.getToolClass().getAnnotation(Summary.class);
    }

    public static String getDescription(ToolModel<?> model) {
        Description description;
        if (model instanceof ScriptToolModel) {
            return DocBuilder.invokeScript((ScriptToolModel)model, "--_print-description");
        }
        AnnotatedToolModel amodel = (AnnotatedToolModel)model;
        ResourceBundle toolBundle = DocBuilder.getToolBundle(model);
        String msg = DocBuilder.msg(toolBundle, "description");
        if (msg.isEmpty() && (description = amodel.getToolClass().getAnnotation(Description.class)) != null) {
            msg = description.value();
        }
        return msg;
    }

    private String getSections(ToolModel<?> model) {
        RemainingSections sections;
        if (!(model instanceof AnnotatedToolModel)) {
            return null;
        }
        AnnotatedToolModel amodel = (AnnotatedToolModel)model;
        ResourceBundle toolBundle = DocBuilder.getToolBundle(model);
        String msg = DocBuilder.msg(toolBundle, "sections.remaining");
        if (msg.isEmpty() && (sections = amodel.getToolClass().getAnnotation(RemainingSections.class)) != null) {
            msg = sections.value();
        }
        return msg;
    }

    public static String getOptionDescription(ToolModel<?> model, OptionModel<?> opt) {
        Description description;
        ResourceBundle toolBundle = DocBuilder.getToolBundle(model);
        String msg = DocBuilder.msg(toolBundle, "option." + opt.getLongName());
        if (msg.isEmpty() && (description = opt.getArgument().getSetter().getAnnotation(Description.class)) != null) {
            msg = description.value();
        }
        return msg;
    }

    private String getCeylonInvocation(ToolModel<?> model) {
        return this.getName(model).isEmpty() ? Tools.progName() : Tools.progName() + " " + model.getName();
    }

    private String getCeylonInvocationForSynopsis(ToolModel<?> model) {
        String ret = this.getCeylonInvocation(model);
        if (model instanceof ScriptToolModel) {
            return ret + " " + DocBuilder.invokeScript((ScriptToolModel)model, "--_print-usage");
        }
        return ret;
    }
}

