/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.ceylon.ShaSigner;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.ModuleSpec;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.EnumUtil;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.NonFatalToolMessage;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import com.redhat.ceylon.common.tools.OutputRepoUsingTool;
import com.redhat.ceylon.common.tools.SourceArgumentsResolver;
import com.redhat.ceylon.common.tools.SourceDependencyResolver;
import com.redhat.ceylon.compiler.CeylonCompileMessages;
import com.redhat.ceylon.compiler.CompilerBugException;
import com.redhat.ceylon.compiler.CompilerErrorException;
import com.redhat.ceylon.compiler.SystemErrorException;
import com.redhat.ceylon.compiler.java.launcher.Main;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.langtools.tools.javac.main.Main;
import com.redhat.ceylon.langtools.tools.javac.main.OptionHelper;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

@Summary(value="Compiles Ceylon and Java source code and directly produces module and source archives in a module repository.")
@Description(value="The default module repositories are `modules` and `https://modules.ceylon-lang.org/repo/1`, while the default source directory is `source` and the default resource directory is `resource`. The default output module repository is `modules`.\n\nThe `<moduleOrFile>` arguments can be either module names (without versions) or file paths specifying the Ceylon or Java source code to compile.\n\nWhen `<moduleOrFile>` specifies a module the compiler searches for compilation units and resource files belonging to the specified modules in the specified source and resource directories. For each specified module, the compiler generates a module archive, source archive, and their checksum files in the specified output module repository.\n\nWhen `<moduleOrFile>` specifies a source file only that file is compiled and the module archive is created or updated with the .class files produced. The source file path is treated as relative to the current directory (it still needs to be located either in the default source folder or in any folder defined by the configuration file or `--source` options!).\n\nWhen `<moduleOrFile>` specifies a resource file only that file is added to the module archive. The resource file path is treated as relative to the current directory (it still needs to be located either in the default resource folder or in any folder defined by the configuration file or `--resource` options!).\n\nAll program elements imported by a compilation unit must belong to the same module as the compilation unit, or must belong to a module that is explicitly imported in the module descriptor.\n\nThe compiler searches for dependencies in the following locations:\n\n* module archives in the specified repositories,\n* source archives in the specified repositories, and\n* module directories in the specified source directories.\n")
@RemainingSections(value="## Compiling dependencies\n\nThe `--include-dependencies` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n\n\n## Configuration file\n\nThe compile tool accepts the following options from the Ceylon configuration file: `defaults.offline`, `defaults.encoding`, `compiler.source`, `compiler.resource` and `repositories` (the equivalent options on the command line always have precedence).\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see https://ceylon-lang.org/documentation/1.3/reference/repository/tools\n\n## Specifying `javac` options\n\nIt is possible to pass options to the `javac` compiler by prefixing them with `--javac=` and separating the javac option from its argument (if any) using another `=`. For example, the option `--javac=-g:none` is equivalent to `javac`'s `-g:none`\n\nExecute `ceylon compile --javac=-help` for a list of the standard javac options, and ceylon compile --javac=-X for a list of the non-standard javac options.\n\n**Important note**: There is no guarantee that any particular `javac` option or combination of options will work, or continue to work in future releases.")
public class CeylonCompileTool
extends OutputRepoUsingTool {
    private Helper helper = new Helper();
    private List<File> sources = DefaultToolOptions.getCompilerSourceDirs();
    private List<File> resources = DefaultToolOptions.getCompilerResourceDirs();
    private List<String> modulesOrFiles = DefaultToolOptions.getCompilerModules(Backend.Java);
    private boolean continueOnErrors;
    private boolean progress = DefaultToolOptions.getCompilerProgress();
    private List<String> javac = DefaultToolOptions.getCompilerJavac();
    private String encoding;
    private String includeDependencies;
    private boolean incremental = DefaultToolOptions.getCompilerIncremental();
    private String resourceRoot = DefaultToolOptions.getCompilerResourceRootName();
    private boolean noOsgi = DefaultToolOptions.getCompilerNoOsgi();
    private String osgiProvidedBundles = DefaultToolOptions.getCompilerOsgiProvidedBundles();
    private boolean noPom = DefaultToolOptions.getCompilerNoPom();
    private boolean pack200 = DefaultToolOptions.getCompilerPack200();
    private EnumSet<Warning> suppressWarnings = EnumUtil.enumsFromPossiblyInvalidStrings(Warning.class, DefaultToolOptions.getCompilerSuppressWarnings());
    private boolean flatClasspath = DefaultToolOptions.getDefaultFlatClasspath();
    private boolean autoExportMavenDependencies = DefaultToolOptions.getDefaultAutoExportMavenDependencies();
    private boolean fullyExportMavenDependencies = DefaultToolOptions.getDefaultFullyExportMavenDependencies();
    private boolean jigsaw = DefaultToolOptions.getCompilerGenerateModuleInfo();
    private Long targetVersion = DefaultToolOptions.getCompilerTargetVersion();
    private boolean ee = DefaultToolOptions.getCompilerEe();
    private List<String> eeImport = DefaultToolOptions.getCompilerEeImport();
    private List<String> eeAnnotation = DefaultToolOptions.getCompilerEeAnnotation();
    private ModuleSpec jdkProvider;
    private List<ModuleSpec> aptModules;
    private List<String> arguments;
    private Main compiler;

    public CeylonCompileTool() {
        super(CeylonCompileMessages.RESOURCE_BUNDLE);
        String jdkProvider = DefaultToolOptions.getCompilerJdkProvider();
        this.jdkProvider = jdkProvider != null ? ModuleSpec.parse(jdkProvider, new ModuleSpec.Option[0]) : null;
        String[] aptModules = DefaultToolOptions.getCompilerAptModules();
        if (aptModules != null) {
            this.setAptModule(Arrays.asList(aptModules));
        }
    }

    @OptionArgument(longName="jdk-provider", argumentName="module")
    @Description(value="Specifies the name of the module providing the JDK (default: the underlying JDK).")
    public void setJdkProvider(String jdkProvider) {
        this.setJdkProviderSpec(ModuleSpec.parse(jdkProvider, new ModuleSpec.Option[0]));
    }

    public void setJdkProviderSpec(ModuleSpec jdkProvider) {
        this.jdkProvider = jdkProvider;
    }

    @OptionArgument(longName="apt", argumentName="module")
    @Description(value="Specifies the list of modules to use as Java annotation-processing modules (default: none). Experimental.")
    public void setAptModule(List<String> aptModules) {
        if (aptModules != null) {
            this.aptModules = new ArrayList<ModuleSpec>(aptModules.size());
            for (String mod : aptModules) {
                this.aptModules.add(ModuleSpec.parse(mod, new ModuleSpec.Option[0]));
            }
        } else {
            this.aptModules = null;
        }
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    @Option(longName="fully-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared, even to Ceylon modules.")
    public void setFullyExportMavenDependencies(boolean fullyExportMavenDependencies) {
        this.fullyExportMavenDependencies = fullyExportMavenDependencies;
    }

    @Option(longName="no-osgi")
    @Description(value="Indicates that the generated car file should not contain OSGi module declarations.")
    public void setNoOsgi(boolean noOsgi) {
        this.noOsgi = noOsgi;
    }

    @OptionArgument(longName="osgi-provided-bundles", argumentName="modules")
    @Description(value="Comma-separated list of module names. The listed modules are expected to be OSGI bundles provided by the framework, and will be omitted from the generated MANIFEST 'Required-Bundle' OSGI header.")
    public void setOsgiProvidedBundles(String osgiProvidedBundles) {
        this.osgiProvidedBundles = osgiProvidedBundles;
    }

    @Option(longName="generate-module-info")
    @Description(value="Generate Java 9 (Jigsaw) `module-info.class` module descriptor in the generated Ceylon archive.")
    public void setJigsaw(boolean jigsaw) {
        this.jigsaw = jigsaw;
    }

    @Option(longName="no-pom")
    @Description(value="Indicates that the generated car file should not contain Maven POM module declarations.")
    public void setNoPom(boolean noPom) {
        this.noPom = noPom;
    }

    @Option(longName="pack200")
    @Description(value="Try to make the generated car file smaller by repacking it using `pack200`.")
    public void setPack200(boolean pack200) {
        this.pack200 = pack200;
    }

    @OptionArgument(shortName=115, longName="src", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to directory containing source files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./source`)")
    public void setSrc(List<File> source) {
        this.sources = source;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(List<File> source) {
        this.setSrc(source);
    }

    @OptionArgument(shortName=114, longName="resource", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="Path to directory containing resource files. Can be specified multiple times; you can also specify several paths separated by your operating system's `PATH` separator. (default: `./resource`)")
    public void setResource(List<File> resource) {
        this.resources = resource;
    }

    @OptionArgument(shortName=82, argumentName="folder-name")
    @Description(value="Sets the special resource folder name whose files will end up in the root of the resulting module CAR file (default: ROOT).")
    public void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Hidden
    @Option(longName="continue-on-errors")
    @Description(value="Set to continue compiling even when errors are found.")
    public void setContinueOnErrors(boolean continueOnErrors) {
        this.continueOnErrors = continueOnErrors;
    }

    @Option(longName="progress")
    @Description(value="Print progress information.")
    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    @OptionArgument(shortName=69, argumentName="encoding")
    @Description(value="Sets the encoding used for reading source files(default: platform-specific).")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation of dependencies should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setIncludeDependencies(String includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    @Option(longName="incremental")
    @Description(value="Enables incremental compilation.")
    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    @Argument(argumentName="moduleOrFile", multiplicity="*")
    public void setModule(List<String> moduleOrFile) {
        this.modulesOrFiles = moduleOrFile;
    }

    @Override
    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `ast`, `code`, `cmr`, `benchmark`.")
    public void setVerbose(String verbose) {
        super.setVerbose(verbose);
    }

    @Override
    protected Set<String> getVerboseCategories(String ... morecats) {
        return super.getVerboseCategories("ast", "code", "cmr", "benchmark");
    }

    @OptionArgument(argumentName="option")
    @Description(value="Passes an option to the underlying java compiler.")
    public void setJavac(List<String> javac) {
        this.javac = javac;
    }

    @Option(shortName=87)
    @OptionArgument(argumentName="warnings")
    @Description(value="Suppress the reporting of the given warnings. If no `warnings` are given then suppresss the reporting of all warnings, otherwise just suppresss those which are present. Allowed flags include: `filenameNonAscii`, `filenameCaselessCollision`, `deprecation`, `compilerAnnotation`, `doclink`, `expressionTypeNothing`, `unusedDeclaration`, `unusedImport`, `ceylonNamespace`, `javaNamespace`, `suppressedAlready`, `suppressesNothing`, `unknownWarning`, `ambiguousAnnotation`, `similarModule`, `importsOtherJdk`, `javaAnnotationElement`.")
    public void setSuppressWarning(EnumSet<Warning> warnings) {
        this.suppressWarnings = warnings;
    }

    @OptionArgument(shortName=116, argumentName="version")
    @Description(value="The JVM that generated .class files should target. Use `7` to target Java 7 JVMs or `8` to target Java 8 JVMs.")
    public void setTarget(Long version2) {
        this.validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option.TARGET, "-target", version2.toString());
        this.validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option.SOURCE, "-source", version2.toString());
        this.targetVersion = version2;
    }

    @Option
    @Description(value="Enable \"EE mode\" globally for all declarations in the compilation")
    public void setEe(boolean ee) {
        this.ee = ee;
    }

    @OptionArgument
    @Description(value="Override the default module imports which trigger \"EE mode\" with the given module imports.When a module *directly* imports any of the listed modules EE mode will be enabled for all declarations in the module.For example if this option includes the value `javax.javaeeapi` or `maven:\"javax.javaee-api\"` then EE mode would be enabled for any declaration in any module which had that *direct* module import.")
    public void setEeImport(List<String> eeImports) {
        this.eeImport = eeImports;
    }

    @OptionArgument
    @Description(value="Override the default annotation types which trigger \"EE mode\" with the given fully-qualified Java annotation type name.When a declaration is annotated with any of the listed annotations EE module will be enabled for the top-level declaration containing that annotated declaration. For example if this option includes the value `javax.inject.Inject` then EE mode would be enabled for any class with an attribute annotatedwith `javax.inject::inject`.")
    public void setEeAnnotation(List<String> eeAnnotations) {
        this.eeAnnotation = eeAnnotations;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.sources;
    }

    @Override
    protected List<File> getResourceDirs() {
        return this.resources;
    }

    private void validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option option, String argument, String value) {
        this.helper.lastError = null;
        if (option.hasArg() ? option.process(this.helper, option.text, value) || this.helper.lastError != null : option.process(this.helper, argument) || this.helper.lastError != null) {
            throw new IllegalArgumentException(this.helper.lastError);
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        SourceDependencyResolver sdr;
        String fileEncoding;
        super.initialize(mainTool);
        this.compiler = new Main("ceylon compile");
        this.helper.options.clear();
        Options.instance(new Context());
        this.includeDependencies = this.processCompileFlags(this.includeDependencies, DefaultToolOptions.getCompilerIncludeDependencies());
        if (this.modulesOrFiles.isEmpty() && !this.javac.contains("-help") && !this.javac.contains("-X") && !this.javac.contains("-version")) {
            throw new IllegalStateException("Argument moduleOrFile should appear at least 1 time(s)");
        }
        this.arguments = new ArrayList<String>();
        if (this.cwd != null) {
            this.arguments.add("-cwd");
            this.arguments.add(this.cwd.getPath());
            this.validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option.CEYLONCWD, "-cwd", this.cwd.getPath());
        }
        if (this.jdkProvider != null) {
            this.arguments.add("-jdk-provider");
            this.arguments.add(this.jdkProvider.toString());
        }
        if (this.aptModules != null) {
            for (ModuleSpec mod : this.aptModules) {
                this.arguments.add("-apt");
                this.arguments.add(mod.toString());
            }
        }
        for (File source : this.applyCwd(this.sources)) {
            this.arguments.add("-src");
            this.arguments.add(source.getPath());
            this.validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option.CEYLONSOURCEPATH, "-sourcepath", source.getPath());
        }
        for (File resource : this.applyCwd(this.resources)) {
            this.arguments.add("-res");
            this.arguments.add(resource.getPath());
        }
        if (this.resourceRoot != null) {
            this.arguments.add("-resroot");
            this.arguments.add(this.resourceRoot);
        }
        if (this.continueOnErrors) {
            this.arguments.add("-continue");
        }
        if (this.progress) {
            this.arguments.add("-progress");
        }
        if (this.offline) {
            this.arguments.add("-offline");
        }
        if (this.timeout != -1) {
            this.arguments.add("-timeout");
            this.arguments.add(String.valueOf(this.timeout));
        }
        if (this.flatClasspath) {
            this.arguments.add("-flat-classpath");
        }
        if (this.autoExportMavenDependencies) {
            this.arguments.add("-auto-export-maven-dependencies");
        }
        if (this.fullyExportMavenDependencies) {
            this.arguments.add("-fully-export-maven-dependencies");
        }
        if (this.overrides != null) {
            this.arguments.add("-overrides");
            if (this.overrides.startsWith("classpath:")) {
                this.arguments.add(this.overrides);
            } else {
                this.arguments.add(this.applyCwd(new File(this.overrides)).getPath());
            }
        }
        if (this.jigsaw) {
            this.arguments.add("-module-info");
        }
        if (this.noOsgi) {
            this.arguments.add("-noosgi");
        }
        if (this.osgiProvidedBundles != null && !this.osgiProvidedBundles.isEmpty()) {
            this.arguments.add("-osgi-provided-bundles");
            this.arguments.add(this.osgiProvidedBundles);
        }
        if (this.noPom) {
            this.arguments.add("-nopom");
        }
        if (this.pack200) {
            this.arguments.add("-pack200");
        }
        if (this.verbose != null) {
            if (this.verbose.isEmpty()) {
                this.arguments.add("-verbose");
            } else {
                this.arguments.add("-verbose:" + this.verbose);
            }
        }
        if (this.out != null) {
            this.arguments.add("-out");
            this.arguments.add(this.out);
        }
        if (this.user != null) {
            this.arguments.add("-user");
            this.arguments.add(this.user);
        }
        if (this.pass != null) {
            this.arguments.add("-pass");
            this.arguments.add(this.pass);
        }
        if ((fileEncoding = this.encoding) == null) {
            fileEncoding = DefaultToolOptions.getDefaultEncoding();
        }
        if (fileEncoding != null) {
            try {
                Charset.forName(fileEncoding);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new IllegalArgumentException("Unsupported encoding: " + fileEncoding);
            }
            this.arguments.add(com.redhat.ceylon.langtools.tools.javac.main.Option.ENCODING.text);
            this.arguments.add(fileEncoding);
        }
        if (this.systemRepo != null) {
            this.arguments.add("-sysrep");
            this.arguments.add(this.systemRepo);
        }
        if (this.cacheRepo != null) {
            this.arguments.add("-cacherep");
            this.arguments.add(this.cacheRepo);
        }
        if (this.noDefRepos) {
            this.arguments.add("-nodefreps");
        }
        if (this.repos != null) {
            for (URI uri : this.repos) {
                this.arguments.add("-rep");
                this.arguments.add(uri.toString());
            }
        }
        if (this.suppressWarnings != null) {
            this.arguments.add("-suppress-warnings");
            this.arguments.add(EnumUtil.enumsToString(this.suppressWarnings));
        }
        if (this.targetVersion != null) {
            this.arguments.add("-source");
            this.arguments.add(this.targetVersion.toString());
            this.arguments.add("-target");
            this.arguments.add(this.targetVersion.toString());
        }
        if (this.ee) {
            this.arguments.add("-ee");
        }
        if (this.eeImport != null) {
            for (String eeImport : this.eeImport) {
                this.arguments.add("-ee-import");
                this.arguments.add(eeImport);
            }
        }
        if (this.eeAnnotation != null) {
            for (String eeAnnotation : this.eeAnnotation) {
                this.arguments.add("-ee-annotation");
                this.arguments.add(eeAnnotation);
            }
        }
        CeylonCompileTool.addJavacArguments(this.arguments, this.javac);
        List<File> srcs = this.applyCwd(this.sources);
        Collection<String> expandedModulesOrFiles = ModuleWildcardsHelper.expandWildcards(srcs, this.modulesOrFiles, Backend.Java);
        expandedModulesOrFiles = this.normalizeFileNames(expandedModulesOrFiles);
        if (expandedModulesOrFiles.isEmpty()) {
            String msg = CeylonCompileMessages.msg("error.no.sources", new Object[0]);
            if (ModuleWildcardsHelper.onlyGlobArgs(this.modulesOrFiles)) {
                throw new NonFatalToolMessage(msg);
            }
            throw new ToolUsageError(msg);
        }
        for (String moduleOrFile : expandedModulesOrFiles) {
            if (!com.redhat.ceylon.langtools.tools.javac.main.Option.SOURCEFILE.matches(moduleOrFile)) {
                throw new IllegalArgumentException(CeylonCompileMessages.msg("argument.error", moduleOrFile));
            }
            this.validateWithJavac(com.redhat.ceylon.langtools.tools.javac.main.Option.SOURCEFILE, moduleOrFile, moduleOrFile);
        }
        SourceArgumentsResolver sar = new SourceArgumentsResolver(this.sources, this.resources, ".ceylon", ".java");
        sar.cwd(this.cwd).parse(expandedModulesOrFiles);
        if (this.includeDependencies != null && !"never".equals(this.includeDependencies) && (sdr = new SourceDependencyResolver(this.getModuleVersionReader(), this.sources, Backends.JAVA)).traverseDependencies(sar.getSourceFiles())) {
            for (ModuleVersionDetails mvd : sdr.getAdditionalModules()) {
                if (!"force".equals(this.includeDependencies) && (!"check".equals(this.includeDependencies) || !this.shouldRecompile(this.getOfflineRepositoryManager(), mvd.getModule(), mvd.getVersion(), ModuleQuery.Type.JVM, true)) && (!"once".equals(this.includeDependencies) || !this.shouldRecompile(this.getOfflineRepositoryManager(), mvd.getModule(), mvd.getVersion(), ModuleQuery.Type.JVM, false))) continue;
                expandedModulesOrFiles.add(mvd.getModule());
                if (!this.incremental) continue;
                sar.parse(expandedModulesOrFiles);
            }
        }
        if (this.incremental) {
            for (String module : sar.getModules()) {
                Collection<String> remove;
                List<File> files;
                Properties newHashes;
                Collection<String> changedFiles;
                Properties oldHashes;
                Properties errors;
                File carFile;
                ModuleVersionDetails mvd;
                mvd = this.getModuleVersionReader().fromSource(module);
                if (mvd == null || (carFile = this.getModuleArtifact(this.getOfflineRepositoryManager(), mvd.getModule(), mvd.getVersion(), ModuleQuery.Type.JVM)) == null || (errors = this.getMetaInfErrors(carFile)) != null && !errors.isEmpty() || (oldHashes = this.getMetaInfHashes(carFile)) == null || (changedFiles = this.determineChangedFiles(module, oldHashes, newHashes = this.getFileHashes(module, files = sar.getFilesByModule().get(module)), carFile)) == null) continue;
                if (changedFiles.isEmpty()) {
                    expandedModulesOrFiles.remove(module);
                    remove = this.filesToStrings(module, files);
                    expandedModulesOrFiles.removeAll(remove);
                    continue;
                }
                if (expandedModulesOrFiles.contains(module)) {
                    if (changedFiles.size() >= files.size()) continue;
                    expandedModulesOrFiles.remove(module);
                    remove = this.filesToStrings(module, files);
                    expandedModulesOrFiles.removeAll(remove);
                    expandedModulesOrFiles.addAll(changedFiles);
                    continue;
                }
                Collection<String> unchanged = this.filesToStrings(module, files);
                unchanged.removeAll(changedFiles);
                expandedModulesOrFiles.removeAll(unchanged);
            }
            if (expandedModulesOrFiles.isEmpty()) {
                String msg = CeylonCompileMessages.msg("error.no.need", new Object[0]);
                throw new NonFatalToolMessage(msg);
            }
        }
        this.arguments.addAll(expandedModulesOrFiles);
        if (this.verbose != null) {
            System.out.println(this.arguments);
            System.out.flush();
        }
    }

    private Collection<String> normalizeFileNames(Collection<String> modulesOrFiles) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String mof : modulesOrFiles) {
            if (mof.contains("/") || mof.contains("\\")) {
                String path = FileUtil.relativeFile(this.sources, mof);
                File norm = FileUtil.applyPath(this.allDirs(), path);
                if (norm != null) {
                    result.add(norm.getPath());
                    continue;
                }
                result.add(mof);
                continue;
            }
            result.add(mof);
        }
        return result;
    }

    private Properties getFileHashes(String moduleName, List<File> files) {
        Properties hashes = new Properties();
        for (File f : files) {
            String name = FileUtil.relativeFile(this.allDirs(), f.getPath());
            name = this.handleResourceRoot(moduleName, name);
            hashes.put(name, ShaSigner.sha1(f, null));
        }
        return hashes;
    }

    private String handleResourceRoot(String moduleName, String relFileName) {
        String rrp;
        String string = rrp = this.resourceRoot.isEmpty() ? "" : ModuleUtil.moduleToPath(moduleName).getPath() + "/" + this.resourceRoot + "/";
        if (!rrp.isEmpty() && relFileName.startsWith(rrp)) {
            relFileName = relFileName.substring(rrp.length());
        }
        return relFileName;
    }

    private Collection<String> determineChangedFiles(String moduleName, Properties oldHashes, Properties newHashes, File carFile) {
        HashMap<String, String> diff = new HashMap<String, String>();
        for (String name : newHashes.stringPropertyNames()) {
            diff.put(name, newHashes.getProperty(name));
        }
        for (String name : oldHashes.stringPropertyNames()) {
            String hash = oldHashes.getProperty(name);
            if (!hash.equals(diff.get(name))) continue;
            diff.remove(name);
        }
        ArrayList<String> result = new ArrayList<String>(diff.size());
        for (String name : diff.keySet()) {
            File full = FileUtil.applyPath(this.allDirs(), name);
            if (full == null) {
                return null;
            }
            try {
                String hash = oldHashes.getProperty(name);
                if (hash == null && !this.isModuleArtifactOutOfDate(carFile, moduleName, ModuleQuery.Type.JVM)) continue;
                result.add(full.getPath());
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private Collection<String> filesToStrings(String moduleName, Collection<File> files) {
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (File f : files) {
            String norm = this.handleResourceRoot(moduleName, f.getPath());
            result.add(norm);
        }
        return result;
    }

    @Override
    public void run() throws IOException {
        Main.Result result = this.compiler.compile(this.arguments.toArray(new String[this.arguments.size()]));
        this.handleExitCode(result.exitCode, this.compiler.exitState);
    }

    private void handleExitCode(int javacExitCode, Main.ExitState exitState) {
        if (exitState == null) {
            throw new IllegalStateException("Missing ExitState, " + javacExitCode);
        }
        Main.ExitState.CeylonState ceylonState = exitState.ceylonState;
        switch (ceylonState) {
            case OK: {
                break;
            }
            case ERROR: {
                throw new CompilerErrorException(exitState.errorCount);
            }
            case SYS: {
                throw new SystemErrorException(exitState.abortingException);
            }
            case BUG: {
                throw new CompilerBugException(exitState);
            }
            default: {
                throw new IllegalStateException("Unexpected CeylonState " + (Object)((Object)ceylonState));
            }
        }
    }

    public static void addJavacArguments(List<String> arguments, List<String> javac) {
        Helper helper = new Helper();
        for (String argument : javac) {
            com.redhat.ceylon.langtools.tools.javac.main.Option javacOpt;
            helper.lastError = null;
            String value = null;
            int index = argument.indexOf(61);
            if (index != -1 && !com.redhat.ceylon.langtools.tools.javac.main.Option.A.matches(argument)) {
                value = index < argument.length() ? argument.substring(index + 1) : "";
                argument = argument.substring(0, index);
            }
            if ((javacOpt = CeylonCompileTool.getJavacOpt(argument)) == null) {
                throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
            }
            if (value != null) {
                if (!javacOpt.hasArg()) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, "Unexpected argument given"));
                }
                if (!javacOpt.matches(argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
                }
                if (javacOpt.process(helper, argument, value)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, helper.lastError));
                }
            } else {
                if (javacOpt.hasArg()) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, "Missing expected argument"));
                }
                if (!javacOpt.matches(argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.javac", argument));
                }
                if (javacOpt.process(helper, argument)) {
                    throw new IllegalArgumentException(CeylonCompileMessages.msg("option.error.syntax.javac", argument, helper.lastError));
                }
            }
            arguments.add(argument);
            if (value == null) continue;
            arguments.add(value);
        }
    }

    private static com.redhat.ceylon.langtools.tools.javac.main.Option getJavacOpt(String optionName) {
        for (com.redhat.ceylon.langtools.tools.javac.main.Option o : com.redhat.ceylon.langtools.tools.javac.main.Option.getJavaCompilerOptions()) {
            if (!o.matches(optionName)) continue;
            return o;
        }
        return null;
    }

    private static final class Helper
    extends OptionHelper {
        String lastError = null;
        private final HashMap<String, String> options = new HashMap();
        private final HashMap<String, List<String>> multiOptions = new HashMap();

        private Helper() {
        }

        @Override
        public String get(com.redhat.ceylon.langtools.tools.javac.main.Option option) {
            return this.options.get(option.text);
        }

        @Override
        public void put(String name, String value) {
            this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            this.options.remove(name);
        }

        @Override
        public Log getLog() {
            return null;
        }

        @Override
        public String getOwnName() {
            return null;
        }

        @Override
        protected void error(String key, Object ... args) {
            this.lastError = Main.getLocalizedString(key, args);
        }

        @Override
        protected void addFile(File f) {
        }

        @Override
        protected void addClassName(String s) {
        }

        @Override
        public List<String> getMulti(com.redhat.ceylon.langtools.tools.javac.main.Option option) {
            return this.multiOptions.get(option.text);
        }

        @Override
        public void addMulti(String name, String value) {
            List<String> list = this.multiOptions.get(name);
            if (list == null) {
                list = new ArrayList<String>(2);
                this.multiOptions.put(name, list);
            }
            list.add(value);
        }
    }
}

