/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AnnotationArgument;
import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationFieldName;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.AnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.BooleanLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.CharacterLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.CollectionLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.DeclarationLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ErroneousException;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.FloatLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.IntegerLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.InvocationAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.LiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ObjectLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.ParameterAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.StringLiteralAnnotationTerm;
import com.redhat.ceylon.compiler.java.codegen.recovery.Errors;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.List;

public class AnnotationModelVisitor
extends Visitor {
    private List<AnnotationFieldName> fieldNames = new ArrayList<AnnotationFieldName>();
    private Tree.AnyMethod annotationConstructor;
    private AnnotationInvocation instantiation;
    private List<AnnotationInvocation> nestedInvocations;
    private boolean spread;
    private boolean checkingArguments;
    private boolean checkingDefaults;
    private AnnotationTerm term;
    private boolean checkingInvocationPrimary;
    private CollectionLiteralAnnotationTerm elements;
    private Errors errors;

    public AnnotationModelVisitor(CeylonTransformer gen) {
        this.errors = gen.errors();
    }

    private void push(AnnotationFieldName parameter) {
        this.fieldNames.add(parameter);
    }

    private AnnotationFieldName pop() {
        return this.fieldNames.remove(this.fieldNames.size() - 1);
    }

    public Parameter parameter() {
        return this.fieldNames.get(this.fieldNames.size() - 1).getAnnotationField();
    }

    @Override
    public void handleException(Exception e, Node node) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean isAnnotationConstructor(Tree.AnyMethod def) {
        return AnnotationModelVisitor.isAnnotationConstructor(def.getDeclarationModel());
    }

    public static boolean isAnnotationConstructor(Declaration def) {
        return def.isToplevel() && def instanceof Function && def.isAnnotation();
    }

    public static boolean isAnnotationClass(Tree.ClassOrInterface def) {
        return AnnotationModelVisitor.isAnnotationClass(def.getDeclarationModel());
    }

    public static boolean isAnnotationClass(Declaration declarationModel) {
        return declarationModel instanceof Class && declarationModel.isAnnotation();
    }

    @Override
    public void visit(Tree.MethodDefinition d) {
        if (this.errors.hasAnyError(d)) {
            return;
        }
        if (AnnotationModelVisitor.isAnnotationConstructor(d)) {
            this.annotationConstructor = d;
            this.instantiation = (AnnotationInvocation)d.getDeclarationModel().getAnnotationConstructor();
        }
        super.visit(d);
        if (AnnotationModelVisitor.isAnnotationConstructor(d)) {
            this.instantiation = null;
            this.annotationConstructor = null;
        }
    }

    @Override
    public void visit(Tree.MethodDeclaration d) {
        if (this.errors.hasAnyError(d)) {
            return;
        }
        if (AnnotationModelVisitor.isAnnotationConstructor(d) && d.getSpecifierExpression() != null) {
            this.annotationConstructor = d;
            this.instantiation = (AnnotationInvocation)d.getDeclarationModel().getAnnotationConstructor();
        }
        super.visit(d);
        if (AnnotationModelVisitor.isAnnotationConstructor(d) && d.getSpecifierExpression() != null) {
            this.instantiation = null;
            this.annotationConstructor = null;
        }
    }

    @Override
    public void visit(Tree.Statement d) {
        if (!(this.annotationConstructor == null || this.annotationConstructor instanceof Tree.MethodDefinition && d instanceof Tree.Return || d instanceof Tree.AttributeDeclaration && ((Tree.AttributeDeclaration)d).getDeclarationModel().isParameter() || d.equals(this.annotationConstructor))) {
            d.addError("compiler bug: annotation constructors may only contain a return statement", Backend.Java);
        }
        super.visit(d);
    }

    @Override
    public void visit(Tree.AnnotationList al) {
    }

    @Override
    public void visit(Tree.Parameter p) {
        if (this.annotationConstructor != null) {
            AnnotationConstructorParameter acp = this.instantiation.findConstructorParameter(p.getParameterModel());
            this.push(acp);
            Tree.SpecifierOrInitializerExpression defaultArgument = Decl.getDefaultArgument(p);
            if (defaultArgument != null) {
                this.defaultedParameter(defaultArgument);
            }
            this.pop();
        }
    }

    public void defaultedParameter(Tree.SpecifierOrInitializerExpression d) {
        if (this.annotationConstructor != null) {
            AnnotationConstructorParameter annotationConstructorParameter = this.instantiation.getConstructorParameters().get(this.instantiation.getConstructorParameters().size() - 1);
            Value t = d.getUnit().getTrueValueDeclaration();
            Value f = d.getUnit().getFalseValueDeclaration();
            Tree.Term term = d.getExpression().getTerm();
            if (term instanceof Tree.InvocationExpression) {
                Tree.Primary primary = ((Tree.InvocationExpression)term).getPrimary();
                if (primary instanceof Tree.BaseMemberOrTypeExpression && (AnnotationModelVisitor.isAnnotationConstructor(((Tree.BaseMemberOrTypeExpression)primary).getDeclaration()) || AnnotationModelVisitor.isAnnotationClass(((Tree.BaseMemberOrTypeExpression)primary).getDeclaration()))) {
                    AnnotationInvocation prevInstantiation = this.instantiation;
                    this.instantiation = new AnnotationInvocation();
                    if (AnnotationModelVisitor.isAnnotationConstructor(((Tree.BaseMemberOrTypeExpression)primary).getDeclaration())) {
                        Function constructor = (Function)((Tree.BaseMemberOrTypeExpression)primary).getDeclaration();
                        this.instantiation.setConstructorDeclaration(constructor);
                        for (AnnotationConstructorParameter x : ((AnnotationInvocation)constructor.getAnnotationConstructor()).getConstructorParameters()) {
                            this.instantiation.addConstructorParameter(x);
                        }
                    }
                    this.checkingDefaults = true;
                    super.visit(d);
                    annotationConstructorParameter.setDefaultArgument(this.term);
                    this.term = null;
                    this.checkingDefaults = false;
                    this.instantiation = prevInstantiation;
                } else {
                    this.errorDefaultedParameter(d);
                }
            } else if (term instanceof Tree.Literal || term instanceof Tree.NegativeOp && ((Tree.NegativeOp)term).getTerm() instanceof Tree.Literal || term instanceof Tree.BaseMemberExpression && (((Tree.BaseMemberExpression)term).getDeclaration().equals(t) || ((Tree.BaseMemberExpression)term).getDeclaration().equals(f) || ((Tree.BaseMemberExpression)term).getDeclaration().isParameter() || Decl.isAnonCaseOfEnumeratedType((Tree.BaseMemberExpression)term))) {
                this.checkingDefaults = true;
                super.visit(d);
                annotationConstructorParameter.setDefaultArgument(this.term);
                this.term = null;
                this.checkingDefaults = false;
            } else if (term instanceof Tree.Tuple || term instanceof Tree.SequenceEnumeration) {
                this.checkingDefaults = true;
                super.visit(d);
                annotationConstructorParameter.setDefaultArgument(this.term);
                this.term = null;
                this.checkingDefaults = false;
            } else {
                this.errorDefaultedParameter(d);
            }
        }
    }

    private void errorDefaultedParameter(Node d) {
        d.addError("compiler bug: only literals, true, false, and annotation class instantiations are permitted as annotation parameter defaults", Backend.Java);
    }

    @Override
    public void visit(Tree.InvocationExpression invocation) {
        if (this.annotationConstructor != null) {
            AnnotationInvocation prevInstantiation = this.instantiation;
            if (this.checkingArguments) {
                this.instantiation = new AnnotationInvocation();
            }
            this.checkingInvocationPrimary = true;
            invocation.getPrimary().visit(this);
            this.checkingInvocationPrimary = false;
            if (invocation.getPositionalArgumentList() != null) {
                invocation.getPositionalArgumentList().visit(this);
            }
            if (invocation.getNamedArgumentList() != null) {
                invocation.getNamedArgumentList().visit(this);
            }
            InvocationAnnotationTerm invocationTerm = new InvocationAnnotationTerm();
            invocationTerm.setInstantiation(this.instantiation);
            if (this.checkingArguments) {
                if (this.nestedInvocations == null) {
                    this.nestedInvocations = new ArrayList<AnnotationInvocation>();
                }
                this.nestedInvocations.add(this.instantiation);
                this.instantiation = prevInstantiation;
            }
            this.term = invocationTerm;
        } else {
            super.visit(invocation);
        }
    }

    @Override
    public void visit(Tree.NamedArgumentList argumentList) {
        boolean prevCheckingArguments = this.checkingArguments;
        this.checkingArguments = true;
        super.visit(argumentList);
        this.checkingArguments = prevCheckingArguments;
    }

    @Override
    public void visit(Tree.PositionalArgumentList argumentList) {
        boolean prevCheckingArguments = this.checkingArguments;
        this.checkingArguments = true;
        super.visit(argumentList);
        this.checkingArguments = prevCheckingArguments;
    }

    @Override
    public void visit(Tree.StringLiteral literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            StringLiteralAnnotationTerm argument = new StringLiteralAnnotationTerm(ExpressionTransformer.literalValue(literal));
            this.appendLiteralArgument(literal, argument);
        }
    }

    @Override
    public void visit(Tree.CharLiteral literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            CharacterLiteralAnnotationTerm argument = new CharacterLiteralAnnotationTerm(ExpressionTransformer.literalValue(literal));
            this.appendLiteralArgument(literal, argument);
        }
    }

    @Override
    public void visit(Tree.FloatLiteral literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            try {
                FloatLiteralAnnotationTerm argument = new FloatLiteralAnnotationTerm(ExpressionTransformer.literalValue(literal));
                this.appendLiteralArgument(literal, argument);
            }
            catch (ErroneousException erroneousException) {
                // empty catch block
            }
        }
    }

    @Override
    public void visit(Tree.NaturalLiteral literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            try {
                IntegerLiteralAnnotationTerm argument = new IntegerLiteralAnnotationTerm(ExpressionTransformer.literalValue(literal).longValue());
                this.appendLiteralArgument(literal, argument);
            }
            catch (ErroneousException erroneousException) {
                // empty catch block
            }
        }
    }

    @Override
    public void visit(Tree.NegativeOp op) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            try {
                if (op.getTerm() instanceof Tree.NaturalLiteral) {
                    IntegerLiteralAnnotationTerm argument = new IntegerLiteralAnnotationTerm(ExpressionTransformer.literalValue(op).longValue());
                    this.appendLiteralArgument(op, argument);
                } else if (op.getTerm() instanceof Tree.FloatLiteral) {
                    FloatLiteralAnnotationTerm argument = new FloatLiteralAnnotationTerm(-ExpressionTransformer.literalValue((Tree.FloatLiteral)op.getTerm()));
                    this.appendLiteralArgument(op, argument);
                }
            }
            catch (ErroneousException erroneousException) {
                // empty catch block
            }
        }
    }

    @Override
    public void visit(Tree.MetaLiteral literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            DeclarationLiteralAnnotationTerm argument = new DeclarationLiteralAnnotationTerm(ExpressionTransformer.getSerializedMetaLiteral(literal));
            this.appendLiteralArgument(literal, argument);
        }
    }

    @Override
    public void visit(Tree.Tuple literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            CollectionLiteralAnnotationTerm prevElements = this.startCollection(literal);
            literal.visitChildren(this);
            this.endCollection(prevElements, literal);
        }
    }

    @Override
    public void visit(Tree.SequenceEnumeration literal) {
        if (this.annotationConstructor != null && (this.checkingArguments || this.checkingDefaults)) {
            CollectionLiteralAnnotationTerm prevElements = this.startCollection(literal);
            literal.visitChildren(this);
            this.endCollection(prevElements, literal);
        }
    }

    private void endCollection(CollectionLiteralAnnotationTerm prevElements, Tree.Term t) {
        this.term = this.elements;
        this.elements = prevElements;
        this.appendLiteralArgument(t, (CollectionLiteralAnnotationTerm)this.term);
    }

    private CollectionLiteralAnnotationTerm startCollection(Tree.Term t) {
        LiteralAnnotationTerm factory;
        Unit unit = t.getUnit();
        Type iteratedType = unit.getIteratedType(this.parameter().getType());
        if (iteratedType.isString()) {
            factory = StringLiteralAnnotationTerm.FACTORY;
        } else if (iteratedType.isInteger()) {
            factory = IntegerLiteralAnnotationTerm.FACTORY;
        } else if (iteratedType.isCharacter()) {
            factory = CharacterLiteralAnnotationTerm.FACTORY;
        } else if (iteratedType.isBoolean()) {
            factory = BooleanLiteralAnnotationTerm.FACTORY;
        } else if (iteratedType.isFloat()) {
            factory = FloatLiteralAnnotationTerm.FACTORY;
        } else if (Decl.isEnumeratedTypeWithAnonCases(iteratedType)) {
            factory = ObjectLiteralAnnotationTerm.FACTORY;
        } else {
            if (Decl.isAnnotationClass(iteratedType.getDeclaration())) {
                t.addError("compiler bug: iterables of annotation classes or annotation constructors not supported as literal " + (this.checkingDefaults ? "defaulted parameters" : "arguments"), Backend.Java);
                return null;
            }
            if (iteratedType.isSubtypeOf(((TypeDeclaration)unit.getLanguageModuleDeclarationDeclaration("Declaration")).getType())) {
                factory = DeclarationLiteralAnnotationTerm.FACTORY;
            } else {
                throw new RuntimeException();
            }
        }
        CollectionLiteralAnnotationTerm result = this.elements;
        this.elements = new CollectionLiteralAnnotationTerm(factory);
        return result;
    }

    @Override
    public void visit(Tree.Expression term) {
        if (this.annotationConstructor != null) {
            term.visitChildren(this);
        }
    }

    @Override
    public void visit(Tree.Term term) {
        if (this.annotationConstructor != null && !this.checkingDefaults) {
            term.addError("compiler bug: unsupported term " + term.getClass().getSimpleName(), Backend.Java);
        }
    }

    @Override
    public void visit(Tree.BaseMemberExpression bme) {
        if (this.annotationConstructor != null) {
            Declaration declaration = bme.getDeclaration();
            if (this.checkingInvocationPrimary && AnnotationModelVisitor.isAnnotationConstructor(bme.getDeclaration())) {
                Function ctor = (Function)bme.getDeclaration();
                this.instantiation.setPrimary(ctor);
                if (ctor.getAnnotationConstructor() != null && ctor.getAnnotationConstructor() != this.instantiation) {
                    for (AnnotationConstructorParameter p : ((AnnotationInvocation)ctor.getAnnotationConstructor()).getConstructorParameters()) {
                        this.instantiation.addConstructorParameter(p);
                    }
                }
            } else if (this.checkingArguments || this.checkingDefaults) {
                if (declaration instanceof Value && ((Value)declaration).isParameter()) {
                    Value constructorParameter = (Value)declaration;
                    ParameterAnnotationTerm a = new ParameterAnnotationTerm();
                    a.setSpread(this.spread);
                    a.setSourceParameter(constructorParameter.getInitializerParameter());
                    this.term = a;
                } else if (ModelUtil.isBooleanTrue(declaration)) {
                    BooleanLiteralAnnotationTerm argument = new BooleanLiteralAnnotationTerm(true);
                    this.appendLiteralArgument(bme, argument);
                } else if (ModelUtil.isBooleanFalse(declaration)) {
                    BooleanLiteralAnnotationTerm argument = new BooleanLiteralAnnotationTerm(false);
                    this.appendLiteralArgument(bme, argument);
                } else if (bme.getUnit().isEmptyType(bme.getTypeModel()) && bme.getUnit().isIterableType(bme.getTypeModel()) && this.elements == null) {
                    this.endCollection(this.startCollection(bme), bme);
                } else if (Decl.isAnonCaseOfEnumeratedType(bme)) {
                    ObjectLiteralAnnotationTerm argument = new ObjectLiteralAnnotationTerm(bme.getTypeModel());
                    this.appendLiteralArgument(bme, argument);
                } else {
                    bme.addError("compiler bug: unsupported base member expression in annotation constructor", Backend.Java);
                }
            } else {
                bme.addError("compiler bug: unsupported base member expression in annotation constructor", Backend.Java);
            }
        }
    }

    private LiteralAnnotationTerm appendLiteralArgument(Node bme, LiteralAnnotationTerm argument) {
        if (this.spread) {
            bme.addError("compiler bug: spread static arguments not supported", Backend.Java);
        }
        if (this.elements != null) {
            this.elements.addElement(argument);
        } else {
            this.term = argument;
        }
        return argument;
    }

    @Override
    public void visit(Tree.BaseTypeExpression bte) {
        if (this.annotationConstructor != null) {
            if (AnnotationModelVisitor.isAnnotationClass(bte.getDeclaration())) {
                this.instantiation.setPrimary((Class)bte.getDeclaration());
            } else {
                bte.addError("compiler bug: not an annotation class", Backend.Java);
            }
        }
    }

    @Override
    public void visit(Tree.PositionalArgument argument) {
        if (this.annotationConstructor != null && this.elements == null) {
            argument.addError("compiler bug: unsupported positional argument", Backend.Java);
        }
        super.visit(argument);
    }

    @Override
    public void visit(Tree.SpreadArgument argument) {
        if (this.annotationConstructor != null && this.elements == null) {
            this.spread = true;
            argument.getExpression().visit(this);
            AnnotationArgument aa = new AnnotationArgument();
            aa.setParameter(argument.getParameter());
            aa.setTerm(this.term);
            this.instantiation.getAnnotationArguments().add(aa);
            this.term = null;
            this.spread = false;
        } else {
            super.visit(argument);
        }
    }

    @Override
    public void visit(Tree.ListedArgument argument) {
        if (this.annotationConstructor != null && this.elements == null) {
            AnnotationArgument aa = new AnnotationArgument();
            aa.setParameter(argument.getParameter());
            this.push(aa);
            argument.getExpression().visit(this);
            aa.setTerm(this.term);
            this.instantiation.getAnnotationArguments().add(aa);
            this.term = null;
            this.pop();
        } else {
            super.visit(argument);
        }
    }

    @Override
    public void visit(Tree.NamedArgument argument) {
        if (this.annotationConstructor != null && this.elements == null) {
            argument.addError("compiler bug: unsupported named argument", Backend.Java);
        }
        super.visit(argument);
    }

    @Override
    public void visit(Tree.SpecifiedArgument argument) {
        if (this.annotationConstructor != null && this.elements == null) {
            AnnotationArgument aa = new AnnotationArgument();
            aa.setParameter(argument.getParameter());
            this.push(aa);
            argument.getSpecifierExpression().visit(this);
            aa.setTerm(this.term);
            this.instantiation.getAnnotationArguments().add(aa);
            this.term = null;
            this.pop();
        } else {
            super.visit(argument);
        }
    }
}

