/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.AnnotationTarget;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class AnnotationUtil {
    public static EnumSet<OutputElement> interopAnnotationTargeting(boolean isEe, EnumSet<OutputElement> outputs, Tree.Annotation annotation, boolean errors, boolean warnings, Declaration d) {
        Declaration annoCtor = ((Tree.BaseMemberExpression)annotation.getPrimary()).getDeclaration();
        if (annoCtor instanceof AnnotationProxyMethod) {
            AnnotationProxyMethod proxyCtor = (AnnotationProxyMethod)annoCtor;
            AnnotationProxyClass annoClass = proxyCtor.getProxyClass();
            EnumSet<OutputElement> possibleTargets = proxyCtor.getAnnotationTarget() != null ? EnumSet.of(proxyCtor.getAnnotationTarget()) : AnnotationTarget.outputTargets(annoClass);
            Object actualTargets = possibleTargets.clone();
            ((AbstractCollection)actualTargets).retainAll(outputs);
            if (((AbstractCollection)actualTargets).size() > 1) {
                if (warnings) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("ambiguous annotation target: ").append(annoCtor.getName());
                    sb.append(" could be applied to several targets, use one of ");
                    Iterator iterator = ((AbstractCollection)actualTargets).iterator();
                    while (iterator.hasNext()) {
                        OutputElement x = (OutputElement)((Object)iterator.next());
                        sb.append(Naming.getDisambigAnnoCtorName(((AnnotationProxyMethod)annoCtor).getProxyClass().iface, x));
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(" to disambiguate");
                    annotation.addUsageWarning(Warning.ambiguousAnnotation, sb.toString(), Backend.Java);
                }
                AnnotationUtil.checkForLateFieldAnnotation(isEe, annotation, d, annoCtor, possibleTargets, (EnumSet<OutputElement>)actualTargets);
                return null;
            }
            if (((AbstractCollection)actualTargets).size() == 0 && errors) {
                annotation.addError("no target for " + annoCtor.getName() + " annotation: @Target of @interface " + annoClass.iface.getName() + " lists " + possibleTargets + " but annotated element tranforms to " + outputs, Backend.Java);
            }
            AnnotationUtil.checkForLateFieldAnnotation(isEe, annotation, d, annoCtor, possibleTargets, (EnumSet<OutputElement>)actualTargets);
            return actualTargets;
        }
        return null;
    }

    protected static void checkForLateFieldAnnotation(boolean isEe, Tree.Annotation annotation, Declaration d, Declaration annoCtor, EnumSet<OutputElement> possibleTargets, EnumSet<OutputElement> actualTargets) {
        if (actualTargets.contains((Object)OutputElement.FIELD) && d instanceof Value && !isEe && ((Value)d).isLate() && (annotation.getUnit().isOptionalType(((Value)d).getType()) || ((Value)d).getType().isInteger() || ((Value)d).getType().isFloat() || ((Value)d).getType().isBoolean() || ((Value)d).getType().isByte() || ((Value)d).getType().isCharacter())) {
            StringBuilder sb = new StringBuilder();
            sb.append("the 'late' attribute '").append(d.getName()).append("' cannot be properly initialized just by setting the field value ").append("because ").append(annotation.getUnit().isOptionalType(((Value)d).getType()) ? "it has an optional type: " : "it is erased to a primitive type: ");
            sb.append("depending on the semantics of '" + annoCtor.getName() + "' consider ");
            if (possibleTargets.contains((Object)OutputElement.GETTER)) {
                sb.append("annotating the JavaBean Property getter with " + annoCtor.getName() + "__GETTER");
                if (possibleTargets.contains((Object)OutputElement.SETTER)) {
                    sb.append(" or its setter with " + annoCtor.getName() + "__SETTER ");
                }
                sb.append("or ");
            }
            sb.append("making it non-'late'");
            annotation.addUsageWarning(Warning.ambiguousAnnotation, sb.toString(), Backend.Java);
        }
    }

    public static EnumSet<OutputElement> outputs(Tree.ObjectDefinition that) {
        return EnumSet.of(OutputElement.TYPE, OutputElement.CONSTRUCTOR, OutputElement.FIELD, OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyClass that) {
        EnumSet<OutputElement> result = EnumSet.of(OutputElement.TYPE);
        if (!that.getDeclarationModel().hasConstructors()) {
            result.add(OutputElement.CONSTRUCTOR);
        }
        if (that.getDeclarationModel().isAnnotation()) {
            result.add(OutputElement.ANNOTATION_TYPE);
        }
        return result;
    }

    public static EnumSet<OutputElement> outputs(Tree.PackageDescriptor annotated) {
        return EnumSet.of(OutputElement.TYPE, OutputElement.PACKAGE);
    }

    public static EnumSet<OutputElement> outputs(Tree.ImportModule annotated) {
        return EnumSet.of(OutputElement.FIELD);
    }

    public static EnumSet<OutputElement> outputs(Tree.ModuleDescriptor annotated) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.TypeAliasDeclaration that) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyInterface that) {
        return EnumSet.of(OutputElement.TYPE);
    }

    public static EnumSet<OutputElement> outputs(Tree.Constructor annotated) {
        return EnumSet.of(OutputElement.CONSTRUCTOR);
    }

    public static EnumSet<OutputElement> outputs(Tree.Enumerated annotated) {
        return EnumSet.of(OutputElement.CONSTRUCTOR, OutputElement.FIELD, OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AnyMethod that) {
        return EnumSet.of(OutputElement.METHOD);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeGetterDefinition that) {
        return EnumSet.of(OutputElement.GETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeSetterDefinition that) {
        return EnumSet.of(OutputElement.SETTER);
    }

    public static EnumSet<OutputElement> outputs(Tree.AttributeDeclaration that) {
        EnumSet<OutputElement> result = EnumSet.noneOf(OutputElement.class);
        Value declarationModel = that.getDeclarationModel();
        if (declarationModel != null) {
            if (declarationModel.isClassMember()) {
                if (declarationModel.isParameter()) {
                    result.add(OutputElement.PARAMETER);
                }
                if (declarationModel.isShared() || declarationModel.isCaptured()) {
                    result.add(OutputElement.GETTER);
                    if (!(that.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression)) {
                        result.add(OutputElement.FIELD);
                    }
                } else if (!declarationModel.isParameter()) {
                    result.add(OutputElement.LOCAL_VARIABLE);
                }
            } else if (declarationModel.isInterfaceMember()) {
                result.add(OutputElement.GETTER);
            } else if (declarationModel.isToplevel()) {
                result.add(OutputElement.GETTER);
                if (!declarationModel.isTransient()) {
                    result.add(OutputElement.FIELD);
                }
            } else if (declarationModel.isParameter()) {
                result.add(OutputElement.PARAMETER);
            } else {
                result.add(OutputElement.LOCAL_VARIABLE);
            }
        }
        if (result.contains((Object)OutputElement.GETTER) && (declarationModel.isVariable() && !declarationModel.isTransient() || declarationModel.isLate())) {
            result.add(OutputElement.SETTER);
        }
        return result;
    }

    public static void duplicateInteropAnnotation(boolean isEe, EnumSet<OutputElement> outputs, List<Tree.Annotation> annotations, Declaration d) {
        block0: for (int i = 0; i < annotations.size(); ++i) {
            TypeDeclaration td;
            Tree.Annotation ann = annotations.get(i);
            Type t = ann.getTypeModel();
            EnumSet<OutputElement> mainTargets = AnnotationUtil.interopAnnotationTargeting(isEe, outputs, ann, false, false, d);
            if (t == null || mainTargets == null || ModelUtil.isCeylonDeclaration(td = t.getDeclaration())) continue;
            for (int j = 0; j < i; ++j) {
                EnumSet<OutputElement> sameTargets;
                EnumSet<OutputElement> dupeTargets;
                TypeDeclaration otd;
                Tree.Annotation other = annotations.get(j);
                Type ot = other.getTypeModel();
                if (ot == null || !(otd = ot.getDeclaration()).equals(td) || (dupeTargets = AnnotationUtil.interopAnnotationTargeting(isEe, outputs, other, false, false, d)) == null || (sameTargets = AnnotationUtil.intersection(mainTargets, dupeTargets)).isEmpty()) continue;
                ann.addError("duplicate annotation: there are multiple annotations of type '" + td.getName() + "' for targets: '" + sameTargets + "'");
                continue block0;
            }
        }
    }

    private static EnumSet<OutputElement> intersection(EnumSet<OutputElement> mainTargets, EnumSet<OutputElement> dupeTargets) {
        EnumSet<OutputElement> intersect = EnumSet.copyOf(mainTargets);
        intersect.retainAll(dupeTargets);
        return intersect;
    }

    public static boolean isNaturalTarget(Function annotationCtorDecl, Object useSite, OutputElement target) {
        EnumSet<AnnotationTarget> interopTargets;
        if (annotationCtorDecl instanceof AnnotationProxyMethod) {
            AnnotationProxyMethod annotationProxyMethod = (AnnotationProxyMethod)annotationCtorDecl;
            if (annotationProxyMethod.getAnnotationTarget() == target) {
                return true;
            }
            interopTargets = annotationProxyMethod.getAnnotationTargets();
        } else {
            interopTargets = null;
        }
        if (useSite instanceof Declaration) {
            if (ModelUtil.isConstructor((Declaration)useSite)) {
                if (useSite instanceof Functional) {
                    return target == OutputElement.CONSTRUCTOR;
                }
                if (useSite instanceof Value) {
                    Class constructedClass = Decl.getConstructedClass((Declaration)useSite);
                    if (constructedClass.isToplevel() || constructedClass.isClassMember()) {
                        return target == OutputElement.GETTER;
                    }
                    return target == OutputElement.CONSTRUCTOR;
                }
            } else {
                if (useSite instanceof Class) {
                    if (((Class)useSite).getParameterList() != null && interopTargets != null && interopTargets.contains((Object)AnnotationTarget.CONSTRUCTOR) && !interopTargets.contains((Object)AnnotationTarget.TYPE)) {
                        return target == OutputElement.CONSTRUCTOR;
                    }
                    return target == OutputElement.TYPE;
                }
                if (useSite instanceof Interface) {
                    return target == OutputElement.TYPE;
                }
                if (useSite instanceof Value) {
                    boolean p;
                    Value value = (Value)useSite;
                    boolean bl = p = value.isParameter() && target == OutputElement.PARAMETER;
                    if (annotationCtorDecl instanceof AnnotationProxyMethod) {
                        if (!value.isTransient() && (interopTargets == null || interopTargets.contains((Object)AnnotationTarget.FIELD))) {
                            return target == OutputElement.FIELD;
                        }
                        return target == OutputElement.GETTER;
                    }
                    return p || target == OutputElement.GETTER;
                }
                if (useSite instanceof Setter) {
                    return target == OutputElement.SETTER;
                }
                if (useSite instanceof Function) {
                    return target == OutputElement.METHOD;
                }
                if (useSite instanceof Constructor) {
                    return target == OutputElement.CONSTRUCTOR;
                }
                if (useSite instanceof TypeAlias) {
                    return target == OutputElement.TYPE;
                }
            }
        } else {
            if (useSite instanceof Package) {
                return annotationCtorDecl instanceof AnnotationProxyMethod ? target == OutputElement.PACKAGE : target == OutputElement.TYPE;
            }
            if (useSite instanceof Module) {
                return target == OutputElement.TYPE;
            }
            if (useSite instanceof Tree.ImportModule) {
                return target == OutputElement.FIELD;
            }
        }
        throw new RuntimeException("" + useSite);
    }
}

