/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AttributeDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.GenericBuilder;
import com.redhat.ceylon.compiler.java.codegen.InitializerBuilder;
import com.redhat.ceylon.compiler.java.codegen.MethodDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ParameterDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.java.codegen.recovery.TransformationPlan;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.langtools.tools.javac.code.BoundKind;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassDefinitionBuilder
implements GenericBuilder<ClassDefinitionBuilder> {
    private final AbstractTransformer gen;
    private final String name;
    private long modifiers;
    private InitializerBuilder initBuilder;
    private boolean isAlias = false;
    private boolean isLocal = false;
    private boolean hasConstructors = false;
    private ClassOrInterface forDefinition;
    private final ListBuffer<JCTree.JCExpression> satisfies = new ListBuffer();
    private final ListBuffer<JCTree.JCTypeParameter> typeParams = new ListBuffer();
    private final ListBuffer<JCTree.JCExpression> typeParamAnnotations = new ListBuffer();
    private final ListBuffer<JCTree.JCAnnotation> annotations = new ListBuffer();
    private final ListBuffer<MethodDefinitionBuilder> constructors = new ListBuffer();
    private final ListBuffer<JCTree> defs = new ListBuffer();
    private ClassDefinitionBuilder concreteInterfaceMemberDefs;
    private final ListBuffer<JCTree> before = new ListBuffer();
    private final ListBuffer<JCTree> after = new ListBuffer();
    private boolean built = false;
    private boolean isCompanion = false;
    private boolean isBroken = false;
    private ClassDefinitionBuilder containingClassBuilder;
    private Type extendingType;
    private Type thisType;
    private Node at;
    private boolean ignoreAnnotations = false;
    private boolean noAnnotations = false;
    private boolean hasDelegatingConstructors;

    public static ClassDefinitionBuilder klass(AbstractTransformer gen, String javaClassName, String ceylonClassName, boolean isLocal) {
        ClassDefinitionBuilder builder = new ClassDefinitionBuilder(gen, javaClassName, ceylonClassName, isLocal);
        builder.setContainingClassBuilder(gen.current());
        gen.replace(builder);
        return builder;
    }

    public static ClassDefinitionBuilder object(AbstractTransformer gen, String javaClassName, String ceylonClassName, boolean isLocal) {
        return ClassDefinitionBuilder.klass(gen, javaClassName, ceylonClassName, isLocal);
    }

    public static ClassDefinitionBuilder methodWrapper(AbstractTransformer gen, String ceylonClassName, boolean shared, boolean javaStrictfp) {
        ClassDefinitionBuilder builder = new ClassDefinitionBuilder(gen, Naming.quoteClassName(ceylonClassName), null, false);
        builder.setContainingClassBuilder(gen.current());
        gen.replace(builder);
        builder.initBuilder.modifiers(2L);
        return builder.annotations(gen.makeAtMethod()).modifiers(0x10 | (shared ? 1 : 0) | (javaStrictfp ? 2048 : 0));
    }

    private ClassDefinitionBuilder(AbstractTransformer gen, String javaClassName, String ceylonClassName, boolean isLocal) {
        this.gen = gen;
        this.initBuilder = new InitializerBuilder(gen);
        this.name = javaClassName;
        this.isLocal = isLocal;
        this.annotations(gen.makeAtCeylon());
        if (ceylonClassName != null && (!ceylonClassName.equals(javaClassName) || isLocal)) {
            this.annotations(gen.makeAtName(ceylonClassName));
        }
    }

    void setContainingClassBuilder(ClassDefinitionBuilder containingClassBuilder) {
        this.containingClassBuilder = containingClassBuilder;
    }

    public String toString() {
        return "CDB for " + (this.isInterface() ? "interface " : "class ") + this.name;
    }

    ClassDefinitionBuilder getContainingClassBuilder() {
        return this.containingClassBuilder;
    }

    private ClassDefinitionBuilder getTopLevelBuilder() {
        ClassDefinitionBuilder result = this;
        while (result.getContainingClassBuilder() != null) {
            result = result.getContainingClassBuilder();
        }
        return result;
    }

    public ClassDefinitionBuilder at(Node at) {
        this.at = at;
        return this;
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> build() {
        if (this.built) {
            throw new BugException("already built");
        }
        this.built = true;
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        this.appendDefinitionsTo(defs);
        if (!this.typeParamAnnotations.isEmpty() || this.typeParams.size() != this.typeParamAnnotations.size()) {
            this.annotations(this.gen.makeAtTypeParameters(this.typeParamAnnotations.toList()));
        }
        JCTree.JCClassDecl klass = this.gen.at(this.at).ClassDef(this.gen.make().Modifiers(this.modifiers, this.getAnnotations()), this.gen.names().fromString(this.name), this.typeParams.toList(), this.getSuperclass(this.extendingType), this.satisfies.toList(), defs.toList());
        ListBuffer<JCTree> klasses = new ListBuffer<JCTree>();
        if (this.isInterface()) {
            if (this == this.getTopLevelBuilder()) {
                klasses.appendList(this.before.toList());
                klasses.append(klass);
                if (this.hasCompanion()) {
                    klasses.appendList(this.concreteInterfaceMemberDefs.build());
                }
                klasses.appendList(this.after.toList());
            } else {
                if (this.hasCompanion()) {
                    klasses.appendList(this.concreteInterfaceMemberDefs.build());
                }
                this.getTopLevelBuilder().before(klass);
            }
        } else {
            klasses.appendList(this.before.toList());
            if (this.hasCompanion()) {
                klasses.appendList(this.concreteInterfaceMemberDefs.build());
            }
            klasses.append(klass);
            klasses.appendList(this.after.toList());
        }
        this.restoreClassBuilder();
        return klasses.toList();
    }

    public void restoreClassBuilder() {
        this.gen.replace(this.getContainingClassBuilder());
    }

    private boolean isInterface() {
        return (this.modifiers & 0x200L) != 0L;
    }

    String getClassName() {
        return this.name;
    }

    private boolean hasCompanion() {
        return !this.isAlias && this.concreteInterfaceMemberDefs != null && (this.isInterface() || !this.concreteInterfaceMemberDefs.defs.isEmpty() || !this.concreteInterfaceMemberDefs.getInitBuilder().isEmptyInit() || !this.concreteInterfaceMemberDefs.constructors.isEmpty());
    }

    void before(JCTree also) {
        this.before.append(also);
    }

    void after(JCTree also) {
        this.after.append(also);
    }

    private void appendDefinitionsTo(ListBuffer<JCTree> defs) {
        if (!this.isInterface()) {
            for (MethodDefinitionBuilder builder : this.constructors) {
                if (this.noAnnotations || this.ignoreAnnotations) {
                    builder.noModelAnnotations();
                }
                defs.append(builder.build());
            }
            if (!this.isCompanion && !this.hasConstructors) {
                defs.append(this.initBuilder.build());
            }
        }
        defs.appendList(this.defs);
    }

    private JCTree.JCExpression getSuperclass(Type extendedType) {
        JCTree.JCExpression superclass = extendedType != null ? this.gen.makeJavaType(extendedType, 2) : (this.isInterface() ? this.gen.makeIdent(this.gen.syms().objectType) : null);
        return superclass;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> transformTypesList(List<Type> types) {
        if (types == null) {
            return com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        }
        ListBuffer<JCTree.JCExpression> typesList = new ListBuffer<JCTree.JCExpression>();
        for (Type t : types) {
            JCTree.JCExpression jt = this.gen.makeJavaType(t, 1);
            if (jt == null) continue;
            typesList.append(jt);
        }
        return typesList.toList();
    }

    public MethodDefinitionBuilder addConstructor(boolean deprecated) {
        MethodDefinitionBuilder constructor = MethodDefinitionBuilder.constructor(this.gen, deprecated);
        this.constructors.append(constructor);
        return constructor;
    }

    public MethodDefinitionBuilder addConstructorWithInitCode(boolean deprecated) {
        MethodDefinitionBuilder constructor = this.addConstructor(deprecated);
        constructor.body(this.initBuilder.build().body.stats);
        return constructor;
    }

    public ClassDefinitionBuilder noInitConstructor() {
        this.hasConstructors = true;
        return this;
    }

    public ClassDefinitionBuilder modifiers(long modifiers) {
        this.modifiers = this.forDefinition instanceof Interface ? modifiers & 0xFFFFFFFFFFFFFFF7L : modifiers;
        if (this.concreteInterfaceMemberDefs != null) {
            this.concreteInterfaceMemberDefs.modifiers(modifiers & 0x809L | 0x10L);
        }
        return this;
    }

    public ClassDefinitionBuilder typeParameter(String name, List<Type> satisfiedTypes, List<Type> caseTypes, boolean covariant, boolean contravariant, Type defaultValue, boolean addModelAnnotation) {
        this.typeParams.append(this.typeParam(name, this.gen.makeTypeParameterBounds(satisfiedTypes)));
        if (addModelAnnotation) {
            this.typeParamAnnotations.append(this.gen.makeAtTypeParameter(name, satisfiedTypes, caseTypes, covariant, contravariant, defaultValue));
        }
        return this;
    }

    private JCTree.JCTypeParameter typeParam(String name, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> bounds) {
        return this.gen.make().TypeParameter(this.gen.names().fromString(name), bounds);
    }

    @Override
    public ClassDefinitionBuilder typeParameter(TypeParameter declarationModel) {
        return this.typeParameter(declarationModel, true);
    }

    public ClassDefinitionBuilder typeParameter(TypeParameter declarationModel, boolean addModelAnnotation) {
        return this.typeParameter(declarationModel.getName(), declarationModel.getSatisfiedTypes(), declarationModel.getCaseTypes(), declarationModel.isCovariant(), declarationModel.isContravariant(), declarationModel.getDefaultTypeArgument(), addModelAnnotation);
    }

    public ClassDefinitionBuilder extending(Type thisType, Type extendingType) {
        if (!this.isAlias) {
            this.thisType = thisType;
            this.extendingType = extendingType;
            this.hasConstructors = ((Class)thisType.getDeclaration()).hasConstructors() || ((Class)thisType.getDeclaration()).hasEnumerated();
        }
        return this;
    }

    public ClassDefinitionBuilder reifiedType() {
        this.satisfies.add(this.gen.makeReifiedTypeType());
        return this;
    }

    public ClassDefinitionBuilder serializable() {
        this.satisfies.add(this.gen.makeSerializableType());
        return this;
    }

    public ClassDefinitionBuilder satisfies(List<Type> satisfies) {
        this.satisfies.addAll((Collection<JCTree.JCExpression>)this.transformTypesList(satisfies));
        this.annotations(this.gen.makeAtSatisfiedTypes(satisfies));
        return this;
    }

    public ClassDefinitionBuilder caseTypes(List<Type> caseTypes, Type ofType) {
        if (caseTypes != null || ofType != null) {
            this.annotations(this.gen.makeAtCaseTypes(caseTypes, ofType));
        }
        return this;
    }

    public ClassDefinitionBuilder ignoreAnnotations() {
        this.ignoreAnnotations = true;
        return this;
    }

    public ClassDefinitionBuilder noAnnotations() {
        this.noAnnotations = true;
        return this;
    }

    public ClassDefinitionBuilder annotations(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annotations) {
        this.annotations.appendList(annotations);
        return this;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> getAnnotations() {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> ret = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        if (!this.noAnnotations) {
            if (this.ignoreAnnotations) {
                ret = ret.prependList(this.gen.makeAtIgnore());
            } else {
                boolean jpaConstructor;
                boolean bl = jpaConstructor = this.thisType != null && Strategy.generateJpaCtor((Class)this.thisType.getDeclaration());
                if (this.hasConstructors || this.thisType != null) {
                    Type exType = this.extendingType;
                    if (this.extendingType != null && this.extendingType.getDeclaration().isNativeHeader()) {
                        exType = this.extendingType.getExtendedType();
                    }
                    ret = ret.prependList(this.gen.makeAtClass(this.thisType, exType, this.hasConstructors));
                }
                ret = ret.prependList(this.annotations.toList());
            }
        }
        if (this.isBroken) {
            ret = ret.prependList(this.gen.makeAtCompileTimeError());
        }
        return ret;
    }

    public ClassDefinitionBuilder attribute(AttributeDefinitionBuilder adb) {
        if (adb != null) {
            this.defs(adb.build());
        }
        return this;
    }

    public ClassDefinitionBuilder method(MethodDefinitionBuilder mdb) {
        if (mdb != null) {
            this.defs(mdb.build());
        }
        return this;
    }

    public ClassDefinitionBuilder methods(com.redhat.ceylon.langtools.tools.javac.util.List<MethodDefinitionBuilder> mdbs) {
        for (MethodDefinitionBuilder mdb : mdbs) {
            this.method(mdb);
        }
        return this;
    }

    public ClassDefinitionBuilder defs(JCTree statement) {
        if (statement != null) {
            this.defs.append(statement);
        }
        return this;
    }

    public ClassDefinitionBuilder defs(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs) {
        if (defs != null) {
            this.defs.appendList(defs);
        }
        return this;
    }

    public ClassDefinitionBuilder getCompanionBuilder(TypeDeclaration decl) {
        if (this.concreteInterfaceMemberDefs == null && (decl instanceof Class || CodegenUtil.isCompanionClassNeeded(decl))) {
            String className = this.gen.naming.getCompanionClassName(decl, false);
            this.concreteInterfaceMemberDefs = new ClassDefinitionBuilder(this.gen, className, decl.getName(), this.isLocal).ignoreAnnotations();
            this.concreteInterfaceMemberDefs.introduce(this.gen.make().QualIdent(this.gen.syms().serializableType.tsym));
            this.concreteInterfaceMemberDefs.isCompanion = true;
        }
        return this.concreteInterfaceMemberDefs;
    }

    public ClassDefinitionBuilder getCompanionBuilder2(TypeDeclaration decl) {
        ClassDefinitionBuilder companionBuilder = this.getCompanionBuilder(decl);
        if (companionBuilder == null) {
            return null;
        }
        if (decl instanceof Generic) {
            companionBuilder.reifiedTypeParameters(decl.getTypeParameters());
        }
        Type thisType = decl.getType();
        companionBuilder.field(18L, "$this", this.gen.makeJavaType(thisType), null, false, this.gen.makeAtIgnore());
        MethodDefinitionBuilder ctor = companionBuilder.addConstructorWithInitCode(decl.isDeprecated());
        ctor.ignoreModelAnnotations();
        if (decl instanceof Generic) {
            ctor.reifiedTypeParameters(decl.getTypeParameters());
        }
        ctor.modifiers(decl.isShared() ? 1L : 0L);
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.implicitParameter(this.gen, "$this");
        pdb.type(new TransformedType(this.gen.makeJavaType(thisType), null, this.gen.makeAtNonNull()));
        ctor.parameter(pdb);
        ListBuffer<JCTree.JCExpressionStatement> bodyStatements = ListBuffer.of(this.gen.make().Exec(this.gen.make().Assign(this.gen.makeSelect(this.gen.naming.makeThis(), "$this"), this.gen.naming.makeQuotedThis())));
        ctor.body(bodyStatements.toList());
        if (decl instanceof Generic && !decl.getTypeParameters().isEmpty()) {
            companionBuilder.addRefineReifiedTypeParametersMethod(decl.getTypeParameters());
        }
        return companionBuilder;
    }

    public ClassDefinitionBuilder field(long modifiers, String attrName, JCTree.JCExpression type, JCTree.JCExpression initialValue, boolean isLocal) {
        return this.field(modifiers, attrName, type, initialValue, isLocal, com.redhat.ceylon.langtools.tools.javac.util.List.nil());
    }

    public ClassDefinitionBuilder field(long modifiers, String attrName, JCTree.JCExpression type, JCTree.JCExpression initialValue, boolean isLocal, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annotations) {
        if (!isLocal) {
            Name attrNameNm = this.gen.names().fromString(Naming.quoteFieldName(attrName));
            JCTree.JCExpression fieldInit = (modifiers & 8L) != 0L ? initialValue : null;
            this.defs(this.gen.make().VarDef(this.gen.make().Modifiers(modifiers, annotations), attrNameNm, type, fieldInit));
            if (initialValue != null && (modifiers & 8L) == 0L) {
                this.initBuilder.init(this.gen.make().Exec(this.gen.make().Assign(this.gen.makeSelect("this", Naming.quoteFieldName(attrName)), initialValue)));
            }
        } else {
            Name attrNameNm = this.gen.names().fromString(Naming.quoteLocalValueName(attrName));
            this.initBuilder.init(this.gen.make().VarDef(this.gen.make().Modifiers(modifiers), attrNameNm, type, initialValue));
        }
        return this;
    }

    public ClassDefinitionBuilder method(Tree.AnyMethod method, TransformationPlan plan) {
        this.methods(this.gen.classGen().transform(method, plan, this));
        return this;
    }

    public ClassDefinitionBuilder modelAnnotations(List<Annotation> annotations) {
        this.annotations(this.gen.makeAtAnnotations(annotations));
        return this;
    }

    public ClassDefinitionBuilder isAlias(boolean isAlias) {
        this.isAlias = isAlias;
        return this;
    }

    public ClassDefinitionBuilder forDefinition(ClassOrInterface def) {
        this.forDefinition = def;
        this.hasConstructors = def instanceof Class && (((Class)def).hasConstructors() || ((Class)def).hasEnumerated());
        return this;
    }

    public ClassOrInterface getForDefinition() {
        return this.forDefinition;
    }

    public ClassDefinitionBuilder reifiedTypeParameter(Tree.TypeParameterDeclaration param) {
        TypeParameter tp = param.getDeclarationModel();
        return this.reifiedTypeParameter(tp);
    }

    public ClassDefinitionBuilder reifiedTypeParameter(TypeParameter tp) {
        String descriptorName = this.gen.naming.getTypeArgumentDescriptorName(tp);
        this.initBuilder.parameter(this.makeReifiedParameter(descriptorName));
        this.defs(this.gen.makeReifiedTypeParameterVarDecl(tp, this.isCompanion));
        this.initBuilder.init(this.gen.makeReifiedTypeParameterAssignment(tp));
        return this;
    }

    private ParameterDefinitionBuilder makeReifiedParameter(String descriptorName) {
        ParameterDefinitionBuilder pdb = ParameterDefinitionBuilder.implicitParameter(this.gen, descriptorName);
        pdb.type(new TransformedType(this.gen.makeTypeDescriptorType(), null, this.gen.makeAtNonNull()));
        pdb.modifiers(16L);
        if (!this.isCompanion) {
            pdb.ignored();
        }
        return pdb;
    }

    public ClassDefinitionBuilder addGetTypeMethod(Type type) {
        if (!this.isInterface()) {
            MethodDefinitionBuilder method = MethodDefinitionBuilder.systemMethod(this.gen, this.gen.naming.getGetTypeMethodName());
            method.modifiers(1L);
            method.resultType(new TransformedType(this.gen.makeTypeDescriptorType(), null, this.gen.makeAtNonNull()));
            method.isOverride(true);
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().Return(this.gen.makeReifiedTypeArgument(type)));
            method.body(body);
            this.defs(method.build());
        }
        return this;
    }

    public ClassDefinitionBuilder addAnnotationTypeMethod(Type type) {
        MethodDefinitionBuilder method = MethodDefinitionBuilder.systemMethod(this.gen, "annotationType");
        method.modifiers(1L);
        method.resultType(new TransformedType(this.gen.make().TypeApply(this.gen.make().QualIdent(this.gen.syms().classType.tsym), com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().Wildcard(this.gen.make().TypeBoundKind(BoundKind.EXTENDS), this.gen.make().Type(this.gen.syms().annotationType)))), null, this.gen.makeAtNonNull()));
        method.isOverride(true);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = com.redhat.ceylon.langtools.tools.javac.util.List.of(this.gen.make().Return(this.gen.makeClassLiteral(type, 4096)));
        method.body(body);
        JCTree.JCMethodDecl build = method.build();
        this.defs(build);
        return this;
    }

    public void reifiedTypeParameters(List<TypeParameter> typeParameterList) {
        for (TypeParameter tp : typeParameterList) {
            this.reifiedTypeParameter(tp);
        }
    }

    public ClassDefinitionBuilder addRefineReifiedTypeParametersMethod(List<TypeParameter> typeParameterList) {
        MethodDefinitionBuilder method = MethodDefinitionBuilder.systemMethod(this.gen, this.gen.naming.getRefineTypeParametersMethodName());
        method.modifiers(1L);
        method.ignoreModelAnnotations();
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
        for (TypeParameter tp : typeParameterList) {
            String descriptorName = this.gen.naming.getTypeArgumentDescriptorName(tp);
            method.parameter(this.makeReifiedParameter(descriptorName));
            body = body.prepend(this.gen.makeReifiedTypeParameterAssignment(tp));
        }
        method.body(body);
        this.defs(method.build());
        return this;
    }

    public ClassDefinitionBuilder refineReifiedType(Type thisType) {
        Interface iface = (Interface)thisType.getDeclaration();
        String companion = this.gen.naming.getCompanionFieldName(iface);
        ListBuffer<JCTree.JCExpression> typeParameters = new ListBuffer<JCTree.JCExpression>();
        for (Type tp : thisType.getTypeArgumentList()) {
            typeParameters.add(this.gen.makeReifiedTypeArgument(tp));
        }
        JCTree.JCMethodInvocation refine = this.gen.make().Apply(null, this.gen.makeSelect(companion, this.gen.naming.getRefineTypeParametersMethodName()), typeParameters.toList());
        this.initBuilder.init(this.gen.make().Exec(refine));
        return this;
    }

    public void reifiedAlias(Type type) {
        try (AbstractTransformer.SavedPosition savedPos = this.gen.noPosition();){
            JCTree.JCExpression klass = this.gen.makeUnerasedClassLiteral(type.getDeclaration());
            JCTree.JCMethodInvocation classDescriptor = this.gen.make().Apply(null, this.gen.makeSelect(this.gen.makeTypeDescriptorType(), "klass"), com.redhat.ceylon.langtools.tools.javac.util.List.of(klass));
            JCTree.JCVariableDecl varDef = this.gen.make().VarDef(this.gen.make().Modifiers(25L, this.gen.makeAtIgnore()), this.gen.names().fromString(this.gen.naming.getTypeDescriptorAliasName()), this.gen.makeTypeDescriptorType(), classDescriptor);
            this.defs(varDef);
        }
    }

    public ClassDefinitionBuilder broken() {
        this.getTopLevelBuilder().isBroken = true;
        return this;
    }

    public void isDynamic(boolean dynamic) {
        if (dynamic) {
            this.annotations(this.gen.makeAtDynamic());
        }
    }

    public InitializerBuilder getInitBuilder() {
        return this.initBuilder;
    }

    public boolean isCompanionBuilder() {
        return this.isCompanion;
    }

    public ClassDefinitionBuilder hasDelegatingConstructors(boolean hasDelegatingConstructors) {
        this.hasDelegatingConstructors = hasDelegatingConstructors;
        return this;
    }

    public boolean hasDelegatingConstructors() {
        return this.hasDelegatingConstructors;
    }

    public Iterable<JCTree.JCVariableDecl> getFields() {
        ArrayList<JCTree.JCVariableDecl> result = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree t : this.defs) {
            if (!(t instanceof JCTree.JCVariableDecl)) continue;
            result.add((JCTree.JCVariableDecl)t);
        }
        return result;
    }

    public void introduce(JCTree.JCExpression qualIdent) {
        this.satisfies.add(qualIdent);
    }
}

