/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CallBuilder;
import com.redhat.ceylon.compiler.java.codegen.CallableBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.ExpressionAndType;
import com.redhat.ceylon.compiler.java.codegen.ExpressionTransformer;
import com.redhat.ceylon.compiler.java.codegen.Invocation;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.Strategy;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

class NamedArgumentInvocation
extends Invocation {
    private final Tree.NamedArgumentList namedArgumentList;
    private final ListBuffer<JCTree.JCStatement> vars = new ListBuffer();
    private final Naming.SyntheticName callVarName;
    private final Naming.SyntheticName varBaseName;
    private final Set<String> argNames = new HashSet<String>();
    private final TreeMap<Integer, Naming.SyntheticName> argsNamesByIndex = new TreeMap();
    private final TreeMap<Integer, ExpressionAndType> argsAndTypes = new TreeMap();
    private final Set<Parameter> bound = new HashSet<Parameter>();
    private Reference producedReference;

    public NamedArgumentInvocation(AbstractTransformer gen, Tree.Term primary, Declaration primaryDeclaration, Reference producedReference, Tree.InvocationExpression invocation) {
        super(gen, primary, primaryDeclaration, invocation.getTypeModel(), invocation);
        this.producedReference = producedReference;
        this.namedArgumentList = invocation.getNamedArgumentList();
        this.varBaseName = gen.naming.alias("arg");
        this.callVarName = this.varBaseName.suffixedBy(NamingBase.Suffix.$callable$);
    }

    @Override
    protected void addReifiedArguments(ListBuffer<ExpressionAndType> result) {
        Reference ref = this.gen.resolveAliasesForReifiedTypeArguments(this.producedReference);
        if (!AbstractTransformer.supportsReified(ref.getDeclaration())) {
            return;
        }
        int tpCount = this.gen.getTypeParameters(ref).size();
        for (int tpIndex = 0; tpIndex < tpCount; ++tpIndex) {
            result.append(new ExpressionAndType(this.reifiedTypeArgName(tpIndex).makeIdent(), this.gen.makeTypeDescriptorType()));
        }
    }

    ListBuffer<JCTree.JCStatement> getVars() {
        return this.vars;
    }

    Iterable<Naming.SyntheticName> getArgsNamesByIndex() {
        return this.argsNamesByIndex.values();
    }

    Iterable<ExpressionAndType> getArgumentsAndTypes() {
        return this.argsAndTypes.values();
    }

    private void buildVars() {
        if (this.getPrimaryDeclaration() == null) {
            return;
        }
        boolean prev = this.gen.expressionGen().withinInvocation(false);
        List<Tree.NamedArgument> namedArguments = this.namedArgumentList.getNamedArguments();
        Tree.SequencedArgument sequencedArgument = this.namedArgumentList.getSequencedArgument();
        List<ParameterList> paramLists = ((Functional)((Object)this.getPrimaryDeclaration())).getParameterLists();
        List<Parameter> declaredParams = paramLists.get(0).getParameters();
        this.appendVarsForNamedArguments(namedArguments, declaredParams);
        this.appendVarsForReifiedTypeArguments();
        if (sequencedArgument != null) {
            this.appendVarsForSequencedArguments(sequencedArgument, declaredParams);
        }
        boolean hasDefaulted = this.appendVarsForDefaulted(declaredParams);
        Strategy.DefaultParameterMethodOwner owner = Strategy.defaultParameterMethodOwner(this.getPrimaryDeclaration());
        if (hasDefaulted && owner != Strategy.DefaultParameterMethodOwner.STATIC && owner != Strategy.DefaultParameterMethodOwner.OUTER && owner != Strategy.DefaultParameterMethodOwner.OUTER_COMPANION) {
            this.vars.prepend(this.makeThis());
        }
        this.gen.expressionGen().withinInvocation(prev);
    }

    private void appendVarsForReifiedTypeArguments() {
        List<JCTree.JCExpression> reifiedTypeArgs = this.gen.makeReifiedTypeArguments(this.producedReference);
        int index = 0;
        for (JCTree.JCExpression reifiedTypeArg : reifiedTypeArgs) {
            Naming.SyntheticName argName = this.reifiedTypeArgName(index);
            JCTree.JCVariableDecl varDecl = this.gen.makeVar(argName, this.gen.makeTypeDescriptorType(), reifiedTypeArg);
            this.vars.append(varDecl);
            ++index;
        }
    }

    private void appendVarsForSequencedArguments(Tree.SequencedArgument sequencedArgument, List<Parameter> declaredParams) {
        Type absentType;
        Type iteratedType;
        Parameter parameter = sequencedArgument.getParameter();
        Type parameterType = this.parameterType(parameter, parameter.getType(), 1);
        this.gen.at(sequencedArgument);
        Type tupleType = AnalyzerUtil.getTupleType(sequencedArgument.getPositionalArguments(), this.gen.typeFact(), false);
        int flags = 12;
        if (this.gen.typeFact().isIterableType(tupleType)) {
            Type argumentsType = tupleType.getSupertype(this.gen.typeFact().getIterableDeclaration());
            iteratedType = this.gen.typeFact().getIteratedType(argumentsType);
            absentType = this.gen.typeFact().getIteratedAbsentType(argumentsType);
        } else if (this.gen.typeFact().isJavaIterableType(tupleType)) {
            Type argumentsType = tupleType.getSupertype(this.gen.typeFact().getJavaIterableDeclaration());
            iteratedType = this.gen.typeFact().getJavaIteratedType(argumentsType);
            absentType = this.gen.typeFact().getNullType();
        } else if (this.gen.typeFact().isJavaObjectArrayType(tupleType)) {
            Type argumentsType = tupleType.getSupertype(this.gen.typeFact().getJavaObjectArrayDeclaration());
            iteratedType = this.gen.typeFact().getJavaArrayElementType(argumentsType);
            absentType = this.gen.typeFact().getNullType();
        } else if (this.gen.typeFact().isJavaPrimitiveArrayType(tupleType)) {
            Type argumentsType = tupleType.getSupertype(this.gen.typeFact().getJavaObjectArrayDeclaration());
            iteratedType = this.gen.typeFact().getJavaArrayElementType(tupleType);
            absentType = this.gen.typeFact().getNullType();
        } else {
            throw BugException.unhandledTypeCase(tupleType);
        }
        JCTree.JCExpression sequenceValue = Strategy.useConstantIterable(sequencedArgument) ? this.gen.makeConstantIterable(sequencedArgument, iteratedType, absentType, flags) : this.gen.makeLazyIterable(sequencedArgument, iteratedType, absentType, flags);
        JCTree.JCExpression sequenceType = this.gen.makeJavaType(parameterType, flags);
        Naming.SyntheticName argName = this.argName(parameter);
        JCTree.JCVariableDecl varDecl = this.gen.makeVar(argName, sequenceType, sequenceValue);
        this.gen.at(this.getPrimary());
        this.bind(parameter, argName, this.gen.makeJavaType(parameterType, flags), com.redhat.ceylon.langtools.tools.javac.util.List.of(varDecl));
    }

    private JCTree.JCExpression makeDefaultedArgumentMethodCall(Parameter param) {
        JCTree.JCExpression thisExpr = null;
        switch (Strategy.defaultParameterMethodOwner(param.getModel())) {
            case SELF: {
                break;
            }
            case STATIC: {
                if (!param.getDeclaration().isStaticallyImportable()) break;
                thisExpr = this.gen.makeStaticQualifier(param.getDeclaration());
                break;
            }
            case OUTER: {
                if (this.getQmePrimary() == null || Decl.isConstructor(this.getPrimaryDeclaration())) break;
                thisExpr = this.callVarName.makeIdent();
                break;
            }
            case OUTER_COMPANION: {
                if (this.getQmePrimary() == null || Decl.isConstructor(this.getPrimaryDeclaration())) break;
                thisExpr = this.callVarName.makeIdent();
                break;
            }
            case INIT_COMPANION: {
                thisExpr = this.varBaseName.suffixedBy(NamingBase.Suffix.$argthis$).makeIdent();
                if (!this.isOnValueType()) break;
                thisExpr = this.gen.boxType(thisExpr, this.getQmePrimary().getTypeModel());
            }
        }
        JCTree.JCExpression defaultValueMethodName = this.gen.naming.makeDefaultedParamMethod(thisExpr, param);
        JCTree.JCMethodInvocation argExpr = this.gen.at(this.getNode()).Apply(null, defaultValueMethodName, this.makeVarRefArgumentList(param));
        return argExpr;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCExpression> makeVarRefArgumentList(Parameter param) {
        ListBuffer<JCTree.JCIdent> names = new ListBuffer<JCTree.JCIdent>();
        if (!Strategy.defaultParameterMethodStatic(this.getPrimaryDeclaration()) && Strategy.defaultParameterMethodTakesThis(param.getModel())) {
            names.append(this.varBaseName.suffixedBy(NamingBase.Suffix.$argthis$).makeIdent());
        }
        Reference ref = this.gen.resolveAliasesForReifiedTypeArguments(this.producedReference);
        int tpCount = this.gen.getTypeParameters(ref).size();
        for (int tpIndex = 0; tpIndex < tpCount; ++tpIndex) {
            names.append(this.reifiedTypeArgName(tpIndex).makeIdent());
        }
        int parameterIndex = this.parameterIndex(param);
        for (int ii = 0; ii < parameterIndex; ++ii) {
            names.append(this.argsNamesByIndex.get(ii).makeIdent());
        }
        return names.toList();
    }

    private Naming.SyntheticName argName(Parameter param) {
        int paramIndex = this.parameterIndex(param);
        Naming.SyntheticName argName = this.varBaseName.suffixedBy(paramIndex);
        if (this.argsNamesByIndex.containsValue(argName)) {
            throw new BugException();
        }
        return argName;
    }

    private Naming.SyntheticName reifiedTypeArgName(int index) {
        return this.varBaseName.suffixedBy(NamingBase.Suffix.$reified$, index);
    }

    private List<Parameter> parameterList(Parameter param) {
        Functional functional = (Functional)((Object)param.getDeclaration());
        return functional.getFirstParameterList().getParameters();
    }

    private int parameterIndex(Parameter param) {
        return this.parameterList(param).indexOf(param);
    }

    private Type parameterType(Parameter declaredParam, Type pt, int flags) {
        if (declaredParam == null) {
            return pt;
        }
        return this.gen.getTypeForParameter(declaredParam, this.producedReference, flags);
    }

    private void appendVarsForNamedArguments(List<Tree.NamedArgument> namedArguments, List<Parameter> declaredParams) {
        for (Tree.NamedArgument namedArg : namedArguments) {
            this.gen.at(namedArg);
            Parameter declaredParam = namedArg.getParameter();
            Naming.SyntheticName argName = this.argName(declaredParam);
            if (namedArg instanceof Tree.SpecifiedArgument) {
                this.bindSpecifiedArgument((Tree.SpecifiedArgument)namedArg, declaredParam, argName);
                continue;
            }
            if (namedArg instanceof Tree.MethodArgument) {
                this.bindMethodArgument((Tree.MethodArgument)namedArg, declaredParam, argName);
                continue;
            }
            if (namedArg instanceof Tree.ObjectArgument) {
                this.bindObjectArgument((Tree.ObjectArgument)namedArg, declaredParam, argName);
                continue;
            }
            if (namedArg instanceof Tree.AttributeArgument) {
                this.bindAttributeArgument((Tree.AttributeArgument)namedArg, declaredParam, argName);
                continue;
            }
            throw BugException.unhandledNodeCase(namedArg);
        }
    }

    private void bindSpecifiedArgument(Tree.SpecifiedArgument specifiedArg, Parameter declaredParam, Naming.SyntheticName argName) {
        Tree.Expression expr = specifiedArg.getSpecifierExpression().getExpression();
        Type type = this.parameterType(declaredParam, expr.getTypeModel(), 1);
        AbstractTransformer.BoxingStrategy boxType = this.getNamedParameterBoxingStrategy(declaredParam);
        int jtFlags = 0;
        int exprFlags = 0;
        if (boxType == AbstractTransformer.BoxingStrategy.BOXED) {
            jtFlags |= 0x404;
        }
        if (!this.isParameterRaw(declaredParam)) {
            exprFlags |= 2;
        }
        if (this.isParameterWithConstrainedTypeParameters(declaredParam)) {
            exprFlags |= 4;
            jtFlags |= 8;
        }
        if (this.isParameterWithDependentCovariantTypeParameters(declaredParam)) {
            exprFlags |= 0x40;
        }
        if (this.erasedArgument(TreeUtil.unwrapExpressionUntilTerm(expr))) {
            exprFlags |= 8;
        }
        if (CodegenUtil.downcastForSmall(expr, specifiedArg.getParameter().getModel())) {
            exprFlags |= 0x80;
        }
        JCTree.JCExpression typeExpr = this.gen.makeJavaType(type, jtFlags);
        this.gen.at(specifiedArg);
        JCTree.JCExpression argExpr = this.gen.expressionGen().transformExpression(expr, boxType, type, exprFlags);
        this.gen.at(specifiedArg);
        JCTree.JCVariableDecl varDecl = this.gen.makeVar(argName, typeExpr, argExpr);
        ListBuffer<JCTree.JCVariableDecl> statements = ListBuffer.of(varDecl);
        this.bind(declaredParam, argName, this.gen.makeJavaType(type, jtFlags), statements.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindMethodArgument(Tree.MethodArgument methodArg, Parameter declaredParam, Naming.SyntheticName argName) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> body;
        Function model = methodArg.getDeclarationModel();
        boolean prevNoExpressionlessReturn = this.gen.statementGen().noExpressionlessReturn;
        boolean prevSyntheticClassBody = this.gen.expressionGen().withinSyntheticClassBody(Decl.isMpl(model) || this.gen.expressionGen().isWithinSyntheticClassBody());
        try {
            this.gen.expressionGen().withinSyntheticClassBody(true);
            this.gen.statementGen().noExpressionlessReturn = AbstractTransformer.isAnything(model.getType());
            if (methodArg.getBlock() != null) {
                body = this.gen.statementGen().transformBlock(methodArg.getBlock());
                if (!methodArg.getBlock().getDefinitelyReturns()) {
                    body = AbstractTransformer.isAnything(model.getType()) ? body.append(this.gen.make().Return(this.gen.makeNull())) : body.append(this.gen.make().Return(this.gen.makeErroneous(methodArg.getBlock(), "compiler bug: non-void method does not definitely return")));
                }
            } else {
                Tree.Expression expr = methodArg.getSpecifierExpression().getExpression();
                AbstractTransformer.BoxingStrategy boxing = CodegenUtil.getBoxingStrategy(model);
                Type type = model.getType();
                JCTree.JCExpression transExpr = this.gen.expressionGen().transformExpression(expr, boxing, type);
                JCTree.JCReturn returnStat = this.gen.make().Return(transExpr);
                body = com.redhat.ceylon.langtools.tools.javac.util.List.of(returnStat);
            }
        }
        finally {
            this.gen.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
            this.gen.statementGen().noExpressionlessReturn = prevNoExpressionlessReturn;
        }
        Type callableType = model.appliedReference(null, Collections.emptyList()).getFullType();
        CallableBuilder callableBuilder = CallableBuilder.methodArgument(this.gen.gen(), methodArg, model, callableType, Collections.singletonList(methodArg.getParameterLists().get(0)), this.gen.classGen().transformMplBody(methodArg.getParameterLists(), model, body));
        JCTree.JCExpression callable = callableBuilder.build();
        this.gen.at(methodArg);
        JCTree.JCExpression typeExpr = this.gen.makeJavaType(callableType, 8);
        JCTree.JCVariableDecl varDecl = this.gen.makeVar(argName, typeExpr, callable);
        ListBuffer<JCTree.JCVariableDecl> statements = ListBuffer.of(varDecl);
        this.bind(declaredParam, argName, this.gen.makeJavaType(callableType), statements.toList());
    }

    private void bindObjectArgument(Tree.ObjectArgument objectArg, Parameter declaredParam, Naming.SyntheticName argName) {
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> object = this.gen.classGen().transformObjectArgument(objectArg);
        JCTree.JCVariableDecl varDecl = this.gen.makeLocalIdentityInstance(argName.getName(), Naming.quoteClassName(objectArg.getIdentifier().getText()), false);
        ListBuffer<JCTree.JCStatement> statements = this.toStmts(objectArg, object).append(varDecl);
        this.bind(declaredParam, argName, this.gen.makeJavaType(objectArg.getType().getTypeModel()), statements.toList());
    }

    private void bindAttributeArgument(Tree.AttributeArgument attrArg, Parameter declaredParam, Naming.SyntheticName argName) {
        Value model = attrArg.getDeclarationModel();
        String name = model.getName();
        String className = Naming.getAttrClassName(model, 0);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> attrClass = this.gen.gen().transformAttribute(model, name, className, null, attrArg.getBlock(), attrArg.getSpecifierExpression(), null, null);
        TypedReference typedRef = this.gen.getTypedReference(model);
        TypedReference nonWideningTypedRef = this.gen.nonWideningTypeDecl(typedRef);
        Type nonWideningType = this.gen.nonWideningType(typedRef, nonWideningTypedRef);
        Type type = this.parameterType(declaredParam, model.getType(), 0);
        AbstractTransformer.BoxingStrategy boxType = this.getNamedParameterBoxingStrategy(declaredParam);
        JCTree.JCExpression initValue = this.gen.make().Apply(null, this.gen.makeSelect(this.gen.makeUnquotedIdent(className), Naming.getGetterName(model)), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
        initValue = this.gen.expressionGen().applyErasureAndBoxing(initValue, nonWideningType, !CodegenUtil.isUnBoxed(nonWideningTypedRef.getDeclaration()), boxType, type);
        JCTree.JCVariableDecl var = this.gen.make().VarDef(this.gen.make().Modifiers(16L, com.redhat.ceylon.langtools.tools.javac.util.List.nil()), argName.asName(), this.gen.makeJavaType(type, boxType == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0), initValue);
        ListBuffer<JCTree.JCStatement> statements = this.toStmts(attrArg, attrClass).append(var);
        this.bind(declaredParam, argName, this.gen.makeJavaType(type, boxType == AbstractTransformer.BoxingStrategy.BOXED ? 4 : 0), statements.toList());
    }

    private void bind(Parameter param, Naming.SyntheticName argName, JCTree.JCExpression argType, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCStatement> statements) {
        this.vars.appendList(statements);
        this.argsAndTypes.put(this.parameterIndex(param), new ExpressionAndType(argName.makeIdent(), argType));
        this.argsNamesByIndex.put(this.parameterIndex(param), argName);
        this.bound.add(param);
    }

    private ListBuffer<JCTree.JCStatement> toStmts(Tree.NamedArgument namedArg, com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> listOfStatements) {
        ListBuffer<JCTree.JCStatement> result = new ListBuffer<JCTree.JCStatement>();
        for (JCTree tree : listOfStatements) {
            if (tree instanceof JCTree.JCStatement) {
                result.append((JCTree.JCStatement)tree);
                continue;
            }
            result.append(this.gen.make().Exec(this.gen.makeErroneous(namedArg, "compiler bug: attempt to put a non-statement in a let")));
        }
        return result;
    }

    private final void appendDefaulted(Parameter param, JCTree.JCExpression argExpr) {
        int flags = 8;
        if (this.getNamedParameterBoxingStrategy(param) == AbstractTransformer.BoxingStrategy.BOXED) {
            flags |= 0x404;
        }
        Type type = this.gen.getTypeForParameter(param, this.producedReference, 1);
        Naming.SyntheticName argName = this.argName(param);
        JCTree.JCExpression typeExpr = this.gen.makeJavaType(type, flags);
        JCTree.JCVariableDecl varDecl = this.gen.makeVar(argName, typeExpr, argExpr);
        this.bind(param, argName, this.gen.makeJavaType(type, flags), com.redhat.ceylon.langtools.tools.javac.util.List.of(varDecl));
    }

    private AbstractTransformer.BoxingStrategy getNamedParameterBoxingStrategy(Parameter param) {
        if (param != null) {
            if (this.isOnValueType() && Decl.isValueTypeDecl(this.getParameterTypeForValueType(this.producedReference, param))) {
                return AbstractTransformer.BoxingStrategy.UNBOXED;
            }
            return CodegenUtil.getBoxingStrategy(param.getModel());
        }
        return AbstractTransformer.BoxingStrategy.UNBOXED;
    }

    private boolean appendVarsForDefaulted(List<Parameter> declaredParams) {
        boolean hasDefaulted = false;
        if (!Decl.isOverloaded(this.getPrimaryDeclaration())) {
            for (Parameter param : declaredParams) {
                JCTree.JCExpression argExpr;
                if (this.bound.contains(param)) continue;
                if (Strategy.hasDefaultParameterValueMethod(param)) {
                    if (this.getPrimaryDeclaration() instanceof Class && this.gen.isJavaArray(((Class)this.getPrimaryDeclaration()).getType())) continue;
                    if (this.getQmePrimary() != null && this.gen.isJavaArray(this.getQmePrimary().getTypeModel())) {
                        if (this.getPrimaryDeclaration() instanceof Function && this.getPrimaryDeclaration().getName().equals("copyTo")) {
                            if (param.getName().equals("sourcePosition") || param.getName().equals("destinationPosition")) {
                                argExpr = this.gen.makeInteger(0);
                                hasDefaulted |= true;
                            } else if (param.getName().equals("length")) {
                                argExpr = this.gen.makeSelect(this.varBaseName.suffixedBy(NamingBase.Suffix.$argthis$).makeIdent(), "length");
                                hasDefaulted |= true;
                            } else {
                                argExpr = this.gen.makeErroneous(this.getNode(), "compiler bug: argument to copyTo method of java array type not supported: " + param.getName());
                            }
                        } else {
                            argExpr = this.gen.makeErroneous(this.getNode(), "compiler bug: virtual method of java array type not supported: " + this.getPrimaryDeclaration());
                        }
                    } else {
                        argExpr = this.makeDefaultedArgumentMethodCall(param);
                        hasDefaulted |= true;
                    }
                } else if (Strategy.hasEmptyDefaultArgument(param)) {
                    argExpr = this.gen.makeEmptyAsSequential(true);
                } else if (this.gen.typeFact().isIterableType(param.getType())) {
                    argExpr = this.gen.make().TypeCast(this.gen.makeJavaType(this.gen.typeFact().getIterableDeclaration().getType(), 8), this.gen.makeEmpty());
                } else {
                    Type appliedType = this.gen.getTypeForParameter(param, this.producedReference, 1);
                    argExpr = this.gen.typeFact().isIterableType(appliedType) ? this.gen.make().TypeCast(this.gen.makeJavaType(this.gen.typeFact().getIterableDeclaration().getType(), 8), this.gen.makeEmpty()) : this.gen.makeErroneous(this.getNode(), "compiler bug: missing argument, and parameter is not defaulted");
                }
                this.appendDefaulted(param, argExpr);
            }
        }
        return hasDefaulted;
    }

    private final JCTree.JCVariableDecl makeThis() {
        JCTree.JCExpression defaultedParameterInstance;
        JCTree.JCExpression thisType;
        Reference target = ((Tree.MemberOrTypeExpression)this.getPrimary()).getTarget();
        if (this.getPrimary() instanceof Tree.BaseMemberExpression && !this.gen.expressionGen().isWithinSyntheticClassBody()) {
            if (Decl.withinClassOrInterface(this.getPrimaryDeclaration())) {
                thisType = this.gen.makeJavaType(target.getQualifyingType(), 4 | (this.getPrimaryDeclaration().isInterfaceMember() && !this.getPrimaryDeclaration().isShared() ? 128 : 0));
                TypeDeclaration outer = Decl.getOuterScopeOfMemberInvocation((Tree.StaticMemberOrTypeExpression)this.getPrimary(), this.getPrimaryDeclaration());
                defaultedParameterInstance = outer instanceof Interface && this.getPrimaryDeclaration().isShared() ? this.gen.naming.makeQuotedThis() : this.gen.naming.makeQualifiedThis(this.gen.makeJavaType(outer.getType(), 4 | (this.getPrimaryDeclaration().isInterfaceMember() && !this.getPrimaryDeclaration().isShared() ? 128 : 0)));
            } else {
                thisType = this.gen.naming.makeName((TypedDeclaration)this.getPrimaryDeclaration(), 2);
                defaultedParameterInstance = this.gen.naming.makeName((TypedDeclaration)this.getPrimaryDeclaration(), 1);
            }
        } else if (this.getPrimary() instanceof Tree.BaseTypeExpression || this.getPrimary() instanceof Tree.QualifiedTypeExpression) {
            TypeDeclaration declaration = (TypeDeclaration)((Tree.MemberOrTypeExpression)this.getPrimary()).getDeclaration();
            thisType = this.gen.makeJavaType(declaration.getType(), 128);
            defaultedParameterInstance = this.gen.make().NewClass(null, null, this.gen.makeJavaType(declaration.getType(), 128), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null);
        } else {
            thisType = this.isOnValueType() ? this.gen.makeJavaType(target.getQualifyingType()) : this.gen.makeJavaType(target.getQualifyingType(), 4);
            defaultedParameterInstance = this.callVarName.makeIdent();
        }
        JCTree.JCVariableDecl thisDecl = this.gen.makeVar(this.varBaseName.suffixedBy(NamingBase.Suffix.$argthis$), thisType, defaultedParameterInstance);
        return thisDecl;
    }

    @Override
    protected Invocation.TransformedInvocationPrimary transformPrimary(JCTree.JCExpression primaryExpr, String selector) {
        Constructor ctor;
        this.buildVars();
        Invocation.TransformedInvocationPrimary actualPrimExpr = super.transformPrimary(primaryExpr, selector);
        JCTree.JCExpression result = actualPrimExpr.expr;
        if (this.vars != null && !this.vars.isEmpty() && primaryExpr != null && selector != null && !this.getPrimaryDeclaration().isStatic()) {
            JCTree.JCExpression varType;
            Type type = ((Tree.MemberOrTypeExpression)this.getPrimary()).getTarget().getQualifyingType();
            if (this.isOnValueType()) {
                varType = this.gen.makeJavaType(this.getQmePrimary().getTypeModel());
            } else {
                int jtFlags = 4;
                if (this.getPrimary() instanceof Tree.QualifiedTypeExpression && !this.getPrimaryDeclaration().isShared() && type.getDeclaration() instanceof Interface) {
                    jtFlags |= 0x80;
                } else if (this.getPrimary() instanceof Tree.StaticMemberOrTypeExpression && Decl.isPrivateAccessRequiringCompanion((Tree.StaticMemberOrTypeExpression)this.getPrimary())) {
                    jtFlags |= 0x80;
                }
                if (ExpressionTransformer.isSuperOrSuperOf(this.getQmePrimary()) && (!(this.getPrimary() instanceof Tree.QualifiedMemberExpression) || ((Tree.QualifiedMemberExpression)this.getPrimary()).getMemberOperator() instanceof Tree.MemberOp)) {
                    jtFlags |= 0x80;
                }
                varType = this.gen.makeJavaType(type, jtFlags);
            }
            this.vars.prepend(this.gen.makeVar(this.callVarName, varType, result));
            result = this.callVarName.makeIdent();
        }
        if ((ctor = this.getConstructor()) != null && !Decl.isDefaultConstructor(ctor) && !Decl.isJavaArrayWith(ctor)) {
            this.argsAndTypes.put(-1, new ExpressionAndType(this.gen.naming.makeNamedConstructorName(ctor, false), this.gen.naming.makeNamedConstructorType(ctor, false)));
        }
        return new Invocation.TransformedInvocationPrimary(result, actualPrimExpr.selector);
    }

    @Override
    public void location(CallBuilder callBuilder) {
        callBuilder.location(this.namedArgumentList);
    }
}

