/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.Annotations;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.TransformedType;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.code.Flags;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import java.util.Iterator;
import java.util.List;

public class ParameterDefinitionBuilder {
    private final AbstractTransformer gen;
    private long modifiers;
    private TransformedType type;
    private boolean sequenced;
    private boolean defaulted;
    private final String name;
    private String aliasedName;
    private int annotationFlags = 6;
    private boolean built = false;
    private ListBuffer<JCTree.JCAnnotation> userAnnotations;
    private ListBuffer<JCTree.JCAnnotation> modelAnnotations;
    private String functionalParameterName;
    private FunctionOrValue boxedVariable;
    private Node at;

    private ParameterDefinitionBuilder(AbstractTransformer gen, String name) {
        this.gen = gen;
        this.name = name;
    }

    static ParameterDefinitionBuilder systemParameter(AbstractTransformer gen, String name) {
        return new ParameterDefinitionBuilder(gen, name);
    }

    static ParameterDefinitionBuilder implicitParameter(AbstractTransformer gen, String name) {
        return new ParameterDefinitionBuilder(gen, name);
    }

    static ParameterDefinitionBuilder explicitParameter(AbstractTransformer gen, Parameter parameter) {
        ParameterDefinitionBuilder pdb = new ParameterDefinitionBuilder(gen, parameter.getName());
        if (ParameterDefinitionBuilder.isBoxedVariableParameter(parameter)) {
            pdb.boxedVariable = parameter.getModel();
        }
        if (parameter.getModel() instanceof Function) {
            pdb.functionalParameterName = ParameterDefinitionBuilder.functionalName((Function)parameter.getModel());
        }
        return pdb;
    }

    private static String functionalName(Function model) {
        StringBuilder sb = new StringBuilder();
        ParameterDefinitionBuilder.functionalName(sb, model);
        return sb.toString();
    }

    private static void functionalName(StringBuilder sb, Function model) {
        if (model.isDeclaredVoid()) {
            sb.append('!');
        }
        for (ParameterList pl : model.getParameterLists()) {
            ParameterDefinitionBuilder.functionalParameters(sb, pl);
        }
    }

    static void functionalParameters(StringBuilder sb, ParameterList pl) {
        sb.append('(');
        Iterator<Parameter> parameters = pl.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter p = parameters.next();
            FunctionOrValue pm = p.getModel();
            sb.append(pm.getName());
            if (p.isSequenced()) {
                if (p.isAtLeastOne()) {
                    sb.append('+');
                } else {
                    sb.append('*');
                }
            }
            if (pm instanceof Function) {
                ParameterDefinitionBuilder.functionalName(sb, (Function)pm);
            }
            if (!parameters.hasNext()) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    static boolean isBoxedVariableParameter(Parameter parameter) {
        return parameter.getModel().isCaptured() && parameter.getModel().isVariable() && (!parameter.getModel().isClassOrInterfaceMember() || Decl.isLocalToInitializer(parameter.getModel())) && !parameter.isHidden();
    }

    public ParameterDefinitionBuilder modifiers(long mods) {
        this.modifiers |= mods;
        return this;
    }

    public ParameterDefinitionBuilder userAnnotations(com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> annos) {
        if (annos != null) {
            if (this.userAnnotations == null) {
                this.userAnnotations = new ListBuffer();
            }
            this.userAnnotations.appendList(annos);
        }
        return this;
    }

    public ParameterDefinitionBuilder modelAnnotations(List<Annotation> annos) {
        if (annos != null) {
            if (this.modelAnnotations == null) {
                this.modelAnnotations = new ListBuffer();
            }
            this.modelAnnotations.appendList(this.gen.makeAtAnnotations(annos));
        }
        return this;
    }

    public ParameterDefinitionBuilder type(TransformedType type) {
        this.type = type;
        return this;
    }

    public ParameterDefinitionBuilder sequenced(boolean sequenced) {
        this.sequenced = sequenced;
        return this;
    }

    public ParameterDefinitionBuilder aliasName(String aliasedName) {
        this.aliasedName = aliasedName;
        return this;
    }

    public ParameterDefinitionBuilder ignored() {
        this.annotationFlags = Annotations.ignore(this.annotationFlags);
        return this;
    }

    public ParameterDefinitionBuilder defaulted(boolean defaulted) {
        this.defaulted = defaulted;
        return this;
    }

    public ParameterDefinitionBuilder noUserOrModelAnnotations() {
        this.annotationFlags = Annotations.noUserOrModel(this.annotationFlags);
        return this;
    }

    public ParameterDefinitionBuilder noModelAnnotations() {
        this.annotationFlags = Annotations.noModel(this.annotationFlags);
        return this;
    }

    public JCTree.JCVariableDecl build() {
        if (this.built) {
            throw new BugException("already built");
        }
        this.built = true;
        ListBuffer<Object> annots = new ListBuffer<JCTree.JCAnnotation>();
        if (Annotations.includeModel(this.annotationFlags)) {
            annots.appendList(this.gen.makeAtName(this.name));
            if (this.functionalParameterName != null) {
                annots.appendList(this.gen.makeAtFunctionalParameter(this.functionalParameterName));
            }
            if (this.sequenced) {
                annots.appendList(this.gen.makeAtSequenced());
            }
            if (this.defaulted) {
                annots.appendList(this.gen.makeAtDefaulted());
            }
            if (this.type != null) {
                annots.appendList(this.type.getTypeAnnotations());
            }
        }
        if (Annotations.includeUser(this.annotationFlags) && this.userAnnotations != null) {
            annots.appendList(this.userAnnotations.toList());
        }
        if (Annotations.includeModel(this.annotationFlags) && this.modelAnnotations != null) {
            annots.appendList(this.modelAnnotations.toList());
        }
        if (Annotations.includeIgnore(this.annotationFlags)) {
            annots = annots.appendList(this.gen.makeAtIgnore());
        }
        Name name = this.gen.names().fromString(Naming.quoteParameterName(this.getJavaParameterName()));
        return this.gen.make().VarDef(this.gen.make().Modifiers(this.modifiers | 0x200000000L, annots.toList()), name, this.type.getTypeExpression(), null);
    }

    private String getJavaParameterName() {
        return this.aliasedName != null ? this.aliasedName : this.name;
    }

    public boolean requiresBoxedVariableDecl() {
        return this.boxedVariable != null;
    }

    public JCTree.JCVariableDecl buildBoxedVariableDecl() {
        return this.gen.makeVariableBoxDecl(this.gen.naming.makeUnquotedIdent(this.getJavaParameterName()), this.boxedVariable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Flags.toString(this.modifiers)).append(' ');
        sb.append(this.type).append(' ');
        sb.append(this.aliasedName != null ? this.aliasedName : this.name);
        return sb.toString();
    }

    public void at(Node node) {
        this.at = node;
    }
}

