/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.Value;

public class SmallDeclarationVisitor
extends Visitor {
    static Type smallUnderlyingType(Type type) {
        Type result;
        if (type.isInteger()) {
            Type result2 = type.withoutUnderlyingType();
            result2.setUnderlyingType("int");
            return result2;
        }
        if (type.isFloat()) {
            result = type.withoutUnderlyingType();
            result.setUnderlyingType("float");
        } else if (type.isCharacter()) {
            result = type.withoutUnderlyingType();
            result.setUnderlyingType("char");
        } else {
            result = type;
        }
        return result;
    }

    static void smallDeclaration(Declaration d) {
        if (Decl.isSmall(d)) {
            FunctionOrValue f = (FunctionOrValue)d;
            SmallDeclarationVisitor.setSmallType(f);
        }
    }

    protected static void setSmallType(FunctionOrValue f) {
        Setter s;
        Type t = SmallDeclarationVisitor.smallUnderlyingType(f.getType());
        f.setType(t);
        if (f instanceof Value && (s = ((Value)f).getSetter()) != null) {
            s.getParameter().getModel().setType(t);
        }
    }

    @Override
    public void visit(Tree.Parameter that) {
        super.visit(that);
        SmallDeclarationVisitor.smallDeclaration(that.getParameterModel().getModel());
    }

    @Override
    public void visit(Tree.ParameterDeclaration that) {
        super.visit(that);
        SmallDeclarationVisitor.smallDeclaration(that.getTypedDeclaration().getDeclarationModel());
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Value getter = that.getDeclarationModel().getGetter();
        if (getter != null && getter.isSmall()) {
            SmallDeclarationVisitor.smallDeclaration(that.getDeclarationModel().getParameter().getModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        if (Decl.isSmall(that.getDeclarationModel())) {
            SmallDeclarationVisitor.smallDeclaration(that.getDeclarationModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        if (Decl.isSmall(that.getDeclarationModel())) {
            SmallDeclarationVisitor.smallDeclaration(that.getDeclarationModel());
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        Declaration d = that.getDeclaration();
        if (d == null && that.getBaseMemberExpression() instanceof Tree.MemberOrTypeExpression) {
            d = ((Tree.MemberOrTypeExpression)that.getBaseMemberExpression()).getDeclaration();
        }
        SmallDeclarationVisitor.smallDeclaration(d);
        super.visit(that);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (Decl.isSmall(that.getParameter().getModel())) {
            that.getDeclarationModel().setSmall(true);
            SmallDeclarationVisitor.smallDeclaration(that.getDeclarationModel());
        }
        super.visit(that);
    }
}

