/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.launcher;

import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.common.tools.SourceArgumentsResolver;
import com.redhat.ceylon.compiler.java.tools.CeylonLocation;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.LanguageCompiler;
import com.redhat.ceylon.compiler.java.util.Timer;
import com.redhat.ceylon.javax.annotation.processing.Processor;
import com.redhat.ceylon.javax.tools.JavaFileManager;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.tools.javac.code.Source;
import com.redhat.ceylon.langtools.tools.javac.file.JavacFileManager;
import com.redhat.ceylon.langtools.tools.javac.jvm.Target;
import com.redhat.ceylon.langtools.tools.javac.main.CommandLine;
import com.redhat.ceylon.langtools.tools.javac.main.JavaCompiler;
import com.redhat.ceylon.langtools.tools.javac.main.Main;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.processing.AnnotationProcessingError;
import com.redhat.ceylon.langtools.tools.javac.util.ClientCodeException;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.FatalError;
import com.redhat.ceylon.langtools.tools.javac.util.JavacMessages;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.PropagatedException;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.MissingResourceException;

public class Main
extends com.redhat.ceylon.langtools.tools.javac.main.Main {
    String ownName;
    PrintWriter out;
    boolean fatalErrors;
    public static final int EXIT_OK = 0;
    public static final int EXIT_ERROR = 1;
    public static final int EXIT_CMDERR = 2;
    public static final int EXIT_SYSERR = 3;
    public static final int EXIT_ABNORMAL = 4;
    private Option[] recognizedOptions = Option.getJavaCompilerOptions().toArray(new Option[0]);
    private Timer timer = null;
    public ExitState exitState = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.redhat.ceylon.langtools.tools.javac.resources.ceylonc";
    private static JavacMessages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        super(name, out);
        this.ownName = name;
        this.out = out;
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        this.out.println(Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        this.out.println(this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    @Override
    public Option getOption(String flag) {
        for (Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    @Override
    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    @Override
    public Collection<File> processArgs(String[] flags, String[] classNames) {
        Target target;
        Source source;
        int ac = 0;
        while (ac < flags.length) {
            int firstOptionToCheck;
            int j;
            String flag = flags[ac];
            ++ac;
            for (j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length && !this.recognizedOptions[j].matches(flag); ++j) {
            }
            if (j == this.recognizedOptions.length) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            Option option = this.recognizedOptions[j];
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.optionHelper, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.optionHelper, flag)) continue;
            return null;
        }
        if (this.classnames != null && classNames != null) {
            this.classnames.addAll(Arrays.asList(classNames));
        }
        if (!this.checkDirectoryOrURL("-d")) {
            return null;
        }
        if (!this.checkDirectory("-s")) {
            return null;
        }
        String sourceString = this.options.get("-source");
        String targetString = this.options.get("-target");
        if (sourceString == null && targetString == null) {
            sourceString = "7";
            this.options.put(Option.SOURCE, sourceString);
        }
        Source source2 = source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        if (targetString == null) {
            targetString = "7";
            this.options.put(Option.TARGET, targetString);
        }
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.JDK1_7;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                this.options.put("-target", source.requiredTarget().name);
            } else if (targetString == null && !source.allowGenerics()) {
                this.options.put("-target", Target.JDK1_4.name);
            }
        }
        return this.filenames;
    }

    private boolean checkDirectory(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    private boolean checkDirectoryOrURL(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        try {
            URL url = new URL(value);
            String scheme = url.getProtocol();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                return true;
            }
            this.error("ceylon.err.output.repo.not.supported", value);
            return false;
        }
        catch (MalformedURLException url) {
            File file = new File(value);
            if (file.exists() && !file.isDirectory()) {
                this.error("err.file.not.directory", value);
                return false;
            }
            return true;
        }
    }

    @Override
    public Main.Result compile(String[] args) {
        Context context = new Context();
        CeyloncFileManager.preRegister(context);
        CeylonLog.preRegister(context);
        Main.Result result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    @Override
    public Main.Result compile(String[] args, Context context) {
        return this.compile(args, context, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null);
    }

    @Override
    public Main.Result compile(String[] args, Context context, com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        return this.compile(args, null, context, fileObjects, processors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Main.Result compile(String[] args, String[] classNames, Context context, com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new LinkedHashSet();
        this.classnames = new ListBuffer();
        this.exitState = ExitState.cmderror();
        JavaCompiler comp = null;
        try {
            Object otherFiles;
            boolean forceStdOut;
            if (args.length == 0 && fileObjects.isEmpty()) {
                this.exitState = ExitState.cmderror();
                Main.Result result = Main.Result.CMDERR;
                return result;
            }
            Collection<File> filenames = this.processArgs(CommandLine.parse(args), classNames);
            if (filenames == null) {
                this.exitState = ExitState.cmderror();
                Main.Result result = Main.Result.CMDERR;
                return result;
            }
            if (filenames.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.get("-help") != null || this.options.get("-jhelp") != null || this.options.get("-X") != null || this.options.get("-version") != null || this.options.get("-fullversion") != null) {
                    Main.Result result = Main.Result.OK;
                    return result;
                }
                this.error("err.no.source.files", new Object[0]);
                this.exitState = ExitState.cmderror();
                Main.Result result = Main.Result.CMDERR;
                return result;
            }
            this.timer = Timer.instance(context);
            this.timer.init();
            boolean bl = forceStdOut = this.options.get("stdout") != null;
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            this.fileManager = context.get(JavaFileManager.class);
            try {
                comp = LanguageCompiler.instance(context);
            }
            catch (Overrides.OverrideException e) {
                CeylonLog.instance(context).error("ceylon.overrides", e.getMessage());
                this.exitState = new ExitState(Main.Result.ERROR, ExitState.CeylonState.ERROR, 0, (Throwable)e);
                Main.Result result = Main.Result.CMDERR;
                if (comp != null) {
                    comp.close();
                }
                this.filenames = null;
                this.options = null;
                if (this.timer != null) {
                    this.timer.end();
                }
                this.timer = null;
                return result;
            }
            if (comp == null) {
                this.exitState = ExitState.systemError(null, null);
                Main.Result e = Main.Result.SYSERR;
                return e;
            }
            if (!this.classnames.isEmpty()) {
                this.filenames.addAll(this.addModuleFiles(filenames));
                this.classnames.clear();
            }
            if (!this.filenames.isEmpty()) {
                otherFiles = com.redhat.ceylon.langtools.tools.javac.util.List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(this.filenames)) {
                    otherFiles = ((com.redhat.ceylon.langtools.tools.javac.util.List)otherFiles).append(javaFileObject);
                }
                fileObjects = fileObjects.prependList((com.redhat.ceylon.langtools.tools.javac.util.List<JavaFileObject>)otherFiles);
            }
            if (fileObjects.isEmpty()) {
                this.error("err.no.source.files", new Object[0]);
                this.exitState = ExitState.cmderror();
                otherFiles = Main.Result.CMDERR;
                return otherFiles;
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            int errorCount = comp.errorCount();
            if (errorCount != 0) {
                this.exitState = ExitState.error(comp);
                Main.Result result = Main.Result.ERROR;
                return result;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            Main.Result result = Main.Result.SYSERR;
            return result;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            Main.Result result = Main.Result.SYSERR;
            return result;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            Main.Result result = Main.Result.SYSERR;
            return result;
        }
        catch (FatalError ex) {
            this.exitState = ExitState.systemError(comp, ex);
            if (this.exitState.javacExitCode == Main.Result.SYSERR) {
                this.feMessage(ex);
            }
            Main.Result result = this.exitState.javacExitCode;
            return result;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            this.exitState = ExitState.systemError(null, ex);
            Main.Result result = Main.Result.SYSERR;
            return result;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (RepositoryException ex) {
            this.exitState = ExitState.abnormal(comp, ex, this.options);
            Main.Result result = Main.Result.ABNORMAL;
            return result;
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            this.exitState = ExitState.abnormal(comp, ex, this.options);
            Main.Result result = Main.Result.ABNORMAL;
            return result;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
            if (this.timer != null) {
                this.timer.end();
            }
            this.timer = null;
        }
        this.exitState = ExitState.ok();
        return Main.Result.OK;
    }

    private ListBuffer<File> addModuleFiles(Collection<File> f) throws IOException {
        Iterable<File> srcdirs = ((JavacFileManager)this.fileManager).getLocation(StandardLocation.SOURCE_PATH);
        Iterable<File> resdirs = ((JavacFileManager)this.fileManager).getLocation(CeylonLocation.RESOURCE_PATH);
        SourceArgumentsResolver resolver = new SourceArgumentsResolver(srcdirs, resdirs, ".ceylon", ".java");
        resolver.parse(this.classnames.toList());
        ListBuffer<File> filenames = new ListBuffer<File>();
        filenames.addAll(f);
        filenames.addAll((Collection<File>)resolver.getSourceFiles());
        filenames.addAll((Collection<File>)resolver.getResourceFiles());
        return filenames;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<File> appendAll(com.redhat.ceylon.langtools.tools.javac.util.List<File> target, List<File> source) {
        for (File f : source) {
            target = target.append(f);
        }
        return target;
    }

    void bugMessage(Throwable ex) {
        this.out.println(Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        this.out.println(ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        this.out.println(Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        this.out.println(Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        this.out.println(Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            @Override
            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }

    public static class ExitState {
        public final Main.Result javacExitCode;
        public final CeylonState ceylonState;
        public final int errorCount;
        public final Throwable abortingException;
        public final int ceylonCodegenExceptionCount;
        public final int ceylonCodegenErroneousCount;
        public final int ceylonCodegenGarbageCount;
        public final int nonCeylonErrorCount;

        private ExitState(Main.Result javacExitCode, CeylonState ceylonState, int errorCount, Throwable abortingException, JavaCompiler comp) {
            this.javacExitCode = javacExitCode;
            this.ceylonState = ceylonState;
            this.errorCount = errorCount;
            this.ceylonCodegenExceptionCount = comp != null ? ExitState.getCeylonCodegenExceptionCount(comp) : 0;
            this.ceylonCodegenErroneousCount = comp != null ? ExitState.getCeylonCodegenErroneousCount(comp) : 0;
            this.ceylonCodegenGarbageCount = comp != null ? ExitState.getCeylonCodegenGarbageTreeCount(comp) : 0;
            this.nonCeylonErrorCount = comp != null ? ExitState.getNonCeylonErrorCount(comp) : 0;
            this.abortingException = abortingException;
        }

        private ExitState(Main.Result javacExitCode, CeylonState ceylonState, int errorCount, Throwable abortingException) {
            this(javacExitCode, ceylonState, errorCount, abortingException, (JavaCompiler)null);
        }

        public static ExitState error(JavaCompiler comp) {
            if (ExitState.hasCeylonCodegenErrors(comp)) {
                return new ExitState(Main.Result.ERROR, CeylonState.BUG, comp.errorCount(), null, comp);
            }
            return new ExitState(Main.Result.ERROR, CeylonState.ERROR, comp.errorCount(), null);
        }

        private static int getCeylonCodegenExceptionCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenExceptionCount();
            }
            return 0;
        }

        private static int getCeylonCodegenErroneousCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenErroneousCount();
            }
            return 0;
        }

        private static int getCeylonCodegenGarbageTreeCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonCodegenGarbageTreeCount();
            }
            return 0;
        }

        private static int getCeylonCodegenErrorCount(JavaCompiler comp) {
            return ExitState.getCeylonCodegenErroneousCount(comp) + ExitState.getCeylonCodegenExceptionCount(comp) + ExitState.getCeylonCodegenGarbageTreeCount(comp);
        }

        private static int getNonCeylonErrorCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getNonCeylonErrorCount();
            }
            return 0;
        }

        private static int getCeylonErrorCount(JavaCompiler comp) {
            if (comp.log instanceof CeylonLog) {
                CeylonLog log = (CeylonLog)comp.log;
                return log.getCeylonErrorCount();
            }
            return 0;
        }

        private static boolean hasCeylonCodegenErrors(JavaCompiler comp) {
            return ExitState.getNonCeylonErrorCount(comp) == 0 && ExitState.getCeylonErrorCount(comp) == 0 && ExitState.getCeylonCodegenErrorCount(comp) > 0;
        }

        public boolean hasCeylonCodegenErrors() {
            return this.ceylonCodegenErroneousCount > 0 || this.ceylonCodegenExceptionCount > 0 || this.nonCeylonErrorCount > 0;
        }

        private static boolean isAbnormalException(Throwable ex) {
            return ex instanceof RuntimeException && !ex.getClass().getName().startsWith("com.redhat.ceylon.") && (!(ex instanceof ClassCastException) || ex.getMessage() == null || !ex.getMessage().contains("com.redhat.ceylon.langtools.")) && !(ex instanceof NullPointerException);
        }

        public static ExitState ok() {
            return new ExitState(Main.Result.ERROR, CeylonState.OK, 0, null, null);
        }

        public static ExitState abnormal(JavaCompiler comp, Throwable ex, Options options) {
            if (comp == null || comp.errorCount() == 0 || options == null || options.get("dev") != null) {
                return new ExitState(Main.Result.ABNORMAL, CeylonState.BUG, 0, ex, null);
            }
            if (ExitState.hasCeylonCodegenErrors(comp) || ExitState.isAbnormalException(ex)) {
                return new ExitState(Main.Result.ABNORMAL, CeylonState.BUG, comp.errorCount(), ex, comp);
            }
            return new ExitState(Main.Result.ABNORMAL, CeylonState.ERROR, comp.errorCount(), null, null);
        }

        public static ExitState systemError(JavaCompiler comp, Throwable ex) {
            if (comp instanceof LanguageCompiler && ((LanguageCompiler)comp).getTreatLikelyBugsAsErrors()) {
                if (ExitState.hasCeylonCodegenErrors(comp)) {
                    return new ExitState(Main.Result.ERROR, CeylonState.BUG, comp.errorCount(), ex, comp);
                }
                return new ExitState(Main.Result.ERROR, CeylonState.ERROR, 0, ex, null);
            }
            return new ExitState(Main.Result.SYSERR, CeylonState.SYS, 0, ex, null);
        }

        public static ExitState cmderror() {
            return new ExitState(Main.Result.CMDERR, CeylonState.BUG, 0, null, null);
        }

        public static enum CeylonState {
            OK,
            ERROR,
            SYS,
            BUG;

        }
    }
}

