/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;

public class ForcedCaptureVisitor
extends Visitor {
    @Override
    public void visit(Tree.TypedDeclaration that) {
        if (this.isForcedCapture(that) && that.getDeclarationModel() instanceof FunctionOrValue) {
            ((FunctionOrValue)that.getDeclarationModel()).setCaptured(true);
        }
        super.visit(that);
    }

    private boolean isForcedCapture(Tree.TypedDeclaration that) {
        if (that.getAnnotationList() == null) {
            return false;
        }
        for (Tree.Annotation anno : that.getAnnotationList().getAnnotations()) {
            Module module;
            TypeDeclaration decl;
            Type type = anno.getTypeModel();
            if (type == null || !type.isClassOrInterface() || (decl = type.getDeclaration()) == null || (module = Decl.getModule(decl)) == null || module.getLanguageModule() == module) continue;
            return true;
        }
        return false;
    }
}

