/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel;

import ceylon.language.Annotated;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Callable;
import ceylon.language.ConstrainedAnnotation;
import ceylon.language.Entry;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Null;
import ceylon.language.OptionalAnnotation;
import ceylon.language.Sequence;
import ceylon.language.SequencedAnnotation;
import ceylon.language.Sequential;
import ceylon.language.String;
import ceylon.language.Tuple;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.meta.declaration.AnnotatedDeclaration;
import ceylon.language.meta.declaration.CallableConstructorDeclaration;
import ceylon.language.meta.declaration.ConstructorDeclaration;
import ceylon.language.meta.declaration.Declaration;
import ceylon.language.meta.declaration.FunctionDeclaration;
import ceylon.language.meta.declaration.GenericDeclaration;
import ceylon.language.meta.declaration.NestableDeclaration;
import ceylon.language.meta.declaration.OpenClassOrInterfaceType;
import ceylon.language.meta.declaration.OpenType;
import ceylon.language.meta.declaration.OpenTypeVariable;
import ceylon.language.meta.declaration.Package;
import ceylon.language.meta.declaration.TypeParameter;
import ceylon.language.meta.declaration.ValueConstructorDeclaration;
import ceylon.language.meta.declaration.contravariant_;
import ceylon.language.meta.declaration.covariant_;
import ceylon.language.meta.declaration.invariant_;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.model.Declared;
import ceylon.language.meta.model.FunctionModel;
import ceylon.language.meta.model.Generic;
import ceylon.language.meta.model.IncompatibleTypeException;
import ceylon.language.meta.model.InvocationException;
import ceylon.language.meta.model.Model;
import ceylon.language.meta.model.Qualified;
import ceylon.language.meta.model.TypeApplicationException;
import ceylon.language.meta.model.ValueModel;
import ceylon.language.meta.model.nothingType_;
import ceylon.language.null_;
import ceylon.language.sequence_;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.BooleanArray;
import com.redhat.ceylon.compiler.java.language.ByteArray;
import com.redhat.ceylon.compiler.java.language.CharArray;
import com.redhat.ceylon.compiler.java.language.DoubleArray;
import com.redhat.ceylon.compiler.java.language.FloatArray;
import com.redhat.ceylon.compiler.java.language.IntArray;
import com.redhat.ceylon.compiler.java.language.InternalMap;
import com.redhat.ceylon.compiler.java.language.LongArray;
import com.redhat.ceylon.compiler.java.language.ObjectArray;
import com.redhat.ceylon.compiler.java.language.ObjectArrayIterable;
import com.redhat.ceylon.compiler.java.language.ShortArray;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.AnnotationBearing;
import com.redhat.ceylon.compiler.java.runtime.metamodel.DeclarationParser;
import com.redhat.ceylon.compiler.java.runtime.metamodel.DefaultValueProvider;
import com.redhat.ceylon.compiler.java.runtime.metamodel.ModelError;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Predicates;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.AliasDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.CallableConstructorDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassOrInterfaceDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassWithConstructorsDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassWithInitializerDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.FunctionDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.InterfaceDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ModuleImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.NestableDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenClassOrInterfaceTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenClassTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenInterfaceTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenIntersectionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenTypeVariableImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.OpenUnionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.PackageImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.SetterDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.TypeParameterImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ValueConstructorDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ValueDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.CallableConstructorImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ClassImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ClassOrInterfaceImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.InterfaceImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.IntersectionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassCallableConstructorImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassValueConstructorImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberInterfaceImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.UnionTypeImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ValueConstructorImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModuleManager;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.RuntimeResolver;
import com.redhat.ceylon.model.loader.JvmBackendUtil;
import com.redhat.ceylon.model.loader.ModelLoader;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionClass;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionMethod;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.FunctionOrValueInterface;
import com.redhat.ceylon.model.loader.model.JavaMethod;
import com.redhat.ceylon.model.loader.model.LazyClass;
import com.redhat.ceylon.model.loader.model.LazyClassAlias;
import com.redhat.ceylon.model.loader.model.LazyElement;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyInterface;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.loader.model.LazyTypeAlias;
import com.redhat.ceylon.model.loader.model.LazyValue;
import com.redhat.ceylon.model.runtime.CeylonModuleClassLoader;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Metamodel {
    private static RuntimeModuleManager moduleManager;
    private static Map<Class, NestableDeclaration> classToDeclaration;
    private static Map<com.redhat.ceylon.model.typechecker.model.Declaration, Object> typeCheckModelToRuntimeModel;
    private static Map<com.redhat.ceylon.model.typechecker.model.Package, PackageImpl> typeCheckPackagesToRuntimeModel;
    private static Map<Module, ModuleImpl> typeCheckModulesToRuntimeModel;
    private static Map<TypeDescriptor, Type> typeDescriptorToProducedType;
    private static final TypeDescriptor TD_ClosedTypeOfAnything;
    private static final TypeDescriptor TD_ClosedTypeArgumentElement;
    private static final TypeDescriptor TD_ClosedTypeArgument;
    public static final TypeDescriptor TD_OpenTypeArgumentElement;
    public static final TypeDescriptor TD_OpenTypeArgument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadModule(java.lang.String name, java.lang.String version2, ArtifactResult result, ClassLoader classLoader) {
        Object lock;
        boolean hasLoaded = moduleManager.loadModule(name, version2, result, classLoader);
        Object object = lock = Metamodel.getLock();
        synchronized (object) {
            lock.notifyAll();
        }
        return hasLoaded;
    }

    public static void resetModuleManager() {
        Metamodel.resetModuleManager(null);
    }

    public static void resetModuleManager(RuntimeResolver runtimeResolver) {
        moduleManager = new RuntimeModuleManager(runtimeResolver);
        moduleManager.initCoreModules(new Modules());
        moduleManager.prepareForTypeChecking();
        classToDeclaration.clear();
        typeCheckModelToRuntimeModel.clear();
        typeCheckModulesToRuntimeModel.clear();
        typeCheckPackagesToRuntimeModel.clear();
        typeDescriptorToProducedType.clear();
    }

    public static RuntimeModuleManager getModuleManager() {
        return moduleManager;
    }

    public static Object getLock() {
        return moduleManager.getModelLoader().getLock();
    }

    public static TypeDescriptor getTypeDescriptor(Object instance) {
        if (instance == null) {
            return null_.$TypeDescriptor$;
        }
        if (instance instanceof ReifiedType) {
            return ((ReifiedType)instance).$getType$();
        }
        return Metamodel.getJavaTypeDescriptor(instance.getClass());
    }

    public static TypeDescriptor getIteratedTypeDescriptor(TypeDescriptor td) {
        return Metamodel.getTypeDescriptorForProducedType(moduleManager.getModelLoader().getUnit().getIteratedType(Metamodel.getProducedType(td)));
    }

    private static TypeDescriptor getJavaArrayTypeDescriptor(Class<?> klass) {
        if (klass == byte[].class) {
            return ByteArray.$TypeDescriptor$;
        }
        if (klass == short[].class) {
            return ShortArray.$TypeDescriptor$;
        }
        if (klass == int[].class) {
            return IntArray.$TypeDescriptor$;
        }
        if (klass == long[].class) {
            return LongArray.$TypeDescriptor$;
        }
        if (klass == float[].class) {
            return FloatArray.$TypeDescriptor$;
        }
        if (klass == double[].class) {
            return DoubleArray.$TypeDescriptor$;
        }
        if (klass == boolean[].class) {
            return BooleanArray.$TypeDescriptor$;
        }
        if (klass == char[].class) {
            return CharArray.$TypeDescriptor$;
        }
        TypeDescriptor componentType = Metamodel.getJavaTypeDescriptor(klass.getComponentType());
        return TypeDescriptor.klass(ObjectArray.class, componentType);
    }

    private static TypeDescriptor getJavaTypeDescriptor(Class<?> klass) {
        if (klass.isArray()) {
            return Metamodel.getJavaArrayTypeDescriptor(klass);
        }
        if (klass == Object.class) {
            return ceylon.language.Object.$TypeDescriptor$;
        }
        if (klass.isMemberClass()) {
            return TypeDescriptor.member(Metamodel.getJavaTypeDescriptor(klass.getEnclosingClass()), TypeDescriptor.klass(klass, new TypeDescriptor[0]));
        }
        return TypeDescriptor.klass(klass, new TypeDescriptor[0]);
    }

    private static boolean reifiedGeneric(java.lang.reflect.Type t) {
        if (t instanceof Class && ((Class)t).getTypeParameters().length == 0) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (java.lang.reflect.Type t2 : pt.getActualTypeArguments()) {
                if (Metamodel.reifiedGeneric(t2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean reifiedByInheritance(Class<?> o, Class<?> tested) {
        int index = 0;
        for (Class<?> c : o.getInterfaces()) {
            if (c.equals(tested) && Metamodel.reifiedGeneric(o.getGenericInterfaces()[index])) {
                return true;
            }
            if (Metamodel.reifiedByInheritance(c, tested)) {
                return true;
            }
            ++index;
        }
        Class<?> sup = o.getSuperclass();
        if (sup != null) {
            if (sup.equals(tested) && Metamodel.reifiedGeneric(o.getGenericSuperclass())) {
                return true;
            }
            if (Metamodel.reifiedByInheritance(sup, tested)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isReified(Object instance, TypeDescriptor type) {
        if (instance == null) {
            return type.containsNull();
        }
        TypeDescriptor instanceType = Metamodel.getTypeDescriptor(instance);
        if (instanceType == null) {
            return false;
        }
        if (instanceType == type) {
            return true;
        }
        boolean result = type.is(instanceType);
        if (!result && !(instance instanceof ReifiedType) && type instanceof TypeDescriptor.Class && ((TypeDescriptor.Class)type).isGeneric() && ((TypeDescriptor.Class)type).getKlass().isInstance(instance) && !Metamodel.reifiedByInheritance(instance.getClass(), ((TypeDescriptor.Class)type).getKlass())) {
            result = true;
        }
        return result;
    }

    public static Type getProducedType(Object instance) {
        TypeDescriptor instanceType = Metamodel.getTypeDescriptor(instance);
        if (instanceType == null) {
            throw Metamodel.newModelError("Metamodel not yet supported for Java types");
        }
        return Metamodel.getProducedType(instanceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type getProducedType(TypeDescriptor reifiedType) {
        Type producedType;
        Object object = Metamodel.getLock();
        synchronized (object) {
            producedType = typeDescriptorToProducedType.get(reifiedType);
            if (producedType == null) {
                producedType = reifiedType.toType(moduleManager);
                typeDescriptorToProducedType.put(reifiedType, producedType);
            }
        }
        return producedType;
    }

    @NonNull
    public static ceylon.language.meta.model.Type<?> getAppliedMetamodel(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            throw Metamodel.newModelError("Metamodel not yet supported for Java types");
        }
        Type pt = Metamodel.getProducedType(typeDescriptor);
        return Metamodel.getAppliedMetamodel(pt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <R> R getOrCreateMetamodel(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
        Object object = Metamodel.getLock();
        synchronized (object) {
            Object ret = typeCheckModelToRuntimeModel.get(declaration);
            if (ret == null) {
                com.redhat.ceylon.model.typechecker.model.Package pkg = Metamodel.getPackage(declaration);
                Module mod = pkg.getModule();
                Metamodel.getOrCreateMetamodel(mod);
                if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Class) {
                    com.redhat.ceylon.model.typechecker.model.Class klass = (com.redhat.ceylon.model.typechecker.model.Class)declaration;
                    ret = klass.hasConstructors() || klass.hasEnumerated() || klass.isAnonymous() ? new ClassWithConstructorsDeclarationImpl(klass) : new ClassWithInitializerDeclarationImpl(klass);
                } else if (declaration instanceof Interface) {
                    Interface interf = (Interface)declaration;
                    ret = new InterfaceDeclarationImpl(interf);
                } else if (declaration instanceof TypeAlias) {
                    TypeAlias alias = (TypeAlias)declaration;
                    ret = new AliasDeclarationImpl(alias);
                } else if (declaration instanceof Function) {
                    Function method = (Function)declaration;
                    ret = method.getTypeDeclaration() instanceof com.redhat.ceylon.model.typechecker.model.Constructor ? new CallableConstructorDeclarationImpl(method, (com.redhat.ceylon.model.typechecker.model.Constructor)method.getTypeDeclaration()) : new FunctionDeclarationImpl(method);
                } else if (declaration instanceof Value) {
                    Value value = (Value)declaration;
                    ret = value.getTypeDeclaration() instanceof com.redhat.ceylon.model.typechecker.model.Constructor ? new ValueConstructorDeclarationImpl(value, (com.redhat.ceylon.model.typechecker.model.Constructor)value.getTypeDeclaration()) : new ValueDeclarationImpl(value);
                } else if (declaration instanceof Setter) {
                    Setter value = (Setter)declaration;
                    ret = new SetterDeclarationImpl(value);
                } else {
                    if (!(declaration instanceof com.redhat.ceylon.model.typechecker.model.Constructor)) throw Metamodel.newModelError("Declaration type not supported yet: " + declaration);
                    com.redhat.ceylon.model.typechecker.model.Constructor value = (com.redhat.ceylon.model.typechecker.model.Constructor)declaration;
                    com.redhat.ceylon.model.typechecker.model.Declaration functionOrValue = value.getContainer().getDirectMember(value.getName(), null, false);
                    if (functionOrValue instanceof Function) {
                        ret = new CallableConstructorDeclarationImpl((Function)functionOrValue, value);
                    } else if (functionOrValue instanceof Value) {
                        ret = new ValueConstructorDeclarationImpl((Value)functionOrValue, value);
                    } else {
                        if (functionOrValue != null) throw Metamodel.newModelError("Declaration type not supported yet: " + declaration);
                        ret = new CallableConstructorDeclarationImpl(value, value);
                    }
                }
                typeCheckModelToRuntimeModel.put(declaration, ret);
            }
            return (R)ret;
        }
    }

    public static boolean hasTypeParameters(TypedDeclaration model) {
        if (model instanceof com.redhat.ceylon.model.typechecker.model.Generic) {
            return Metamodel.hasTypeParameters((com.redhat.ceylon.model.typechecker.model.Generic)((Object)model));
        }
        if (model.getContainer() instanceof com.redhat.ceylon.model.typechecker.model.ClassOrInterface) {
            return Metamodel.hasTypeParameters((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)model.getContainer());
        }
        return false;
    }

    public static boolean hasTypeParameters(com.redhat.ceylon.model.typechecker.model.Generic model) {
        if (!model.getTypeParameters().isEmpty()) {
            return true;
        }
        Scope container = ((com.redhat.ceylon.model.typechecker.model.Declaration)((Object)model)).getContainer();
        if (container instanceof com.redhat.ceylon.model.typechecker.model.ClassOrInterface) {
            return Metamodel.hasTypeParameters((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)container);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageImpl getOrCreateMetamodel(com.redhat.ceylon.model.typechecker.model.Package declaration) {
        Object object = Metamodel.getLock();
        synchronized (object) {
            PackageImpl ret = typeCheckPackagesToRuntimeModel.get(declaration);
            if (ret == null) {
                Module mod = declaration.getModule();
                Metamodel.getOrCreateMetamodel(mod);
                ret = new PackageImpl(declaration);
                typeCheckPackagesToRuntimeModel.put(declaration, ret);
            }
            return ret;
        }
    }

    public static ModuleImpl getOrCreateMetamodel(Module declaration) {
        return Metamodel.getOrCreateMetamodel(null, declaration, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleImpl getOrCreateMetamodel(java.lang.String namespace, Module declaration, Set<Module> visitedModules, boolean optional) {
        Object object = Metamodel.getLock();
        synchronized (object) {
            ModuleImpl ret = typeCheckModulesToRuntimeModel.get(declaration);
            if (ret == null) {
                Metamodel.loadModule(namespace, declaration, visitedModules, optional);
                if (!declaration.isAvailable()) {
                    return null;
                }
                ret = new ModuleImpl(declaration);
                typeCheckModulesToRuntimeModel.put(declaration, ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModule(java.lang.String namespace, Module declaration, Set<Module> visitedModules, boolean optional) {
        if (!Metamodel.isJBossModules()) {
            return;
        }
        if (JDKUtils.isJDKModule(declaration.getNameAsString()) || JDKUtils.isOracleJDKModule(declaration.getNameAsString())) {
            return;
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof CeylonModuleClassLoader) {
                java.lang.String modname = ModuleUtil.makeModuleName(namespace, declaration.getNameAsString(), null);
                CeylonModuleClassLoader newModuleClassLoader = ((CeylonModuleClassLoader)((Object)contextClassLoader)).loadModule(modname, declaration.getVersion());
                if (newModuleClassLoader != null) {
                    newModuleClassLoader.registerInMetaModel();
                }
                if (!declaration.isAvailable()) {
                    Object lock;
                    Object object = lock = Metamodel.getLock();
                    synchronized (object) {
                        int tries = 4;
                        while (!declaration.isAvailable()) {
                            try {
                                lock.wait(5000L);
                            }
                            catch (InterruptedException e) {
                                throw Metamodel.newModelError("Interrupted");
                            }
                            if (tries-- >= 0) continue;
                            throw Metamodel.newModelError("JBoss modules failed to make module available: " + declaration.getNameAsString() + "/" + declaration.getVersion());
                        }
                    }
                }
            }
            if (visitedModules == null) {
                visitedModules = new HashSet<Module>();
            }
            visitedModules.add(declaration);
            for (ModuleImport mi : declaration.getImports()) {
                Module importedModule = mi.getModule();
                if (mi.isOptional() || importedModule == null || visitedModules.contains(importedModule)) continue;
                java.lang.String ns = mi.getNamespace() != null ? mi.getNamespace() : namespace;
                Metamodel.getOrCreateMetamodel(ns, importedModule, visitedModules, mi.isOptional());
            }
        }
        catch (CeylonModuleClassLoader.ModuleLoadException e) {
            if (!declaration.isDefaultModule() && !optional) {
                throw Metamodel.newModelError(e.toString());
            }
        }
        catch (SecurityException e) {
            throw Metamodel.newModelError(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw Metamodel.newModelError(e.toString());
        }
    }

    private static boolean isJBossModules() {
        return Metamodel.class.getClassLoader().getClass().getName().equals("org.jboss.modules.ModuleClassLoader");
    }

    public static OpenType getMetamodel(Type pt) {
        TypeDeclaration declaration = pt.getDeclaration();
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Class) {
            return new OpenClassTypeImpl(pt);
        }
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Constructor) {
            return new OpenClassTypeImpl(pt.getQualifyingType());
        }
        if (declaration instanceof Interface) {
            return new OpenInterfaceTypeImpl(pt);
        }
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.TypeParameter) {
            com.redhat.ceylon.model.typechecker.model.TypeParameter tp = (com.redhat.ceylon.model.typechecker.model.TypeParameter)declaration;
            return new OpenTypeVariableImpl(tp);
        }
        if (declaration instanceof UnionType) {
            return new OpenUnionTypeImpl((UnionType)declaration);
        }
        if (declaration instanceof IntersectionType) {
            return new OpenIntersectionTypeImpl((IntersectionType)declaration);
        }
        if (declaration instanceof NothingType) {
            return ceylon.language.meta.declaration.nothingType_.get_();
        }
        if (declaration instanceof UnknownType) {
            ((UnknownType)declaration).reportErrors();
        }
        throw Metamodel.newModelError("Declaration type not supported yet: " + declaration);
    }

    public static Sequential<? extends OpenType> getMetamodelSequential(List<Type> types) {
        if (types.isEmpty()) {
            return empty_.get_();
        }
        OpenType[] ret = new OpenType[types.size()];
        int i = 0;
        TypeDescriptor td = TypeDescriptor.NothingType;
        for (Type pt : types) {
            OpenType mm = Metamodel.getMetamodel(pt);
            td = TypeDescriptor.union(((ReifiedType)((Object)mm)).$getType$());
            ret[i++] = mm;
        }
        return Util.sequentialWrapper(td, ret);
    }

    public static Sequential<? extends ceylon.language.meta.model.Type<? extends Object>> getAppliedMetamodelSequential(List<Type> types) {
        if (types.isEmpty()) {
            return empty_.get_();
        }
        ceylon.language.meta.model.Type[] ret = new ceylon.language.meta.model.Type[types.size()];
        int i = 0;
        for (Type pt : types) {
            ret[i++] = Metamodel.getAppliedMetamodel(pt);
        }
        return Util.sequentialWrapper(TypeDescriptor.klass(ceylon.language.meta.model.Type.class, Anything.$TypeDescriptor$), ret);
    }

    @NonNull
    public static <T> ceylon.language.meta.model.Type<T> getAppliedMetamodel(Type pt) {
        TypeDeclaration declaration = pt.getDeclaration();
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Constructor) {
            com.redhat.ceylon.model.typechecker.model.Constructor ctorDeclaration = (com.redhat.ceylon.model.typechecker.model.Constructor)declaration;
            Type ctorType = pt;
            pt = pt.getExtendedType();
            declaration = pt.getDeclaration();
            TypeDescriptor reifiedArguments = !ModelUtil.isEnumeratedConstructor(ctorDeclaration) && !declaration.isAnonymous() && !Metamodel.isLocalType(declaration) ? Metamodel.getTypeDescriptorForArguments(declaration.getUnit(), ctorDeclaration, ctorType) : TypeDescriptor.NothingType;
            TypeDescriptor reifiedType = Metamodel.getTypeDescriptorForProducedType(pt);
            if (declaration.isToplevel() || Metamodel.isLocalType(declaration)) {
                return new ClassImpl(reifiedType, reifiedArguments, pt, Metamodel.getAppliedMetamodel(pt.getQualifyingType()), null);
            }
            TypeDescriptor reifiedContainer = Metamodel.getTypeDescriptorForProducedType(pt.getQualifyingType());
            return new MemberClassImpl(reifiedContainer, reifiedType, reifiedArguments, pt);
        }
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Class) {
            TypeDescriptor reifiedArguments = !declaration.isAnonymous() && !Metamodel.isLocalType(declaration) ? Metamodel.getTypeDescriptorForArguments(declaration.getUnit(), (Functional)((Object)declaration), pt) : TypeDescriptor.NothingType;
            TypeDescriptor reifiedType = Metamodel.getTypeDescriptorForProducedType(pt);
            if (declaration.isToplevel() || Metamodel.isLocalType(declaration)) {
                return new ClassImpl(reifiedType, reifiedArguments, pt, null, null);
            }
            Type qt = pt.getQualifyingType();
            if (qt == null && declaration.isStatic()) {
                qt = ((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)declaration.getContainer()).getType();
            }
            TypeDescriptor reifiedContainer = Metamodel.getTypeDescriptorForProducedType(qt);
            return new MemberClassImpl(reifiedContainer, reifiedType, reifiedArguments, pt);
        }
        if (declaration instanceof Interface) {
            TypeDescriptor reifiedType = Metamodel.getTypeDescriptorForProducedType(pt);
            if (declaration.isToplevel() || Metamodel.isLocalType(declaration)) {
                return new InterfaceImpl(reifiedType, pt, null, null);
            }
            Type qt = pt.getQualifyingType();
            if (qt == null && declaration.isStatic()) {
                qt = ((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)declaration.getContainer()).getType();
            }
            TypeDescriptor reifiedContainer = Metamodel.getTypeDescriptorForProducedType(qt);
            return new MemberInterfaceImpl(reifiedContainer, reifiedType, pt);
        }
        if (declaration instanceof UnionType) {
            TypeDescriptor reifiedType = Metamodel.getTypeDescriptorForProducedType(pt);
            return new UnionTypeImpl(reifiedType, (UnionType)declaration);
        }
        if (declaration instanceof IntersectionType) {
            TypeDescriptor reifiedType = Metamodel.getTypeDescriptorForProducedType(pt);
            return new IntersectionTypeImpl(reifiedType, (IntersectionType)declaration);
        }
        if (declaration instanceof NothingType) {
            return nothingType_.get_();
        }
        if (declaration instanceof UnknownType) {
            ((UnknownType)declaration).reportErrors();
        }
        throw Metamodel.newModelError("Declaration type not supported yet: " + declaration);
    }

    public static Class<?> getJavaClass(Module module) {
        java.lang.String className = module.getNameAsString() + "." + "$module_";
        ReflectionClass classMirror = (ReflectionClass)moduleManager.getModelLoader().lookupClassMirror(module, className);
        return classMirror.klass;
    }

    public static Class<?> getJavaClass(com.redhat.ceylon.model.typechecker.model.Package pkg) {
        java.lang.String className = ((LazyPackage)pkg).getNameAsString() + "." + "$package_";
        ReflectionClass classMirror = (ReflectionClass)moduleManager.getModelLoader().lookupClassMirror(pkg.getModule(), className);
        return classMirror != null ? classMirror.klass : null;
    }

    public static Class<?> getJavaClass(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
        if (declaration instanceof LazyClass) {
            ReflectionClass classMirror = (ReflectionClass)((LazyClass)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof LazyInterface) {
            ReflectionClass classMirror = (ReflectionClass)((LazyInterface)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof LazyFunction) {
            ReflectionClass classMirror = (ReflectionClass)((LazyFunction)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof LazyValue) {
            ReflectionClass classMirror = (ReflectionClass)((LazyValue)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof LazyClassAlias) {
            ReflectionClass classMirror = (ReflectionClass)((LazyClassAlias)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof LazyTypeAlias) {
            ReflectionClass classMirror = (ReflectionClass)((LazyTypeAlias)declaration).classMirror;
            return classMirror.klass;
        }
        if (declaration instanceof AnnotationProxyClass) {
            return Metamodel.getJavaClass(((AnnotationProxyClass)declaration).iface);
        }
        if (declaration.getContainer() instanceof com.redhat.ceylon.model.typechecker.model.Declaration) {
            return Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Declaration)((Object)declaration.getContainer()));
        }
        throw Metamodel.newModelError("Unsupported declaration type: " + declaration + " of type " + declaration.getClass());
    }

    public static Constructor<?> getJavaConstructor(com.redhat.ceylon.model.typechecker.model.Constructor declaration) {
        return Metamodel.getJavaConstructor((com.redhat.ceylon.model.typechecker.model.Class)declaration.getContainer(), declaration.getName());
    }

    public static Constructor<?> getJavaConstructor(com.redhat.ceylon.model.typechecker.model.Class clazz, java.lang.String ctorName) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = Metamodel.getJavaClass(clazz).getDeclaredConstructors()) {
            java.lang.String n2;
            if (ctor.isAnnotationPresent(Ignore.class)) continue;
            Name name = ctor.getAnnotation(Name.class);
            java.lang.String n1 = name == null ? "" : name.value();
            java.lang.String string = n2 = ctorName == null ? "" : ctorName;
            if (!n1.equals(n2)) continue;
            return ctor;
        }
        return null;
    }

    public static Method getJavaInstantiator(com.redhat.ceylon.model.typechecker.model.Constructor declaration, java.lang.String methodName) {
        com.redhat.ceylon.model.typechecker.model.Class cls = (com.redhat.ceylon.model.typechecker.model.Class)declaration.getContainer();
        Class<?> terJavaCls = Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Declaration)((Object)cls.getContainer()));
        Method[] methods = terJavaCls.getDeclaredMethods();
        int numReified = cls.getTypeParameters().size();
        boolean defaultCtor = Metamodel.isDefaultConstructor(declaration);
        Method longestSig = null;
        for (Method method : methods) {
            boolean ctorNameParam;
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] sig = method.getParameterTypes();
            if (longestSig != null && longestSig.getParameterTypes().length >= sig.length) continue;
            Class<?> possibleCtorNameCls = sig.length > numReified ? sig[numReified] : null;
            boolean bl = ctorNameParam = possibleCtorNameCls != null && possibleCtorNameCls.getAnnotation(Ignore.class) != null;
            if (defaultCtor && !ctorNameParam) {
                longestSig = method;
                continue;
            }
            if (defaultCtor || !ctorNameParam) continue;
            longestSig = method;
        }
        if (longestSig == null) {
            throw Metamodel.newModelError("Unsupported declaration type: " + declaration);
        }
        return longestSig;
    }

    public static List<Constructor<?>> getJavaConstructors(com.redhat.ceylon.model.typechecker.model.Constructor declaration) {
        Class<?> javaClass = Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Class)declaration.getContainer());
        ArrayList result = new ArrayList();
        Constructor<?> ultimate = Metamodel.getJavaConstructor(declaration);
        result.add(ultimate);
        List<Parameter> parameters = declaration.getFirstParameterList().getParameters();
        Class<?>[] javapl = ultimate.getParameterTypes();
        int ii = parameters.size() - 1;
        int jj = javapl.length;
        while (ii >= 0) {
            Parameter p = parameters.get(ii);
            if (p.isDefaulted() || p.isSequenced() && !p.isAtLeastOne()) {
                Object[] sig = Arrays.copyOfRange(javapl, 0, jj - 1);
                try {
                    Constructor<?> overloaded = javaClass.getDeclaredConstructor((Class<?>[])sig);
                    result.add(overloaded);
                }
                catch (NoSuchMethodException e) {
                    throw Metamodel.newModelError("Could not find overloaded constructor with signature " + Arrays.toString(sig), e);
                }
            }
            --ii;
            --jj;
        }
        return result;
    }

    public static List<Method> getJavaInstantiators(com.redhat.ceylon.model.typechecker.model.Constructor declaration) {
        com.redhat.ceylon.model.typechecker.model.Class classModel = (com.redhat.ceylon.model.typechecker.model.Class)declaration.getContainer();
        Class<?> outerJavaClass = Metamodel.getJavaClass((com.redhat.ceylon.model.typechecker.model.Declaration)((Object)classModel.getContainer()));
        ArrayList<Method> result = new ArrayList<Method>();
        java.lang.String methodName = classModel.getName() + "$new$";
        Method ultimate = Metamodel.getJavaInstantiator(declaration, methodName);
        result.add(ultimate);
        List<Parameter> parameters = declaration.getFirstParameterList().getParameters();
        Class<?>[] javapl = ultimate.getParameterTypes();
        int ii = parameters.size() - 1;
        int jj = javapl.length;
        while (ii >= 0) {
            Parameter p = parameters.get(ii);
            if (p.isDefaulted() || p.isSequenced() && !p.isAtLeastOne()) {
                Object[] sig = Arrays.copyOfRange(javapl, 0, jj - 1);
                try {
                    Method overloaded = outerJavaClass.getDeclaredMethod(methodName, (Class<?>[])sig);
                    result.add(overloaded);
                }
                catch (NoSuchMethodException e) {
                    throw Metamodel.newModelError("Could not find overloaded constructor with signature " + Arrays.toString(sig), e);
                }
            }
            --ii;
            --jj;
        }
        return result;
    }

    public static boolean isDefaultConstructor(com.redhat.ceylon.model.typechecker.model.Constructor declaration) {
        return declaration.getName() == null || declaration.getName().isEmpty();
    }

    public static AnnotatedElement getJavaAnnotatedElement(Function declaration) {
        if (declaration instanceof JavaMethod || declaration instanceof LazyFunction) {
            return Metamodel.getJavaMethod(declaration);
        }
        if (declaration instanceof AnnotationProxyMethod) {
            return Metamodel.getJavaClass(((AnnotationProxyMethod)declaration).proxyClass.iface);
        }
        throw Metamodel.newModelError("Unsupported declaration type: " + declaration);
    }

    public static Method getJavaMethod(Function declaration) {
        if (declaration instanceof JavaMethod) {
            ReflectionMethod methodMirror = (ReflectionMethod)((JavaMethod)declaration).mirror;
            return (Method)methodMirror.method;
        }
        if (declaration instanceof LazyFunction) {
            ReflectionMethod methodMirror = (ReflectionMethod)((LazyFunction)declaration).getMethodMirror();
            return (Method)methodMirror.method;
        }
        throw Metamodel.newModelError("Unsupported declaration type: " + declaration);
    }

    public static TypeDescriptor getTypeDescriptorForProducedType(Type type) {
        TypeDeclaration declaration = type.getDeclaration();
        if (type.isNothing()) {
            return TypeDescriptor.NothingType;
        }
        if (type.isUnion()) {
            TypeDescriptor[] tdArgs = Metamodel.getTypeDescriptorsForProducedTypes(type.getCaseTypes());
            return TypeDescriptor.union(tdArgs);
        }
        if (type.isIntersection()) {
            TypeDescriptor[] tdArgs = Metamodel.getTypeDescriptorsForProducedTypes(type.getSatisfiedTypes());
            return TypeDescriptor.intersection(tdArgs);
        }
        if (declaration instanceof LazyClass) {
            ReflectionClass classMirror = (ReflectionClass)((LazyClass)declaration).classMirror;
            TypeDescriptor[] tdArgs = Metamodel.getTypeDescriptorsForProducedTypes(type.getTypeArgumentList());
            TypeDescriptor ret = TypeDescriptor.klass(classMirror.klass, tdArgs);
            if (type.getQualifyingType() != null) {
                return TypeDescriptor.member(Metamodel.getTypeDescriptorForProducedType(type.getQualifyingType()), ret);
            }
            return ret;
        }
        if (declaration instanceof LazyInterface) {
            ReflectionClass classMirror = (ReflectionClass)((LazyInterface)declaration).classMirror;
            TypeDescriptor[] tdArgs = Metamodel.getTypeDescriptorsForProducedTypes(type.getTypeArgumentList());
            TypeDescriptor ret = TypeDescriptor.klass(classMirror.klass, tdArgs);
            if (type.getQualifyingType() != null) {
                return TypeDescriptor.member(Metamodel.getTypeDescriptorForProducedType(type.getQualifyingType()), ret);
            }
            return ret;
        }
        if (declaration instanceof FunctionOrValueInterface) {
            TypeDescriptor ret;
            TypedDeclaration underlyingDeclaration = ((FunctionOrValueInterface)declaration).getUnderlyingDeclaration();
            TypeDescriptor[] tdArgs = Metamodel.getTypeDescriptorsForProducedTypes(type.getTypeArgumentList());
            if (underlyingDeclaration.isToplevel()) {
                ReflectionClass classMirror;
                if (underlyingDeclaration instanceof Setter) {
                    underlyingDeclaration = ((Setter)underlyingDeclaration).getGetter();
                }
                if (underlyingDeclaration instanceof LazyValue) {
                    classMirror = (ReflectionClass)((LazyValue)underlyingDeclaration).classMirror;
                } else if (underlyingDeclaration instanceof LazyFunction) {
                    classMirror = (ReflectionClass)((LazyFunction)underlyingDeclaration).classMirror;
                } else {
                    throw Metamodel.newModelError("Unsupported underlying declaration type: " + underlyingDeclaration);
                }
                ret = TypeDescriptor.functionOrValue(classMirror.klass, tdArgs);
            } else {
                ret = TypeDescriptor.functionOrValue(underlyingDeclaration.getPrefixedName(), tdArgs);
            }
            if (type.getQualifyingType() != null) {
                return TypeDescriptor.member(Metamodel.getTypeDescriptorForProducedType(type.getQualifyingType()), ret);
            }
            return ret;
        }
        if (declaration instanceof UnknownType) {
            ((UnknownType)declaration).reportErrors();
        }
        throw Metamodel.newModelError("Unsupported declaration type: " + (declaration == null ? "null" : declaration.getClass()));
    }

    public static TypeDescriptor[] getTypeDescriptors(Sequential<? extends ceylon.language.meta.model.Type<?>> types) {
        Object it;
        Iterator iterator = types.iterator();
        TypeDescriptor[] ret = new TypeDescriptor[(int)types.getSize()];
        int i = 0;
        while ((it = iterator.next()) != finished_.get_()) {
            ceylon.language.meta.model.Type annotationType = (ceylon.language.meta.model.Type)it;
            ret[i++] = Metamodel.getTypeDescriptor(annotationType);
        }
        return ret;
    }

    public static TypeDescriptor getTypeDescriptor(ceylon.language.meta.model.Type<?> appliedType) {
        if (appliedType instanceof ClassImpl) {
            return ((ClassImpl)appliedType).$reifiedType;
        }
        if (appliedType instanceof InterfaceImpl) {
            return ((InterfaceImpl)appliedType).$reifiedType;
        }
        if (appliedType instanceof UnionTypeImpl) {
            return ((UnionTypeImpl)appliedType).$reifiedUnion;
        }
        if (appliedType instanceof IntersectionTypeImpl) {
            return ((IntersectionTypeImpl)appliedType).$reifiedIntersection;
        }
        if (appliedType == nothingType_.get_()) {
            return TypeDescriptor.NothingType;
        }
        throw Metamodel.newModelError("Unsupported type: " + appliedType);
    }

    private static TypeDescriptor[] getTypeDescriptorsForProducedTypes(List<Type> args) {
        TypeDescriptor[] tdArgs = new TypeDescriptor[args.size()];
        for (int i = 0; i < tdArgs.length; ++i) {
            tdArgs[i] = Metamodel.getTypeDescriptorForProducedType(args.get(i));
        }
        return tdArgs;
    }

    public static FunctionDeclaration getMetamodel(Function method) {
        Scope container = method.getContainer();
        if (container instanceof com.redhat.ceylon.model.typechecker.model.ClassOrInterface) {
            ClassOrInterfaceDeclarationImpl classOrInterface = (ClassOrInterfaceDeclarationImpl)Metamodel.getOrCreateMetamodel((com.redhat.ceylon.model.typechecker.model.ClassOrInterface)container);
            FunctionDeclarationImpl ret = classOrInterface.findMethod(method.getName());
            if (ret == null) {
                throw Metamodel.newModelError("Failed to find method " + method.getName() + " in " + container);
            }
            return ret;
        }
        if (container instanceof com.redhat.ceylon.model.typechecker.model.Package) {
            PackageImpl pkg = Metamodel.getOrCreateMetamodel((com.redhat.ceylon.model.typechecker.model.Package)container);
            FunctionDeclaration ret = pkg.getFunction(method.getName());
            if (ret == null) {
                throw Metamodel.newModelError("Failed to find method " + method.getName() + " in " + container);
            }
            return ret;
        }
        throw Metamodel.newModelError("Unsupported method container for " + method.getName() + ": " + container);
    }

    public static Type getModel(OpenType pt) {
        if (pt instanceof OpenClassOrInterfaceTypeImpl) {
            return ((OpenClassOrInterfaceTypeImpl)pt).producedType;
        }
        throw Metamodel.newModelError("Unsupported produced type: " + pt);
    }

    public static Type getModel(ceylon.language.meta.model.Type<?> pt) {
        if (pt instanceof ClassOrInterfaceImpl) {
            return ((ClassOrInterfaceImpl)pt).producedType;
        }
        if (pt instanceof UnionTypeImpl) {
            return ((UnionTypeImpl)pt).model;
        }
        if (pt instanceof IntersectionTypeImpl) {
            return ((IntersectionTypeImpl)pt).model;
        }
        if (pt instanceof nothingType_) {
            return new NothingType(moduleManager.getModelLoader().getUnit()).getType();
        }
        throw Metamodel.newModelError("Unsupported applied produced type: " + pt);
    }

    public static com.redhat.ceylon.model.typechecker.model.Package getPackage(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
        Scope scope;
        for (scope = declaration.getContainer(); scope != null && !(scope instanceof com.redhat.ceylon.model.typechecker.model.Package); scope = scope.getContainer()) {
        }
        if (scope == null) {
            throw Metamodel.newModelError("Declaration with no package: " + declaration);
        }
        return (com.redhat.ceylon.model.typechecker.model.Package)scope;
    }

    public static List<Type> getProducedTypes(Sequential<? extends ceylon.language.meta.model.Type<?>> types) {
        Object it;
        Iterator iterator = types.iterator();
        LinkedList<Type> producedTypes = new LinkedList<Type>();
        while ((it = iterator.next()) != finished_.get_()) {
            ceylon.language.meta.model.Type pt = (ceylon.language.meta.model.Type)it;
            Type modelPt = Metamodel.getModel(pt);
            producedTypes.add(modelPt);
        }
        return producedTypes;
    }

    public static <Value extends Annotation, Values, ProgramElement extends Annotated> Class<?> getReflectedAnnotationClass(ClassOrInterface<? extends Annotation> annotationType) {
        ClassOrInterfaceDeclarationImpl freeClass = annotationType instanceof ClassOrInterfaceImpl ? (ClassOrInterfaceDeclarationImpl)((ClassOrInterfaceImpl)annotationType).getDeclaration() : (ClassOrInterfaceDeclarationImpl)((Object)annotationType);
        Class<?> refAnnotationClass = Metamodel.getJavaClass(freeClass.declaration);
        return refAnnotationClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <A extends Annotation> void addAnnotation(Annotated annotated, ArrayList<A> ceylonAnnotations, Annotation jAnnotation, Predicates.Predicate<A> pred) {
        Class<? extends Annotation> jAnnotationType = jAnnotation.annotationType();
        if (pred != null && pred instanceof Predicates.AnnotationPredicate && !((Predicates.AnnotationPredicate)pred).shouldInstantiate(jAnnotationType)) {
            return;
        }
        if (jAnnotationType.getAnnotation(Ceylon.class) == null) {
            Metamodel.addProxyCeylonAnnotation(annotated, ceylonAnnotations, jAnnotation);
            return;
        }
        if (jAnnotationType.getName().endsWith("$annotations$")) {
            Annotation[] jAnnotations;
            try {
                Method method = jAnnotationType.getMethod("value", new Class[0]);
                method.setAccessible(true);
                jAnnotations = (Annotation[])method.invoke((Object)jAnnotation, new Object[0]);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw Metamodel.newModelError("While unwrapping a sequenced annotation of element " + annotated, e);
            }
            for (Annotation wrapped : jAnnotations) {
                Metamodel.addAnnotation(annotated, ceylonAnnotations, wrapped, pred);
            }
            return;
        }
        Class<A> annotationClass = Metamodel.getAnnotationClass(jAnnotationType, annotated);
        try {
            Constructor<A> constructor = annotationClass.getDeclaredConstructor(jAnnotationType);
            constructor.setAccessible(true);
            Annotation cAnnotation = (Annotation)constructor.newInstance(jAnnotation);
            if (!pred.accept(cAnnotation)) return;
            ceylonAnnotations.add(cAnnotation);
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Metamodel.newModelError("While reflectively instantiating " + annotationClass + " on element " + annotated, e);
        }
    }

    protected static <A extends Annotation> Class<A> getAnnotationClass(Class<? extends Annotation> jAnnotationType, Annotated annotated) {
        Class<?> annotationClass;
        java.lang.String annotationName = jAnnotationType.getName();
        if (!annotationName.endsWith("$annotation$")) {
            throw Metamodel.newModelError("Annotation has invalid name: " + annotationName);
        }
        java.lang.String className = annotationName.substring(0, annotationName.length() - "$annotation$".length());
        try {
            annotationClass = Class.forName(className, false, jAnnotationType.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw Metamodel.newModelError("Unable to find annotation class " + className + " for annotation type " + annotationName + " on element " + annotated, e);
        }
        return annotationClass;
    }

    protected static <AT extends Annotation> Class<AT> getJavaAnnotationClass(Class<? extends Annotation> ceylonAnnotationClass) {
        if (ceylonAnnotationClass == ceylon.language.Annotation.class || ceylonAnnotationClass == ConstrainedAnnotation.class) {
            return Annotation.class;
        }
        java.lang.String suffix = SequencedAnnotation.class.isAssignableFrom(ceylonAnnotationClass) ? "$annotations$" : "$annotation$";
        java.lang.String classname = ceylonAnnotationClass.getName() + suffix;
        try {
            return Class.forName(classname, false, ceylonAnnotationClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw Metamodel.newModelError("Unable to find annotation class " + classname + " for annotation type " + ceylonAnnotationClass, e);
        }
    }

    private static void addProxyCeylonAnnotation(Annotated annotated, ArrayList<? extends Annotation> ceylonAnnotations, Annotation jAnnotation) {
        Class<? extends Annotation> jAnnotationType = jAnnotation.annotationType();
        if (jAnnotationType == Deprecated.class) {
            return;
        }
        if (jAnnotationType.getName().startsWith("com.redhat.ceylon.compiler.java.metadata.")) {
            return;
        }
        ceylonAnnotations.add(jAnnotation);
    }

    public static <A extends Annotation> Sequential<? extends A> annotations(TypeDescriptor $reifiedValues, Annotated annotated) {
        Predicates.Predicate predicate = Predicates.isAnnotationOfType($reifiedValues);
        return Metamodel.annotations($reifiedValues, annotated, predicate);
    }

    public static <A extends Annotation> Sequential<? extends A> annotations(TypeDescriptor $reifiedValues, Annotated annotated, Predicates.Predicate<A> predicate) {
        Annotation[] jAnnotations = ((AnnotationBearing)annotated).$getJavaAnnotations$();
        if (jAnnotations == null) {
            throw Metamodel.newModelError("Unable to find java.lang.reflect.AnnotatedElement for " + annotated);
        }
        ArrayList ceylonAnnotations = new ArrayList(jAnnotations.length);
        for (Annotation jAnnotation : jAnnotations) {
            Metamodel.addAnnotation(annotated, ceylonAnnotations, jAnnotation, predicate);
        }
        Object[] array = ceylonAnnotations.toArray(new Annotation[0]);
        return new ObjectArrayIterable($reifiedValues, array).sequence();
    }

    public static java.lang.String getJavaMethodName(Functional method) {
        if (method instanceof JavaMethod) {
            return ((JavaMethod)method).getRealName();
        }
        if (method instanceof LazyFunction) {
            return ((LazyFunction)method).getRealMethodName();
        }
        throw Metamodel.newModelError("Function declaration type not supported yet: " + method);
    }

    public static int getFirstDefaultedParameter(List<Parameter> parameters) {
        int i = 0;
        for (Parameter param : parameters) {
            if (param.isDefaulted() || param.isSequenced() && !param.isAtLeastOne()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getVariadicParameter(List<Parameter> parameters) {
        int i = 0;
        for (Parameter param : parameters) {
            if (param.isSequenced()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Sequential<? extends ceylon.language.meta.declaration.Module> getModuleList() {
        Set<Module> modules = moduleManager.getModules().getListOfModules();
        Module[] view = new Module[modules.size()];
        modules.toArray(view);
        Object[] array = new ceylon.language.meta.declaration.Module[view.length];
        int i = 0;
        for (Module module : view) {
            ModuleImpl mod = Metamodel.getOrCreateMetamodel(null, module, null, true);
            if (mod == null) continue;
            array[i++] = mod;
        }
        ObjectArrayIterable iterable = new ObjectArrayIterable(ceylon.language.meta.declaration.Module.$TypeDescriptor$, array);
        return iterable.take(i).sequence();
    }

    public static ceylon.language.meta.declaration.Module findLoadedModule(java.lang.String name, java.lang.String version2) {
        Module module = moduleManager.findLoadedModule(name, version2);
        return module != null ? Metamodel.getOrCreateMetamodel(null, module, null, true) : null;
    }

    public static ceylon.language.meta.declaration.Module getDefaultModule() {
        Module module = moduleManager.getModules().getDefaultModule();
        return module != null ? Metamodel.getOrCreateMetamodel(null, module, null, true) : null;
    }

    public static List<Type> getParameterProducedTypes(List<Parameter> parameters, Reference producedReference) {
        ArrayList<Type> parameterProducedTypes = new ArrayList<Type>(parameters.size());
        for (Parameter parameter : parameters) {
            Type ft = producedReference.getTypedParameter(parameter).getFullType();
            parameterProducedTypes.add(ft);
        }
        return parameterProducedTypes;
    }

    public static boolean isCeylon(com.redhat.ceylon.model.typechecker.model.ClassOrInterface declaration) {
        return JvmBackendUtil.isCeylon(declaration);
    }

    public static TypeDescriptor getTypeDescriptorForArguments(Unit unit, Functional decl, Reference producedReference) {
        if (!decl.getParameterLists().isEmpty()) {
            List<Parameter> parameters = decl.getFirstParameterList().getParameters();
            Type tupleType = unit.getParameterTypesAsTupleType(parameters, producedReference);
            return Metamodel.getTypeDescriptorForProducedType(tupleType);
        }
        return TypeDescriptor.NothingType;
    }

    public static Type getProducedTypeForArguments(Unit unit, Functional decl, Reference producedReference) {
        if (!decl.getParameterLists().isEmpty()) {
            List<Parameter> parameters = decl.getFirstParameterList().getParameters();
            return unit.getParameterTypesAsTupleType(parameters, producedReference);
        }
        return new NothingType(unit).getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NestableDeclaration getOrCreateMetamodel(Class<?> klass) {
        Object object = Metamodel.getLock();
        synchronized (object) {
            NestableDeclaration result = classToDeclaration.get(klass);
            if (result == null) {
                java.lang.String typeName = klass.getName();
                Module module = moduleManager.findModuleForClass(klass);
                TypeDeclaration decl = (TypeDeclaration)moduleManager.getModelLoader().getDeclaration(module, typeName, ModelLoader.DeclarationType.TYPE);
                result = (NestableDeclaration)Metamodel.getOrCreateMetamodel(decl);
                classToDeclaration.put(klass, result);
            }
            return result;
        }
    }

    public static TypeDescriptor getTypeDescriptorForFunction(Reference appliedFunction) {
        return Metamodel.getTypeDescriptorForProducedType(Metamodel.getFunctionReturnType(appliedFunction));
    }

    public static Type getFunctionReturnType(Reference appliedFunction) {
        Type fullType = appliedFunction.getFullType();
        return fullType.getTypeArgumentList().get(0);
    }

    public static Parameter getParameterFromTypedDeclaration(TypedDeclaration declaration) {
        if (declaration instanceof FunctionOrValue) {
            return ((FunctionOrValue)declaration).getInitializerParameter();
        }
        return null;
    }

    public static <T extends Declaration> T parseMetamodelReference(java.lang.String ref) {
        DeclarationParser parser = new DeclarationParser();
        return (T)parser.ref(ref);
    }

    public static <T extends Declaration> Sequential<T> parseMetamodelReferences(TypeDescriptor $reifiedElement, java.lang.String[] refs) {
        DeclarationParser parser = new DeclarationParser();
        Declaration[] array = new Declaration[refs.length];
        for (int ii = 0; ii < refs.length; ++ii) {
            array[ii] = parser.ref(refs[ii]);
        }
        return Util.sequentialWrapper($reifiedElement, array);
    }

    public static <T> T parseEnumerationReference(Class<T> klass) {
        ClassOrInterfaceDeclarationImpl decl = (ClassOrInterfaceDeclarationImpl)Metamodel.getOrCreateMetamodel(klass);
        java.lang.String getterName = NamingBase.getGetterName(decl.declaration);
        try {
            Method method = klass.getDeclaredMethod(getterName, new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(null, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Metamodel.newModelError(e.toString());
        }
    }

    public static <T> Sequential<? extends T> parseEnumerationReferences(TypeDescriptor $reifiedElement, Class<?>[] refs) {
        Object[] array = new Object[refs.length];
        for (int ii = 0; ii < refs.length; ++ii) {
            array[ii] = Metamodel.parseEnumerationReference(refs[ii]);
        }
        return new ObjectArrayIterable($reifiedElement, array).sequence();
    }

    public static Sequential<? extends TypeParameter> getTypeParameters(com.redhat.ceylon.model.typechecker.model.Generic declaration) {
        List<com.redhat.ceylon.model.typechecker.model.TypeParameter> typeParameters = declaration.getTypeParameters();
        TypeParameter[] typeParametersArray = new TypeParameter[typeParameters.size()];
        int i = 0;
        for (com.redhat.ceylon.model.typechecker.model.TypeParameter tp : typeParameters) {
            typeParametersArray[i++] = new TypeParameterImpl(tp);
        }
        return Util.sequentialWrapper(TypeParameter.$TypeDescriptor$, typeParametersArray);
    }

    public static <DeclarationType extends Declaration> DeclarationType findDeclarationByName(Sequential<? extends DeclarationType> declarations, java.lang.String name) {
        Object it;
        Iterator iterator = declarations.iterator();
        while ((it = iterator.next()) != finished_.get_()) {
            Declaration tp = (Declaration)it;
            if (!tp.getName().equals(name)) continue;
            return (DeclarationType)tp;
        }
        return null;
    }

    public static AnnotatedDeclaration getContainer(com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
        Scope container = declaration.getContainer();
        if (container instanceof com.redhat.ceylon.model.typechecker.model.Declaration) {
            return (AnnotatedDeclaration)Metamodel.getOrCreateMetamodel((com.redhat.ceylon.model.typechecker.model.Declaration)((Object)container));
        }
        if (container instanceof com.redhat.ceylon.model.typechecker.model.Package) {
            return Metamodel.getOrCreateMetamodel((com.redhat.ceylon.model.typechecker.model.Package)container);
        }
        throw Metamodel.newModelError("Illegal container type: " + container);
    }

    public static boolean isLocalType(TypeDeclaration decl) {
        return ((LazyElement)((Object)decl)).isLocal();
    }

    public static ceylon.language.Map<? extends TypeParameter, ? extends ceylon.language.meta.model.Type<?>> getTypeArguments(GenericDeclaration declaration, Reference appliedFunction) {
        Object it;
        LinkedHashMap typeArguments = new LinkedHashMap();
        Iterator typeParameters = declaration.getTypeParameterDeclarations().iterator();
        Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, Type> ptArguments = appliedFunction.getTypeArguments();
        while ((it = typeParameters.next()) != finished_.get_()) {
            TypeParameterImpl tp = (TypeParameterImpl)it;
            com.redhat.ceylon.model.typechecker.model.TypeParameter tpDecl = tp.declaration;
            Type ptArg = ptArguments.get(tpDecl);
            ceylon.language.meta.model.Type ptArgWrapped = Metamodel.getAppliedMetamodel(ptArg);
            typeArguments.put(tp, ptArgWrapped);
        }
        return new InternalMap(TypeParameter.$TypeDescriptor$, TD_ClosedTypeOfAnything, typeArguments);
    }

    public static ceylon.language.Map<? extends TypeParameter, ? extends Sequence<? extends Object>> getTypeArgumentWithVariances(GenericDeclaration declaration, Reference appliedFunction) {
        Object it;
        Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, SiteVariance> varianceOverrides;
        LinkedHashMap typeArguments = new LinkedHashMap();
        Iterator typeParameters = declaration.getTypeParameterDeclarations().iterator();
        Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, Type> ptArguments = appliedFunction.getTypeArguments();
        Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, SiteVariance> map = varianceOverrides = appliedFunction instanceof Type ? ((Type)appliedFunction).getVarianceOverrides() : null;
        while ((it = typeParameters.next()) != finished_.get_()) {
            TypeParameterImpl tp = (TypeParameterImpl)it;
            com.redhat.ceylon.model.typechecker.model.TypeParameter tpDecl = tp.declaration;
            Type ptArg = ptArguments.get(tpDecl);
            ceylon.language.meta.model.Type ptArgWrapped = Metamodel.getAppliedMetamodel(ptArg);
            ceylon.language.meta.declaration.Variance variance = Metamodel.modelVarianceToMetaModel(varianceOverrides, tpDecl);
            Tuple<?, ?, ?> tuple = Tuple.instance(TD_ClosedTypeArgumentElement, new Object[]{ptArgWrapped, variance});
            typeArguments.put(tp, tuple);
        }
        return new InternalMap(TypeParameter.$TypeDescriptor$, TD_ClosedTypeArgument, typeArguments);
    }

    public static ceylon.language.meta.declaration.Variance modelVarianceToMetaModel(Map<com.redhat.ceylon.model.typechecker.model.TypeParameter, SiteVariance> varianceOverrides, com.redhat.ceylon.model.typechecker.model.TypeParameter tpDecl) {
        if (varianceOverrides == null) {
            return Metamodel.getModelVariance(tpDecl);
        }
        SiteVariance useSiteVariance = varianceOverrides.get(tpDecl);
        if (useSiteVariance == null) {
            return invariant_.get_();
        }
        switch (useSiteVariance) {
            case IN: {
                return contravariant_.get_();
            }
            case OUT: {
                return covariant_.get_();
            }
        }
        return invariant_.get_();
    }

    public static java.lang.String toTypeString(NestableDeclaration declaration, ceylon.language.Map<? extends TypeParameter, ? extends Sequence<? extends Object>> typeArguments) {
        StringBuffer string = new StringBuffer();
        string.append(declaration.getName());
        if (declaration instanceof GenericDeclaration) {
            Metamodel.addTypeArguments(string, (GenericDeclaration)((Object)declaration), typeArguments);
        }
        Object container = declaration.getContainer();
        while (container != null) {
            if (container instanceof Package) {
                return ((Package)container).getName() + "::" + string;
            }
            StringBuffer string2 = new StringBuffer(((NestableDeclaration)container).getName());
            if (container instanceof GenericDeclaration) {
                Metamodel.addTypeArguments(string2, (GenericDeclaration)container, typeArguments);
            }
            string2.append(".");
            string.insert(0, string2.toString());
            container = ((NestableDeclaration)container).getContainer();
        }
        return string.toString();
    }

    private static void addTypeArguments(StringBuffer string, GenericDeclaration declaration, ceylon.language.Map<? extends TypeParameter, ? extends Sequence<? extends Object>> typeArguments) {
        if (!declaration.getTypeParameterDeclarations().getEmpty()) {
            Object it;
            string.append("<");
            Iterator iterator = declaration.getTypeParameterDeclarations().iterator();
            boolean once = true;
            while ((it = iterator.next()) != finished_.get_()) {
                if (once) {
                    once = false;
                } else {
                    string.append(",");
                }
                TypeParameter tpDecl = Util.assertExists((TypeParameter)it);
                Sequence<? extends Object> tuple = typeArguments != null ? typeArguments.get(tpDecl) : null;
                Object val = tuple.getFromFirst(0L);
                ceylon.language.meta.declaration.Variance variance = (ceylon.language.meta.declaration.Variance)tuple.getFromFirst(1L);
                if (variance == contravariant_.get_()) {
                    string.append("in ");
                } else if (variance == covariant_.get_()) {
                    string.append("out ");
                }
                if (val instanceof ceylon.language.meta.model.Type) {
                    string.append(val);
                    continue;
                }
                if (val instanceof OpenTypeVariable) {
                    string.append(((OpenTypeVariable)val).getDeclaration().getQualifiedName());
                    continue;
                }
                if (val instanceof OpenClassOrInterfaceType) {
                    string.append(((OpenClassOrInterfaceType)val).getDeclaration().getQualifiedName());
                    continue;
                }
                if (val instanceof OpenType) {
                    string.append(val);
                    continue;
                }
                string.append("##Missing##");
            }
            string.append(">");
        }
    }

    public static java.lang.String toTypeString(Model model) {
        StringBuffer string = new StringBuffer();
        ceylon.language.meta.model.Type container = model.getContainer();
        if (model instanceof CallableConstructorImpl) {
            string.append(((CallableConstructorImpl)model).appliedClass.toString()).append(".");
        } else if (model instanceof ValueConstructorImpl) {
            string.append(((ValueConstructorImpl)model).clazz.toString()).append(".");
        } else if (model instanceof MemberClassCallableConstructorImpl) {
            string.append(((MemberClassCallableConstructorImpl)model).clazz.toString()).append(".");
        } else if (model instanceof MemberClassValueConstructorImpl) {
            string.append(((MemberClassValueConstructorImpl)model).clazz.toString()).append(".");
        } else if (container == null) {
            string.append(model.getDeclaration().getContainingPackage().getName()).append("::");
        } else if (container instanceof ClassOrInterface) {
            string.append(container.toString()).append(".");
        } else {
            string.append("<").append(container.toString()).append(">.");
        }
        string.append(model.getDeclaration().getName());
        if (model instanceof Generic) {
            Metamodel.addTypeArguments(string, (GenericDeclaration)((Object)model.getDeclaration()), ((Generic)((Object)model)).getTypeArgumentWithVariances());
        }
        return string.toString();
    }

    public static void checkTypeArguments(Type qualifyingType, com.redhat.ceylon.model.typechecker.model.Declaration declaration, List<Type> typeArguments) {
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.Generic) {
            List<com.redhat.ceylon.model.typechecker.model.TypeParameter> typeParameters = ((com.redhat.ceylon.model.typechecker.model.Generic)((Object)declaration)).getTypeParameters();
            if (typeParameters.size() < typeArguments.size()) {
                throw new TypeApplicationException("Too many type arguments provided: " + typeArguments.size() + ", but only accepts " + typeParameters.size());
            }
            int min = 0;
            for (com.redhat.ceylon.model.typechecker.model.TypeParameter tp : typeParameters) {
                if (tp.isDefaulted()) continue;
                ++min;
            }
            if (typeArguments.size() < min) {
                java.lang.String requires = min == typeParameters.size() ? "exactly" : "at least";
                throw new TypeApplicationException("Not enough type arguments provided: " + typeArguments.size() + ", but requires " + requires + " " + min);
            }
            for (int i = 0; i < typeArguments.size(); ++i) {
                Type typeArgument = typeArguments.get(i);
                com.redhat.ceylon.model.typechecker.model.TypeParameter typeParameter = typeParameters.get(i);
                for (Type st : typeParameter.getSatisfiedTypes()) {
                    Type sts = st.appliedType(qualifyingType, declaration, typeArguments, null);
                    if (typeArgument.isSubtypeOf(sts)) continue;
                    throw new TypeApplicationException("Type argument " + i + ": " + typeArgument.asQualifiedString() + " does not conform to upper bound constraint: " + sts.asQualifiedString() + " of type parameter " + typeParameter.getQualifiedNameString());
                }
                if (ModelUtil.argumentSatisfiesEnumeratedConstraint(qualifyingType, declaration, typeArguments, typeArgument, typeParameter)) continue;
                throw new TypeApplicationException("Type argument " + i + ": " + typeArgument.asQualifiedString() + " does not conform to enumerated constraints  of type parameter " + typeParameter.getQualifiedNameString());
            }
        } else if (!typeArguments.isEmpty()) {
            throw new TypeApplicationException("Declaration does not accept type arguments");
        }
    }

    public static boolean isTypeOf(Type producedType, Object instance) {
        Type instanceType = Metamodel.getProducedType(instance);
        return instanceType.isSubtypeOf(producedType);
    }

    public static boolean isSuperTypeOf(Type a, ceylon.language.meta.model.Type<? extends Object> type) {
        Type b = Metamodel.getModel(type);
        return a.isSupertypeOf(b);
    }

    public static boolean isSubTypeOf(Type a, ceylon.language.meta.model.Type<? extends Object> type) {
        Type b = Metamodel.getModel(type);
        return a.isSubtypeOf(b);
    }

    public static boolean isExactly(Type a, ceylon.language.meta.model.Type<? extends Object> type) {
        Type b = Metamodel.getModel(type);
        return a.isExactly(b);
    }

    public static ceylon.language.meta.model.Type<?> union(ceylon.language.meta.model.Type<? extends Object> typeX, ceylon.language.meta.model.Type<? extends Object> typeY) {
        Type x = Metamodel.getModel(typeX);
        Type y = Metamodel.getModel(typeY);
        Type unionType = ModelUtil.unionType(x, y, moduleManager.getModelLoader().getUnit());
        return Metamodel.getAppliedMetamodel(unionType);
    }

    public static ceylon.language.meta.model.Type<?> intersection(ceylon.language.meta.model.Type<? extends Object> typeX, ceylon.language.meta.model.Type<? extends Object> typeY) {
        Type x = Metamodel.getModel(typeX);
        Type y = Metamodel.getModel(typeY);
        Type intersectionType = ModelUtil.intersectionType(x, y, moduleManager.getModelLoader().getUnit());
        return Metamodel.getAppliedMetamodel(intersectionType);
    }

    public static void checkReifiedTypeArgument(java.lang.String methodName, java.lang.String className, Variance variance, Type appliedType, TypeDescriptor $reifiedType) {
        Type expectedReifiedType = Metamodel.getProducedType($reifiedType);
        boolean check = Metamodel.checkReifiedTypeArgument(variance, appliedType, expectedReifiedType);
        if (!check) {
            java.lang.String appliedTypeString = appliedType.asString();
            java.lang.String expectedReifiedTypeString = expectedReifiedType.asString();
            java.lang.String appliedString = className.replace("$1", appliedTypeString);
            java.lang.String expectedString = className.replace("$1", expectedReifiedTypeString);
            throw new IncompatibleTypeException("Incompatible type: actual type of applied declaration is " + appliedString + " is not compatible with expected type: " + expectedString + ". Try passing the type argument explicitly with: " + methodName + "<" + appliedTypeString + ">()");
        }
    }

    public static void checkReifiedTypeArgument(java.lang.String methodName, java.lang.String className, Variance variance1, Type appliedType1, TypeDescriptor $reifiedType1, Variance variance2, Type appliedType2, TypeDescriptor $reifiedType2) {
        Type expectedReifiedType1 = Metamodel.getProducedType($reifiedType1);
        Type expectedReifiedType2 = Metamodel.getProducedType($reifiedType2);
        boolean check1 = Metamodel.checkReifiedTypeArgument(variance1, appliedType1, expectedReifiedType1);
        boolean check2 = Metamodel.checkReifiedTypeArgument(variance2, appliedType2, expectedReifiedType2);
        if (!check1 || !check2) {
            java.lang.String appliedTypeString1 = appliedType1.asString();
            java.lang.String expectedReifiedTypeString1 = expectedReifiedType1.asString();
            java.lang.String appliedTypeString2 = appliedType2.asString();
            java.lang.String expectedReifiedTypeString2 = expectedReifiedType2.asString();
            java.lang.String appliedString = className.replace("$1", appliedTypeString1).replace("$2", appliedTypeString2);
            java.lang.String expectedString = className.replace("$1", expectedReifiedTypeString1).replace("$2", expectedReifiedTypeString2);
            throw new IncompatibleTypeException("Incompatible type: actual type of applied declaration is " + appliedString + " is not compatible with expected type: " + expectedString + ". Try passing the type argument explicitly with: " + methodName + "<" + appliedTypeString1 + "," + appliedTypeString2 + ">()");
        }
    }

    public static void checkReifiedTypeArgument(java.lang.String methodName, java.lang.String className, Variance variance1, Type appliedType1, TypeDescriptor $reifiedType1, Variance variance2, Type appliedType2, TypeDescriptor $reifiedType2, Variance variance3, Type appliedType3, TypeDescriptor $reifiedType3) {
        Type expectedReifiedType1 = Metamodel.getProducedType($reifiedType1);
        Type expectedReifiedType2 = Metamodel.getProducedType($reifiedType2);
        Type expectedReifiedType3 = Metamodel.getProducedType($reifiedType3);
        boolean check1 = Metamodel.checkReifiedTypeArgument(variance1, appliedType1, expectedReifiedType1);
        boolean check2 = Metamodel.checkReifiedTypeArgument(variance2, appliedType2, expectedReifiedType2);
        boolean check3 = Metamodel.checkReifiedTypeArgument(variance3, appliedType3, expectedReifiedType3);
        if (!(check1 && check2 && check3)) {
            java.lang.String appliedTypeString1 = appliedType1.asString();
            java.lang.String expectedReifiedTypeString1 = expectedReifiedType1.asString();
            java.lang.String appliedTypeString2 = appliedType2.asString();
            java.lang.String expectedReifiedTypeString2 = expectedReifiedType2.asString();
            java.lang.String appliedTypeString3 = appliedType3.asString();
            java.lang.String expectedReifiedTypeString3 = expectedReifiedType3.asString();
            java.lang.String appliedString = className.replace("$1", appliedTypeString1).replace("$2", appliedTypeString2).replace("$3", appliedTypeString3);
            java.lang.String expectedString = className.replace("$1", expectedReifiedTypeString1).replace("$2", expectedReifiedTypeString2).replace("$3", expectedReifiedTypeString3);
            throw new IncompatibleTypeException("Incompatible type: actual type of applied declaration is " + appliedString + " is not compatible with expected type: " + expectedString + ". Try passing the type argument explicitly with: " + methodName + "<" + appliedTypeString1 + "," + appliedTypeString2 + "," + appliedTypeString3 + ">()");
        }
    }

    private static boolean checkReifiedTypeArgument(Variance variance, Type appliedType, Type expectedReifiedType) {
        switch (variance) {
            case IN: {
                return appliedType.isSupertypeOf(expectedReifiedType);
            }
            case OUT: {
                return appliedType.isSubtypeOf(expectedReifiedType);
            }
            case NONE: {
                return appliedType.isExactly(expectedReifiedType);
            }
        }
        throw Metamodel.newModelError("Invalid variance: " + (Object)((Object)variance));
    }

    public static void checkQualifyingType(Type qualifyingType, com.redhat.ceylon.model.typechecker.model.Declaration declaration) {
        Scope container = declaration.getContainer();
        if (!(container instanceof TypeDeclaration)) {
            throw new IncompatibleTypeException("Declaration container is not a type: " + container);
        }
        TypeDeclaration typeDecl = (TypeDeclaration)container;
        Type supertype = qualifyingType.getSupertype(typeDecl);
        if (supertype == null) {
            throw new IncompatibleTypeException("Invalid container type: " + qualifyingType + " is not a subtype of " + typeDecl);
        }
    }

    public static <Return> Return namedApply(Callable<? extends Return> function, DefaultValueProvider defaultValueProvider, Functional declaration, Iterable<? extends Entry<? extends String, ? extends Object>, ? extends Object> arguments, List<Type> parameterProducedTypes) {
        Map<java.lang.String, Object> argumentMap = Metamodel.collectArguments(arguments);
        List<Parameter> parameters = declaration.getFirstParameterList().getParameters();
        Array<Object> values = new Array<Object>(Anything.$TypeDescriptor$, parameters.size(), null);
        int parameterIndex = 0;
        java.util.Iterator<Object> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            Object value;
            Parameter parameter = iterator.next();
            if (argumentMap.containsKey(parameter.getName())) {
                Type parameterType;
                value = argumentMap.remove(parameter.getName());
                Type argumentType = Metamodel.getProducedType(value);
                if (!argumentType.isSubtypeOf(parameterType = parameterProducedTypes.get(parameterIndex))) {
                    throw new IncompatibleTypeException("Invalid argument " + parameter.getName() + ", expected type " + parameterType + " but got " + argumentType);
                }
            } else {
                if (!parameter.isDefaulted()) {
                    throw new InvocationException("Missing value for non-defaulted parameter " + parameter.getName());
                }
                value = defaultValueProvider.getDefaultParameterValue(parameter, values, parameterIndex);
                argumentMap.remove(parameter.getName());
            }
            values.set((long)parameterIndex++, value);
        }
        if (!argumentMap.isEmpty() && (iterator = argumentMap.keySet().iterator()).hasNext()) {
            java.lang.String name = (java.lang.String)iterator.next();
            throw new InvocationException("No such parameter " + name);
        }
        Sequential<Object> argumentSequence = values.sequence();
        return Util.apply(function, argumentSequence, null);
    }

    private static Map<java.lang.String, Object> collectArguments(Iterable<? extends Entry<? extends String, ? extends Object>, ? extends Object> arguments) {
        Object elem;
        HashMap<java.lang.String, Object> args = new HashMap<java.lang.String, Object>();
        Iterator<? extends Entry<? extends String, ? extends Object>> iterator = arguments.iterator();
        while ((elem = iterator.next()) != finished_.get_()) {
            Entry entry = (Entry)elem;
            args.put(((String)entry.getKey()).toString(), entry.getItem());
        }
        return args;
    }

    public static <Return> Return apply(Callable<? extends Return> function, Sequential<?> arguments, List<Type> parameterProducedTypes, int firstDefaulted, int variadicIndex) {
        Object arg;
        int argumentCount = Util.toInt(arguments.getSize());
        int parameters = parameterProducedTypes.size();
        if (firstDefaulted == -1) {
            if (argumentCount < parameters) {
                throw new InvocationException("Not enough arguments to function. Expected " + parameters + " but got only " + argumentCount);
            }
        } else if (argumentCount < firstDefaulted) {
            throw new InvocationException("Not enough arguments to function. Expected at least " + firstDefaulted + " but got only " + argumentCount);
        }
        if (variadicIndex == -1 && argumentCount > parameters) {
            throw new InvocationException("To many arguments to function. Expected at most " + parameters + " but got " + argumentCount);
        }
        Iterator it = arguments.iterator();
        int i = 0;
        Type variadicElement = null;
        if (variadicIndex != -1) {
            variadicElement = parameterProducedTypes.get(variadicIndex).getTypeArgumentList().get(0);
        }
        while ((arg = it.next()) != finished_.get_()) {
            Type parameterType = variadicIndex == -1 || i < variadicIndex ? parameterProducedTypes.get(i) : variadicElement;
            Type argumentType = Metamodel.getProducedType(arg);
            if (!argumentType.isSubtypeOf(parameterType)) {
                throw new IncompatibleTypeException("Invalid argument " + i + ", expected type " + parameterType + " but got " + argumentType);
            }
            ++i;
        }
        TypeDescriptor variadicElementType = variadicElement != null ? Metamodel.getTypeDescriptorForProducedType(variadicElement) : null;
        return Util.apply(function, arguments, variadicElementType);
    }

    public static <K, C> K bind(Qualified<K, C> member, Type containerType, Object container) {
        Type argumentType;
        if (!(container != null || member instanceof Declared && ((Declared)((Object)member)).getDeclaration() instanceof NestableDeclaration && ((NestableDeclaration)((Declared)((Object)member)).getDeclaration()).getStatic())) {
            throw new IncompatibleTypeException("Invalid container " + container + ", expected type " + containerType + " but got ceylon.language::Null");
        }
        if (container != null && !(argumentType = Metamodel.getProducedType(container)).isSubtypeOf(containerType)) {
            throw new IncompatibleTypeException("Invalid container " + container + ", expected type " + containerType + " but got " + argumentType);
        }
        return (K)member.$call$(container);
    }

    public static int hashCode(NestableDeclarationImpl decl, java.lang.String type) {
        int result = 1;
        Object container = decl.getContainer();
        result = 37 * result + type.hashCode();
        result = 37 * result + (container == null ? 0 : container.hashCode());
        result = 37 * result + (decl.getQualifier() == null ? 0 : decl.getQualifier().hashCode());
        result = 37 * result + decl.getName().hashCode();
        return result;
    }

    public static boolean equalsForSameType(NestableDeclarationImpl a, NestableDeclarationImpl b) {
        if (!Util.eq(a.getContainer(), b.getContainer())) {
            return false;
        }
        if (!Util.eq(a.getQualifier(), b.getQualifier())) {
            return false;
        }
        return a.getName().equals(b.getName());
    }

    public static RuntimeException newModelError(java.lang.String string) {
        return Metamodel.newModelError(string, null);
    }

    public static RuntimeException newModelError(java.lang.String string, Throwable cause) {
        Util.rethrow(new ModelError(string, cause));
        return null;
    }

    public static ceylon.language.meta.declaration.Module checkModule(ceylon.language.meta.declaration.Module module, java.lang.String name, java.lang.String version2) {
        if (module == null) {
            java.lang.String spec = version2 == null ? name : name + "/" + version2;
            if (moduleManager.getModelLoader().isDynamicMetamodel()) {
                return Metamodel.getOrCreateMetamodel(Metamodel.getModuleManager().getModules().getDefaultModule());
            }
            throw new AssertionError("Module " + spec + " is not available");
        }
        return module;
    }

    public static Object getCompanionInstance(Object instance, Interface iface) {
        if (instance == null) {
            return null;
        }
        try {
            Method implAccessor = instance.getClass().getMethod("$" + iface.getQualifiedNameString().replace('.', '$').replace("::", "$") + "$impl", new Class[0]);
            implAccessor.setAccessible(true);
            return implAccessor.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Sequential<? extends ceylon.language.meta.model.Type<?>> getTypeArgumentList(Generic generic) {
        Object sequence = sequence_.sequence(TypeDescriptor.klass(ceylon.language.meta.model.Type.class, Anything.$TypeDescriptor$), Null.$TypeDescriptor$, generic.getTypeArguments().getItems());
        return (Sequential)(sequence != null ? sequence : empty_.get_());
    }

    public static Sequential<? extends OpenType> getTypeArgumentList(OpenClassOrInterfaceType generic) {
        Object sequence = sequence_.sequence(OpenType.$TypeDescriptor$, Null.$TypeDescriptor$, generic.getTypeArguments().getItems());
        return (Sequential)(sequence != null ? sequence : empty_.get_());
    }

    public static Sequential<? extends Sequence<? extends Object>> getTypeArgumentWithVarianceList(Generic generic) {
        Object sequence = sequence_.sequence(TD_ClosedTypeArgument, Null.$TypeDescriptor$, generic.getTypeArgumentWithVariances().getItems());
        return (Sequential)(sequence != null ? sequence : empty_.get_());
    }

    public static Sequential<? extends Sequence<? extends Object>> getTypeArgumentWithVarianceList(OpenClassOrInterfaceType generic) {
        Object sequence = sequence_.sequence(TD_OpenTypeArgument, Null.$TypeDescriptor$, generic.getTypeArgumentWithVariances().getItems());
        return (Sequential)(sequence != null ? sequence : empty_.get_());
    }

    public static boolean isAnnotated(TypeDescriptor reifed$AnnotationType, AnnotationBearing annotated) {
        Class<?> klass;
        Class<?> clazz = klass = reifed$AnnotationType instanceof TypeDescriptor.Class ? ((TypeDescriptor.Class)reifed$AnnotationType).getKlass() : null;
        if (klass == ceylon.language.Annotation.class) {
            Annotation[] ja = annotated.$getJavaAnnotations$();
            return ja != null && ja.length > 0;
        }
        if (klass == OptionalAnnotation.class || klass == SequencedAnnotation.class || klass == ConstrainedAnnotation.class) {
            TypeDescriptor typeArgument = ((TypeDescriptor.Class)reifed$AnnotationType).getTypeArgument(0);
            if (typeArgument.equals(TypeDescriptor.NothingType)) {
                Annotation[] ja = annotated.$getJavaAnnotations$();
                if (ja != null) {
                    for (Annotation j : ja) {
                        if (!j.annotationType().isAnnotationPresent(Ceylon.class) || klass != ConstrainedAnnotation.class && !j.annotationType().getName().endsWith(klass == OptionalAnnotation.class ? "$annotation$" : "$annotations$")) continue;
                        return true;
                    }
                }
                return false;
            }
            klass = ((TypeDescriptor.Class)typeArgument).getKlass();
            return annotated.$isAnnotated$(Metamodel.getJavaAnnotationClass(klass));
        }
        return annotated.$isAnnotated$(Metamodel.getJavaAnnotationClass(klass));
    }

    public static ceylon.language.meta.declaration.Variance getModelVariance(com.redhat.ceylon.model.typechecker.model.TypeParameter declaration) {
        if (declaration.isInvariant()) {
            return invariant_.get_();
        }
        if (declaration.isCovariant()) {
            return covariant_.get_();
        }
        if (declaration.isContravariant()) {
            return contravariant_.get_();
        }
        throw Metamodel.newModelError("Underlying declaration is neither invariant, covariant nor contravariant");
    }

    public static boolean hasAllAnnotations(AnnotatedDeclaration decl, TypeDescriptor[] annotationTypeDescriptors) {
        for (TypeDescriptor annotationTypeDescriptor : annotationTypeDescriptors) {
            if (!decl.annotations(annotationTypeDescriptor).getEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <Type> Sequential getConstructors(ClassOrInterfaceImpl<Type> cls, boolean justShared, boolean callableConstructors, TypeDescriptor $reified$Arguments, Sequential<? extends ceylon.language.meta.model.Type<? extends Annotation>> annotations) {
        ArrayList<Object> ctors = new ArrayList<Object>();
        Type reifiedArguments = $reified$Arguments == null ? null : Metamodel.getProducedType($reified$Arguments);
        TypeDescriptor[] annotationTypeDescriptors = Metamodel.getTypeDescriptors(annotations);
        if (cls.declaration instanceof ClassWithInitializerDeclarationImpl) {
            Reference producedReference = cls.declaration.declaration.appliedReference(cls.producedType, Collections.emptyList());
            Type argumentsType = Metamodel.getProducedTypeForArguments(cls.declaration.declaration.getUnit(), (Functional)((Object)cls.declaration.declaration), producedReference);
            if ((reifiedArguments == null || reifiedArguments.isSubtypeOf(argumentsType)) && Metamodel.hasAllAnnotations(((ClassWithInitializerDeclarationImpl)cls.declaration).getDefaultConstructor(), annotationTypeDescriptors)) {
                ctors.add(((ClassModel)((Object)cls)).getDefaultConstructor());
            }
        } else {
            for (Declaration d : ((ClassDeclarationImpl)cls.declaration).constructors()) {
                Type argumentsType;
                Reference producedReference;
                ConstructorDeclaration annotated;
                com.redhat.ceylon.model.typechecker.model.Declaration dd = null;
                if (d instanceof CallableConstructorDeclarationImpl && callableConstructors) {
                    dd = ((CallableConstructorDeclarationImpl)d).declaration;
                    annotated = (CallableConstructorDeclaration)d;
                } else {
                    if (!(d instanceof ValueConstructorDeclarationImpl) || callableConstructors) continue;
                    dd = ((ValueConstructorDeclarationImpl)d).declaration;
                    annotated = (ValueConstructorDeclaration)d;
                }
                if (!Metamodel.hasAllAnnotations(annotated, annotationTypeDescriptors)) continue;
                if (dd instanceof Functional && reifiedArguments != null) {
                    producedReference = dd.appliedReference(cls.producedType, Collections.emptyList());
                    argumentsType = Metamodel.getProducedTypeForArguments(dd.getUnit(), (Functional)((Object)dd), producedReference);
                    if (!reifiedArguments.isSubtypeOf(argumentsType)) continue;
                }
                if (!Metamodel.hasAllAnnotations((AnnotatedDeclaration)d, annotationTypeDescriptors)) continue;
                if (dd instanceof Functional && reifiedArguments != null) {
                    producedReference = dd.appliedReference(cls.producedType, Collections.emptyList());
                    argumentsType = Metamodel.getProducedTypeForArguments(dd.getUnit(), (Functional)((Object)dd), producedReference);
                    if (!reifiedArguments.isSubtypeOf(argumentsType)) continue;
                }
                if (justShared && (!(d instanceof NestableDeclaration) || !((NestableDeclaration)d).getShared())) continue;
                Object ctor = cls instanceof ClassImpl ? ((ClassImpl)cls).getDeclaredConstructor(TypeDescriptor.NothingType, d.getName()) : ((MemberClassImpl)cls).getDeclaredConstructor(TypeDescriptor.NothingType, d.getName());
                ctors.add(ctor);
            }
        }
        Object[] array = ctors.toArray(new Object[ctors.size()]);
        ObjectArrayIterable iterable = new ObjectArrayIterable(TypeDescriptor.union(TypeDescriptor.klass(FunctionModel.class, cls.$reifiedType, TypeDescriptor.NothingType), TypeDescriptor.klass(ValueModel.class, cls.$reifiedType, TypeDescriptor.NothingType)), array);
        return iterable.sequence();
    }

    public static Class<?> getJavaClass(TypeDescriptor $reifiedT) {
        TypeDescriptor.Member member;
        TypeDescriptor m;
        if ($reifiedT instanceof TypeDescriptor.Intersection) {
            return Metamodel.getJavaClass(((TypeDescriptor.Intersection)$reifiedT).toSimpleType(Metamodel.getModuleManager()));
        }
        if ($reifiedT instanceof TypeDescriptor.Union) {
            return Metamodel.getJavaClass(((TypeDescriptor.Union)$reifiedT).toSimpleType(Metamodel.getModuleManager()));
        }
        if ($reifiedT instanceof TypeDescriptor.Class) {
            TypeDescriptor.Class klass = (TypeDescriptor.Class)$reifiedT;
            return klass.getArrayElementClass();
        }
        if ($reifiedT instanceof TypeDescriptor.Member && (m = (member = (TypeDescriptor.Member)$reifiedT).getMember()) instanceof TypeDescriptor.Class) {
            TypeDescriptor.Class klass = (TypeDescriptor.Class)m;
            return klass.getKlass();
        }
        return null;
    }

    private static Class<?> getJavaClass(Type pt) {
        TypeDeclaration declaration = pt.getDeclaration();
        if (declaration instanceof com.redhat.ceylon.model.typechecker.model.ClassOrInterface) {
            return Metamodel.getJavaClass(TypeDescriptor.klass(Metamodel.getJavaClass(declaration), new TypeDescriptor[0]));
        }
        return null;
    }

    static {
        classToDeclaration = new HashMap<Class, NestableDeclaration>();
        typeCheckModelToRuntimeModel = new HashMap<com.redhat.ceylon.model.typechecker.model.Declaration, Object>();
        typeCheckPackagesToRuntimeModel = new HashMap<com.redhat.ceylon.model.typechecker.model.Package, PackageImpl>();
        typeCheckModulesToRuntimeModel = new HashMap<Module, ModuleImpl>();
        typeDescriptorToProducedType = new WeakHashMap<TypeDescriptor, Type>();
        TD_ClosedTypeOfAnything = TypeDescriptor.klass(ceylon.language.meta.model.Type.class, Anything.$TypeDescriptor$);
        TD_ClosedTypeArgumentElement = TypeDescriptor.union(TD_ClosedTypeOfAnything, ceylon.language.meta.declaration.Variance.$TypeDescriptor$);
        TD_ClosedTypeArgument = TypeDescriptor.tuple(false, false, -1, TD_ClosedTypeOfAnything, ceylon.language.meta.declaration.Variance.$TypeDescriptor$);
        TD_OpenTypeArgumentElement = TypeDescriptor.union(OpenType.$TypeDescriptor$, ceylon.language.meta.declaration.Variance.$TypeDescriptor$);
        TD_OpenTypeArgument = TypeDescriptor.tuple(false, false, -1, OpenType.$TypeDescriptor$, ceylon.language.meta.declaration.Variance.$TypeDescriptor$);
        Metamodel.resetModuleManager();
    }
}

