/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.metamodel.decl;

import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Empty;
import ceylon.language.Exception;
import ceylon.language.Iterable;
import ceylon.language.Null;
import ceylon.language.Resource;
import ceylon.language.Sequential;
import ceylon.language.Tuple;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import ceylon.language.impl.BaseIterator;
import ceylon.language.meta.declaration.Import;
import ceylon.language.meta.declaration.Package;
import ceylon.language.meta.model.ClassOrInterface;
import ceylon.language.meta.type_;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.language.ByteArrayResource;
import com.redhat.ceylon.compiler.java.language.FileResource;
import com.redhat.ceylon.compiler.java.language.ObjectArrayIterable;
import com.redhat.ceylon.compiler.java.language.ZipResource;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.runtime.metamodel.AnnotationBearing;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ClassOrInterfaceDeclarationImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.decl.ImportImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModelLoader;
import com.redhat.ceylon.compiler.java.runtime.model.RuntimeModuleManager;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModuleImpl
implements ceylon.language.meta.declaration.Module,
AnnotationBearing,
ReifiedType {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ModuleImpl.class, new TypeDescriptor[0]);
    private static final Annotation[] NO_ANNOTATION = new Annotation[0];
    protected Module declaration;
    private Sequential<? extends Package> packages;
    private Sequential<? extends Import> dependencies;

    public ModuleImpl(Module declaration) {
        this.declaration = declaration;
    }

    @Override
    @Ignore
    public Annotation[] $getJavaAnnotations$() {
        if (this.declaration.isDefaultModule() || this.declaration.isJava()) {
            return NO_ANNOTATION;
        }
        return Metamodel.getJavaClass(this.declaration).getAnnotations();
    }

    @Override
    @Ignore
    public boolean $isAnnotated$(Class<? extends Annotation> annotationType) {
        if (this.declaration.isDefaultModule() || this.declaration.isJava()) {
            return false;
        }
        Class<?> element = Metamodel.getJavaClass(this.declaration);
        return element != null ? element.isAnnotationPresent(annotationType) : false;
    }

    @Override
    public <AnnotationType extends Annotation> boolean annotated(TypeDescriptor reifed$AnnotationType) {
        return Metamodel.isAnnotated(reifed$AnnotationType, this);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Annotation>")
    @TypeParameters(value={@TypeParameter(value="Annotation", satisfies={"ceylon.language::Annotation"})})
    public <Annotation extends Annotation> Sequential<? extends Annotation> annotations(@Ignore TypeDescriptor $reifiedAnnotation) {
        return Metamodel.annotations($reifiedAnnotation, this);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::Package>")
    public Sequential<? extends Package> getMembers() {
        if (this.packages == null) {
            List<com.redhat.ceylon.model.typechecker.model.Package> modelPackages = this.declaration.getPackages();
            Package[] packages = new Package[modelPackages.size()];
            for (int i = 0; i < packages.length; ++i) {
                packages[i] = Metamodel.getOrCreateMetamodel(modelPackages.get(i));
            }
            this.packages = Util.sequentialWrapper(Package.$TypeDescriptor$, packages);
        }
        return this.packages;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language.meta.declaration::Package")
    public Package findPackage(@Name(value="name") String name) {
        com.redhat.ceylon.model.typechecker.model.Package pkg = this.declaration.getDirectPackage(name);
        return pkg == null ? null : Metamodel.getOrCreateMetamodel(pkg);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language.meta.declaration::Package")
    public Package findImportedPackage(@Name(value="name") String name) {
        com.redhat.ceylon.model.typechecker.model.Package pkg = this.declaration.getPackage(name);
        return pkg == null ? null : Metamodel.getOrCreateMetamodel(pkg);
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<ceylon.language.meta.declaration::Import>")
    public Sequential<? extends Import> getDependencies() {
        if (this.dependencies == null) {
            List<ModuleImport> modelImports = this.declaration.getImports();
            ArrayList<ImportImpl> sb = new ArrayList<ImportImpl>(modelImports.size());
            for (ModuleImport moduleImport : modelImports) {
                sb.add(new ImportImpl(this, moduleImport));
            }
            Object[] array = sb.toArray(new ImportImpl[0]);
            this.dependencies = new ObjectArrayIterable(Import.$TypeDescriptor$, array).sequence();
        }
        return this.dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @TypeInfo(value="ceylon.language::Resource")
    public Resource resourceByPath(@Name(value="path") String path) {
        byte[] contents;
        RuntimeModelLoader modelLoader;
        String fullPath = path;
        if (!fullPath.startsWith("/")) {
            String modPath = "default".equals(this.getName()) ? "" : this.getName().replace('.', '/') + "/";
            fullPath = modPath + path;
        } else {
            fullPath = fullPath.substring(1);
        }
        fullPath = JVMModuleUtil.quoteJavaKeywordsInFilename(fullPath);
        RuntimeModuleManager moduleManager = Metamodel.getModuleManager();
        if (moduleManager != null && (modelLoader = moduleManager.getModelLoader()) != null && (contents = modelLoader.getContents(this.declaration, fullPath)) != null) {
            URI uri = modelLoader.getContentUri(this.declaration, fullPath);
            return new ByteArrayResource(contents, uri);
        }
        String moduleUnitFullPath = this.declaration.getUnit().getFullPath();
        if (moduleUnitFullPath != null) {
            File car = new File(moduleUnitFullPath);
            try (ZipFile zip = new ZipFile(car);){
                ZipEntry e = zip.getEntry(fullPath);
                if (e != null && !e.isDirectory()) {
                    ZipResource zipResource = new ZipResource(car, fullPath);
                    return zipResource;
                }
            }
            catch (IOException ex) {
                throw new Exception(new ceylon.language.String("Searching for resource " + path), (Throwable)ex);
            }
            File target = new File(new File(car.getParentFile(), "module-resources"), fullPath);
            if (target.exists() && target.isFile() && target.canRead()) {
                return new FileResource(target);
            }
        }
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(fullPath);){
            if (stream == null) return null;
            byte[] buf = new byte[16384];
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int bytesRead = stream.read(buf);
            while (bytesRead > 0) {
                bout.write(buf, 0, bytesRead);
                bytesRead = stream.read(buf);
            }
            ByteArrayResource byteArrayResource = new ByteArrayResource(bout.toByteArray(), new URI("classpath:" + fullPath));
            return byteArrayResource;
        }
        catch (IOException | URISyntaxException ex) {
            throw new Exception(new ceylon.language.String("Searching for resource " + path), (Throwable)ex);
        }
    }

    @Override
    @TypeInfo(value="ceylon.language::String")
    public String getName() {
        return this.declaration.getNameAsString();
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    @TypeInfo(value="ceylon.language::String")
    public String getVersion() {
        return this.declaration.getVersion();
    }

    @Override
    @TypeInfo(value="{Service*}")
    public <Service> Iterable<? extends Service, ? extends Object> findServiceProviders(final TypeDescriptor $reified$Service, ClassOrInterface<? extends Service> service) {
        Class<?> klass = Metamodel.getJavaClass(((ClassOrInterfaceDeclarationImpl)service.getDeclaration()).declaration);
        ServiceLoader<?> moduleServices = ServiceLoader.load(klass, Metamodel.getJavaClass(this.declaration).getClassLoader());
        ServiceLoader<?> extensionServices = ServiceLoader.loadInstalled(klass);
        class It
        extends BaseIterable<Service, Object> {
            private final ServiceLoader<Service> sl;

            public It(ServiceLoader<Service> sl) {
                super(var3_3, Null.$TypeDescriptor$);
                this.sl = sl;
            }

            @Override
            public ceylon.language.Iterator<? extends Service> iterator() {
                return new BaseIterator<Service>($reified$Service){
                    Iterator<Service> it;
                    {
                        this.it = sl.iterator();
                    }

                    @Override
                    public Object next() {
                        if (this.it.hasNext()) {
                            return this.it.next();
                        }
                        return finished_.get_();
                    }
                };
            }
        }
        Iterable services = new It(moduleServices).chain($reified$Service, Null.$TypeDescriptor$, new It(extensionServices));
        return services.filter((Callable<Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.klass(Tuple.class, $reified$Service, $reified$Service, Empty.$TypeDescriptor$), "Boolean(Service)", -1){

            @Override
            public Boolean $call$(Object arg0) {
                Object service = arg0;
                return Boolean.instance(type_.type(null, service).subtypeOf(Metamodel.getAppliedMetamodel($reified$Service)));
            }
        });
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.getName().hashCode();
        String version2 = this.getVersion();
        result = 37 * result + (version2 == null ? 0 : version2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ceylon.language.meta.declaration.Module)) {
            return false;
        }
        ceylon.language.meta.declaration.Module other = (ceylon.language.meta.declaration.Module)obj;
        if (!Util.eq(other.getVersion(), this.getVersion())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return "module " + this.getName() + "/" + this.getVersion();
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

