/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilerOptions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class JavaCompilerOptions
extends CompilerOptions {
    private boolean flatClasspath;
    private boolean autoExportMavenDependencies;
    private boolean fullyExportMavenDependencies;
    private String jdkProvider;
    private List<String> aptModules = new LinkedList<String>();
    private List<String> javacOptions = new LinkedList<String>();
    private long javacTarget;
    private boolean noOsgi;
    private String osgiProvidedBundles;
    private boolean noPom;
    private boolean pack200;
    private boolean jigsaw;
    private boolean ee;
    private List<String> eeImport;
    private List<String> eeAnnotation;

    public boolean isFlatClasspath() {
        return this.flatClasspath;
    }

    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    public boolean isAutoExportMavenDependencies() {
        return this.autoExportMavenDependencies;
    }

    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    public boolean isFullyExportMavenDependencies() {
        return this.fullyExportMavenDependencies;
    }

    public void setFullyExportMavenDependencies(boolean fullyExportMavenDependencies) {
        this.fullyExportMavenDependencies = fullyExportMavenDependencies;
    }

    public String getJdkProvider() {
        return this.jdkProvider;
    }

    public void setJdkProvider(String jdkProvider) {
        this.jdkProvider = jdkProvider;
    }

    public List<String> getAptModules() {
        return this.aptModules;
    }

    public void setAptModules(List<String> aptModules) {
        this.aptModules = aptModules;
    }

    public List<String> getJavacOptions() {
        return this.javacOptions;
    }

    public void setJavacOptions(List<String> javacOptions) {
        this.javacOptions = javacOptions;
    }

    public long getJavacTarget() {
        return this.javacTarget;
    }

    public void setJavacTarget(long javacTarget) {
        this.javacTarget = javacTarget;
    }

    public boolean isNoOsgi() {
        return this.noOsgi;
    }

    public void setNoOsgi(boolean noOsgi) {
        this.noOsgi = noOsgi;
    }

    public String getOsgiProvidedBundles() {
        return this.osgiProvidedBundles;
    }

    public void setOsgiProvidedBundles(String osgiProvidedBundles) {
        this.osgiProvidedBundles = osgiProvidedBundles;
    }

    public boolean isNoPom() {
        return this.noPom;
    }

    public void setNoPom(boolean noPom) {
        this.noPom = noPom;
    }

    public boolean isPack200() {
        return this.pack200;
    }

    public void setPack200(boolean pack200) {
        this.pack200 = pack200;
    }

    public boolean isGenerateModuleInfo() {
        return this.jigsaw;
    }

    public void setGenerateModuleInfo(boolean jigsaw) {
        this.jigsaw = jigsaw;
    }

    public boolean isEe() {
        return this.ee;
    }

    public void setEe(boolean ee) {
        this.ee = ee;
    }

    public List<String> getEeImport() {
        return this.eeImport;
    }

    public void setEeImport(List<String> eeImport) {
        this.eeImport = eeImport;
    }

    public List<String> getEeAnnotation() {
        return this.eeAnnotation;
    }

    public void setEeAnnotation(List<String> eeAnnotation) {
        this.eeAnnotation = eeAnnotation;
    }

    @Override
    public void mapOptions(CeylonConfig config) {
        super.mapOptions(config);
        this.setModules(DefaultToolOptions.getCompilerModules(config, Backend.Java));
        this.setFlatClasspath(DefaultToolOptions.getDefaultFlatClasspath(config));
        this.setAutoExportMavenDependencies(DefaultToolOptions.getDefaultAutoExportMavenDependencies(config));
        this.setFullyExportMavenDependencies(DefaultToolOptions.getDefaultFullyExportMavenDependencies(config));
        this.setNoOsgi(DefaultToolOptions.getCompilerNoOsgi(config));
        this.setOsgiProvidedBundles(DefaultToolOptions.getCompilerOsgiProvidedBundles(config));
        this.setNoPom(DefaultToolOptions.getCompilerNoPom(config));
        this.setGenerateModuleInfo(DefaultToolOptions.getCompilerGenerateModuleInfo(config));
        this.setPack200(DefaultToolOptions.getCompilerPack200(config));
        this.setJdkProvider(DefaultToolOptions.getCompilerJdkProvider(config));
        String[] aptModules = DefaultToolOptions.getCompilerAptModules(config);
        if (aptModules != null) {
            this.setAptModules(Arrays.asList(aptModules));
        }
        this.setJavacTarget(DefaultToolOptions.getCompilerTargetVersion());
        this.setJavacOptions(DefaultToolOptions.getCompilerJavac(config));
        this.setEe(DefaultToolOptions.getCompilerEe(config));
        this.setEeImport(DefaultToolOptions.getCompilerEeImport(config));
        this.setEeAnnotation(DefaultToolOptions.getCompilerEeAnnotation(config));
    }

    public static JavaCompilerOptions fromConfig() {
        return JavaCompilerOptions.fromConfig(CeylonConfig.get());
    }

    public static JavaCompilerOptions fromConfig(CeylonConfig config) {
        JavaCompilerOptions options = new JavaCompilerOptions();
        options.mapOptions(config);
        return options;
    }
}

