/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.tools.impl;

import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.java.runtime.tools.Runner;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import com.redhat.ceylon.compiler.js.CeylonRunJsTool;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaScriptRunnerImpl
implements Runner {
    private CeylonRunJsTool tool;
    private String moduleSpec;

    public JavaScriptRunnerImpl(final RunnerOptions options, String module, String version2) {
        this.tool = new CeylonRunJsTool(){

            @Override
            protected void customizeDependencies(List<File> localRepos, RepositoryManager repoman, Set<String> loadedDependencies) throws IOException {
                for (Map.Entry<String, String> extraModule : options.getExtraModules().entrySet()) {
                    String modName = extraModule.getKey();
                    String modVersion = extraModule.getValue();
                    File artifact = this.getArtifact(repoman, modName, modVersion, true);
                    localRepos.add(this.getRepoDir(modName, artifact));
                    this.loadDependencies(localRepos, repoman, artifact, loadedDependencies);
                }
            }
        };
        if (options.getWorkingDirectory() != null) {
            this.tool.setCwd(new File(options.getWorkingDirectory()));
        }
        this.moduleSpec = ModuleUtil.makeModuleName(module, version2);
        this.tool.setThrowOnError(true);
        this.tool.setModuleVersion(this.moduleSpec);
        try {
            this.tool.setRepositoryAsStrings(options.getUserRepositories());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tool.setNoDefRepos(options.isNoDefaultRepositories());
        this.tool.setSystemRepository(options.getSystemRepository());
        this.tool.setOffline(options.isOffline());
        this.tool.setTimeout(options.getTimeout());
        if (options.getRun() != null) {
            this.tool.setRun(options.getRun());
        }
        if (options.isVerbose()) {
            this.tool.setVerbose(options.getVerboseCategory());
        }
    }

    @Override
    public void run(String ... arguments) {
        try {
            this.tool.setArgs(Arrays.asList(arguments));
            this.tool.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during run of " + this.moduleSpec, e);
        }
    }

    @Override
    public void cleanup() {
    }
}

