/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.tools;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.java.loader.CeylonModelLoader;
import com.redhat.ceylon.compiler.java.tools.CeylonLocation;
import com.redhat.ceylon.compiler.java.tools.CeylonTaskListener;
import com.redhat.ceylon.compiler.java.tools.CeyloncFileManager;
import com.redhat.ceylon.compiler.java.tools.JarEntryFileObject;
import com.redhat.ceylon.compiler.java.tools.JarEntryManifestFileObject;
import com.redhat.ceylon.compiler.java.tools.Java9Util;
import com.redhat.ceylon.compiler.java.tools.JavacLogger;
import com.redhat.ceylon.compiler.java.tools.MavenPomUtil;
import com.redhat.ceylon.compiler.java.tools.MetaInfServices;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.javax.tools.StandardLocation;
import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.source.util.TaskListener;
import com.redhat.ceylon.langtools.tools.javac.api.MultiTaskListener;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.ClassFileUtil;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.OsgiUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarOutputRepositoryManager {
    private Map<Module, ProgressiveJar> openJars = new HashMap<Module, ProgressiveJar>();
    private Log log;
    private Options options;
    private CeyloncFileManager ceyloncFileManager;
    private MultiTaskListener taskListener;
    private boolean aptRound;

    JarOutputRepositoryManager(Log log, Options options, CeyloncFileManager ceyloncFileManager, MultiTaskListener taskListener) {
        this.log = log;
        this.options = options;
        this.ceyloncFileManager = ceyloncFileManager;
        this.taskListener = taskListener;
    }

    public JavaFileObject getFileObject(RepositoryManager repositoryManager, Module module, String fileName, File sourceFile) throws IOException {
        ProgressiveJar progressiveJar = this.getProgressiveJar(repositoryManager, module);
        return progressiveJar.getJavaFileObject(fileName, sourceFile);
    }

    private ProgressiveJar getProgressiveJar(RepositoryManager repositoryManager, Module module) throws IOException {
        ProgressiveJar jarFile = this.openJars.get(module);
        if (jarFile == null) {
            jarFile = new ProgressiveJar(repositoryManager, module, this.log, this.options, this.ceyloncFileManager, this.taskListener, this.aptRound);
            this.openJars.put(module, jarFile);
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Exception ex = null;
        try {
            for (ProgressiveJar jarFile : this.openJars.values()) {
                try {
                    jarFile.close();
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        finally {
            this.openJars.clear();
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    public void setAptRound(boolean b) {
        this.aptRound = b;
        for (ProgressiveJar jar : this.openJars.values()) {
            jar.validModule = b;
        }
    }

    static class ProgressiveJar {
        private static final String META_INF = "META-INF";
        private static final String FILE_MAPPING = "META-INF/mapping.txt";
        private static final String FILE_ERRORS = "META-INF/errors.txt";
        private static final String FILE_HASHES = "META-INF/hashes.txt";
        private static final String QUOTED_MODULE_DESCRIPTOR = "$module_.class";
        private static final String ANNOTATION_COMPILE_ERROR = "com.redhat.ceylon.compiler.java.metadata.CompileTimeError";
        private File originalJarFile;
        private File outputJarTempFolder;
        private final Set<String> modifiedSourceFiles = new HashSet<String>();
        private final Set<String> modifiedResourceFilesRel = new HashSet<String>();
        private final Set<String> modifiedResourceFilesFull = new HashSet<String>();
        private final Properties writtenClassesMapping = new Properties();
        private final Properties entrySourceMapping = new Properties();
        private Logger cmrLog;
        private Options options;
        private RepositoryManager repoManager;
        private ArtifactContext carContext;
        private ArtifactCreator srcCreator;
        private ArtifactCreator resourceCreator;
        private Module module;
        private boolean writeOsgiManifest;
        private String osgiProvidedBundles;
        private final String resourceRootPath;
        private boolean writeMavenManifest;
        private boolean writeJava9Module;
        private MultiTaskListener taskListener;
        private JarEntryManifestFileObject manifest;
        private Log log;
        private JdkProvider jdkProvider;
        private Map<ClassOrInterface, Set<Class>> services;
        private boolean validModule;

        public ProgressiveJar(RepositoryManager repoManager, Module module, Log log, Options options, CeyloncFileManager ceyloncFileManager, MultiTaskListener taskListener, boolean aptRound) throws IOException {
            String rootName;
            this.options = options;
            this.repoManager = repoManager;
            this.carContext = new ArtifactContext(null, module.getNameAsString(), module.getVersion(), ".car");
            this.log = log;
            this.cmrLog = new JavacLogger(options, Log.instance(ceyloncFileManager.getContext()));
            AbstractModelLoader modelLoader = CeylonModelLoader.instance(ceyloncFileManager.getContext());
            this.jdkProvider = modelLoader.getJdkProvider();
            this.srcCreator = CeylonUtils.makeSourceArtifactCreator(repoManager, ceyloncFileManager.getLocation(StandardLocation.SOURCE_PATH), module.getNameAsString(), module.getVersion(), options.get(Option.VERBOSE) != null, this.cmrLog);
            this.resourceCreator = CeylonUtils.makeResourceArtifactCreator(repoManager, ceyloncFileManager.getLocation(StandardLocation.SOURCE_PATH), ceyloncFileManager.getLocation(CeylonLocation.RESOURCE_PATH), options.get(Option.CEYLONRESOURCEROOT), module.getNameAsString(), module.getVersion(), options.get(Option.VERBOSE) != null, this.cmrLog);
            this.module = module;
            this.writeOsgiManifest = !options.isSet(Option.CEYLONNOOSGI);
            this.osgiProvidedBundles = options.get(Option.CEYLONOSGIPROVIDEDBUNDLES);
            this.writeMavenManifest = !options.isSet(Option.CEYLONNOPOM) && !module.isDefaultModule();
            this.writeJava9Module = options.isSet(Option.CEYLONJIGSAW) && !module.isDefaultModule();
            this.services = module.getServices();
            String rrp = module.getNameAsString().replace('.', '/');
            if (!rrp.isEmpty() && !rrp.endsWith("/")) {
                rrp = rrp + "/";
            }
            if ((rootName = options.get(Option.CEYLONRESOURCEROOT)) == null) {
                rootName = "ROOT";
            }
            this.resourceRootPath = rrp + rootName + "/";
            this.taskListener = taskListener;
            this.originalJarFile = repoManager.getArtifact(this.carContext);
            this.outputJarTempFolder = FileUtil.makeTempDir("ceylon-compiler-");
            this.validModule = module.isDefaultModule() || aptRound;
        }

        private Map<String, Set<String>> getPreviousServices() throws IOException {
            Map<String, Set<String>> result = this.originalJarFile != null ? MetaInfServices.parseAllServices(this.originalJarFile) : new HashMap<String, Set<String>>(0);
            return result;
        }

        private Properties getPreviousMapping() throws IOException {
            return JarUtils.getMetaInfProperties(this.originalJarFile, FILE_MAPPING);
        }

        private Properties getPreviousErrors() throws IOException {
            return JarUtils.getMetaInfProperties(this.originalJarFile, FILE_ERRORS);
        }

        private Properties getPreviousHashes() throws IOException {
            return JarUtils.getMetaInfProperties(this.originalJarFile, FILE_HASHES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest getPreviousManifest() throws IOException {
            JarFile jarFile = JarUtils.validJar(this.originalJarFile);
            if (jarFile != null) {
                try {
                    Manifest manifest = jarFile.getManifest();
                    return manifest;
                }
                finally {
                    jarFile.close();
                }
            }
            return null;
        }

        public void close() throws IOException {
            try {
                Set<String> copiedSourceFiles = this.srcCreator.copy(this.modifiedSourceFiles);
                this.resourceCreator.copy(this.modifiedResourceFilesFull);
                Manifest manifestObject = null;
                if (this.writeOsgiManifest && this.manifest == null) {
                    manifestObject = (this.module.isDefaultModule() ? new OsgiUtil.DefaultModuleManifest() : new OsgiUtil.OsgiManifest(this.module, this.jdkProvider, this.osgiProvidedBundles, this.getPreviousManifest(), null)).build();
                } else if (this.manifest != null && !this.module.isDefaultModule()) {
                    manifestObject = this.manifest.writeManifest(new JavacLogger(this.options, this.log));
                }
                if (this.writeMavenManifest) {
                    this.writeMavenManifest(this.outputJarTempFolder, this.module);
                }
                if (this.writeJava9Module && !this.module.isDefaultModule()) {
                    this.writeJava9Module(this.outputJarTempFolder, this.module);
                }
                Properties previousMapping = this.getPreviousMapping();
                JarUtils.JarEntryFilter jarFilter = this.getJarFilter(previousMapping, copiedSourceFiles);
                this.writeMappingJarEntry(this.outputJarTempFolder, previousMapping, jarFilter);
                this.writeServicesJarEntry(this.outputJarTempFolder);
                this.writeErrorsJarEntry(this.outputJarTempFolder, copiedSourceFiles);
                this.writeHashesJarEntry(this.outputJarTempFolder);
                if (this.originalJarFile != null && JarUtils.isValidJar(this.originalJarFile)) {
                    this.addOriginalJarFiles(this.outputJarTempFolder, this.originalJarFile, jarFilter);
                }
                if (this.validModule) {
                    File finalCarFile = IOUtils.zipFolder(manifestObject, this.outputJarTempFolder);
                    if (this.options.isSet(Option.CEYLONPACK200)) {
                        JarUtils.repack(finalCarFile, this.cmrLog);
                    }
                    File sha1File = ShaSigner.sign(finalCarFile, this.cmrLog, this.options.get(Option.VERBOSE) != null);
                    JarUtils.publish(finalCarFile, sha1File, this.carContext, this.repoManager, this.cmrLog);
                    String info = this.module.isDefaultModule() ? this.module.getNameAsString() : this.module.getNameAsString() + "/" + this.module.getVersion();
                    this.cmrLog.info("Created module " + info);
                    if (this.taskListener != null) {
                        for (TaskListener listener : this.taskListener.getTaskListeners()) {
                            if (!(listener instanceof CeylonTaskListener)) continue;
                            ((CeylonTaskListener)listener).moduleCompiled(this.module.getNameAsString(), this.module.getVersion());
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                FileUtil.deleteQuietly(this.outputJarTempFolder);
            }
        }

        private void addOriginalJarFiles(File outputJarTempFolder, File originalJarFile, JarUtils.JarEntryFilter filter) throws IOException {
            try (JarFile j = new JarFile(originalJarFile);){
                Enumeration<JarEntry> inEntries = j.entries();
                while (inEntries.hasMoreElements()) {
                    File targetFile;
                    JarEntry entry = inEntries.nextElement();
                    String name = entry.getName();
                    if (name.equals(QUOTED_MODULE_DESCRIPTOR) || name.endsWith("/$module_.class")) {
                        this.validModule = true;
                    }
                    if (filter != null && filter.avoid(name) || (targetFile = new File(outputJarTempFolder, name)).exists()) continue;
                    if (entry.isDirectory()) {
                        FileUtil.mkdirs(targetFile);
                        continue;
                    }
                    FileUtil.mkdirs(targetFile.getParentFile());
                    InputStream in = j.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        FileOutputStream out = new FileOutputStream(targetFile);
                        Throwable throwable2 = null;
                        try {
                            JarUtils.copy(in, out);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                                continue;
                            }
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
        }

        private JarUtils.JarEntryFilter getJarFilter(final Properties previousMapping, final Set<String> copiedSourceFiles) {
            return new JarUtils.JarEntryFilter(){

                @Override
                public boolean avoid(String entryFullName) {
                    if (entryFullName.endsWith(".class")) {
                        boolean classWasUpdated = ProgressiveJar.this.writtenClassesMapping.containsKey(entryFullName);
                        if (previousMapping != null) {
                            String sourceFileForClass = previousMapping.getProperty(entryFullName);
                            classWasUpdated = classWasUpdated || copiedSourceFiles.contains(sourceFileForClass);
                        }
                        return classWasUpdated;
                    }
                    return ProgressiveJar.this.modifiedResourceFilesRel.contains(entryFullName) || entryFullName.equals(ProgressiveJar.FILE_MAPPING) || entryFullName.equals(ProgressiveJar.FILE_ERRORS) || entryFullName.equals(ProgressiveJar.FILE_HASHES) || ProgressiveJar.this.writeOsgiManifest && OsgiUtil.OsgiManifest.isManifestFileName(entryFullName) || ProgressiveJar.this.writeMavenManifest && MavenPomUtil.isMavenDescriptor(entryFullName, ProgressiveJar.this.module);
                }
            };
        }

        private void writeMavenManifest(File outputFolder, Module module) {
            MavenPomUtil.writeMavenManifest2(outputFolder, module, this.jdkProvider);
        }

        private void writeJava9Module(File outputFolder, Module module) {
            Java9Util.writeModuleDescriptor(outputFolder, new Java9Util.Java9ModuleDescriptor(module));
        }

        private void writeServicesJarEntry(File outputFolder) throws IOException {
            HashMap compiledServices = new HashMap(this.services.size());
            for (Map.Entry<ClassOrInterface, Set<Class>> entry : this.services.entrySet()) {
                ClassOrInterface service = entry.getKey();
                Set<Class> impls = entry.getValue();
                HashSet<String> implNames = new HashSet<String>(impls.size());
                for (Class impl2 : impls) {
                    implNames.add(JVMModuleUtil.quoteJavaKeywords(impl2.getQualifiedNameString().replace("::", ".")));
                }
                compiledServices.put(JVMModuleUtil.quoteJavaKeywords(service.getQualifiedNameString().replace("::", ".")), implNames);
            }
            Map<String, Set<String>> previousServices = this.getPreviousServices();
            for (Map.Entry e : compiledServices.entrySet()) {
                Set<String> set = previousServices.get(e.getKey());
                if (set == null) {
                    previousServices.put((String)e.getKey(), (Set<String>)e.getValue());
                    continue;
                }
                set.addAll((Collection)e.getValue());
            }
            FileUtil.mkdirs(new File(outputFolder, "META-INF/services/"));
            MetaInfServices.writeAllServices(outputFolder, previousServices);
        }

        private void writeMappingJarEntry(File outputFolder, Properties previousMapping, JarUtils.JarEntryFilter filter) {
            Properties newMapping = new Properties();
            newMapping.putAll((Map<?, ?>)this.writtenClassesMapping);
            if (previousMapping != null) {
                for (String classFullName : previousMapping.stringPropertyNames()) {
                    if (filter.avoid(classFullName)) continue;
                    newMapping.setProperty(classFullName, previousMapping.getProperty(classFullName));
                }
            }
            FileUtil.mkdirs(new File(outputFolder, META_INF));
            try (FileOutputStream os = new FileOutputStream(new File(outputFolder, FILE_MAPPING));){
                newMapping.store(os, "List of all class files and their originating source files");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void writeErrorsJarEntry(File outputFolder, Set<String> copiedSourceFiles) throws IOException {
            Properties newErrors = new Properties();
            for (String classFullName : this.writtenClassesMapping.stringPropertyNames()) {
                if (!this.hasErrors(new File(outputFolder, classFullName))) continue;
                String sourceFile = this.writtenClassesMapping.getProperty(classFullName);
                newErrors.setProperty(classFullName, sourceFile);
            }
            Properties previousErrors = this.getPreviousErrors();
            if (previousErrors != null) {
                for (String classFullName : previousErrors.stringPropertyNames()) {
                    String sourceFile = previousErrors.getProperty(classFullName);
                    if (copiedSourceFiles.contains(sourceFile)) continue;
                    newErrors.setProperty(classFullName, sourceFile);
                }
            }
            FileUtil.mkdirs(new File(outputFolder, META_INF));
            try (FileOutputStream os = new FileOutputStream(new File(outputFolder, FILE_ERRORS));){
                newErrors.store(os, "List of class files that have compile errors");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasErrors(File classFile) {
            try (FileInputStream stream = new FileInputStream(classFile);){
                ClassFile cls = ClassFile.read(stream);
                Annotation annot = ClassFileUtil.findAnnotation(cls, ANNOTATION_COMPILE_ERROR);
                boolean bl = annot != null;
                return bl;
            }
            catch (ConstantPoolException e) {
                return true;
            }
            catch (IOException e) {
                return true;
            }
        }

        private void writeHashesJarEntry(File outputFolder) throws IOException {
            Properties newHashes = new Properties();
            for (String entryName : this.entrySourceMapping.stringPropertyNames()) {
                File file = new File(this.entrySourceMapping.getProperty(entryName));
                newHashes.setProperty(entryName, ShaSigner.sha1(file));
            }
            Properties previousHashes = this.getPreviousHashes();
            if (previousHashes != null) {
                for (String inputFile : previousHashes.stringPropertyNames()) {
                    if (this.entrySourceMapping.keySet().contains(inputFile)) continue;
                    String hash = previousHashes.getProperty(inputFile);
                    newHashes.setProperty(inputFile, hash);
                }
            }
            FileUtil.mkdirs(new File(outputFolder, META_INF));
            try (FileOutputStream os = new FileOutputStream(new File(outputFolder, FILE_HASHES));){
                newHashes.store(os, "List of input (re)source files and their SHA1 hashes");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public JavaFileObject getJavaFileObject(String fileName, File sourceFile) {
            String quotedFileName = JVMModuleUtil.quoteJavaKeywordsInFilename(fileName);
            String entryName = this.handleResourceRoot(quotedFileName.replace(File.separatorChar, '/'));
            if (sourceFile != null) {
                this.modifiedSourceFiles.add(sourceFile.getPath());
                String sourcePath = JarUtils.toPlatformIndependentPath(this.srcCreator.getPaths(), sourceFile.getPath());
                this.writtenClassesMapping.put(entryName, sourcePath);
                this.entrySourceMapping.put(sourcePath, sourceFile.getPath());
                if ("module.ceylon".equals(sourceFile.getName())) {
                    this.validModule = true;
                }
            } else {
                this.modifiedResourceFilesRel.add(entryName);
                File full = FileUtil.applyPath(this.resourceCreator.getPaths(), fileName);
                if (full != null) {
                    this.modifiedResourceFilesFull.add(full.getPath());
                    String resourcePath = JarUtils.toPlatformIndependentPath(this.resourceCreator.getPaths(), full.getPath());
                    this.entrySourceMapping.put(this.handleResourceRoot(resourcePath), full.getPath());
                }
                if (OsgiUtil.CeylonManifest.isManifestFileName(entryName) && (this.module.isDefaultModule() || this.writeOsgiManifest)) {
                    this.manifest = new JarEntryManifestFileObject(this.outputJarTempFolder, entryName, this.module, this.osgiProvidedBundles, this.jdkProvider);
                    return this.manifest;
                }
            }
            return new JarEntryFileObject(this.outputJarTempFolder, entryName);
        }

        private String handleResourceRoot(String entryName) {
            if (!this.resourceRootPath.isEmpty() && entryName.startsWith(this.resourceRootPath)) {
                entryName = entryName.substring(this.resourceRootPath.length());
            }
            return entryName;
        }
    }
}

