/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.wrapping;

import ceylon.language.Collection;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.wrapping.WrappedCeylonIterator;
import com.redhat.ceylon.compiler.java.wrapping.Wrapping;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;

class WrappedCeylonSet<In, Out>
extends AbstractSet<Out>
implements Serializable {
    private static final long serialVersionUID = 1800969777619067034L;
    private final Collection<In> cSet;
    private final Wrapping<In, Out> elementWrapping;

    public WrappedCeylonSet(Collection<In> cSet, Wrapping<In, Out> elementWrapping) {
        this.cSet = cSet;
        this.elementWrapping = elementWrapping;
    }

    @Override
    public Iterator<Out> iterator() {
        return new WrappedCeylonIterator<Out, In>(this.cSet, this.elementWrapping);
    }

    @Override
    public int size() {
        return Util.toInt(this.cSet.getSize());
    }

    @Override
    public boolean contains(Object element) {
        Wrapping<Out, In> rev = this.elementWrapping.inverted();
        if (rev != null) {
            return this.cSet.contains((Object)rev.wrap(element));
        }
        return super.contains(element);
    }

    Collection<In> unwrap() {
        return this.cSet;
    }
}

