/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.AbstractTestTool;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.compiler.js.CeylonRunJsMessages;
import com.redhat.ceylon.compiler.js.CeylonRunJsTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Summary(value="Executes tests on Node.js")
@Description(value="Executes tests in specified `<modules>`. The `<modules>` arguments are the names of the modules to test with an optional version.")
@RemainingSections(value="## Compile flags\n\nThe `--compile` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n\n\n## Configuration file\n\nThe test-js tool accepts the following option from the Ceylon configuration file: `testtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute tests in the `com.example.foobar` module:\n\n    ceylon test-js com.example.foobar/1.0.0")
public class CeylonTestJsTool
extends AbstractTestTool {
    private static final String COLOR_RESET = "com.redhat.ceylon.common.tool.terminal.color.reset";
    private static final String COLOR_GREEN = "com.redhat.ceylon.common.tool.terminal.color.green";
    private static final String COLOR_RED = "com.redhat.ceylon.common.tool.terminal.color.red";
    private String nodeExe;
    private boolean debug = true;
    private CeylonRunJsTool ceylonRunJsTool;

    public CeylonTestJsTool() {
        super(CeylonRunJsMessages.RESOURCE_BUNDLE, ModuleQuery.Type.JS, null, null, 10, 0);
    }

    @OptionArgument(argumentName="node-exe")
    @Description(value="The path to the node.js executable. Will be searched in standard locations if not specified.")
    public void setNodeExe(String nodeExe) {
        this.nodeExe = nodeExe;
    }

    @OptionArgument(argumentName="debug")
    @Description(value="Shows more detailed output in case of errors.")
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
        ArrayList<String> args = new ArrayList<String>();
        final ArrayList<String> moduleAndVersionList = new ArrayList<String>();
        this.processModuleNameOptVersionList(args, moduleAndVersionList);
        this.processTestList(args);
        this.processTagList(args);
        this.processArgumentList(args);
        this.compileFlags = this.processCompileFlags(this.compileFlags, DefaultToolOptions.getTestToolCompileFlags(Backend.JavaScript));
        this.processTapOption(args);
        this.processReportOption(args);
        this.processColors(args);
        this.resolveVersion(moduleAndVersionList);
        this.ceylonRunJsTool = new CeylonRunJsTool(){

            @Override
            protected void customizeDependencies(List<File> localRepos, RepositoryManager repoman, Set<String> loadedDependencies) throws IOException {
                for (String moduleAndVersion : moduleAndVersionList) {
                    String modName = ModuleUtil.moduleName(moduleAndVersion);
                    String modVersion = ModuleUtil.moduleVersion(moduleAndVersion);
                    File artifact = this.getArtifact(repoman, modName, modVersion, true);
                    localRepos.add(this.getRepoDir(modName, artifact));
                    this.loadDependencies(localRepos, repoman, artifact, loadedDependencies);
                }
            }
        };
        this.ceylonRunJsTool.setModuleVersion("ceylon.test/" + this.version);
        this.ceylonRunJsTool.setRun("ceylon.test::runTestTool");
        this.ceylonRunJsTool.setArgs(args);
        this.ceylonRunJsTool.setRepository(this.repos);
        this.ceylonRunJsTool.setSystemRepository(this.systemRepo);
        this.ceylonRunJsTool.setCacheRepository(this.cacheRepo);
        this.ceylonRunJsTool.setOverrides(this.overrides);
        this.ceylonRunJsTool.setNoDefRepos(this.noDefRepos);
        this.ceylonRunJsTool.setOffline(this.offline);
        this.ceylonRunJsTool.setVerbose(this.verbose);
        this.ceylonRunJsTool.setNodeExe(this.nodeExe);
        this.ceylonRunJsTool.setDebug(this.debug);
        this.ceylonRunJsTool.setCompile(this.compileFlags);
        this.ceylonRunJsTool.setCwd(this.cwd);
    }

    @Override
    public void run() throws Exception {
        this.ceylonRunJsTool.run();
    }

    private void processColors(List<String> args) {
        String reset = OSUtil.Color.reset.escape();
        String green = OSUtil.Color.green.escape();
        String red = OSUtil.Color.red.escape();
        if (reset != null && green != null && red != null) {
            args.add("--com.redhat.ceylon.common.tool.terminal.color.reset");
            args.add(reset);
            args.add("--com.redhat.ceylon.common.tool.terminal.color.green");
            args.add(green);
            args.add("--com.redhat.ceylon.common.tool.terminal.color.red");
            args.add(red);
        }
    }
}

