/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.compiler.js.CompilerErrorException;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;

public class ReturnConstructorVisitor
extends Visitor {
    private final Tree.Declaration node;
    private final Constructor d;
    private boolean ret;

    public ReturnConstructorVisitor(Tree.Declaration constructorNode) {
        Tree.Block block;
        this.node = constructorNode;
        if (constructorNode instanceof Tree.Constructor) {
            this.d = ((Tree.Constructor)this.node).getConstructor();
            block = ((Tree.Constructor)this.node).getBlock();
        } else if (constructorNode instanceof Tree.Enumerated) {
            this.d = ((Tree.Enumerated)this.node).getEnumerated();
            block = ((Tree.Enumerated)this.node).getBlock();
        } else {
            throw new CompilerErrorException("Bug in the JS compiler. A ReturnConstructorVisitor must be created with an Enumerated or Constructor node.");
        }
        block.visit(this);
    }

    @Override
    public void visit(Tree.Return that) {
        if (that.getExpression() == null && !this.ret && this.d == ModelUtil.getContainingDeclarationOfScope(that.getScope())) {
            this.ret = true;
        }
    }

    public boolean isReturns() {
        return this.ret;
    }
}

