/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js;

import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.EnumUtil;
import com.redhat.ceylon.compiler.js.ErrorCollectingVisitor;
import com.redhat.ceylon.compiler.js.JsCompiler;
import com.redhat.ceylon.compiler.js.loader.MetamodelVisitor;
import com.redhat.ceylon.compiler.js.loader.ModelEncoder;
import com.redhat.ceylon.compiler.js.util.JsIdentifierNames;
import com.redhat.ceylon.compiler.js.util.JsJULLogger;
import com.redhat.ceylon.compiler.js.util.JsOutput;
import com.redhat.ceylon.compiler.js.util.NpmDescriptorGenerator;
import com.redhat.ceylon.compiler.js.util.Options;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.TypeCheckerBuilder;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Stitcher {
    private static TypeCheckerBuilder langmodtc;
    private static Path tmpDir;
    private static final File baseDir;
    private static final File clSrcDir;
    private static final File clSrcFileDir;
    public static final File LANGMOD_JS_SRC;
    private static final File clJsFileDir;
    private static JsIdentifierNames names;
    private static Module mod;
    private static final HashSet<File> compiledFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int compileLanguageModule(String line, JsOutput writer) throws IOException {
        File compsrc;
        File clsrcTmpDir = Files.createTempDirectory(tmpDir, "clsrc", new FileAttribute[0]).toFile();
        File tmpout = new File(clsrcTmpDir, "modules");
        FileUtil.mkdirs(tmpout);
        Options opts = new Options().addRepo("build/runtime").comment(false).optimize(true).outRepo(tmpout.getAbsolutePath()).modulify(false).minify(true).suppressWarnings(EnumUtil.enumsFromStrings(Warning.class, Arrays.asList("unusedDeclaration", "ceylonNamespace", "unusedImport"))).addSrcDir(clSrcDir).addSrcDir(LANGMOD_JS_SRC);
        if (langmodtc == null) {
            langmodtc = new TypeCheckerBuilder().addSrcDirectory(clSrcDir).addSrcDirectory(LANGMOD_JS_SRC).encoding("UTF-8");
            langmodtc.setRepositoryManager(CeylonUtils.repoManager().systemRepo(opts.getSystemRepo()).userRepos(opts.getRepos()).outRepo(opts.getOutRepo()).buildManager());
            langmodtc.usageWarnings(false);
        }
        TypeChecker tc = langmodtc.getTypeChecker();
        tc.process(true);
        if (tc.getErrors() > 0) {
            return 1;
        }
        ArrayList<File> includes = new ArrayList<File>();
        for (String filename : line.split(",")) {
            File src2;
            File src;
            boolean exclude;
            filename = filename.trim();
            boolean isJsSrc = filename.endsWith(".js");
            boolean isDir = filename.endsWith("/");
            boolean bl = exclude = filename.charAt(0) == '-';
            if (exclude) {
                filename = filename.substring(1);
            }
            File file = ".".equals(filename) ? clSrcFileDir : (src = new File(isJsSrc ? LANGMOD_JS_SRC : clSrcFileDir, isJsSrc || isDir ? filename : String.format("%s.ceylon", filename)));
            if (Stitcher.addFiles(includes, src, exclude) || Stitcher.addFiles(includes, src2 = new File(clJsFileDir, isDir ? filename : String.format("%s.ceylon", filename)), exclude)) continue;
            throw new IllegalArgumentException("Invalid Ceylon language module source " + src + " or " + src2);
        }
        if (includes.isEmpty()) {
            return 0;
        }
        JsCompiler jsc = new JsCompiler(tc, opts, true).stopOnErrors(false).setSourceFiles(includes);
        if (!jsc.generate()) {
            jsc.printErrorsAndCount(new OutputStreamWriter(System.out));
            return 1;
        }
        jsc.printErrorsAndCount(new OutputStreamWriter(System.out));
        if (names == null) {
            names = jsc.getNames();
        }
        if ((compsrc = new File(tmpout, "delete/me/delete-me.js")).exists() && compsrc.isFile() && compsrc.canRead()) {
            try {
                writer.outputFile(compsrc);
            }
            finally {
                compsrc.delete();
            }
        } else {
            System.out.println("Can't find generated js for language module in " + compsrc.getAbsolutePath());
            return 1;
        }
        return 0;
    }

    private static boolean addFiles(List<File> includes, File src, boolean exclude) {
        if (src.exists() && src.isFile() && src.canRead()) {
            if (exclude) {
                System.out.println("EXCLUDING " + src);
                compiledFiles.add(src);
            } else if (!compiledFiles.contains(src)) {
                includes.add(src);
                compiledFiles.add(src);
            }
        } else if (src.exists() && src.isDirectory()) {
            List<File> subs = Arrays.asList(src.listFiles());
            Collections.sort(subs);
            for (File sub : subs) {
                if (compiledFiles.contains(sub)) continue;
                includes.add(sub);
                compiledFiles.add(sub);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int encodeModel(File moduleFile) throws IOException {
        String name = moduleFile.getName();
        File file = new File(moduleFile.getParentFile(), name.substring(0, name.length() - 3) + "-model.js");
        System.out.println("Generating language module compile-time model in JSON...");
        TypeCheckerBuilder tcb = new TypeCheckerBuilder().usageWarnings(false);
        tcb.addSrcDirectory(clSrcDir);
        TypeChecker tc = tcb.getTypeChecker();
        tc.process(true);
        MetamodelVisitor mmg = null;
        ErrorCollectingVisitor errVisitor = new ErrorCollectingVisitor(tc);
        for (Object pu : tc.getPhasedUnits().getPhasedUnits()) {
            ((PhasedUnit)pu).getCompilationUnit().visit(errVisitor);
            if (errVisitor.getErrorCount() > 0) {
                errVisitor.printErrors(false, false);
                System.out.println("errors in the language module " + ((PhasedUnit)pu).getCompilationUnit().getLocation());
                return 1;
            }
            if (mmg == null) {
                mmg = new MetamodelVisitor(((PhasedUnit)pu).getPackage().getModule());
            }
            ((PhasedUnit)pu).getCompilationUnit().visit(mmg);
        }
        mod = ((PhasedUnit)tc.getPhasedUnits().getPhasedUnits().get(0)).getPackage().getModule();
        try {
            Object pu;
            final FileWriter writer = new FileWriter(file);
            pu = null;
            try {
                JsCompiler.beginWrapper(writer);
                writer.write("ex$.$CCMM$=");
                ModelEncoder.encodeModel(mmg.getModel(), writer);
                writer.write(";\n");
                JsOutput jsout = new JsOutput(mod, true){

                    @Override
                    public Writer getWriter() throws IOException {
                        return writer;
                    }
                };
                jsout.outputFile(new File(LANGMOD_JS_SRC, "MODEL.js"));
                JsCompiler.endWrapper(writer);
            }
            catch (Throwable throwable) {
                pu = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (pu != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)pu).addSuppressed(x2);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        finally {
            ShaSigner.sign(file, new JsJULLogger(), true);
        }
        File npmFile = new File(moduleFile.getParentFile(), "package.json");
        try (FileWriter writer = new FileWriter(npmFile);){
            String npmdesc = new NpmDescriptorGenerator(mod, true, false).generateDescriptor();
            writer.write(npmdesc);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int stitch(File infile, JsOutput writer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || !line.startsWith("COMPILE ")) continue;
                String sourceFiles = line.substring(8);
                System.out.println("Compiling language module sources: " + sourceFiles);
                int exitCode = Stitcher.compileLanguageModule(sourceFiles, writer);
                if (exitCode == 0) continue;
                int n = exitCode;
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int exitCode;
        block23: {
            if (args.length < 2) {
                System.err.println("This program requires 2 arguments to run:");
                System.err.println("1. The path to the master file (the one with the list of files to compile)");
                System.err.println("2. The path of the resulting JS file");
                System.exit(1);
                return;
            }
            String useColors = System.getProperty("ceylon.terminal.usecolors", "yes");
            System.setProperty("ceylon.terminal.usecolors", useColors);
            exitCode = 0;
            tmpDir = Files.createTempDirectory("ceylon-jsstitcher-", new FileAttribute[0]);
            try {
                File infile = new File(args[0]);
                if (infile.exists() && infile.isFile() && infile.canRead()) {
                    File outfile = new File(args[1]);
                    if (!outfile.getParentFile().exists()) {
                        FileUtil.mkdirs(outfile);
                    }
                    if ((exitCode = Stitcher.encodeModel(outfile)) != 0) break block23;
                    int p0 = args[1].indexOf(".language-");
                    String version2 = args[1].substring(p0 + 10, args[1].length() - 3);
                    try (final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8");){
                        JsOutput jsout = new JsOutput(mod, true){

                            @Override
                            public Writer getWriter() throws IOException {
                                return writer;
                            }
                        };
                        JsCompiler.beginWrapper(writer);
                        JsCompiler.requireWrapper(writer, mod);
                        jsout.out("var _CTM$;function $CCMM$(){if (_CTM$===undefined)_CTM$=require('", "ceylon/language/", version2, "/ceylon.language-", version2, "-model", "').$CCMM$;return _CTM$;}\nex$.$CCMM$=$CCMM$;");
                        exitCode = Stitcher.stitch(infile, jsout);
                        if (names != null) {
                            jsout.publishUnsharedDeclarations(names);
                        }
                        JsCompiler.endWrapper(writer);
                        break block23;
                    }
                    finally {
                        ShaSigner.sign(outfile, new JsJULLogger(), true);
                    }
                }
                System.err.println("Input file is invalid: " + infile);
                exitCode = 2;
            }
            finally {
                FileUtil.deleteQuietly(tmpDir.toFile());
            }
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    static {
        baseDir = new File("../language");
        clSrcDir = new File(baseDir, "src");
        clSrcFileDir = new File(clSrcDir, "ceylon/language/");
        LANGMOD_JS_SRC = new File(baseDir, "runtime-js");
        clJsFileDir = new File(LANGMOD_JS_SRC, "ceylon/language");
        compiledFiles = new HashSet(256);
    }
}

