/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.js.loader.JsonPackage;
import com.redhat.ceylon.compiler.js.loader.NpmAware;
import com.redhat.ceylon.compiler.js.loader.NpmPackage;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JsonModule
extends Module
implements NpmAware {
    private Map<String, Object> model;
    private boolean loaded = false;
    private String npmPath;

    public void setModel(Map<String, Object> value) {
        Object moduleAnns;
        if (this.model != null) {
            String modName = (String)this.model.get("$mod-name");
            String modVers = (String)this.model.get("$mod-version");
            if (!Objects.equals(modName, value.get("$mod-name")) || !Objects.equals(modVers, value.get("$mod-version"))) {
                throw new IllegalStateException("JsonModule " + modName + "/" + modVers + " receives new module " + value.get("$mod-name") + "/" + value.get("$mod-version"));
            }
            return;
        }
        this.model = value;
        String binVersion = (String)this.model.get("$mod-bin");
        int dotidx = binVersion.indexOf(46);
        this.setJsMajor(Integer.parseInt(binVersion.substring(0, dotidx), 10));
        this.setJsMinor(Integer.parseInt(binVersion.substring(dotidx + 1), 10));
        if (this.model.get("$mod-pa") != null) {
            int bits = (Integer)this.model.get("$mod-pa");
            this.setNativeBackends(JsonPackage.hasAnnotationBit(bits, "native") ? Backend.JavaScript.asSet() : Backends.ANY);
        }
        if ((moduleAnns = this.model.get("$mod-anns")) instanceof List) {
            JsonPackage.setNewAnnotations(this.getAnnotations(), (List)moduleAnns);
        } else if (moduleAnns instanceof Map) {
            JsonPackage.setOldAnnotations(this.getAnnotations(), (Map)moduleAnns);
        } else if (moduleAnns != null) {
            throw new IllegalArgumentException("Annotations should be a List (new format) or a Map (old format)");
        }
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    void loadDeclarations() {
        if (this.loaded) {
            return;
        }
        if (this.model != null && !this.loaded) {
            this.loaded = true;
            for (Map.Entry<String, Object> e : this.model.entrySet()) {
                if (e.getKey().startsWith("$mod-")) continue;
                JsonPackage p = new JsonPackage(e.getKey());
                p.setModule(this);
                this.getPackages().add(p);
            }
        }
    }

    public Map<String, Object> getModelForPackage(String name) {
        return this.model == null ? null : (Map)this.model.get(name);
    }

    @Override
    public Package getPackage(String name) {
        Package p;
        if ("default".equals(name)) {
            name = "";
        }
        if ((p = this.getDirectPackage(name)) != null) {
            return p;
        }
        HashSet<Module> visited = new HashSet<Module>();
        visited.add(this);
        for (ModuleImport imp : this.getImports()) {
            p = this.getPackageFromImport(name, imp.getModule(), visited);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public Package getDirectPackage(String name) {
        Package pkg = super.getDirectPackage(name);
        if (pkg == null && this.npmPath != null) {
            String modName = this.getNameAsString();
            if (this.getNameAsString().indexOf(45) > 0) {
                modName = modName.replace('-', '.');
            }
            if (modName.equals(name)) {
                pkg = new NpmPackage(this, name);
                this.getPackages().add(pkg);
            }
        }
        return pkg;
    }

    private Package getPackageFromImport(String name, Module module, Set<Module> visited) {
        if (!visited.add(module)) {
            return null;
        }
        Package p = module.getDirectPackage(name);
        if (p != null) {
            return p;
        }
        for (ModuleImport imp : module.getImports()) {
            if (!imp.isExport() || (p = this.getPackageFromImport(name, imp.getModule(), visited)) == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public List<ModuleImport> getImports() {
        List<ModuleImport> s = super.getImports();
        ArrayList<ModuleImport> r = new ArrayList<ModuleImport>(s.size());
        r.addAll(s);
        return r;
    }

    public void setNpmPath(String value) {
        this.npmPath = value;
    }

    @Override
    public String getNpmPath() {
        return this.npmPath;
    }
}

