/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.js.util.TypeUtils;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationKind;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetamodelGenerator {
    public static final String KEY_CLASSES = "$c";
    public static final String KEY_INTERFACES = "$i";
    public static final String KEY_OBJECTS = "$o";
    public static final String KEY_METHODS = "$m";
    public static final String KEY_ATTRIBUTES = "$at";
    public static final String KEY_ANNOTATIONS = "an";
    public static final String KEY_PACKED_ANNS = "pa";
    public static final String KEY_TYPE = "$t";
    public static final String KEY_RETURN_TYPE = "$rt";
    public static final String KEY_TYPES = "l";
    public static final String KEY_TYPE_PARAMS = "tp";
    public static final String KEY_TYPE_ARGS = "ta";
    public static final String KEY_METATYPE = "mt";
    public static final String KEY_MODULE = "md";
    public static final String KEY_NAME = "nm";
    public static final String KEY_PACKAGE = "pk";
    public static final String KEY_PARAMS = "ps";
    public static final String KEY_SELF_TYPE = "st";
    public static final String KEY_SATISFIES = "sts";
    public static final String KEY_DS_VARIANCE = "dv";
    public static final String KEY_US_VARIANCE = "uv";
    public static final String KEY_CONSTRUCTOR = "co";
    public static final String KEY_CONSTRUCTORS = "$cn";
    public static final String KEY_FLAGS = "$ff";
    public static final String KEY_DEFAULT = "def";
    public static final String KEY_DYNAMIC = "dyn";
    public static final String KEY_JS_TSENUM = "$tsenum";
    public static final String METATYPE_CLASS = "c";
    public static final String METATYPE_INTERFACE = "i";
    public static final String METATYPE_ALIAS = "als";
    public static final String METATYPE_OBJECT = "o";
    public static final String METATYPE_METHOD = "m";
    public static final String METATYPE_ATTRIBUTE = "a";
    public static final String METATYPE_GETTER = "g";
    public static final String METATYPE_SETTER = "s";
    public static final String METATYPE_TYPE_PARAMETER = "tp";
    public static final String METATYPE_PARAMETER = "prm";
    public static final List<String> annotationBits = Arrays.asList("shared", "actual", "formal", "default", "sealed", "final", "native", "late", "abstract", "annotation", "variable", "serializable", "static");
    private final Map<String, Object> model = new HashMap<String, Object>();
    private static final Map<String, Object> unknownTypeMap = new HashMap<String, Object>();
    private static final Map<String, Object> nothingTypeMap = new HashMap<String, Object>();
    private final Module module;

    public MetamodelGenerator(Module module) {
        this.module = module;
        this.model.put("$mod-name", module.getNameAsString());
        this.model.put("$mod-version", module.getVersion());
        this.model.put("$mod-bin", "10.0");
        if (module.isNative()) {
            ArrayList<String> backends = new ArrayList<String>(1);
            for (Backend backend : module.getNativeBackends()) {
                backends.add(backend.nativeAnnotation);
            }
            this.model.put("$mod-nat", backends);
        }
        MetamodelGenerator.encodeAnnotations(module.getAnnotations(), module, this.model);
        if (!module.getImports().isEmpty()) {
            ArrayList<Object> imps = new ArrayList<Object>(module.getImports().size());
            for (ModuleImport mi : module.getImports()) {
                if (!ModelUtil.isForBackend(mi.getNativeBackends(), Backend.JavaScript) || mi.getModule().getVersion() == null) continue;
                String impath = String.format("%s/%s", mi.getModule().getNameAsString(), mi.getModule().getVersion());
                if (mi.getNamespace() != null) {
                    impath = mi.getNamespace() + ":" + impath;
                }
                if (mi.isOptional() || mi.isExport() || mi.isNative()) {
                    HashMap<String, Object> optimp = new HashMap<String, Object>(3);
                    optimp.put("path", impath);
                    if (mi.isOptional()) {
                        optimp.put("opt", 1);
                    }
                    if (mi.isExport()) {
                        optimp.put("exp", 1);
                    }
                    if (mi.isNative()) {
                        ArrayList<String> backends = new ArrayList<String>(1);
                        for (Backend backend : mi.getNativeBackends()) {
                            backends.add(backend.nativeAnnotation);
                        }
                        optimp.put("nat", backends);
                    }
                    imps.add(optimp);
                    continue;
                }
                imps.add(impath);
            }
            this.model.put("$mod-deps", imps);
        }
        if (unknownTypeMap.isEmpty()) {
            unknownTypeMap.put(KEY_NAME, "$U");
        }
        if (nothingTypeMap.isEmpty()) {
            nothingTypeMap.put(KEY_NAME, "Nothing");
            nothingTypeMap.put(KEY_PACKAGE, "$");
        }
    }

    public Map<String, Object> getModel() {
        return Collections.unmodifiableMap(this.model);
    }

    private Map<String, Object> findParent(Declaration d) {
        HashMap pkgmap = this.getPackageMap(d.getUnit().getPackage());
        if (d.isToplevel()) {
            return pkgmap;
        }
        List<String> names = TypeUtils.generateModelPath(ModelUtil.getContainingDeclaration(d));
        names.remove(0);
        if (names.isEmpty()) {
            return pkgmap;
        }
        HashMap last = pkgmap;
        for (String name : names) {
            if (last == null) break;
            HashMap sub = (HashMap)last.get(name);
            if (sub == null && name.charAt(0) == '$') {
                sub = new HashMap();
                last.put(name, sub);
            }
            last = sub;
        }
        return last;
    }

    private Map<String, Object> tupleTypeMap(Type tt, Declaration from) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_NAME, "Tuple");
        m.put(KEY_PACKAGE, "$");
        List<Type> targs = tt.getTypeArgumentList();
        if (from.getUnit().isHomogeneousTuple(tt)) {
            int min = from.getUnit().getHomogeneousTupleLength(tt);
            m.put(KEY_TYPE, this.typeMap(targs.get(1), from));
            m.put("count", min);
        } else {
            this.encodeTypes(from.getUnit().getTupleElementTypes(tt), m, KEY_TYPES, from);
        }
        return m;
    }

    private Map<String, Object> typeMap(Type pt, Declaration from) {
        if (ModelUtil.isTypeUnknown(pt)) {
            return unknownTypeMap;
        }
        if (pt.isNothing()) {
            return nothingTypeMap;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (pt.isUnion() || pt.isIntersection()) {
            List<Type> subtipos = pt.isUnion() ? pt.getCaseTypes() : pt.getSatisfiedTypes();
            ArrayList<Map<String, Object>> subs = new ArrayList<Map<String, Object>>(subtipos.size());
            for (Type sub : subtipos) {
                subs.add(this.typeMap(sub, from));
            }
            m.put("comp", pt.isUnion() ? "u" : METATYPE_INTERFACE);
            m.put(KEY_TYPES, subs);
            return m;
        }
        if (pt.isTuple() && !pt.involvesTypeParameters()) {
            return this.tupleTypeMap(pt, from);
        }
        TypeDeclaration d = pt.getDeclaration();
        if (d.isToplevel() || pt.isTypeParameter()) {
            m.put(KEY_NAME, d.getName());
        } else {
            String qn = d.getQualifiedNameString();
            int p0 = qn.indexOf("::");
            if (p0 >= 0) {
                qn = qn.substring(p0 + 2);
            }
            if ((p0 = qn.indexOf(46)) >= 0) {
                StringBuilder nestedName = new StringBuilder(TypeUtils.modelName(d));
                Declaration pd = ModelUtil.getContainingDeclaration(d);
                while (pd != null) {
                    nestedName.insert(0, '.');
                    nestedName.insert(0, TypeUtils.modelName(pd));
                    pd = ModelUtil.getContainingDeclaration(pd);
                }
                qn = nestedName.toString();
            }
            m.put(KEY_NAME, qn);
        }
        if (d.getDeclarationKind() == DeclarationKind.TYPE_PARAMETER) {
            return m;
        }
        Package pkg = d.getUnit().getPackage();
        if (pkg == null || pkg.equals(from.getUnit().getPackage())) {
            this.addPackage(m, ".");
        } else {
            this.addPackage(m, pkg.getNameAsString());
        }
        if (pkg != null && !pkg.getModule().equals(this.module)) {
            Module mod = pkg.getModule();
            m.put(KEY_MODULE, mod.isLanguageModule() ? "$" : mod.getNameAsString());
        }
        this.putTypeArguments(m, pt, from);
        return m;
    }

    private Map<String, Object> typeParameterMap(TypeParameter tp, Declaration from) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_NAME, tp.getName());
        if (tp.isCovariant()) {
            map.put(KEY_DS_VARIANCE, "out");
        } else if (tp.isContravariant()) {
            map.put(KEY_DS_VARIANCE, "in");
        }
        if (tp.getSelfType() != null) {
            map.put(KEY_SELF_TYPE, tp.getSelfType().getDeclaration().getName());
        }
        if (tp.getSatisfiedTypes() != null && !tp.getSatisfiedTypes().isEmpty()) {
            this.encodeTypes(tp.getSatisfiedTypes(), map, KEY_SATISFIES, from);
        }
        if (tp.getCaseTypes() != null && !tp.getCaseTypes().isEmpty()) {
            this.encodeTypes(tp.getCaseTypes(), map, "of", from);
        }
        if (tp.getDefaultTypeArgument() != null) {
            map.put(KEY_DEFAULT, this.typeMap(tp.getDefaultTypeArgument(), from));
        }
        return map;
    }

    private void putTypeArguments(Map<String, Object> container, Type pt, Declaration from) {
        Type t;
        int tparmSize = 0;
        for (t = pt; t != null; t = t.getQualifyingType()) {
            tparmSize += t.getTypeArgumentList() == null ? 0 : t.getTypeArgumentList().size();
        }
        if (tparmSize > 0) {
            HashMap<String, Map<String, Object>> targs = new HashMap<String, Map<String, Object>>(tparmSize);
            for (t = pt; t != null; t = t.getQualifyingType()) {
                Map<TypeParameter, SiteVariance> usv = t.getVarianceOverrides();
                if (t.getTypeArgumentList() == null || t.getTypeArgumentList().isEmpty()) continue;
                for (Map.Entry<TypeParameter, Type> targ : t.getTypeArguments().entrySet()) {
                    Map<String, Object> tpmap = this.typeMap(targ.getValue(), from);
                    SiteVariance variance = usv.get(targ.getKey());
                    if (variance != null) {
                        tpmap.put(KEY_US_VARIANCE, variance.ordinal());
                    }
                    targs.put(MetamodelGenerator.partiallyQualifiedName(targ.getKey().getDeclaration()) + "." + targ.getKey().getName(), tpmap);
                }
            }
            container.put(KEY_TYPE_ARGS, targs);
        }
    }

    public static String partiallyQualifiedName(Declaration d) {
        String qname = d.getQualifiedNameString();
        int idx = qname.indexOf("::");
        if (idx >= 0) {
            qname = qname.substring(idx + 2);
        }
        return qname;
    }

    private List<Map<String, Object>> typeParameters(List<TypeParameter> tpl, Declaration from) {
        if (tpl != null && !tpl.isEmpty()) {
            ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>(tpl.size());
            for (TypeParameter tp : tpl) {
                l.add(this.typeParameterMap(tp, from));
            }
            return l;
        }
        return null;
    }

    private List<Map<String, Object>> parameterListMap(ParameterList plist, Declaration from) {
        if (plist == null) {
            return null;
        }
        List<Parameter> parms = plist.getParameters();
        if (parms.size() > 0) {
            ArrayList<Map<String, Object>> p = new ArrayList<Map<String, Object>>(parms.size());
            for (Parameter parm : parms) {
                FunctionOrValue parmtype;
                HashMap<String, Object> pm = new HashMap<String, Object>();
                pm.put(KEY_NAME, parm.getName());
                pm.put(KEY_METATYPE, METATYPE_PARAMETER);
                if (parm.isSequenced()) {
                    pm.put("seq", 1);
                }
                if (parm.isDefaulted()) {
                    pm.put(KEY_DEFAULT, 1);
                }
                if (parm.isAtLeastOne()) {
                    pm.put("$min1", 1);
                }
                if ((parmtype = parm.getModel()) != null && parmtype.getDeclarationKind() == DeclarationKind.TYPE_PARAMETER) {
                    pm.put(KEY_TYPE, parmtype.getName());
                } else {
                    pm.put(KEY_TYPE, this.typeMap(parm.getType(), from));
                }
                if (parm.isHidden()) {
                    pm.put("$hdn", 1);
                }
                if (parmtype instanceof Function) {
                    pm.put("$pt", "f");
                    ArrayList<List<Map<String, Object>>> _paramLists = new ArrayList<List<Map<String, Object>>>(((Function)parmtype).getParameterLists().size());
                    for (ParameterList subplist : ((Function)parmtype).getParameterLists()) {
                        List<Map<String, Object>> params = this.parameterListMap(subplist, from);
                        if (params == null) {
                            params = Collections.emptyList();
                        }
                        _paramLists.add(params);
                    }
                    if (_paramLists.size() > 1 || !((List)_paramLists.get(0)).isEmpty()) {
                        pm.put(KEY_PARAMS, _paramLists);
                    }
                }
                MetamodelGenerator.encodeAnnotations(parm.getModel().getAnnotations(), parm.getModel(), pm);
                p.add(pm);
            }
            return p;
        }
        return null;
    }

    public Map<String, Object> encodeMethod(Function d) {
        List<Map<String, Object>> tpl;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_METATYPE, METATYPE_METHOD);
        m.put(KEY_NAME, d.getName());
        if (d.isDynamic()) {
            m.put(KEY_DYNAMIC, 1);
        }
        if ((tpl = this.typeParameters(d.getTypeParameters(), d)) != null) {
            m.put("tp", tpl);
        }
        m.put(KEY_TYPE, this.typeMap(d.getType(), d));
        ArrayList<List<Map<String, Object>>> paramLists = new ArrayList<List<Map<String, Object>>>(d.getParameterLists().size());
        for (ParameterList plist : d.getParameterLists()) {
            List<Map<String, Object>> params = this.parameterListMap(plist, d);
            if (params == null) {
                params = Collections.emptyList();
            }
            paramLists.add(params);
        }
        if (paramLists.size() > 1 || !((List)paramLists.get(0)).isEmpty()) {
            m.put(KEY_PARAMS, paramLists);
        }
        int ff = 0;
        if (d.isDeclaredVoid()) {
            ff |= 1;
        }
        if (d.isDeferred()) {
            ff |= 2;
        }
        if (ff > 0) {
            m.put(KEY_FLAGS, ff);
        }
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        Map parent = this.findParent(d);
        if (parent != null) {
            if (parent != this.getPackageMap(d.getUnit().getPackage())) {
                if (!parent.containsKey(KEY_METHODS)) {
                    parent.put(KEY_METHODS, new HashMap());
                }
                parent = (Map)parent.get(KEY_METHODS);
            }
            if (parent != null) {
                parent.put((String)TypeUtils.modelName(d), m);
            }
        }
        return m;
    }

    public Map<String, Object> encodeClass(Class d) {
        Map parent;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_METATYPE, METATYPE_CLASS);
        m.put(KEY_NAME, TypeUtils.modelName(d));
        List<Map<String, Object>> tpl = this.typeParameters(d.getTypeParameters(), d);
        if (tpl != null) {
            m.put("tp", tpl);
        }
        if (d.getSelfType() != null) {
            m.put(KEY_SELF_TYPE, d.getSelfType().getDeclaration().getName());
        }
        if (d.getExtendedType() != null) {
            m.put("super", this.typeMap(d.getExtendedType(), d));
        }
        this.encodeTypes(d.getSatisfiedTypes(), m, KEY_SATISFIES, d);
        List<Map<String, Object>> inits = this.parameterListMap(d.getParameterList(), d);
        if (inits != null && !inits.isEmpty()) {
            m.put(KEY_PARAMS, inits);
        }
        this.encodeTypes(d.getCaseTypes(), m, "of", d);
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        if (d.isAnonymous()) {
            m.put("$anon", 1);
        }
        if (d.isAlias()) {
            m.put("$alias", 1);
            TypeDeclaration constructor = ((ClassAlias)d).getConstructor();
            if (constructor instanceof Constructor) {
                m.put(KEY_CONSTRUCTOR, ((Constructor)constructor).getName());
            }
        }
        if ((parent = this.findParent(d)) != null) {
            if (parent != this.getPackageMap(d.getUnit().getPackage())) {
                if (!parent.containsKey(KEY_CLASSES)) {
                    parent.put(KEY_CLASSES, new HashMap());
                }
                parent = (Map)parent.get(KEY_CLASSES);
            }
            parent.put((String)TypeUtils.modelName(d), m);
        }
        return m;
    }

    public Map<String, Object> encodeConstructor(Constructor d) {
        ParameterList plist;
        Map<String, Object> c = this.findParent(d);
        String mname = TypeUtils.modelName(d);
        if (c == null) {
            System.out.println("WTF no parent for Constructor " + d);
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (d.getName() != null) {
            m.put(KEY_NAME, mname);
        }
        if ((plist = d.getFirstParameterList()) != null) {
            m.put(KEY_PARAMS, plist.getParameters().isEmpty() ? Collections.EMPTY_LIST : this.parameterListMap(plist, d));
        }
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        if (c.get(KEY_CONSTRUCTORS) == null) {
            c.put(KEY_CONSTRUCTORS, new HashMap());
        }
        Map consmap = (Map)c.get(KEY_CONSTRUCTORS);
        consmap.put(d.getName() == null ? "$def" : mname, m);
        return null;
    }

    public Map<String, Object> encodeInterface(Interface d) {
        Map parent;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_METATYPE, METATYPE_INTERFACE);
        m.put(KEY_NAME, d.getName());
        List<Map<String, Object>> tpl = this.typeParameters(d.getTypeParameters(), d);
        if (tpl != null) {
            m.put("tp", tpl);
        }
        if (d.getSelfType() != null) {
            m.put(KEY_SELF_TYPE, d.getSelfType().getDeclaration().getName());
        }
        if (d.isDynamic()) {
            m.put(KEY_DYNAMIC, 1);
        }
        this.encodeTypes(d.getSatisfiedTypes(), m, KEY_SATISFIES, d);
        this.encodeTypes(d.getCaseTypes(), m, "of", d);
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        if (d.isAlias()) {
            m.put("$alias", this.typeMap(d.getExtendedType(), d));
        }
        if ((parent = this.findParent(d)) != null) {
            if (!d.isToplevel() || d.isMember()) {
                if (!parent.containsKey(KEY_INTERFACES)) {
                    parent.put(KEY_INTERFACES, new HashMap());
                }
                parent = (Map)parent.get(KEY_INTERFACES);
            }
            parent.put((String)TypeUtils.modelName(d), m);
        }
        return m;
    }

    public void encodeObject(Value d) {
        Map parent = this.findParent(d);
        if (!d.isToplevel() && parent != null) {
            if (!parent.containsKey(KEY_OBJECTS)) {
                parent.put(KEY_OBJECTS, new HashMap());
            }
            parent = (Map)parent.get(KEY_OBJECTS);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_METATYPE, METATYPE_OBJECT);
        m.put(KEY_NAME, d.getName());
        m.put("super", this.typeMap(d.getTypeDeclaration().getExtendedType(), d));
        this.encodeTypes(d.getTypeDeclaration().getSatisfiedTypes(), m, KEY_SATISFIES, d);
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        if (parent != null) {
            parent.put(TypeUtils.modelName(d.getTypeDeclaration()), m);
        }
    }

    public Map<String, Object> encodeAttributeOrGetter(FunctionOrValue d) {
        HashMap<String, Object> smap;
        Map parent;
        Map<String, Object> m = new HashMap<String, String>();
        String mname = TypeUtils.modelName(d);
        if (d.isToplevel() || d.isMember() || this.containsTypes(d)) {
            parent = this.findParent(d);
            if (parent == null) {
                return null;
            }
            if (parent != this.getPackageMap(d.getUnit().getPackage())) {
                String _k = KEY_ATTRIBUTES;
                if (!parent.containsKey(KEY_ATTRIBUTES)) {
                    parent.put(KEY_ATTRIBUTES, new HashMap());
                }
                parent = (Map)parent.get(KEY_ATTRIBUTES);
            }
            if (parent.containsKey(mname)) {
                m = (Map)parent.get(mname);
            }
        } else {
            return null;
        }
        m.put(KEY_NAME, d.getName());
        m.put(KEY_METATYPE, d instanceof Value && d.isTransient() ? METATYPE_GETTER : METATYPE_ATTRIBUTE);
        m.put(KEY_TYPE, this.typeMap(d.getType(), d));
        if (d.isDynamic()) {
            m.put(KEY_DYNAMIC, 1);
        }
        parent.put(mname, m);
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        if (d instanceof Value && ((Value)d).getSetter() != null && (smap = (HashMap<String, Object>)m.get("$set")) == null) {
            smap = new HashMap<String, Object>();
            m.put("$set", smap);
            smap.put(KEY_METATYPE, METATYPE_SETTER);
            MetamodelGenerator.encodeAnnotations(((Value)d).getSetter().getAnnotations(), ((Value)d).getSetter(), smap);
        }
        return m;
    }

    public Map<String, Object> encodeTypeAlias(TypeAlias d) {
        Map parent;
        if (d.isToplevel() || d.isMember()) {
            parent = this.findParent(d);
            if (parent == null) {
                return null;
            }
            if (!d.isToplevel()) {
                if (!parent.containsKey(KEY_ATTRIBUTES)) {
                    parent.put(KEY_ATTRIBUTES, new HashMap());
                }
                parent = (Map)parent.get(KEY_ATTRIBUTES);
            }
        } else {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(KEY_METATYPE, METATYPE_ALIAS);
        m.put(KEY_NAME, d.getName());
        List<Map<String, Object>> tpl = this.typeParameters(d.getTypeParameters(), d);
        if (tpl != null) {
            m.put("tp", tpl);
        }
        if (d.getSelfType() != null) {
            m.put(KEY_SELF_TYPE, d.getSelfType().getDeclaration().getName());
        }
        m.put("$alias", this.typeMap(d.getExtendedType(), d));
        this.encodeTypes(d.getCaseTypes(), m, "of", d);
        this.encodeTypes(d.getSatisfiedTypes(), m, KEY_SATISFIES, d);
        MetamodelGenerator.encodeAnnotations(d.getAnnotations(), d, m);
        parent.put(TypeUtils.modelName(d), m);
        return m;
    }

    private void encodeTypes(List<Type> types, Map<String, Object> m, String key, Declaration from) {
        if (types == null || types.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> sats = new ArrayList<Map<String, Object>>(types.size());
        for (Type st : types) {
            sats.add(this.typeMap(st, from));
        }
        m.put(key, sats);
    }

    public static int encodeAnnotations(List<Annotation> annotations, Object d, Map<String, Object> m) {
        String key;
        ArrayList<Map<String, List<String>>> anns = m == null ? null : new ArrayList<Map<String, List<String>>>(annotations.size());
        int bits = 0;
        for (Annotation a : annotations) {
            int idx;
            String name = a.getName();
            int n = idx = "native".equals(name) ? -1 : annotationBits.indexOf(name);
            if (idx >= 0) {
                bits |= 1 << idx;
                continue;
            }
            if (anns == null) continue;
            List<String> args = a.getPositionalArguments();
            if (args == null) {
                args = Collections.emptyList();
            }
            anns.add(Collections.singletonMap(name, args));
        }
        if (d instanceof Value && ((Value)d).isVariable()) {
            bits |= 1 << annotationBits.indexOf("variable");
        } else if (d instanceof Class && ((Class)d).isAbstract()) {
            bits |= 1 << annotationBits.indexOf("abstract");
        } else if (d instanceof Constructor && ((Constructor)d).isAbstract()) {
            bits |= 1 << annotationBits.indexOf("abstract");
        }
        if (bits > 0 && m != null) {
            key = d instanceof Module ? "$mod-pa" : (d instanceof Package ? "$pkg-pa" : KEY_PACKED_ANNS);
            m.put(key, bits);
        }
        if (anns != null && m != null && !anns.isEmpty()) {
            key = d instanceof Module ? "$mod-anns" : (d instanceof Package ? "$pkg-anns" : KEY_ANNOTATIONS);
            m.put(key, anns);
        }
        return bits;
    }

    private void addPackage(Map<String, Object> map, String pkgName) {
        if (pkgName.equals("ceylon.language")) {
            map.put(KEY_PACKAGE, "$");
        } else {
            map.put(KEY_PACKAGE, pkgName);
        }
    }

    public boolean containsTypes(Declaration d) {
        for (Declaration m : d.getMembers()) {
            if (m instanceof Value && ((Value)m).getTypeDeclaration().isAnonymous()) {
                return true;
            }
            if (!(m instanceof TypeDeclaration) && !this.containsTypes(m)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getPackageMap(Package p) {
        HashMap<String, Object> pkgmap = (HashMap<String, Object>)this.model.get(p.getNameAsString());
        if (pkgmap == null) {
            pkgmap = new HashMap<String, Object>();
            MetamodelGenerator.encodeAnnotations(p.getAnnotations(), p, pkgmap);
            this.model.put(p.getNameAsString(), pkgmap);
        }
        return pkgmap;
    }
}

