/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.js.loader;

import com.redhat.ceylon.compiler.js.loader.MetamodelGenerator;
import com.redhat.ceylon.compiler.typechecker.analyzer.UsageWarning;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.Map;

public class MetamodelVisitor
extends Visitor {
    final MetamodelGenerator gen;

    public MetamodelVisitor(Module module) {
        this.gen = new MetamodelGenerator(module);
    }

    public Map<String, Object> getModel() {
        return this.gen.getModel();
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeMethod(that.getDeclarationModel());
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeMethod(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeAttributeOrGetter(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeClass(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Constructor that) {
        if (this.errorFree(that)) {
            this.gen.encodeConstructor(that.getConstructor());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.Enumerated that) {
        if (this.errorFree(that)) {
            this.gen.encodeConstructor(that.getEnumerated());
        }
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeInterface(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeObject(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        if (this.errorFree(that)) {
            this.gen.encodeObject(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeAttributeOrGetter(that.getDeclarationModel());
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        if (this.errorFree(that)) {
            this.gen.encodeTypeAlias(that.getDeclarationModel());
        }
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeClass(that.getDeclarationModel());
        }
    }

    @Override
    public void visit(Tree.InterfaceDeclaration that) {
        if (!MetamodelVisitor.isNativeHeader(that.getDeclarationModel())) {
            return;
        }
        if (this.errorFree(that)) {
            this.gen.encodeInterface(that.getDeclarationModel());
        }
    }

    public boolean errorFree(Node node) {
        if (node.getErrors() != null) {
            for (Message m : node.getErrors()) {
                if (m instanceof UsageWarning) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(Tree.SpecifierStatement st) {
        TypedDeclaration d = st.getDeclaration();
        if (!MetamodelVisitor.isNativeHeader(d)) {
            return;
        }
        if (d != null) {
            Annotation ann = new Annotation();
            ann.setName("shared");
            d.getAnnotations().add(ann);
            ann = new Annotation();
            ann.setName("actual");
            d.getAnnotations().add(ann);
            if (d instanceof Function) {
                this.gen.encodeMethod((Function)d);
            } else if (d instanceof Value) {
                this.gen.encodeAttributeOrGetter((Value)d);
            } else {
                throw new RuntimeException("JS compiler doesn't know how to encode " + d.getClass().getName() + " into model");
            }
        }
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        super.visit(that);
        this.gen.getPackageMap(that.getUnit().getPackage());
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        if (this.errorFree(that)) {
            this.gen.encodeClass(that.getAnonymousClass());
            super.visit(that);
        }
    }

    private static boolean isNativeHeader(Declaration d) {
        if (d != null && d.isNative()) {
            return d.isNativeHeader();
        }
        return true;
    }
}

