/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.TypeVisitor;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.util.NativeUtil;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassAlias;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.ConditionScope;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ImportList;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.InterfaceAlias;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.LazyType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.NamedArgumentList;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DeclarationVisitor
extends Visitor {
    private static final ClassOrInterface[] NO_CLASSES = new ClassOrInterface[0];
    private static final FunctionOrValue[] NO_FUNCTIONS_OR_VALUES = new FunctionOrValue[0];
    private static final Constructor[] NO_CONSTRUCTORS = new Constructor[0];
    private final Package pkg;
    private Scope scope;
    private Unit unit;
    private ParameterList parameterList;
    private Declaration declaration;
    private boolean dynamic;
    private int fid = 0;
    private int id = 0;
    private boolean declarationReference = false;
    private boolean inExtends;

    public DeclarationVisitor(Unit unit) {
        this.unit = unit;
        this.pkg = unit.getPackage();
        this.scope = this.pkg;
    }

    public Unit getCompilationUnit() {
        return this.unit;
    }

    private Scope enterScope(Scope innerScope) {
        Scope outerScope = this.scope;
        this.scope = innerScope;
        return outerScope;
    }

    private void exitScope(Scope outerScope) {
        this.scope = outerScope;
    }

    private Declaration beginDeclaration(Declaration innerDec) {
        Declaration outerDec = this.declaration;
        this.declaration = innerDec;
        return outerDec;
    }

    private void endDeclaration(Declaration outerDec) {
        this.declaration = outerDec;
    }

    private void visitDeclaration(Tree.Declaration that, Declaration model) {
        this.visitDeclaration(that, model, true);
    }

    private void visitDeclaration(Tree.Declaration that, Declaration model, boolean checkDupe) {
        this.visitElement(that, model);
        this.handleDeclarationAnnotations(that, model);
        DeclarationVisitor.setVisibleScope(model);
        DeclarationVisitor.checkFormalMember(that, model);
        Tree.Identifier id = that.getIdentifier();
        if (DeclarationVisitor.setModelName(that, model, id) && checkDupe) {
            this.checkForNativeAnnotation(that, model, this.scope);
            DeclarationVisitor.checkForDuplicateDeclaration(that, model, this.scope);
        }
        this.unit.addDeclaration(model);
        Scope sc = this.getContainer(that);
        sc.addMember(model);
    }

    private void visitArgument(Tree.NamedArgument that, Declaration model) {
        Tree.Identifier id = that.getIdentifier();
        DeclarationVisitor.setModelName(that, model, id);
        this.visitElement(that, model);
        this.unit.addDeclaration(model);
        DeclarationVisitor.setVisibleScope(model);
    }

    private void visitArgument(Tree.Term that, Declaration model) {
        this.visitElement(that, model);
        this.unit.addDeclaration(model);
        DeclarationVisitor.setVisibleScope(model);
    }

    private static boolean setModelName(Node that, Declaration model, Tree.Identifier id) {
        if (that instanceof Tree.MissingDeclaration) {
            return false;
        }
        if (id == null || id.isMissingToken()) {
            if (that instanceof Tree.Constructor) {
                return true;
            }
            that.addError("missing declaration or argument name");
            return false;
        }
        model.setName(id.getText());
        return true;
    }

    private void checkForNativeAnnotation(Tree.Declaration that, Declaration model, Scope scope) {
        Unit unit = model.getUnit();
        if (model.isNative()) {
            Backends mbackends = model.getNativeBackends();
            boolean isHeader = model.isNativeHeader();
            String name = model.getName();
            boolean canBeNative = DeclarationVisitor.canBeNative(that);
            if (canBeNative) {
                Backends moduleBackends = unit.getPackage().getModule().getNativeBackends();
                Backends backends = model.getScope().getScopedBackends();
                if (!(isHeader || moduleBackends.none() || mbackends.supports(moduleBackends))) {
                    that.addError("native backend name on declaration conflicts with module descriptor: '\"" + mbackends.names() + "\"' is not '\"" + moduleBackends.names() + "\"' for '" + name + "'");
                } else if (!(isHeader || backends.none() || backends.supports(mbackends))) {
                    that.addError("native backend for declaration conflicts with its scope: native implementation '" + name + "' for '\"" + mbackends.names() + "\"' occurs in a scope which only supports '\"" + backends.names() + "\"'");
                }
                if (isHeader && this.existImplementations(model)) {
                    that.addError("native header must be declared before its implementations: the native header '" + name + "' is declared after an implementation");
                }
                if (model instanceof Interface && ((Interface)model).isAlias()) {
                    that.addError("interface alias may not be marked native: '" + name + "' (add a body if a native interface was intended)");
                }
                model.setNativeBackends(mbackends);
                Declaration member = ModelUtil.getNativeHeader(model);
                if ((member == null || member.isNativeImplementation()) && !isHeader && DeclarationVisitor.mustHaveHeader(model) && !moduleBackends.equals(mbackends)) {
                    that.addError("shared native implementation must have a header: '" + model.getName() + "' has no native header");
                }
                if (member == null) {
                    if (model.isNativeHeader()) {
                        this.handleNativeHeader(model, name);
                        if (that instanceof Tree.ObjectDefinition) {
                            Tree.ObjectDefinition od = (Tree.ObjectDefinition)that;
                            this.handleNativeHeader(od.getAnonymousClass(), name);
                        } else if (that instanceof Tree.Constructor) {
                            Tree.Constructor c = (Tree.Constructor)that;
                            this.handleNativeHeader(c.getConstructor(), name);
                        }
                    } else {
                        member = model.getContainer().getDirectMemberForBackend(model.getName(), mbackends);
                        if (member != null && member != model) {
                            that.addError("duplicate native implementation: the implementation '" + name + "' for '\"" + mbackends.names() + "\"' is not unique");
                            unit.getDuplicateDeclarations().add(member);
                        }
                    }
                } else if (member.isNative()) {
                    List<Declaration> overloads = member.getOverloads();
                    if (isHeader && member.isNativeHeader()) {
                        that.addError("duplicate native header: the header for '" + name + "' is not unique");
                        unit.getDuplicateDeclarations().add(member);
                    } else {
                        Declaration overload = this.findOverloadForBackend(mbackends, model, overloads);
                        if (overload != null) {
                            that.addError("duplicate native implementation: the implementation '" + name + "' for '\"" + mbackends.names() + "\"' is not unique");
                            unit.getDuplicateDeclarations().add(overload);
                        }
                    }
                    if (this.isAllowedToChangeModel(member) && !this.hasModelInOverloads(model, overloads)) {
                        overloads.add(model);
                        if (that instanceof Tree.ObjectDefinition) {
                            Tree.ObjectDefinition od = (Tree.ObjectDefinition)that;
                            Class objImplCls = od.getAnonymousClass();
                            Value value = (Value)member;
                            Class objHdrCls = (Class)value.getType().getDeclaration();
                            objHdrCls.getOverloads().add(objImplCls);
                        } else if (that instanceof Tree.Constructor) {
                            Tree.Constructor c = (Tree.Constructor)that;
                            Constructor cd = c.getConstructor();
                            FunctionOrValue fov = (FunctionOrValue)member;
                            Constructor hdr = (Constructor)fov.getType().getDeclaration();
                            hdr.getOverloads().add(cd);
                        }
                    }
                } else if (isHeader) {
                    that.addError("native header for non-native declaration: '" + name + "' is not declared native");
                } else {
                    that.addError("native implementation for non-native header: '" + name + "' is not declared native");
                }
            } else if (!(model instanceof Setter || isHeader || canBeNative)) {
                that.addError("native declaration is not a class, constructor, method, attribute or object: '" + name + "' may not be annotated 'native'");
            }
        }
    }

    private boolean existImplementations(Declaration hdr) {
        List<Declaration> decls = ModelUtil.lookupOverloadedByName(hdr.getScope().getMembers(), hdr.getName());
        for (Declaration decl : decls) {
            if (!decl.isNativeImplementation()) continue;
            return true;
        }
        return false;
    }

    private static boolean canBeNative(Tree.Declaration that) {
        return that instanceof Tree.ClassOrInterface || that instanceof Tree.Constructor || that instanceof Tree.Enumerated || that instanceof Tree.AnyMethod || that instanceof Tree.AnyAttribute || that instanceof Tree.ObjectDefinition;
    }

    protected static boolean canBeNative(Declaration member) {
        return member instanceof Function || member instanceof Value || member instanceof ClassOrInterface;
    }

    private static boolean mustHaveHeader(Declaration model) {
        if (model.isShared()) {
            if (model.isToplevel()) {
                return true;
            }
            if (model.isMember()) {
                Declaration container = (Declaration)((Object)model.getContainer());
                return !container.isNative() || container.isNativeHeader();
            }
        }
        return false;
    }

    private void handleNativeHeader(Declaration model, String name) {
        TypeDeclaration c;
        ArrayList<FunctionOrValue> loadedFunctionsOrValues = null;
        ArrayList<ClassOrInterface> loadedClasses = null;
        ArrayList<ClassOrInterface> loadedConstructors = null;
        for (Backend backendToSearch : Backend.getRegisteredBackends()) {
            TypeDeclaration c2;
            Declaration overloadFromModelLoader = model.getContainer().getDirectMemberForBackend(name, backendToSearch.asSet());
            if (overloadFromModelLoader instanceof FunctionOrValue) {
                if (loadedFunctionsOrValues == null) {
                    loadedFunctionsOrValues = new ArrayList<FunctionOrValue>();
                }
                FunctionOrValue fov = (FunctionOrValue)overloadFromModelLoader;
                loadedFunctionsOrValues.add(fov);
                continue;
            }
            if (overloadFromModelLoader instanceof ClassOrInterface) {
                if (loadedClasses == null) {
                    loadedClasses = new ArrayList<ClassOrInterface>();
                }
                c2 = (ClassOrInterface)overloadFromModelLoader;
                loadedClasses.add((ClassOrInterface)c2);
                continue;
            }
            if (!(overloadFromModelLoader instanceof Constructor)) continue;
            if (loadedConstructors == null) {
                loadedConstructors = new ArrayList<ClassOrInterface>();
            }
            c2 = (Constructor)overloadFromModelLoader;
            loadedConstructors.add((ClassOrInterface)c2);
        }
        if (model instanceof FunctionOrValue) {
            FunctionOrValue m = (FunctionOrValue)model;
            if (loadedFunctionsOrValues != null) {
                m.initOverloads(loadedFunctionsOrValues.toArray(NO_FUNCTIONS_OR_VALUES));
            } else {
                m.initOverloads(new FunctionOrValue[0]);
            }
        } else if (model instanceof ClassOrInterface) {
            c = (ClassOrInterface)model;
            if (loadedClasses != null) {
                ((ClassOrInterface)c).initOverloads(loadedClasses.toArray(NO_CLASSES));
            } else {
                ((ClassOrInterface)c).initOverloads(new ClassOrInterface[0]);
            }
        } else if (model instanceof Constructor) {
            c = (Constructor)model;
            if (loadedConstructors != null) {
                ((Constructor)c).initOverloads(loadedConstructors.toArray(NO_CONSTRUCTORS));
            } else {
                ((Constructor)c).initOverloads(new Constructor[0]);
            }
        }
    }

    private Declaration findOverloadForBackend(Backends backends, Declaration declaration, List<Declaration> overloads) {
        if (overloads != null) {
            for (Declaration overload : overloads) {
                if (!backends.supports(overload.getNativeBackends()) || this.shouldIgnoreOverload(overload, declaration)) continue;
                return overload;
            }
        }
        return null;
    }

    private boolean hasModelInOverloads(Declaration declaration, List<Declaration> overloads) {
        if (overloads != null) {
            for (Declaration overload : overloads) {
                if (overload != declaration) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean shouldIgnoreOverload(Declaration var1, Declaration var2);

    protected abstract boolean isAllowedToChangeModel(Declaration var1);

    private static void checkForDuplicateDeclaration(Tree.Declaration that, Declaration model, Scope scope) {
        String name = model.getName();
        Unit unit = model.getUnit();
        if (name != null) {
            if (model instanceof Setter) {
                Setter setter = (Setter)model;
                DeclarationVisitor.checkGetterForSetter(that, setter, scope);
            } else {
                boolean isControl;
                do {
                    Declaration member;
                    if ((member = scope.getDirectMember(name, null, false)) != null && member != model) {
                        boolean legalOverloadedMethod;
                        boolean dup = false;
                        boolean possibleOverloadedMethod = member instanceof Function && model instanceof Function && !(that instanceof Tree.Constructor) && !(that instanceof Tree.Enumerated) && scope instanceof ClassOrInterface && !member.isNative() && member.isShared() && model.isShared();
                        boolean bl = legalOverloadedMethod = possibleOverloadedMethod && model.isActual() && member.isActual();
                        if (legalOverloadedMethod) {
                            DeclarationVisitor.initOverload(model, member, scope, unit);
                        } else if (!(DeclarationVisitor.canBeNative(member) && DeclarationVisitor.canBeNative(model) && model.isNative())) {
                            dup = true;
                            if (possibleOverloadedMethod) {
                                if (DeclarationVisitor.initOverload(model, member, scope, unit)) {
                                    that.addError("duplicate declaration: the name '" + name + "' is not unique in this scope (overloading is only supported when refining Java methods)");
                                }
                            } else {
                                that.addError("duplicate declaration: the name '" + name + "' is not unique in this scope");
                            }
                        }
                        if (dup) {
                            unit.getDuplicateDeclarations().add(member);
                        }
                    }
                    isControl = scope instanceof ControlBlock;
                    scope = scope.getContainer();
                } while (isControl);
            }
        }
    }

    private static void checkGetterForSetter(Tree.Declaration that, Setter setter, Scope scope) {
        Tree.AnnotationList al = that.getAnnotationList();
        String name = setter.getName();
        Unit unit = setter.getUnit();
        Declaration member = setter.getContainer().getDirectMemberForBackend(name, TreeUtil.getNativeBackend(al, unit));
        if (member == null) {
            that.addError("setter with no matching getter: there is no getter named '" + name + "' already declared in this scope (declare a matching getter earlier in this scope)");
        } else if (!(member instanceof Value)) {
            that.addError("setter name does not resolve to matching getter: '" + name + "' is not a getter");
        } else if (member.isNative() && !setter.isNative()) {
            setter.setGetter((Value)member);
            that.addError("setter must be marked native: the getter '" + name + "' is annotated 'native'");
        } else if (!member.isNative() && setter.isNative()) {
            setter.setGetter((Value)member);
            that.addError("setter may not be marked native: the getter '" + name + "' is not annotated 'native'");
        } else if (!((Value)member).isTransient() && !ModelUtil.isNativeHeader(member)) {
            that.addError("matching value is a reference or is forward-declared: '" + name + "' is not a getter");
        } else {
            Value getter = (Value)member;
            setter.setGetter(getter);
            if (getter.isVariable()) {
                that.addError("duplicate setter for getter: '" + name + "' already has a setter");
            } else {
                getter.setSetter(setter);
            }
            setter.setNativeBackends(getter.getNativeBackends());
            setter.setStatic(getter.isStatic());
        }
    }

    private static boolean initOverload(Declaration model, Declaration member, Scope scope, Unit unit) {
        Function method = (Function)member;
        Function newMethod = (Function)model;
        newMethod.setOverloaded(true);
        if (method.isAbstraction()) {
            Function abstraction = method;
            abstraction.getOverloads().add(model);
            return abstraction.isActual() && !model.isActual();
        }
        String name = model.getName();
        method.setOverloaded(true);
        Function abstraction = new Function();
        abstraction.setAbstraction(true);
        abstraction.setType(new UnknownType(unit).getType());
        abstraction.setName(name);
        abstraction.setShared(true);
        abstraction.setActual(method.isActual());
        abstraction.setFormal(method.isFormal());
        abstraction.setDefault(method.isDefault());
        abstraction.setContainer(scope);
        abstraction.setScope(scope);
        abstraction.setUnit(unit);
        abstraction.initOverloads(method, newMethod);
        scope.addMember(abstraction);
        scope.getMembers().remove(method);
        scope.getMembers().add(method);
        return true;
    }

    private void visitElement(Node that, Element model) {
        model.setUnit(this.unit);
        model.setScope(this.scope);
        model.setContainer(this.getContainer(that));
    }

    private Scope getContainer(Node that) {
        if (that instanceof Tree.Declaration && !(that instanceof Tree.Parameter) && !(that instanceof Tree.Variable)) {
            Scope s = this.scope;
            while (s instanceof ConditionScope) {
                s = s.getScope();
            }
            return s;
        }
        return this.scope;
    }

    @Override
    public void visitAny(Node that) {
        that.setScope(this.scope);
        that.setUnit(this.unit);
        super.visitAny(that);
    }

    @Override
    public void visit(Tree.DynamicStatement that) {
        boolean od = this.dynamic;
        this.dynamic = true;
        super.visit(that);
        this.dynamic = od;
        NativeUtil.checkNotJvm(that, "dynamic is not supported on the JVM");
    }

    @Override
    public void visit(Tree.Dynamic that) {
        super.visit(that);
        NativeUtil.checkNotJvm(that, "dynamic is not supported on the JVM");
    }

    @Override
    public void visit(Tree.DynamicModifier that) {
        super.visit(that);
        NativeUtil.checkNotJvm(that, "dynamic is not supported on the JVM");
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.pkg.removeUnit(this.unit);
        this.pkg.addUnit(this.unit);
        super.visit(that);
        Node firstNonImportNode = null;
        int index = -1;
        Iterator<Tree.StatementOrArgument> i$ = that.getDeclarations().iterator();
        if (i$.hasNext()) {
            Node d;
            firstNonImportNode = d = (Node)i$.next();
            index = d.getToken().getTokenIndex();
        }
        if ((i$ = that.getModuleDescriptors().iterator()).hasNext()) {
            Tree.ModuleDescriptor md = (Tree.ModuleDescriptor)i$.next();
            if (index < 0 || md.getToken().getTokenIndex() < index) {
                firstNonImportNode = md;
                index = md.getToken().getTokenIndex();
            }
        }
        if ((i$ = that.getPackageDescriptors().iterator()).hasNext()) {
            Tree.PackageDescriptor pd = (Tree.PackageDescriptor)i$.next();
            if (index < 0 || pd.getToken().getTokenIndex() < index) {
                firstNonImportNode = pd;
                index = pd.getToken().getTokenIndex();
            }
        }
        if (firstNonImportNode != null) {
            for (Tree.Import im : that.getImportList().getImports()) {
                if (im.getEndIndex() <= firstNonImportNode.getStartIndex()) continue;
                im.addError("import statement must occur before any declaration or descriptor");
            }
        }
        boolean first = true;
        for (Tree.ModuleDescriptor md : that.getModuleDescriptors()) {
            if (!first) {
                md.addError("there may be only one module descriptor for a module");
            }
            first = false;
        }
        first = true;
        for (Tree.PackageDescriptor pd : that.getPackageDescriptors()) {
            if (!first) {
                pd.addError("there may be only one package descriptor for a module");
            }
            first = false;
        }
    }

    @Override
    public void visit(Tree.ImportMemberOrTypeList that) {
        ImportList il = new ImportList();
        this.unit.getImportLists().add(il);
        that.setImportList(il);
        il.setContainer(this.scope);
        il.setUnit(this.unit);
        Scope o = this.enterScope(il);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.TypeParameterList that) {
        super.visit(that);
        Generic g = (Generic)((Object)this.declaration);
        g.setTypeParameters(DeclarationVisitor.getTypeParameters(that));
    }

    private void defaultExtendedToBasic(Class c) {
        c.setExtendedType(new LazyType(this.unit){

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                return Collections.emptyMap();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                return DeclarationVisitor.this.unit.getBasicDeclaration();
            }
        });
    }

    private void defaultExtendedToObject(Interface c) {
        c.setExtendedType(new LazyType(this.unit){

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                return Collections.emptyMap();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                return DeclarationVisitor.this.unit.getObjectDeclaration();
            }
        });
    }

    private void defaultExtendedToAnything(TypeParameter c) {
        c.setExtendedType(new LazyType(this.unit){

            @Override
            public Map<TypeParameter, Type> initTypeArguments() {
                return Collections.emptyMap();
            }

            @Override
            public TypeDeclaration initDeclaration() {
                return DeclarationVisitor.this.unit.getAnythingDeclaration();
            }
        });
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        ClassOrInterface container;
        Class c = new Class();
        if (!AnalyzerUtil.isVeryAbstractClass(that, this.unit)) {
            this.defaultExtendedToBasic(c);
        }
        that.setDeclarationModel(c);
        super.visit(that);
        if (that.getParameterList() == null) {
            Tree.AnnotationList al;
            if (c.isClassOrInterfaceMember() && (c.isFormal() || c.isDefault() || c.isActual())) {
                that.addError("member class declared 'formal', 'default', or 'actual' must have a parameter list");
            }
            if (TreeUtil.hasAnnotation(al = that.getAnnotationList(), "sealed", this.unit)) {
                that.addError("class without parameter list may not be annotated 'sealed'", 1800);
            }
        }
        if (c.isSealed() && c.isFormal() && c.isClassOrInterfaceMember() && !(container = (ClassOrInterface)c.getContainer()).isSealed()) {
            that.addError("sealed formal member class does not belong to a sealed type", 1801);
        }
        if (c.isNativeImplementation()) {
            this.addMissingHeaderMembers(c);
        }
    }

    @Override
    public void visit(Tree.ClassDeclaration that) {
        ClassAlias c = new ClassAlias();
        that.setDeclarationModel(c);
        super.visit(that);
        if (that.getParameterList() == null) {
            that.addError("class alias must have a parameter list");
        }
    }

    @Override
    public void visit(Tree.AnyClass that) {
        Class c = that.getDeclarationModel();
        this.visitDeclaration(that, c);
        Scope o = this.enterScope(c);
        super.visit(that);
        this.exitScope(o);
        Tree.ParameterList pl = that.getParameterList();
        if (pl != null) {
            pl.getModel().setFirst(true);
            c.addParameterList(pl.getModel());
        }
        if (c.isClassOrInterfaceMember() && c.getContainer() instanceof TypedDeclaration) {
            that.addUnsupportedError("nested classes of inner classes are not yet supported");
        }
        Tree.Identifier identifier = that.getIdentifier();
        if (c.isAbstract() && c.isFinal()) {
            that.addError("class may not be both 'abstract' and 'final': '" + TreeUtil.name(identifier) + "'");
        }
        if (c.isFormal() && c.isFinal()) {
            that.addError("class may not be both 'formal' and 'final': '" + TreeUtil.name(identifier) + "'");
        }
        if (TreeUtil.hasAnnotation(that.getAnnotationList(), "service", that.getUnit()) && !c.getTypeParameters().isEmpty()) {
            that.addError("service class may not be generic");
        }
    }

    @Override
    public void visit(Tree.Constructor that) {
        Type at;
        Constructor c = new Constructor();
        that.setConstructor(c);
        if (this.scope instanceof Class) {
            Class clazz = (Class)this.scope;
            if (that.getIdentifier() == null && clazz.getDefaultConstructor() != null) {
                that.addError("duplicate default constructor: '" + clazz.getName() + "' may have at most one default constructor");
                this.unit.getDuplicateDeclarations().add(c);
            }
        }
        this.visitDeclaration(that, c, false);
        Scope realScope = ModelUtil.getRealScope(this.scope);
        if (realScope instanceof Class) {
            Class clazz = (Class)realScope;
            Type ot = clazz.getType();
            c.setExtendedType(ot);
            at = c.appliedType(ot, AnalyzerUtil.NO_TYPE_ARGS);
            clazz.setConstructors(true);
            if (clazz.isAnonymous()) {
                that.addError("anonymous class may not have constructor: '" + clazz.getName() + "' is an anonymous class");
            }
        } else {
            at = null;
            that.addError("constructor declaration must occur directly in the body of a class");
        }
        Function f = new Function();
        f.setType(at);
        that.setDeclarationModel(f);
        this.visitDeclaration(that, f);
        Scope o = this.enterScope(c);
        super.visit(that);
        this.exitScope(o);
        f.setImplemented(that.getBlock() != null);
        if (that.getParameterList() == null) {
            that.addError("missing parameter list in constructor declaration: '" + TreeUtil.name(that.getIdentifier()) + "' must have a parameter list", 1000);
        } else {
            ParameterList model = that.getParameterList().getModel();
            model.setFirst(true);
            if (model != null) {
                c.addParameterList(model);
                f.addParameterList(model);
            }
        }
        if (that.getIdentifier() == null) {
            if (!c.isShared()) {
                that.addError("default constructor must be annotated 'shared'", 705);
            }
            if (c.isAbstract()) {
                that.addError("default constructor may not be annotated 'abstract'", 1601);
            }
        }
        if (c.isAbstract() && c.isShared()) {
            that.addError("abstract constructor may not be annotated 'shared'", 1610);
        }
    }

    @Override
    public void visit(Tree.Enumerated that) {
        Type at;
        Constructor e = new Constructor();
        that.setEnumerated(e);
        this.visitDeclaration(that, e, false);
        if (this.scope instanceof Class) {
            Class clazz = (Class)this.scope;
            Type ot = clazz.getType();
            e.setExtendedType(ot);
            at = e.appliedType(ot, AnalyzerUtil.NO_TYPE_ARGS);
            clazz.setEnumerated(true);
            if (clazz.isAnonymous()) {
                that.addError("anonymous class may not have a value constructor: '" + clazz.getName() + "' is an anonymous class");
            } else if (clazz.isAbstract()) {
                that.addError("abstract class may not have a value constructor: '" + clazz.getName() + "' is abstract");
            } else if (!clazz.getTypeParameters().isEmpty()) {
                that.addError("generic class may not have a value constructor: '" + clazz.getName() + "' is generic");
            } else if (this.scope.getContainer() instanceof Interface) {
                that.addError("class nested inside an interface may not have a value constructor: '" + clazz.getName() + "' belongs to an interface");
            }
        } else {
            at = null;
            that.addError("value constructor declaration must occur directly in the body of a class");
        }
        Value v = new Value();
        v.setType(at);
        that.setDeclarationModel(v);
        this.visitDeclaration(that, v);
        Scope o = this.enterScope(e);
        super.visit(that);
        this.exitScope(o);
        v.setImplemented(that.getBlock() != null);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        Interface i = new Interface();
        i.setDynamic(that.getDynamic());
        this.defaultExtendedToObject(i);
        that.setDeclarationModel(i);
        super.visit(that);
        if (i.isNativeImplementation()) {
            this.addMissingHeaderMembers(i);
        }
        if (i.isDynamic()) {
            i.makeMembersDynamic();
        }
    }

    private void addMissingHeaderMembers(ClassOrInterface coi) {
        Declaration hdr = ModelUtil.getNativeHeader(coi);
        if (hdr != null) {
            HashSet<String> names = new HashSet<String>();
            for (Declaration im : coi.getMembers()) {
                if (!im.isMember()) continue;
                names.add(im.getQualifiedNameString());
            }
            for (Declaration hm : hdr.getMembers()) {
                if (!hm.isMember() || names.contains(hm.getQualifiedNameString()) || !(coi instanceof Interface) && !ModelUtil.isImplemented(hm)) continue;
                coi.addMember(hm);
            }
        }
    }

    @Override
    public void visit(Tree.InterfaceDeclaration that) {
        InterfaceAlias i = new InterfaceAlias();
        that.setDeclarationModel(i);
        super.visit(that);
    }

    @Override
    public void visit(Tree.AnyInterface that) {
        Interface i = that.getDeclarationModel();
        that.setDeclarationModel(i);
        this.visitDeclaration(that, i);
        Scope o = this.enterScope(i);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        TypeAlias a = new TypeAlias();
        that.setDeclarationModel(a);
        this.visitDeclaration(that, a);
        Scope o = this.enterScope(a);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.TypeParameterDeclaration that) {
        Tree.TypeVariance tv = that.getTypeVariance();
        TypeParameter p = new TypeParameter();
        this.defaultExtendedToAnything(p);
        p.setDeclaration(this.declaration);
        if (tv != null) {
            String v = tv.getText();
            p.setCovariant("out".equals(v));
            p.setContravariant("in".equals(v));
        }
        that.setDeclarationModel(p);
        this.visitDeclaration(that, p);
        super.visit(that);
        Tree.TypeSpecifier ts = that.getTypeSpecifier();
        if (ts != null) {
            p.setDefaulted(true);
            Tree.StaticType type = ts.getType();
            if (type != null) {
                Type dta = type.getTypeModel();
                p.setDefaultTypeArgument(dta);
            }
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        Function m = new Function();
        that.setDeclarationModel(m);
        this.visitDeclaration(that, m);
        Scope o = this.enterScope(m);
        super.visit(that);
        this.exitScope(o);
        DeclarationVisitor.setParameterLists(m, that.getParameterLists(), that);
        Tree.Type type = that.getType();
        m.setDeclaredVoid(type instanceof Tree.VoidModifier);
        if (type instanceof Tree.ValueModifier) {
            type.addError("functions may not be declared using the keyword value");
        }
        if (type instanceof Tree.DynamicModifier) {
            m.setDynamicallyTyped(true);
        }
    }

    private static void setParameterLists(Function m, List<Tree.ParameterList> paramLists, Node that) {
        if (m != null) {
            for (Tree.ParameterList pl : paramLists) {
                m.addParameterList(pl.getModel());
            }
        }
        if (paramLists.isEmpty()) {
            that.addError("missing parameter list in function declaration", 1000);
        } else {
            paramLists.get(0).getModel().setFirst(true);
            for (int i = 0; i < paramLists.size() - 1; ++i) {
                Tree.ParameterList pl;
                pl = paramLists.get(i);
                for (Tree.Parameter p : pl.getParameters()) {
                    if (!(p instanceof Tree.InitializerParameter)) continue;
                    p.addError("split parameter declaration only allowed in last parameter list");
                }
            }
        }
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        super.visit(that);
        Tree.Type type = that.getType();
        if (type instanceof Tree.FunctionModifier) {
            type.addError("values may not be declared using the keyword function");
        }
        if (type instanceof Tree.DynamicModifier) {
            that.getDeclarationModel().setDynamicallyTyped(true);
        }
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        Function m = new Function();
        m.setImplemented(that.getBlock() != null);
        that.setDeclarationModel(m);
        this.visitArgument(that, (Declaration)m);
        Scope o = this.enterScope(m);
        super.visit(that);
        this.exitScope(o);
        DeclarationVisitor.setParameterLists(m, that.getParameterLists(), that);
        Tree.Type type = that.getType();
        m.setDeclaredVoid(type instanceof Tree.VoidModifier);
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        Tree.Type type = that.getType();
        final Function f = new Function();
        f.setName("anonymous#" + this.fid++);
        f.setAnonymous(true);
        if (type.getToken() != null) {
            f.setDeclaredVoid(type instanceof Tree.VoidModifier);
        } else {
            Tree.Block block = that.getBlock();
            if (block != null) {
                f.setDeclaredVoid(true);
                new Visitor(){

                    @Override
                    public void visit(Tree.Declaration that) {
                    }

                    @Override
                    public void visit(Tree.TypedArgument that) {
                    }

                    @Override
                    public void visit(Tree.ObjectExpression that) {
                    }

                    @Override
                    public void visit(Tree.FunctionArgument that) {
                    }

                    @Override
                    public void visit(Tree.Return that) {
                        if (that.getExpression() != null) {
                            f.setDeclaredVoid(false);
                        }
                        super.visit(that);
                    }
                }.visit(block);
            }
        }
        that.setDeclarationModel(f);
        this.visitArgument(that, (Declaration)f);
        Scope o = this.enterScope(f);
        Declaration d = this.beginDeclaration(f);
        super.visit(that);
        this.endDeclaration(d);
        this.exitScope(o);
        DeclarationVisitor.setParameterLists(f, that.getParameterLists(), that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        ClassOrInterface ci;
        Scope container;
        Class c = new Class();
        this.defaultExtendedToBasic(c);
        c.setAnonymous(true);
        that.setAnonymousClass(c);
        this.visitDeclaration(that, c, false);
        Value v = new Value();
        that.setDeclarationModel(v);
        this.visitDeclaration(that, v);
        Type t = c.getType();
        that.getType().setTypeModel(t);
        v.setType(t);
        v.setStatic(c.isStatic());
        if (c.isStatic() && (container = v.getContainer()) instanceof ClassOrInterface && !(ci = (ClassOrInterface)container).getTypeParameters().isEmpty()) {
            that.addError("anonymous class belonging to generic type may not be annotated 'static'");
        }
        Scope o = this.enterScope(c);
        super.visit(that);
        this.exitScope(o);
        if (c.isInterfaceMember()) {
            that.addError("object declaration may not occur directly in interface body");
        }
        if (c.isNativeImplementation()) {
            this.addMissingHeaderMembers(c);
        }
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        Class c = new Class();
        this.defaultExtendedToBasic(c);
        c.setAnonymous(true);
        that.setAnonymousClass(c);
        this.visitArgument(that, (Declaration)c);
        Value v = new Value();
        that.setDeclarationModel(v);
        this.visitArgument(that, (Declaration)v);
        Type t = c.getType();
        that.getType().setTypeModel(t);
        v.setType(t);
        Scope o = this.enterScope(c);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        Class c = new Class();
        c.setName("anonymous#" + this.fid++);
        c.setNamed(false);
        this.defaultExtendedToBasic(c);
        c.setAnonymous(true);
        that.setAnonymousClass(c);
        this.visitArgument(that, (Declaration)c);
        Scope o = this.enterScope(c);
        super.visit(that);
        this.exitScope(o);
    }

    private boolean mustHaveExplicitType(FunctionOrValue fov) {
        return fov.isShared() && !fov.isActual();
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        Tree.Type type;
        ClassOrInterface ci;
        Scope container;
        Value v = new Value();
        that.setDeclarationModel(v);
        Tree.SpecifierOrInitializerExpression sie = that.getSpecifierOrInitializerExpression();
        boolean lazy = sie instanceof Tree.LazySpecifierExpression;
        v.setTransient(lazy);
        v.setImplemented(sie != null);
        this.visitDeclaration(that, v);
        if (!lazy && v.isVariable() && v.isStatic() && (container = v.getContainer()) instanceof ClassOrInterface && !(ci = (ClassOrInterface)container).getTypeParameters().isEmpty()) {
            that.addError("attribute of generic type may not be annotated both 'variable' and 'static'");
        }
        Scope o = null;
        o = this.enterScope(v);
        super.visit(that);
        this.exitScope(o);
        if (v.isInterfaceMember() && !v.isFormal() && !v.isNative() && sie == null) {
            that.addError("interface attribute must be annotated 'formal'", 1400);
        }
        if (v.isLate()) {
            if (v.isFormal()) {
                that.addError("formal attribute may not be annotated 'late'");
            } else if (!v.isClassOrInterfaceMember() && !v.isToplevel()) {
                that.addError("block-local value may not be annotated 'late'");
            }
        }
        if (v.isFormal() && sie != null) {
            that.addError("formal attributes may not have a value", 1102);
        }
        if ((type = that.getType()) instanceof Tree.ValueModifier) {
            if (v.isToplevel()) {
                if (sie == null) {
                    type.addError("toplevel value must explicitly specify a type");
                } else {
                    type.addError("toplevel value must explicitly specify a type", 200);
                }
            } else if (this.mustHaveExplicitType(v)) {
                type.addError("shared value must explicitly specify a type", 200);
            }
        }
    }

    @Override
    public void visit(Tree.MethodDeclaration that) {
        Tree.Type type;
        super.visit(that);
        Tree.SpecifierExpression sie = that.getSpecifierExpression();
        Function m = that.getDeclarationModel();
        m.setImplemented(sie != null);
        if (m.isFormal() && sie != null) {
            that.addError("formal method may not have a specification", 1102);
        }
        if ((type = that.getType()) instanceof Tree.FunctionModifier) {
            if (m.isToplevel()) {
                if (sie == null) {
                    type.addError("toplevel function must explicitly specify a return type");
                } else {
                    type.addError("toplevel function must explicitly specify a return type", 200);
                }
            } else if (this.mustHaveExplicitType(m)) {
                type.addError("shared function must explicitly specify a return type", 200);
            }
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        super.visit(that);
        Function m = that.getDeclarationModel();
        m.setImplemented(that.getBlock() != null);
        Tree.Type type = that.getType();
        if (type instanceof Tree.FunctionModifier) {
            if (m.isToplevel()) {
                type.addError("toplevel function must explicitly specify a return type", 200);
            } else if (this.mustHaveExplicitType(m) && !this.dynamic) {
                type.addError("shared function must explicitly specify a return type", 200);
            }
        }
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        Value g = new Value();
        g.setTransient(true);
        g.setImplemented(that.getBlock() != null);
        that.setDeclarationModel(g);
        this.visitDeclaration(that, g);
        Scope o = this.enterScope(g);
        super.visit(that);
        this.exitScope(o);
        Tree.Type type = that.getType();
        if (type instanceof Tree.ValueModifier) {
            if (g.isToplevel()) {
                type.addError("toplevel getter must explicitly specify a type", 200);
            } else if (this.mustHaveExplicitType(g) && !this.dynamic) {
                type.addError("shared getter must explicitly specify a type", 200);
            }
        }
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        Value g = new Value();
        g.setTransient(true);
        g.setImplemented(that.getBlock() != null);
        that.setDeclarationModel(g);
        this.visitArgument(that, (Declaration)g);
        Scope o = this.enterScope(g);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        Setter s = new Setter();
        s.setImplemented(that.getBlock() != null);
        that.setDeclarationModel(s);
        this.visitDeclaration(that, s);
        Scope o = this.enterScope(s);
        Parameter p = new Parameter();
        p.setHidden(true);
        Value v = new Value();
        v.setInitializerParameter(p);
        p.setModel(v);
        v.setName(s.getName());
        p.setName(s.getName());
        p.setDeclaration(s);
        this.visitElement(that, v);
        this.unit.addDeclaration(v);
        Scope sc = this.getContainer(that);
        sc.addMember(v);
        s.setParameter(p);
        super.visit(that);
        this.exitScope(o);
        if (that.getSpecifierExpression() == null && that.getBlock() == null && !ModelUtil.isNativeHeader(s) && !ModelUtil.isNativeHeader(s.getGetter())) {
            that.addError("setter declaration must have a body or => specifier");
        }
    }

    @Override
    public void visit(Tree.MissingDeclaration that) {
        that.addError("missing keyword or type annotation");
        Value value = new Value();
        that.setDeclarationModel(value);
        this.visitDeclaration(that, value);
        super.visit(that);
    }

    @Override
    public void visit(Tree.InitializerParameter that) {
        Parameter p = new Parameter();
        p.setDeclaration(this.declaration);
        p.setDefaulted(that.getSpecifierExpression() != null);
        p.setHidden(true);
        p.setName(that.getIdentifier().getText());
        that.setParameterModel(p);
        super.visit(that);
        this.parameterList.getParameters().add(p);
    }

    @Override
    public void visit(Tree.Parameter that) {
        super.visit(that);
        Tree.SpecifierOrInitializerExpression sie = null;
        if (that instanceof Tree.ParameterDeclaration) {
            Tree.ParameterDeclaration pd = (Tree.ParameterDeclaration)that;
            Tree.TypedDeclaration td = pd.getTypedDeclaration();
            if (td instanceof Tree.AttributeDeclaration) {
                Tree.AttributeDeclaration ad = (Tree.AttributeDeclaration)td;
                sie = ad.getSpecifierOrInitializerExpression();
            } else if (td instanceof Tree.MethodDeclaration) {
                Tree.MethodDeclaration md = (Tree.MethodDeclaration)td;
                sie = md.getSpecifierExpression();
            }
        } else if (that instanceof Tree.InitializerParameter) {
            Tree.InitializerParameter ip = (Tree.InitializerParameter)that;
            sie = ip.getSpecifierExpression();
        }
        if (sie != null) {
            if (this.scope instanceof ClassAlias) {
                sie.addUnsupportedError("defaulted parameters are not yet supported for class aliases");
            }
            new Visitor(){

                @Override
                public void visit(Tree.AssignmentOp that) {
                    that.addError("assignment may not occur in default argument expression");
                }

                @Override
                public void visit(Tree.PostfixOperatorExpression that) {
                    that.addError("postfix increment or decrement may not occur in default argument expression");
                }

                @Override
                public void visit(Tree.PrefixOperatorExpression that) {
                    that.addError("prefix increment or decrement may not occur in default argument expression");
                }
            }.visit(sie);
        }
    }

    private static Tree.SpecifierOrInitializerExpression getSpecifier(Tree.ValueParameterDeclaration that) {
        Tree.AttributeDeclaration ad = (Tree.AttributeDeclaration)that.getTypedDeclaration();
        return ad.getSpecifierOrInitializerExpression();
    }

    private static Tree.SpecifierExpression getSpecifier(Tree.FunctionalParameterDeclaration that) {
        Tree.MethodDeclaration md = (Tree.MethodDeclaration)that.getTypedDeclaration();
        return md.getSpecifierExpression();
    }

    @Override
    public void visit(Tree.ValueParameterDeclaration that) {
        Tree.SequencedType st;
        Parameter p = new Parameter();
        p.setDeclaration(this.declaration);
        p.setDefaulted(DeclarationVisitor.getSpecifier(that) != null);
        Tree.TypedDeclaration td = that.getTypedDeclaration();
        Tree.Type type = td.getType();
        p.setSequenced(type instanceof Tree.SequencedType);
        that.setParameterModel(p);
        super.visit(that);
        Value v = (Value)td.getDeclarationModel();
        p.setName(v.getName());
        p.setModel(v);
        v.setInitializerParameter(p);
        this.parameterList.getParameters().add(p);
        if (p.isSequenced() && p.isDefaulted()) {
            DeclarationVisitor.getSpecifier(that).addError("variadic parameter may not specify default argument");
        }
        if (p.isSequenced() && (st = (Tree.SequencedType)type).getAtLeastOne()) {
            p.setAtLeastOne(true);
        }
        if (v.isFormal()) {
            that.addError("parameter may not be annotated 'formal'", 1312);
        }
    }

    @Override
    public void visit(Tree.FunctionalParameterDeclaration that) {
        Parameter p = new Parameter();
        p.setDeclaration(this.declaration);
        p.setDefaulted(DeclarationVisitor.getSpecifier(that) != null);
        Tree.TypedDeclaration td = that.getTypedDeclaration();
        Tree.Type type = td.getType();
        p.setDeclaredAnything(type instanceof Tree.VoidModifier);
        that.setParameterModel(p);
        super.visit(that);
        Function m = (Function)td.getDeclarationModel();
        p.setModel(m);
        p.setName(m.getName());
        m.setInitializerParameter(p);
        this.parameterList.getParameters().add(p);
        if (type instanceof Tree.SequencedType) {
            type.addError("functional parameter type may not be variadic");
        }
        if (m.isFormal()) {
            that.addError("parameter may not be annotated 'formal'", 1312);
        }
    }

    @Override
    public void visit(Tree.ParameterList that) {
        ParameterList pl = this.parameterList;
        this.parameterList = new ParameterList();
        that.setModel(this.parameterList);
        super.visit(that);
        this.parameterList = pl;
    }

    @Override
    public void visit(Tree.ControlClause that) {
        ControlBlock cb = new ControlBlock();
        cb.setLet(that instanceof Tree.LetClause);
        cb.setId(this.id++);
        that.setControlBlock(cb);
        this.visitElement(that, cb);
        Scope o = this.enterScope(cb);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        ControlBlock cb = new ControlBlock();
        cb.setId(this.id++);
        that.setControlBlock(cb);
        this.visitElement(that, cb);
        Scope o = this.enterScope(cb);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.SwitchExpression that) {
        ControlBlock cb = new ControlBlock();
        cb.setId(this.id++);
        this.visitElement(that, cb);
        Scope o = this.enterScope(cb);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.Condition that) {
        ConditionScope cb = new ConditionScope();
        cb.setId(this.id++);
        that.setScope(cb);
        this.visitElement(that, cb);
        this.enterScope(cb);
        super.visit(that);
    }

    @Override
    public void visit(Tree.Resource that) {
        ConditionScope cb = new ConditionScope();
        cb.setId(this.id++);
        that.setScope(cb);
        this.visitElement(that, cb);
        this.enterScope(cb);
        super.visit(that);
    }

    @Override
    public void visit(Tree.ExistsOrNonemptyCondition that) {
        super.visit(that);
        String op = that instanceof Tree.ExistsCondition ? "exists" : "nonempty";
        Tree.Expression be = that.getBrokenExpression();
        if (be != null) {
            be.addError("incorrect syntax: '" + op + "' conditions do not apply to arbitrary expressions (use postfix '" + op + "' operator or introduce a variable)", 3100);
        } else if (that.getVariable() == null) {
            that.addError("missing variable or value reference: '" + op + "' condition requires an operand");
        }
    }

    @Override
    public void visit(Tree.Body that) {
        DeclarationVisitor.addGuardedVariables(that, that instanceof Tree.ClassBody);
        int oid = this.id;
        this.id = 0;
        super.visit(that);
        this.id = oid;
        Tree.ImportList importList = that.getImportList();
        if (importList != null) {
            Node firstNonImportNode = null;
            Iterator<Tree.StatementOrArgument> i$ = that.getStatements().iterator();
            if (i$.hasNext()) {
                Node d;
                firstNonImportNode = d = (Node)i$.next();
            }
            if (firstNonImportNode != null) {
                for (Tree.Import im : importList.getImports()) {
                    if (im.getEndIndex() <= firstNonImportNode.getStartIndex()) continue;
                    im.addError("import statement must occur before any other statement in block");
                }
            }
        }
    }

    private static void addGuardedVariables(Tree.Body that, boolean isInitializer) {
        List<Tree.Statement> originals = that.getStatements();
        int originalSize = originals.size();
        ArrayList<Tree.Statement> result = new ArrayList<Tree.Statement>(originalSize);
        for (int i = 0; i < originalSize; ++i) {
            Tree.ConditionList cl;
            Tree.Variable v;
            int size;
            Tree.Statement last;
            List<Tree.Statement> statements;
            Tree.Block block;
            Tree.ElseClause elcl;
            Tree.ConditionList cl2;
            Tree.Variable v2;
            int size2;
            Tree.Statement last2;
            List<Tree.Statement> statements2;
            Tree.Block block2;
            Tree.Statement st = originals.get(i);
            result.add(st);
            if (i >= originalSize - 1 || !(st instanceof Tree.IfStatement)) continue;
            Tree.IfStatement ifst = (Tree.IfStatement)st;
            Tree.IfClause ifcl = ifst.getIfClause();
            if (ifcl != null && (block2 = ifcl.getBlock()) != null && !(statements2 = block2.getStatements()).isEmpty() && DeclarationVisitor.definitelyReturns(last2 = statements2.get((size2 = statements2.size()) - 1), isInitializer, false) && (v2 = DeclarationVisitor.guardedVariable(cl2 = ifcl.getConditionList(), true)) != null) {
                result.add(v2);
            }
            if ((elcl = ifst.getElseClause()) == null || (block = elcl.getBlock()) == null || (statements = block.getStatements()).isEmpty() || !DeclarationVisitor.definitelyReturns(last = statements.get((size = statements.size()) - 1), isInitializer, false) || (v = DeclarationVisitor.guardedVariable(cl = ifcl.getConditionList(), false)) == null) continue;
            result.add(v);
        }
        originals.clear();
        originals.addAll(result);
    }

    public static boolean definitelyReturns(Tree.Statement last, boolean isInitializer, boolean withinInnerLoop) {
        if (last instanceof Tree.Throw || !isInitializer && last instanceof Tree.Return || !withinInnerLoop && (last instanceof Tree.Break || last instanceof Tree.Continue)) {
            return true;
        }
        if (last instanceof Tree.IfStatement) {
            Tree.IfStatement is = (Tree.IfStatement)last;
            Tree.IfClause ic = is.getIfClause();
            Tree.ElseClause ec = is.getElseClause();
            if (ic != null && ec != null) {
                Tree.Block icb = ic.getBlock();
                Tree.Block ecb = ec.getBlock();
                if (icb != null && ecb != null) {
                    List<Tree.Statement> ists = icb.getStatements();
                    List<Tree.Statement> ests = ecb.getStatements();
                    if (!ists.isEmpty() && !ests.isEmpty()) {
                        Tree.Statement ilast = ists.get(ists.size() - 1);
                        Tree.Statement elast = ests.get(ests.size() - 1);
                        return DeclarationVisitor.definitelyReturns(ilast, isInitializer, withinInnerLoop) && DeclarationVisitor.definitelyReturns(elast, isInitializer, withinInnerLoop);
                    }
                }
            }
            return false;
        }
        if (last instanceof Tree.SwitchStatement) {
            Tree.SwitchStatement ss = (Tree.SwitchStatement)last;
            Tree.SwitchCaseList scl = ss.getSwitchCaseList();
            if (scl != null) {
                for (Tree.CaseClause cc : scl.getCaseClauses()) {
                    Tree.Block cb = cc.getBlock();
                    if (cb == null) {
                        return false;
                    }
                    List<Tree.Statement> csts = cb.getStatements();
                    if (csts.isEmpty()) {
                        return false;
                    }
                    Tree.Statement clast = csts.get(csts.size() - 1);
                    if (DeclarationVisitor.definitelyReturns(clast, isInitializer, withinInnerLoop)) continue;
                    return false;
                }
                Tree.ElseClause ec = scl.getElseClause();
                if (ec != null) {
                    Tree.Block ecb = ec.getBlock();
                    if (ecb == null) {
                        return false;
                    }
                    List<Tree.Statement> ests = ecb.getStatements();
                    if (ests.isEmpty()) {
                        return false;
                    }
                    Tree.Statement elast = ests.get(ests.size() - 1);
                    if (!DeclarationVisitor.definitelyReturns(elast, isInitializer, withinInnerLoop)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (last instanceof Tree.ForStatement) {
            Tree.ForStatement fs = (Tree.ForStatement)last;
            Tree.ElseClause ec = fs.getElseClause();
            Tree.ForClause fc = fs.getForClause();
            if (ec != null && fc != null) {
                Tree.Block ecb = ec.getBlock();
                Tree.Block fcb = fc.getBlock();
                if (ecb != null && ecb != null) {
                    List<Tree.Statement> fsts = fcb.getStatements();
                    List<Tree.Statement> ests = ecb.getStatements();
                    if (!ests.isEmpty() && !fsts.isEmpty()) {
                        Tree.Statement flast = fsts.get(fsts.size() - 1);
                        Tree.Statement elast = ests.get(ests.size() - 1);
                        return DeclarationVisitor.definitelyReturns(flast, isInitializer, true) && DeclarationVisitor.definitelyReturns(elast, isInitializer, true);
                    }
                }
            }
            return false;
        }
        return false;
    }

    private static Tree.Variable guardedVariable(Tree.ConditionList cl, boolean reversed) {
        List<Tree.Condition> conditions;
        if (cl != null && (conditions = cl.getConditions()).size() == 1) {
            Tree.IsCondition ic;
            Tree.Variable v;
            Tree.Condition c = conditions.get(0);
            Tree.Identifier id = null;
            Tree.Type t = null;
            if (c instanceof Tree.ExistsOrNonemptyCondition) {
                Tree.Variable v2;
                Tree.ExistsOrNonemptyCondition enc = (Tree.ExistsOrNonemptyCondition)c;
                Tree.Statement s = enc.getVariable();
                if (s instanceof Tree.Variable && (v2 = (Tree.Variable)s) != null) {
                    t = v2.getType();
                    id = v2.getIdentifier();
                }
            } else if (c instanceof Tree.IsCondition && (v = (ic = (Tree.IsCondition)c).getVariable()) != null) {
                t = v.getType();
                id = v.getIdentifier();
            }
            if (id != null && t instanceof Tree.SyntheticVariable) {
                CustomTree.GuardedVariable ev = new CustomTree.GuardedVariable(null);
                ev.setReversed(reversed);
                ev.setConditionList(cl);
                ev.setType(new Tree.SyntheticVariable(null));
                Tree.SpecifierExpression ese = new Tree.SpecifierExpression(null);
                Tree.Expression ee = new Tree.Expression(null);
                Tree.BaseMemberExpression ebme = new Tree.BaseMemberExpression(null);
                ebme.setTypeArguments(new Tree.InferredTypeArguments(null));
                ee.setTerm(ebme);
                ese.setExpression(ee);
                ev.setSpecifierExpression(ese);
                ev.setIdentifier(id);
                ebme.setIdentifier(id);
                return ev;
            }
        }
        return null;
    }

    @Override
    public void visit(Tree.NamedArgumentList that) {
        NamedArgumentList nal = new NamedArgumentList();
        nal.setId(this.id++);
        for (Tree.NamedArgument na : that.getNamedArguments()) {
            Tree.Identifier id = na.getIdentifier();
            if (id == null) continue;
            nal.getArgumentNames().add(id.getText());
        }
        that.setNamedArgumentList(nal);
        this.visitElement(that, nal);
        Scope o = this.enterScope(nal);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.Variable that) {
        Tree.AnnotationList al;
        Tree.Identifier identifier;
        Tree.SpecifierExpression se;
        if (that instanceof CustomTree.GuardedVariable) {
            ConditionScope cb = new ConditionScope();
            cb.setId(this.id++);
            that.setScope(cb);
            this.visitElement(that, cb);
            this.enterScope(cb);
        }
        if ((se = that.getSpecifierExpression()) != null) {
            ControlBlock block;
            Scope s = this.scope;
            if (this.scope instanceof ControlBlock && !(block = (ControlBlock)this.scope).isLet()) {
                this.scope = this.scope.getContainer();
            }
            se.visit(this);
            this.scope = s;
        }
        Tree.Type type = that.getType();
        Value v = new Value();
        that.setDeclarationModel(v);
        this.visitDeclaration(that, v, !(type instanceof Tree.SyntheticVariable));
        DeclarationVisitor.setVisibleScope(v);
        if (type != null) {
            type.visit(this);
        }
        if ((identifier = that.getIdentifier()) != null) {
            identifier.visit(this);
        }
        if ((al = that.getAnnotationList()) != null) {
            al.visit(this);
        }
        List<Tree.ParameterList> pls = that.getParameterLists();
        for (Tree.ParameterList pl : pls) {
            pl.visit(this);
        }
        if (pls.isEmpty()) {
            if (type instanceof Tree.FunctionModifier) {
                type.addError("variables with no parameters may not be declared using the keyword 'function'");
            }
            if (type instanceof Tree.VoidModifier) {
                type.addError("variables with no parameters may not be declared using the keyword 'void'");
            }
        } else {
            Tree.ParameterList pl = pls.get(0);
            pl.addUnsupportedError("variables with parameter lists are not yet supported");
            if (type instanceof Tree.ValueModifier) {
                type.addError("variables with parameters may not be declared using the keyword 'value'");
            }
        }
        that.setScope(this.scope);
        that.setUnit(this.unit);
    }

    private static List<TypeParameter> getTypeParameters(Tree.TypeParameterList tpl) {
        List<TypeParameter> typeParameters = Collections.emptyList();
        if (tpl != null) {
            boolean foundDefaulted = false;
            List<Tree.TypeParameterDeclaration> tpds = tpl.getTypeParameterDeclarations();
            typeParameters = new ArrayList<TypeParameter>(tpds.size());
            for (Tree.TypeParameterDeclaration tp : tpds) {
                typeParameters.add(tp.getDeclarationModel());
                if (tp.getTypeSpecifier() == null) {
                    if (!foundDefaulted) continue;
                    tp.addError("required type parameter follows defaulted type parameter");
                    continue;
                }
                foundDefaulted = true;
            }
        }
        return typeParameters;
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        if (!this.unit.getFilename().equals("module.ceylon")) {
            that.addError("module descriptor must occur in a compilation unit named module.ceylon");
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        if (!this.unit.getFilename().equals("package.ceylon")) {
            that.addError("package descriptor must occur in a compilation unit named package.ceylon");
        }
        super.visit(that);
    }

    @Override
    public void visit(Tree.Declaration that) {
        ClassOrInterface container;
        if (this.unit.getFilename().equals("module.ceylon") || this.unit.getFilename().equals("package.ceylon")) {
            that.addError("declaration may not occur in a module or package descriptor file");
        }
        Declaration model = that.getDeclarationModel();
        Declaration d = this.beginDeclaration(model);
        super.visit(that);
        this.endDeclaration(d);
        if (model.isClassOrInterfaceMember() && (container = (ClassOrInterface)model.getContainer()).isFinal() && model.isDefault()) {
            that.addError("member of final class may not be annotated 'default'", 1350);
        }
        if (model.isToplevel()) {
            String name = model.getName();
            if (name != null && name.endsWith("_")) {
                that.addUnsupportedError("toplevel declaration name ending in _ not currently supported");
            }
            if (this.pkg.getNameAsString().endsWith("_")) {
                that.addUnsupportedError("toplevel declaration belonging to package with name ending in _ not currently supported");
            }
        }
    }

    private void handleDeclarationAnnotations(Tree.Declaration that, Declaration model) {
        Value value;
        Tree.AnnotationList al = that.getAnnotationList();
        if (TreeUtil.hasAnnotation(al, "shared", this.unit)) {
            if (that instanceof Tree.AttributeSetterDefinition) {
                that.addError("setter may not be annotated 'shared'", 1201);
            } else {
                model.setShared(true);
            }
        }
        if (TreeUtil.hasAnnotation(al, "static", this.unit)) {
            if (model instanceof Function || model instanceof Value || model instanceof ClassOrInterface || model instanceof TypeAlias) {
                model.setStatic(true);
                if (model.isInterfaceMember()) {
                    that.addUnsupportedError("static members of interfaces are not yet supported");
                }
                if (ModelUtil.isAnonymousClass(model.getContainer())) {
                    that.addError("member of anonymous class may not be annotated 'static'");
                }
            } else {
                that.addError("declaration may not be annotated 'static'");
            }
        }
        if (TreeUtil.hasAnnotation(al, "small", this.unit) && model instanceof FunctionOrValue) {
            ((FunctionOrValue)model).setSmall(true);
        }
        if (TreeUtil.hasAnnotation(al, "default", this.unit)) {
            if (that instanceof Tree.ObjectDefinition) {
                that.addError("object declaration may not be annotated 'default'", 1313);
            } else {
                model.setDefault(true);
            }
        }
        if (TreeUtil.hasAnnotation(al, "formal", this.unit)) {
            if (that instanceof Tree.ObjectDefinition) {
                that.addError("object declaration may not be annotated 'formal'", 1312);
            } else {
                model.setFormal(true);
            }
        }
        if (model.isFormal() && model.isDefault()) {
            that.addError("declaration may not be annotated both 'formal' and 'default'", 1320);
        }
        if (model.isStatic() && model.isActual()) {
            that.addError("static member may not be annotated 'actual'", 1311);
        }
        if (model.isStatic() && model.isFormal()) {
            that.addError("static member may not be annotated 'formal'", 1312);
        }
        if (model.isStatic() && model.isDefault()) {
            that.addError("static member may not be annotated 'default'", 1313);
        }
        Tree.Annotation na = TreeUtil.getAnnotation(al, "native", this.unit);
        Backends backends = Backends.ANY;
        if (na != null) {
            int cnt = TreeUtil.getAnnotationArgumentCount(na);
            if (cnt == 0) {
                backends = Backends.HEADER;
            } else {
                for (int i = 0; i < cnt; ++i) {
                    String be = TreeUtil.getAnnotationArgument(na, i);
                    Backend backend = Backend.fromAnnotation(be);
                    if (backend == null) continue;
                    if (!backend.isRegistered()) {
                        na.addError("illegal native backend name: '\"" + backend.nativeAnnotation + "\"' (must be either '\"jvm\"' or '\"js\"')");
                    }
                    backends = backends.merged(backend);
                }
            }
        }
        model.setNativeBackends(backends);
        if (model.isNative() && model.isFormal()) {
            that.addError("declaration may not be annotated both 'formal' and 'native'");
        }
        if (TreeUtil.hasAnnotation(al, "actual", this.unit)) {
            model.setActual(true);
        }
        if (TreeUtil.hasAnnotation(al, "abstract", this.unit)) {
            if (model instanceof Class) {
                ((Class)model).setAbstract(true);
            } else if (ModelUtil.isConstructor(model)) {
                if (!(model instanceof Constructor)) {
                    if (model instanceof Function) {
                        ((Constructor)((Function)model).getTypeDeclaration()).setAbstract(true);
                    } else {
                        that.addError("declaration is not a callable constructor, and may not be annotated 'abstract'", 1800);
                    }
                }
            } else {
                that.addError("declaration is not a class, and may not be annotated 'abstract'", 1600);
            }
        }
        if (TreeUtil.hasAnnotation(al, "final", this.unit)) {
            if (model instanceof ClassAlias) {
                that.addError("declaration is a class alias, and may not be annotated 'final'", 1700);
            } else if (model instanceof Class) {
                ((Class)model).setFinal(true);
            } else {
                that.addError("declaration is not a class, and may not be annotated 'final'", 1700);
            }
        }
        if (TreeUtil.hasAnnotation(al, "sealed", this.unit)) {
            if (model instanceof ClassOrInterface) {
                ((ClassOrInterface)model).setSealed(true);
            } else if (ModelUtil.isConstructor(model)) {
                if (!(model instanceof Constructor)) {
                    if (model instanceof Function) {
                        ((Function)model).getTypeDeclaration().setSealed(true);
                    } else {
                        that.addError("declaration is not a callable constructor, and may not be annotated 'sealed'", 1800);
                    }
                }
            } else {
                that.addError("declaration is not a class or interface, and may not be annotated 'sealed'", 1800);
            }
        }
        if (TreeUtil.hasAnnotation(al, "variable", this.unit)) {
            if (model instanceof Value) {
                ((Value)model).setVariable(true);
            } else {
                that.addError("declaration is not a value, and may not be annotated 'variable'", 1500);
            }
        }
        if (TreeUtil.hasAnnotation(al, "late", this.unit)) {
            if (model instanceof Value) {
                if (that instanceof Tree.AttributeDeclaration) {
                    Tree.AttributeDeclaration ad = (Tree.AttributeDeclaration)that;
                    ((Value)model).setLate(true);
                } else {
                    that.addError("value is not a reference, and may not be annotated 'late'", 1900);
                }
            } else {
                that.addError("declaration is not a value, and may not be annotated 'late'", 1900);
            }
        }
        if (model instanceof Value && (value = (Value)model).isVariable() && value.isTransient()) {
            that.addError("getter may not be annotated 'variable' (define a setter with 'assign' instead)", 1501);
        }
        if (TreeUtil.hasAnnotation(al, "deprecated", this.unit)) {
            model.setDeprecated(true);
        }
        if (TreeUtil.hasAnnotation(al, "annotation", this.unit)) {
            if (!(model instanceof Function) && !(model instanceof Class)) {
                that.addError("declaration is not a function or class, and may not be annotated 'annotation'", 1950);
            } else if (!model.isToplevel()) {
                that.addError("declaration is not toplevel, and may not be annotated 'annotation'", 1951);
            } else {
                model.setAnnotation(true);
            }
        }
        if (TreeUtil.hasAnnotation(al, "serializable", this.unit)) {
            if (model instanceof Class) {
                ((Class)model).setSerializable(true);
            } else {
                that.addError("declaration is not a class, and may not be annotated 'serializable'", 1600);
            }
        }
        if (TreeUtil.hasAnnotation(al, "aliased", this.unit)) {
            Tree.Annotation aliased = TreeUtil.getAnnotation(al, "aliased", this.unit);
            List<String> aliases = TreeUtil.getAnnotationSequenceArgument(aliased);
            model.setAliases(aliases);
        }
        if (TreeUtil.hasAnnotation(al, "service", this.unit)) {
            if (!(model instanceof Class) || !model.isToplevel()) {
                that.addError("declaration is not a toplevel class, and may not be annotated 'service'");
            } else if (!model.isShared()) {
                that.addError("class is not shared, and may not be annotated 'service'", 705);
            } else if (((Class)model).isAbstract()) {
                that.addError("class is abstract, and may not be annotated 'service'", 1601);
            }
        }
        if (TreeUtil.hasAnnotation(al, "doc", this.unit) && TreeUtil.hasAnonymousAnnotation(al)) {
            TreeUtil.getAnnotation(al, "doc", this.unit).addError("documentation already specified");
        }
        TreeUtil.buildAnnotations(al, model.getAnnotations());
    }

    public static void setVisibleScope(Declaration model) {
        ModelUtil.setVisibleScope(model);
    }

    private static void checkFormalMember(Tree.Declaration that, Declaration d) {
        Scope container = d.getContainer();
        if (d.isFormal()) {
            if (!(container instanceof ClassOrInterface)) {
                that.addError("formal member does not belong to an interface or abstract class", 1100);
            }
            if (!(that instanceof Tree.AttributeDeclaration || that instanceof Tree.MethodDeclaration || that instanceof Tree.AnyClass)) {
                that.addError("formal member may not have a body", 1101);
            }
        }
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        Declaration d = this.beginDeclaration(that.getDeclarationModel());
        super.visit(that);
        this.endDeclaration(d);
    }

    TypeParameter searchForTypeParameter(String name, Generic g) {
        for (TypeParameter tp : g.getTypeParameters()) {
            if (!tp.isTypeConstructor()) continue;
            TypeParameter p = (TypeParameter)tp.getDirectMember(name, null, false);
            if (p == null) {
                p = this.searchForTypeParameter(name, tp);
            }
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public void visit(Tree.TypeConstraint that) {
        String name = TreeUtil.name(that.getIdentifier());
        TypeParameter p = (TypeParameter)this.scope.getDirectMember(name, null, false);
        if (p == null && this.scope instanceof Generic) {
            Generic g = (Generic)((Object)this.scope);
            p = this.searchForTypeParameter(name, g);
        }
        that.setDeclarationModel(p);
        if (p == null) {
            that.addError("no matching type parameter for constraint: '" + name + "'", 2500);
            p = new TypeParameter();
            p.setDeclaration(this.declaration);
            that.setDeclarationModel(p);
            this.visitDeclaration(that, p);
        } else {
            if (that.getTypeParameterList() != null) {
                p.setTypeConstructor(true);
            }
            if (p.isConstrained()) {
                that.addError("duplicate constraint list for type parameter: '" + name + "'");
            }
            p.setConstrained(true);
        }
        Scope o = this.enterScope(p);
        super.visit(that);
        this.exitScope(o);
        if (that.getAbstractedType() != null) {
            that.addUnsupportedError("lower bound type constraints are not yet supported");
        }
    }

    @Override
    public void visit(Tree.ParameterizedExpression that) {
        super.visit(that);
        DeclarationVisitor.setParameterLists(null, that.getParameterLists(), that);
        if (!that.getLeftTerm()) {
            that.addError("parameterized expression not the target of a specification statement: parameter list is not followed by '=>' specifier (add '=>' specifier, or explicitly specify 'function' keyword or return type)");
        }
    }

    @Override
    public void visit(Tree.SpecifierStatement that) {
        Tree.Term lhs = that.getBaseMemberExpression();
        if (lhs instanceof Tree.ParameterizedExpression) {
            Tree.ParameterizedExpression pe = (Tree.ParameterizedExpression)lhs;
            pe.setLeftTerm(true);
        }
        Specification s = new Specification();
        s.setId(this.id++);
        this.visitElement(that, s);
        Scope o = this.enterScope(s);
        super.visit(that);
        this.exitScope(o);
    }

    @Override
    public void visit(Tree.SatisfiesCondition that) {
        super.visit(that);
        that.addUnsupportedError("satisfies conditions are not yet supported");
    }

    @Override
    public void visit(Tree.Assertion that) {
        Tree.ConditionList cl = that.getConditionList();
        if (cl != null) {
            for (Tree.Condition c : cl.getConditions()) {
                c.setAssertion(true);
            }
        }
        Declaration d = this.beginDeclaration(null);
        super.visit(that);
        this.endDeclaration(d);
    }

    @Override
    public void visit(Tree.Annotation that) {
        super.visit(that);
        that.getPrimary().setScope(this.pkg);
    }

    @Override
    public void visit(Tree.TypeArgumentList that) {
        super.visit(that);
    }

    @Override
    public void visit(Tree.PositionalArgumentList that) {
        super.visit(that);
        this.checkPositionalArguments(that.getPositionalArguments());
    }

    @Override
    public void visit(Tree.SequencedArgument that) {
        super.visit(that);
        this.checkPositionalArguments(that.getPositionalArguments());
    }

    private void checkPositionalArguments(List<Tree.PositionalArgument> args) {
        for (int i = 0; i < args.size() - 1; ++i) {
            Tree.PositionalArgument a = args.get(i);
            if (a instanceof Tree.SpreadArgument) {
                a.addError("spread argument must be the last argument in the argument list");
            }
            if (!(a instanceof Tree.Comprehension)) continue;
            a.addError("comprehension must be the last argument in the argument list");
        }
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        super.visit(that);
        if (that.getTryClause().getBlock() != null && that.getCatchClauses().isEmpty() && that.getFinallyClause() == null && that.getTryClause().getResourceList() == null) {
            that.addError("try must have a catch, finally, or resource expression");
        }
    }

    @Override
    public void visit(Tree.Import that) {
        super.visit(that);
        Tree.ImportPath path = that.getImportPath();
        if (path != null) {
            boolean languagePackage = TreeUtil.formatPath(path.getIdentifiers()).equals("ceylon.language");
            Tree.ImportMemberOrTypeList imtl = that.getImportMemberOrTypeList();
            if (imtl != null) {
                Map<String, String> mods = this.unit.getModifiers();
                for (Tree.ImportMemberOrType imt : imtl.getImportMemberOrTypes()) {
                    String alias;
                    Tree.Identifier aid;
                    Tree.Alias a = imt.getAlias();
                    Tree.Identifier id = imt.getIdentifier();
                    if (id == null) continue;
                    String name = TreeUtil.name(id);
                    if (languagePackage) {
                        if (a == null) continue;
                        aid = a.getIdentifier();
                        alias = TreeUtil.name(aid);
                        if (!mods.containsKey(name)) continue;
                        mods.put(name, alias);
                        continue;
                    }
                    if (a == null) {
                        if (!mods.containsKey(name) || !name.equals(mods.get(name))) continue;
                        mods.put(name, "$");
                        continue;
                    }
                    aid = a.getIdentifier();
                    alias = TreeUtil.name(aid);
                    if (!mods.containsKey(alias) || !alias.equals(mods.get(alias))) continue;
                    mods.put(alias, "$");
                }
            }
        }
    }

    @Override
    public void visit(Tree.MetaLiteral that) {
        this.declarationReference = that instanceof Tree.ClassLiteral || that instanceof Tree.InterfaceLiteral || that instanceof Tree.NewLiteral || that instanceof Tree.AliasLiteral || that instanceof Tree.TypeParameterLiteral || that instanceof Tree.ValueLiteral || that instanceof Tree.FunctionLiteral;
        super.visit(that);
        this.declarationReference = false;
    }

    @Override
    public void visit(Tree.StaticType that) {
        that.setMetamodel(this.declarationReference);
        super.visit(that);
    }

    @Override
    public void visit(Tree.BaseType that) {
        super.visit(that);
        final Scope scope = that.getScope();
        final String name = TreeUtil.name(that.getIdentifier());
        if (this.inExtends) {
            final Tree.TypeArgumentList tal = that.getTypeArgumentList();
            final boolean packageQualified = that.getPackageQualified();
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    return packageQualified ? AnalyzerUtil.getPackageTypeDeclaration(name, null, false, DeclarationVisitor.this.unit) : AnalyzerUtil.getTypeDeclaration(scope, name, null, false, DeclarationVisitor.this.unit);
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    TypeDeclaration dec = this.getDeclaration();
                    List<TypeParameter> tps = dec.getTypeParameters();
                    return ModelUtil.getTypeArgumentMap(dec, null, AnalyzerUtil.getTypeArguments(tal, null, tps));
                }

                @Override
                public Map<TypeParameter, SiteVariance> initVarianceOverrides() {
                    TypeDeclaration dec = this.getDeclaration();
                    List<TypeParameter> tps = dec.getTypeParameters();
                    return ModelUtil.getVarianceMap(dec, null, AnalyzerUtil.getVariances(tal, tps));
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.QualifiedType that) {
        super.visit(that);
        final String name = TreeUtil.name(that.getIdentifier());
        final Tree.StaticType outerType = that.getOuterType();
        if (this.inExtends) {
            final Tree.TypeArgumentList tal = that.getTypeArgumentList();
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    if (outerType == null) {
                        return null;
                    }
                    TypeDeclaration dec = outerType.getTypeModel().getDeclaration();
                    return AnalyzerUtil.getTypeMember(dec, name, null, false, DeclarationVisitor.this.unit, DeclarationVisitor.this.scope);
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    if (outerType == null) {
                        return Collections.emptyMap();
                    }
                    TypeDeclaration dec = this.getDeclaration();
                    List<TypeParameter> tps = dec.getTypeParameters();
                    Type ot = outerType.getTypeModel();
                    return ModelUtil.getTypeArgumentMap(dec, ot, AnalyzerUtil.getTypeArguments(tal, ot, tps));
                }

                @Override
                public Map<TypeParameter, SiteVariance> initVarianceOverrides() {
                    TypeDeclaration dec = this.getDeclaration();
                    List<TypeParameter> tps = dec.getTypeParameters();
                    Type ot = outerType.getTypeModel();
                    return ModelUtil.getVarianceMap(dec, ot, AnalyzerUtil.getVariances(tal, tps));
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.IterableType that) {
        super.visit(that);
        if (this.inExtends) {
            final Tree.Type elem = that.getElementType();
            LazyType t = new LazyType(this.unit){

                Type iterableType() {
                    boolean atLeastOne;
                    Type elementType;
                    if (elem == null) {
                        elementType = DeclarationVisitor.this.unit.getNothingType();
                        atLeastOne = false;
                    } else if (elem instanceof Tree.SequencedType) {
                        Tree.SequencedType set = (Tree.SequencedType)elem;
                        elementType = set.getType().getTypeModel();
                        atLeastOne = set.getAtLeastOne();
                    } else {
                        elementType = null;
                        atLeastOne = false;
                    }
                    if (elementType != null) {
                        return atLeastOne ? DeclarationVisitor.this.unit.getNonemptyIterableType(elementType) : DeclarationVisitor.this.unit.getIterableType(elementType);
                    }
                    Type ut = new UnknownType(DeclarationVisitor.this.unit).getType();
                    return DeclarationVisitor.this.unit.getIterableType(ut);
                }

                @Override
                public boolean isUnknown() {
                    return false;
                }

                @Override
                public TypeDeclaration initDeclaration() {
                    return this.iterableType().getDeclaration();
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return this.iterableType().getTypeArguments();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.TupleType that) {
        super.visit(that);
        if (this.inExtends) {
            final List<Tree.Type> ets = that.getElementTypes();
            LazyType t = new LazyType(this.unit){

                private Type tupleType() {
                    return TypeVisitor.getTupleType(ets, DeclarationVisitor.this.unit);
                }

                @Override
                public TypeDeclaration initDeclaration() {
                    return this.tupleType().getDeclaration();
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return this.tupleType().getTypeArguments();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.OptionalType that) {
        super.visit(that);
        final Tree.StaticType definiteType = that.getDefiniteType();
        if (this.inExtends) {
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    ArrayList<Type> types = new ArrayList<Type>(2);
                    types.add(DeclarationVisitor.this.unit.getNullType());
                    if (definiteType != null) {
                        types.add(definiteType.getTypeModel());
                    }
                    UnionType ut = new UnionType(DeclarationVisitor.this.unit);
                    ut.setCaseTypes(types);
                    return ut;
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return Collections.emptyMap();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.UnionType that) {
        super.visit(that);
        final List<Tree.StaticType> sts = that.getStaticTypes();
        if (this.inExtends) {
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    ArrayList<Type> types = new ArrayList<Type>(sts.size());
                    for (Tree.StaticType st : sts) {
                        Type t = st.getTypeModel();
                        if (t == null) continue;
                        types.add(t);
                    }
                    UnionType ut = new UnionType(DeclarationVisitor.this.unit);
                    ut.setCaseTypes(types);
                    return ut;
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return Collections.emptyMap();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.IntersectionType that) {
        super.visit(that);
        if (this.inExtends) {
            final List<Tree.StaticType> sts = that.getStaticTypes();
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    ArrayList<Type> types = new ArrayList<Type>(sts.size());
                    for (Tree.StaticType st : sts) {
                        Type t = st.getTypeModel();
                        if (t == null) continue;
                        types.add(t);
                    }
                    IntersectionType it = new IntersectionType(DeclarationVisitor.this.unit);
                    it.setSatisfiedTypes(types);
                    return it;
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return Collections.emptyMap();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.SequenceType that) {
        super.visit(that);
        if (this.inExtends) {
            LazyType t;
            final Tree.StaticType elementType = that.getElementType();
            Tree.NaturalLiteral length = that.getLength();
            if (length == null) {
                t = new LazyType(this.unit){

                    @Override
                    public boolean isUnknown() {
                        return false;
                    }

                    @Override
                    public TypeDeclaration initDeclaration() {
                        return DeclarationVisitor.this.unit.getSequentialDeclaration();
                    }

                    @Override
                    public Map<TypeParameter, Type> initTypeArguments() {
                        List<TypeParameter> stps = DeclarationVisitor.this.unit.getSequentialDeclaration().getTypeParameters();
                        return Collections.singletonMap(stps.get(0), elementType.getTypeModel());
                    }
                };
            } else {
                int len;
                try {
                    len = Integer.parseInt(length.getText());
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                if (len < 1 || len > 1000) {
                    return;
                }
                t = new StaticLengthSequenceType(elementType, len);
            }
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.SequencedType that) {
        super.visit(that);
        if (this.inExtends) {
            final Type type = that.getType().getTypeModel();
            final boolean atLeastOne = that.getAtLeastOne();
            LazyType t = new LazyType(this.unit){

                @Override
                public boolean isUnknown() {
                    return false;
                }

                @Override
                public TypeDeclaration initDeclaration() {
                    return atLeastOne ? DeclarationVisitor.this.unit.getSequenceDeclaration() : DeclarationVisitor.this.unit.getSequentialDeclaration();
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    Interface dec = atLeastOne ? DeclarationVisitor.this.unit.getSequenceDeclaration() : DeclarationVisitor.this.unit.getSequentialDeclaration();
                    List<TypeParameter> stps = dec.getTypeParameters();
                    return Collections.singletonMap(stps.get(0), type);
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.EntryType that) {
        super.visit(that);
        if (this.inExtends) {
            final Tree.StaticType keyType = that.getKeyType();
            final Tree.StaticType valueType = that.getValueType();
            LazyType t = new LazyType(this.unit){

                @Override
                public boolean isUnknown() {
                    return false;
                }

                @Override
                public TypeDeclaration initDeclaration() {
                    return DeclarationVisitor.this.unit.getEntryDeclaration();
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    HashMap<TypeParameter, Type> map = new HashMap<TypeParameter, Type>();
                    List<TypeParameter> itps = DeclarationVisitor.this.unit.getEntryDeclaration().getTypeParameters();
                    map.put(itps.get(0), keyType.getTypeModel());
                    map.put(itps.get(1), valueType.getTypeModel());
                    return map;
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.FunctionType that) {
        Tree.StaticType rt;
        super.visit(that);
        if (this.inExtends && (rt = that.getReturnType()) != null) {
            final List<Tree.Type> args = that.getArgumentTypes();
            LazyType t = new LazyType(this.unit){

                @Override
                public boolean isUnknown() {
                    return false;
                }

                @Override
                public TypeDeclaration initDeclaration() {
                    return DeclarationVisitor.this.unit.getCallableDeclaration();
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    HashMap<TypeParameter, Type> map = new HashMap<TypeParameter, Type>();
                    List<TypeParameter> ctps = DeclarationVisitor.this.unit.getCallableDeclaration().getTypeParameters();
                    map.put(ctps.get(0), rt.getTypeModel());
                    map.put(ctps.get(1), TypeVisitor.getTupleType(args, DeclarationVisitor.this.unit));
                    return map;
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.TypeConstructor that) {
        TypeAlias ta = new TypeAlias();
        ta.setShared(true);
        ta.setName("Anonymous#" + this.fid++);
        ta.setAnonymous(true);
        this.visitElement(that, ta);
        DeclarationVisitor.setVisibleScope(ta);
        Scope o = this.enterScope(ta);
        Declaration od = this.beginDeclaration(ta);
        super.visit(that);
        this.endDeclaration(od);
        this.exitScope(o);
        ta.setExtendedType(that.getType().getTypeModel());
        that.setDeclarationModel(ta);
        Type pt = ta.getType();
        pt.setTypeConstructor(true);
        that.setTypeModel(pt);
    }

    @Override
    public void visit(Tree.SuperType that) {
        super.visit(that);
        if (this.inExtends) {
            final Scope scope = that.getScope();
            LazyType t = new LazyType(this.unit){

                @Override
                public TypeDeclaration initDeclaration() {
                    ClassOrInterface ci = ModelUtil.getContainingClassOrInterface(scope);
                    if (ci == null) {
                        return null;
                    }
                    if (ci.isClassOrInterfaceMember()) {
                        ClassOrInterface oci = (ClassOrInterface)ci.getContainer();
                        return ModelUtil.intersectionOfSupertypes(oci).getDeclaration();
                    }
                    return null;
                }

                @Override
                public Map<TypeParameter, Type> initTypeArguments() {
                    return Collections.emptyMap();
                }
            };
            that.setTypeModel(t);
        }
    }

    @Override
    public void visit(Tree.GroupedType that) {
        super.visit(that);
        Tree.StaticType type = that.getType();
        if (type != null) {
            that.setTypeModel(type.getTypeModel());
        }
    }

    @Override
    public void visit(Tree.ExtendedType that) {
        this.inExtends = true;
        super.visit(that);
        this.inExtends = false;
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (!td.isAlias()) {
            Tree.SimpleType type = that.getType();
            if (type == null) {
                that.addError("missing extended type");
            } else {
                Type et = type.getTypeModel();
                if (et != null) {
                    td.setExtendedType(et);
                }
            }
        }
    }

    @Override
    public void visit(Tree.SatisfiedTypes that) {
        this.inExtends = true;
        super.visit(that);
        this.inExtends = false;
        TypeDeclaration td = (TypeDeclaration)that.getScope();
        if (td.isAlias()) {
            return;
        }
        List<Tree.StaticType> types = that.getTypes();
        ArrayList<Type> list = new ArrayList<Type>(types.size());
        for (Tree.StaticType st : types) {
            Type type;
            if (st == null || (type = st.getTypeModel()) == null) continue;
            list.add(type);
        }
        td.setSatisfiedTypes(list);
    }

    @Override
    public void visit(Tree.ClassSpecifier that) {
        this.inExtends = true;
        super.visit(that);
        this.inExtends = false;
        Tree.SimpleType type = that.getType();
        if (type == null) {
            that.addError("missing aliased type");
        } else if (that.getInvocationExpression() == null) {
            that.addError("missing instantiation arguments");
        } else {
            TypeDeclaration td = (TypeDeclaration)that.getScope();
            Type at = type.getTypeModel();
            if (at != null) {
                td.setExtendedType(at);
            }
            DeclarationVisitor.checkSpecifierSymbol(that);
        }
    }

    @Override
    public void visit(Tree.TypeSpecifier that) {
        this.inExtends = true;
        super.visit(that);
        this.inExtends = false;
        Tree.StaticType type = that.getType();
        if (type == null) {
            that.addError("missing aliased type");
        } else if (!(that instanceof Tree.DefaultTypeArgument)) {
            TypeDeclaration td = (TypeDeclaration)that.getScope();
            Type at = type.getTypeModel();
            if (at != null) {
                td.setExtendedType(at);
            }
            DeclarationVisitor.checkSpecifierSymbol(that);
        }
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        super.visit(that);
        DeclarationVisitor.checkSpecifierSymbol(that);
    }

    private static void checkSpecifierSymbol(Node that) {
        if (that.getMainToken().getType() == 109) {
            that.addError("incorrect syntax: expression must be specified using =>", 1050);
        }
    }

    private final class StaticLengthSequenceType
    extends LazyType {
        private final Tree.StaticType elementType;
        private final int len;

        private StaticLengthSequenceType(Tree.StaticType elementType, int len) {
            super(DeclarationVisitor.this.unit);
            this.elementType = elementType;
            this.len = len;
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public TypeDeclaration initDeclaration() {
            return DeclarationVisitor.this.unit.getTupleDeclaration();
        }

        @Override
        public Map<TypeParameter, Type> initTypeArguments() {
            List<TypeParameter> stps = DeclarationVisitor.this.unit.getTupleDeclaration().getTypeParameters();
            HashMap<TypeParameter, Type> args = new HashMap<TypeParameter, Type>(3);
            Type et = this.elementType.getTypeModel();
            args.put(stps.get(0), et);
            args.put(stps.get(1), et);
            args.put(stps.get(2), this.len == 1 ? DeclarationVisitor.this.unit.getEmptyType() : new StaticLengthSequenceType(this.elementType, this.len - 1));
            return args;
        }
    }
}

