/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.analyzer;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ModuleVisitor
extends Visitor {
    private Module mainModule;
    private final ModuleManager moduleManager;
    private final ModuleSourceMapper moduleManagerUtil;
    private final Package pkg;
    private Tree.CompilationUnit unit;
    private Phase phase = Phase.SRC_MODULE;
    private boolean completeOnlyAST = false;
    private Backends moduleBackends = Backends.ANY;
    private boolean moduleFile;

    public void setCompleteOnlyAST(boolean completeOnlyAST) {
        this.completeOnlyAST = completeOnlyAST;
    }

    public boolean isCompleteOnlyAST() {
        return this.completeOnlyAST;
    }

    public ModuleVisitor(ModuleManager moduleManager, ModuleSourceMapper moduleManagerUtil, Package pkg, boolean moduleFile) {
        this.moduleManager = moduleManager;
        this.moduleManagerUtil = moduleManagerUtil;
        this.pkg = pkg;
        this.moduleFile = moduleFile;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        this.unit = that;
        if (this.moduleFile && that.getModuleDescriptors().isEmpty()) {
            that.addError("missing module descriptor");
        }
        if (!this.moduleFile && that.getPackageDescriptors().isEmpty()) {
            that.addError("missing package descriptor");
        }
        super.visit(that);
    }

    private static String removeQuotes(String quoted) {
        return quoted.substring(1, quoted.length() - 1);
    }

    private static String getVersionString(Tree.QuotedLiteral quoted, Node that) {
        int codePoint;
        if (quoted == null) {
            that.addError("missing version");
            return "0";
        }
        String versionString = quoted.getText();
        for (int i = 0; i < versionString.length(); i += Character.charCount(codePoint)) {
            codePoint = versionString.codePointAt(i);
            if (!Character.isWhitespace(codePoint)) continue;
            quoted.addError("module version may not contain whitespace");
            break;
        }
        if (versionString.length() < 2) {
            return "";
        }
        if (versionString.charAt(0) == '\'') {
            quoted.addError("module version should be double-quoted");
        }
        return ModuleVisitor.removeQuotes(versionString);
    }

    private static String getNameString(Tree.QuotedLiteral quoted) {
        return ModuleVisitor.getNameString(quoted, true);
    }

    private static String getNameString(Tree.QuotedLiteral quoted, boolean addErrorOnInvalidQuotes) {
        int codePoint;
        String nameString = quoted.getText();
        if (nameString.length() < 2) {
            return "";
        }
        for (int i = 0; i < nameString.length(); i += Character.charCount(codePoint)) {
            codePoint = nameString.codePointAt(i);
            if (!Character.isWhitespace(codePoint)) continue;
            quoted.addError("module name may not contain whitespace");
            break;
        }
        if (addErrorOnInvalidQuotes && nameString.charAt(0) == '\'') {
            quoted.addError("module name should be double-quoted");
        }
        return ModuleVisitor.removeQuotes(nameString);
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        this.moduleBackends = TreeUtil.getNativeBackend(that.getAnnotationList(), that.getUnit());
        super.visit(that);
        if (this.phase == Phase.SRC_MODULE) {
            String version2 = ModuleVisitor.getVersionString(that.getVersion(), that);
            Tree.ImportPath importPath = that.getImportPath();
            List<String> name = this.getNameAsList(importPath);
            if (this.pkg.getNameAsString().isEmpty()) {
                that.addError("module descriptor encountered in root source directory");
            } else if (name.isEmpty()) {
                that.addError("missing module name");
            } else {
                String initialName = name.get(0);
                Backends unitBackends = this.unit.getUnit().getSupportedBackends();
                if (initialName.equals("default")) {
                    importPath.addError("reserved module name: 'default'");
                } else if (name.size() == 1 && initialName.equals("ceylon")) {
                    importPath.addError("reserved module name: 'ceylon'");
                } else if (!this.moduleBackends.none() && this.moduleBackends.header()) {
                    that.addError("missing backend argument for native annotation on module: " + TreeUtil.formatPath(that.getImportPath().getIdentifiers()));
                } else if (!(this.moduleBackends.none() || unitBackends.none() || unitBackends.supports(this.moduleBackends))) {
                    that.addError("module not meant for this backend: " + TreeUtil.formatPath(that.getImportPath().getIdentifiers()));
                } else {
                    if (initialName.equals("ceylon")) {
                        importPath.addUsageWarning(Warning.ceylonNamespace, "discouraged module name: this namespace is used by Ceylon platform modules");
                    } else if (initialName.equals("java") || initialName.equals("javax")) {
                        importPath.addUnsupportedError("unsupported module name: this namespace is used by Java platform modules");
                    }
                    this.mainModule = this.moduleManager.getOrCreateModule(name, version2);
                    importPath.setModel(this.mainModule);
                    if (!this.completeOnlyAST) {
                        this.mainModule.setUnit(this.unit.getUnit());
                        this.mainModule.setVersion(version2);
                    }
                    String nameString = TreeUtil.formatPath(importPath.getIdentifiers());
                    if (!this.pkg.getNameAsString().equals(nameString)) {
                        importPath.addError("module name does not match descriptor location: '" + nameString + "' should be '" + this.pkg.getNameAsString() + "'", 8000);
                    }
                    if (!this.completeOnlyAST) {
                        this.moduleManagerUtil.addLinkBetweenModuleAndNode(this.mainModule, that);
                        this.mainModule.setAvailable(true);
                        this.mainModule.getAnnotations().clear();
                        TreeUtil.buildAnnotations(that.getAnnotationList(), this.mainModule.getAnnotations());
                        this.mainModule.setNativeBackends(this.moduleBackends);
                        if (that.getArtifact() != null) {
                            this.mainModule.setArtifactId(ModuleVisitor.getNameString(that.getArtifact()));
                        }
                        if (that.getGroupImportPath() != null) {
                            this.mainModule.setGroupId(TreeUtil.formatPath(that.getGroupImportPath().getIdentifiers()));
                        } else if (that.getGroupQuotedLiteral() != null) {
                            this.mainModule.setGroupId(ModuleVisitor.getNameString(that.getGroupQuotedLiteral()));
                        }
                    }
                }
            }
            HashSet<String> set = new HashSet<String>();
            Tree.ImportModuleList iml = that.getImportModuleList();
            if (iml != null) {
                for (Tree.ImportModule im : iml.getImportModules()) {
                    String path = im.getName();
                    if (path == null || set.add(path)) continue;
                    im.addError("duplicate module import: '" + path + "'");
                }
            }
        }
        this.moduleBackends = Backends.ANY;
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        super.visit(that);
        if (this.phase == Phase.REMAINING) {
            Tree.ImportPath importPath = that.getImportPath();
            List<String> name = this.getNameAsList(importPath);
            if (this.pkg.getNameAsString().isEmpty()) {
                that.addError("package descriptor encountered in root source directory");
            } else if (name.isEmpty()) {
                that.addError("missing package name");
            } else if (name.get(0).equals("default")) {
                importPath.addError("reserved module name: 'default'");
            } else if (name.size() == 1 && name.get(0).equals("ceylon")) {
                importPath.addError("reserved module name: 'ceylon'");
            } else {
                if (name.get(0).equals("ceylon")) {
                    importPath.addUsageWarning(Warning.ceylonNamespace, "discouraged package name: this namespace is used by Ceylon platform modules");
                } else if (name.get(0).equals("java") || name.get(0).equals("javax")) {
                    importPath.addUsageWarning(Warning.javaNamespace, "discouraged package name: this namespace is used by Java platform modules");
                }
                importPath.setModel(this.pkg);
                Unit u = this.unit.getUnit();
                if (!this.completeOnlyAST) {
                    this.pkg.setUnit(u);
                }
                String nameString = TreeUtil.formatPath(importPath.getIdentifiers());
                if (!this.pkg.getNameAsString().equals(nameString)) {
                    importPath.addError("package name does not match descriptor location: '" + nameString + "' should be '" + this.pkg.getNameAsString() + "'", 8000);
                }
                if (!this.completeOnlyAST) {
                    Tree.AnnotationList al = that.getAnnotationList();
                    if (TreeUtil.hasAnnotation(al, "shared", u)) {
                        this.pkg.setShared(true);
                    } else {
                        this.pkg.setShared(false);
                    }
                    this.pkg.getAnnotations().clear();
                    TreeUtil.buildAnnotations(al, this.pkg.getAnnotations());
                }
            }
        }
    }

    @Override
    public void visit(Tree.ImportModule that) {
        String path;
        Tree.QuotedLiteral artifact;
        Node node;
        List<String> name;
        super.visit(that);
        String version2 = ModuleVisitor.getVersionString(that.getVersion(), that);
        Tree.ImportPath importPath = that.getImportPath();
        Tree.QuotedLiteral quotedLiteral = that.getQuotedLiteral();
        if (importPath != null) {
            name = this.getNameAsList(importPath);
            node = importPath;
        } else if (quotedLiteral != null) {
            String nameString = ModuleVisitor.getNameString(quotedLiteral);
            name = Arrays.asList(nameString.split("\\."));
            node = quotedLiteral;
        } else {
            name = Collections.emptyList();
            node = null;
        }
        if (node != null && (artifact = that.getArtifact()) != null) {
            name = new ArrayList<String>(name);
            String nameString = ModuleVisitor.getNameString(artifact);
            name.add("");
            name.addAll(Arrays.asList(nameString.split("\\.")));
        }
        if (this.phase == Phase.SRC_MODULE) {
            path = ModelUtil.formatPath(name);
            that.setName(path);
        } else if (this.phase == Phase.REMAINING) {
            boolean forCeylon;
            path = that.getName();
            Tree.Identifier ns = that.getNamespace();
            String namespace = ns != null ? ns.getText() : null;
            boolean hasMavenName = ModuleUtil.isMavenModule(path);
            boolean bl = forCeylon = importPath != null && namespace == null || importPath == null && namespace == null && !hasMavenName || "ceylon".equals(namespace);
            if (name.isEmpty()) {
                that.addError("missing module name");
            } else if (name.get(0).equals("default")) {
                if (forCeylon) {
                    node.addError("reserved module name: 'default'");
                }
            } else if (name.size() == 1 && name.get(0).equals("ceylon")) {
                if (forCeylon) {
                    node.addError("reserved module name: 'ceylon'");
                }
            } else if (name.size() > 1 && name.get(0).equals("ceylon") && name.get(1).equals("language")) {
                if (forCeylon) {
                    node.addError("the language module is imported implicitly");
                }
            } else {
                Unit u;
                Tree.AnnotationList al;
                Backends bs;
                if (namespace == null && hasMavenName) {
                    namespace = "maven";
                    node.addUsageWarning(Warning.missingImportPrefix, "use of old style Maven imports is deprecated, prefix with 'maven:'");
                }
                if (!(bs = TreeUtil.getNativeBackend(al = that.getAnnotationList(), u = this.unit.getUnit())).none()) {
                    for (Backend b : bs) {
                        if (b.isRegistered()) continue;
                        node.addError("illegal native backend name: '\"" + b.nativeAnnotation + "\"' (must be either '\"jvm\"' or '\"js\"')");
                    }
                    if (!this.moduleBackends.none() && !this.moduleBackends.supports(bs)) {
                        node.addError("native backend name on import conflicts with module descriptor: '\"" + bs.names() + "\"' is not in '\"" + this.moduleBackends.names() + "\"'");
                    }
                }
                Module importedModule = this.moduleManager.getOrCreateModule(name, version2);
                if (importPath != null) {
                    importPath.setModel(importedModule);
                }
                if (!this.completeOnlyAST && this.mainModule != null) {
                    ModuleImport moduleImport;
                    if (importedModule.getVersion() == null) {
                        importedModule.setVersion(version2);
                    }
                    if ((moduleImport = this.moduleManager.findImport(this.mainModule, importedModule)) == null) {
                        boolean optional = TreeUtil.hasAnnotation(al, "optional", u);
                        boolean export = TreeUtil.hasAnnotation(al, "shared", u);
                        moduleImport = new ModuleImport(namespace, importedModule, optional, export, bs);
                        moduleImport.getAnnotations().clear();
                        TreeUtil.buildAnnotations(al, moduleImport.getAnnotations());
                        this.mainModule.addImport(moduleImport);
                    }
                    this.moduleManagerUtil.addModuleDependencyDefinition(moduleImport, that);
                }
            }
        }
    }

    private List<String> getNameAsList(Tree.ImportPath that) {
        ArrayList<String> name = new ArrayList<String>();
        for (Tree.Identifier i : that.getIdentifiers()) {
            name.add(i.getText());
        }
        return name;
    }

    public Module getMainModule() {
        return this.mainModule;
    }

    @Override
    public void visit(Tree.Import that) {
        Tree.ImportMemberOrTypeList imtl;
        super.visit(that);
        Tree.ImportPath path = that.getImportPath();
        if (path != null && TreeUtil.formatPath(path.getIdentifiers()).equals("ceylon.language") && (imtl = that.getImportMemberOrTypeList()) != null) {
            for (Tree.ImportMemberOrType imt : imtl.getImportMemberOrTypes()) {
                if (imt.getAlias() == null || imt.getIdentifier() == null) continue;
                String name = TreeUtil.name(imt.getIdentifier());
                String alias = TreeUtil.name(imt.getAlias().getIdentifier());
                Map<String, String> mods = this.unit.getUnit().getModifiers();
                if (!mods.containsKey(name)) continue;
                String curr = mods.get(alias);
                if (curr != null && curr.equals(alias)) {
                    mods.remove(alias);
                }
                mods.put(name, alias);
            }
        }
    }

    public static enum Phase {
        SRC_MODULE,
        REMAINING;

    }
}

