/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.parser;

import com.redhat.ceylon.compiler.typechecker.parser.RecognitionError;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;

public class ParseError
extends RecognitionError {
    private Parser parser;
    private int code;
    private int expecting;

    public ParseError(Parser parser, RecognitionException re, int expecting, String[] tn) {
        this(parser, re, tn, -1);
        this.expecting = expecting;
    }

    public ParseError(Parser parser, RecognitionException re, String[] tn, int code) {
        super(re, tn);
        this.parser = parser;
        this.code = code;
    }

    public String getToken() {
        return this.recognitionException.token.getText();
    }

    public String getHeader() {
        return this.parser.getErrorHeader(this.recognitionException);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        String message = this.parser.getErrorMessage(this.recognitionException, this.tokenNames).replace("'<EOF>'", "end of file").replace("input", "token").replace("missing null", "error");
        String result = "incorrect syntax: " + message;
        if (this.expecting != -1 && !result.contains("expecting")) {
            result = result + " expecting " + this.tokenNames[this.expecting];
        }
        return result;
    }

    public String toString() {
        return this.getMessage();
    }
}

