/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.typechecker.tree;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.compiler.typechecker.tree.CustomTree;
import com.redhat.ceylon.compiler.typechecker.tree.Message;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TreeUtil {
    public static final String MISSING_NAME = "program element with missing name";

    public static String name(Tree.Identifier id) {
        if (id == null) {
            return MISSING_NAME;
        }
        return id.getText();
    }

    public static boolean hasAnonymousAnnotation(Tree.AnnotationList al) {
        return al != null && al.getAnonymousAnnotation() != null;
    }

    public static boolean hasAnnotation(Tree.AnnotationList al, String name, Unit unit) {
        return TreeUtil.getAnnotation(al, name, unit) != null;
    }

    public static Tree.Annotation getAnnotation(Tree.AnnotationList al, String name, Unit unit) {
        if (al != null) {
            for (Tree.Annotation a : al.getAnnotations()) {
                String alias;
                Tree.BaseMemberExpression p = (Tree.BaseMemberExpression)a.getPrimary();
                if (p == null) continue;
                String an = TreeUtil.name(p.getIdentifier());
                String string = alias = unit == null ? name : unit.getModifiers().get(name);
                if (alias == null) {
                    alias = name;
                }
                if (!an.equals(alias)) continue;
                return a;
            }
        }
        return null;
    }

    public static int getAnnotationArgumentCount(Tree.Annotation ann) {
        Tree.PositionalArgumentList pal = ann.getPositionalArgumentList();
        if (pal != null) {
            return pal.getPositionalArguments().size();
        }
        Tree.NamedArgumentList nal = ann.getNamedArgumentList();
        if (nal != null) {
            return nal.getNamedArguments().size();
        }
        return 0;
    }

    public static String getAnnotationArgument(Tree.Annotation ann, int index) {
        Tree.Literal literal;
        Tree.Term term;
        List<Tree.NamedArgument> args;
        Tree.NamedArgumentList nal;
        Tree.PositionalArgument arg;
        List<Tree.PositionalArgument> args2;
        String result = null;
        Tree.Expression expression = null;
        Tree.PositionalArgumentList pal = ann.getPositionalArgumentList();
        if (pal != null && !(args2 = pal.getPositionalArguments()).isEmpty() && (arg = args2.get(index)) instanceof Tree.ListedArgument) {
            Tree.ListedArgument la = (Tree.ListedArgument)arg;
            expression = la.getExpression();
        }
        if ((nal = ann.getNamedArgumentList()) != null && !(args = nal.getNamedArguments()).isEmpty()) {
            Tree.SpecifiedArgument arg2 = (Tree.SpecifiedArgument)args.get(index);
            expression = arg2.getSpecifierExpression().getExpression();
        }
        if (expression != null && (term = expression.getTerm()) instanceof Tree.Literal && (result = (literal = (Tree.Literal)term).getText()).startsWith("\"") && result.endsWith("\"")) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public static boolean isForUnsupportedBackend(Tree.AnnotationList al, Unit unit) {
        Backends bs = TreeUtil.getNativeBackend(al, unit);
        if (!bs.none()) {
            return !ModelUtil.isForBackend(bs, unit.getSupportedBackends());
        }
        return false;
    }

    public static boolean isForBackend(Tree.AnnotationList al, Backend forBackend, Unit unit) {
        Backends bs = TreeUtil.getNativeBackend(al, unit);
        return ModelUtil.isForBackend(bs, forBackend.asSet());
    }

    public static Backends getNativeBackend(Tree.AnnotationList al, Unit unit) {
        Tree.Annotation ann = TreeUtil.getAnnotation(al, "native", unit);
        Backends backends = Backends.ANY;
        if (ann != null) {
            int cnt = TreeUtil.getAnnotationArgumentCount(ann);
            if (cnt == 0) {
                backends = Backends.HEADER;
            } else {
                for (int i = 0; i < cnt; ++i) {
                    String be = TreeUtil.getAnnotationArgument(ann, i);
                    if (be == null) continue;
                    backends = backends.merged(Backend.fromAnnotation(be));
                }
            }
        }
        return backends;
    }

    public static boolean hasUncheckedNulls(Tree.Term term) {
        return TreeUtil.hasUncheckedNulls(term, false);
    }

    private static boolean hasUncheckedNulls(Tree.Term term, boolean invoking) {
        if (term instanceof Tree.MemberOrTypeExpression) {
            Tree.MemberOrTypeExpression mte = (Tree.MemberOrTypeExpression)term;
            Declaration d = mte.getDeclaration();
            if (d instanceof TypedDeclaration) {
                TypedDeclaration td = (TypedDeclaration)d;
                return td.hasUncheckedNullType() && (!(d instanceof Function) || invoking);
            }
            return false;
        }
        if (term instanceof Tree.QualifiedMemberOrTypeExpression) {
            Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)term;
            return TreeUtil.hasUncheckedNulls(qmte.getPrimary(), invoking);
        }
        if (term instanceof Tree.InvocationExpression) {
            Tree.InvocationExpression ite = (Tree.InvocationExpression)term;
            return TreeUtil.hasUncheckedNulls(ite.getPrimary(), true);
        }
        if (term instanceof Tree.DefaultOp) {
            Tree.DefaultOp op = (Tree.DefaultOp)term;
            return TreeUtil.hasUncheckedNulls(op.getRightTerm(), invoking);
        }
        if (term instanceof Tree.Expression) {
            Tree.Expression e = (Tree.Expression)term;
            return TreeUtil.hasUncheckedNulls(e.getTerm(), invoking);
        }
        if (term instanceof Tree.LetExpression) {
            Tree.LetExpression e = (Tree.LetExpression)term;
            return TreeUtil.hasUncheckedNulls(e.getLetClause().getExpression(), invoking);
        }
        if (term instanceof Tree.IfExpression) {
            Tree.IfExpression e = (Tree.IfExpression)term;
            return TreeUtil.hasUncheckedNulls(e.getIfClause().getExpression(), invoking) || TreeUtil.hasUncheckedNulls(e.getElseClause().getExpression(), invoking);
        }
        if (term instanceof Tree.SwitchExpression) {
            Tree.SwitchExpression e = (Tree.SwitchExpression)term;
            for (Tree.CaseClause clause : e.getSwitchCaseList().getCaseClauses()) {
                if (!TreeUtil.hasUncheckedNulls(clause.getExpression(), invoking)) continue;
                return true;
            }
            if (e.getSwitchCaseList().getElseClause() != null) {
                return TreeUtil.hasUncheckedNulls(e.getSwitchCaseList().getElseClause().getExpression(), invoking);
            }
            return false;
        }
        return false;
    }

    public static String formatPath(List<Tree.Identifier> nodes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Node node : nodes) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(node.getText());
        }
        return sb.toString();
    }

    public static Node getIdentifyingNode(Node node) {
        Node result = null;
        if (node instanceof Tree.Declaration) {
            Tree.Declaration d = (Tree.Declaration)node;
            result = d.getIdentifier();
        } else if (node instanceof Tree.ModuleDescriptor) {
            Tree.ModuleDescriptor md = (Tree.ModuleDescriptor)node;
            result = md.getImportPath();
        } else if (node instanceof Tree.PackageDescriptor) {
            Tree.PackageDescriptor pd = (Tree.PackageDescriptor)node;
            result = pd.getImportPath();
        } else if (node instanceof Tree.NamedArgument) {
            Tree.NamedArgument na = (Tree.NamedArgument)node;
            result = na.getIdentifier();
        } else if (node instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)node;
            result = smte.getIdentifier();
        } else if (node instanceof Tree.ExtendedTypeExpression) {
            CustomTree.ExtendedTypeExpression ete = (CustomTree.ExtendedTypeExpression)node;
            result = ete.getType().getIdentifier();
        } else if (node instanceof Tree.SimpleType) {
            Tree.SimpleType st = (Tree.SimpleType)node;
            result = st.getIdentifier();
        } else if (node instanceof Tree.ImportMemberOrType) {
            Tree.ImportMemberOrType imt = (Tree.ImportMemberOrType)node;
            result = imt.getIdentifier();
        } else {
            result = node;
        }
        if (result == null) {
            result = node;
        }
        return result;
    }

    public static Tree.Term eliminateParensAndWidening(Tree.Term term) {
        while (term instanceof Tree.OfOp || term instanceof Tree.Expression) {
            if (term instanceof Tree.OfOp) {
                term = ((Tree.OfOp)term).getTerm();
                continue;
            }
            if (!(term instanceof Tree.Expression)) continue;
            term = ((Tree.Expression)term).getTerm();
        }
        return term;
    }

    public static Tree.Term unwrapExpressionUntilTerm(Tree.Term term) {
        while (term instanceof Tree.Expression) {
            Tree.Expression e = (Tree.Expression)term;
            term = e.getTerm();
        }
        return term;
    }

    public static boolean hasErrorOrWarning(Node node) {
        return TreeUtil.hasError(node, true);
    }

    public static boolean hasError(Node node) {
        return TreeUtil.hasError(node, false);
    }

    static boolean hasError(Node node, boolean includeWarnings) {
        class ErrorFoundException
        extends RuntimeException {
            ErrorFoundException() {
            }
        }
        class ErrorVisitor
        extends Visitor {
            final /* synthetic */ boolean val$includeWarnings;

            ErrorVisitor(boolean bl) {
                this.val$includeWarnings = bl;
            }

            @Override
            public void handleException(Exception e, Node that) {
                if (e instanceof ErrorFoundException) {
                    throw (ErrorFoundException)e;
                }
                super.handleException(e, that);
            }

            @Override
            public void visitAny(Node that) {
                if (that.getErrors().isEmpty()) {
                    super.visitAny(that);
                } else {
                    if (this.val$includeWarnings) {
                        throw new ErrorFoundException();
                    }
                    for (Message error : that.getErrors()) {
                        if (error.isWarning()) continue;
                        throw new ErrorFoundException();
                    }
                    super.visitAny(that);
                }
            }
        }
        ErrorVisitor ev = new ErrorVisitor(includeWarnings);
        try {
            node.visit(ev);
            return false;
        }
        catch (ErrorFoundException x) {
            return true;
        }
    }

    public static void buildAnnotations(Tree.AnnotationList al, List<Annotation> annotations) {
        if (al != null) {
            Tree.AnonymousAnnotation aa = al.getAnonymousAnnotation();
            if (aa != null) {
                Annotation ann = new Annotation();
                ann.setName("doc");
                Tree.StringLiteral lit = aa.getStringLiteral();
                if (lit != null) {
                    String text = lit.getText();
                    ann.addPositionalArgument(text);
                    annotations.add(ann);
                }
            }
            for (Tree.Annotation a : al.getAnnotations()) {
                Tree.PositionalArgumentList pal;
                Annotation ann = new Annotation();
                Tree.BaseMemberExpression bma = (Tree.BaseMemberExpression)a.getPrimary();
                String name = bma.getIdentifier().getText();
                ann.setName(name);
                Tree.NamedArgumentList nal = a.getNamedArgumentList();
                if (nal != null) {
                    for (Tree.NamedArgument na : nal.getNamedArguments()) {
                        String text;
                        Tree.SpecifiedArgument sa;
                        Tree.SpecifierExpression sie;
                        Tree.Expression e;
                        if (!(na instanceof Tree.SpecifiedArgument) || (e = (sie = (sa = (Tree.SpecifiedArgument)na).getSpecifierExpression()).getExpression()) == null) continue;
                        Tree.Term t = e.getTerm();
                        Parameter p = sa.getParameter();
                        if (p == null || (text = TreeUtil.toString(t)) == null) continue;
                        ann.addNamedArgument(p.getName(), text);
                    }
                }
                if ((pal = a.getPositionalArgumentList()) != null) {
                    for (Tree.PositionalArgument pa : pal.getPositionalArguments()) {
                        Tree.ListedArgument la;
                        Tree.Term t;
                        String text;
                        if (!(pa instanceof Tree.ListedArgument) || (text = TreeUtil.toString(t = (la = (Tree.ListedArgument)pa).getExpression().getTerm())) == null) continue;
                        ann.addPositionalArgument(text);
                    }
                }
                annotations.add(ann);
            }
        }
    }

    public static List<String> getAnnotationSequenceArgument(Tree.Annotation a) {
        Tree.PositionalArgumentList pal;
        Tree.Term t;
        Tree.NamedArgumentList nal = a.getNamedArgumentList();
        if (nal != null) {
            for (Tree.NamedArgument na : nal.getNamedArguments()) {
                String text;
                Tree.SpecifiedArgument sa;
                Tree.SpecifierExpression sie;
                Tree.Expression e;
                if (!(na instanceof Tree.SpecifiedArgument) || (e = (sie = (sa = (Tree.SpecifiedArgument)na).getSpecifierExpression()).getExpression()) == null) continue;
                t = e.getTerm();
                Parameter p = sa.getParameter();
                if (p == null || (text = TreeUtil.toString(t)) == null) continue;
                return Arrays.asList(text);
            }
        }
        if ((pal = a.getPositionalArgumentList()) != null) {
            ArrayList<String> ret = new ArrayList<String>(pal.getPositionalArguments().size());
            for (Tree.PositionalArgument pa : pal.getPositionalArguments()) {
                Tree.ListedArgument la;
                String text;
                if (!(pa instanceof Tree.ListedArgument) || (text = TreeUtil.toString(t = (la = (Tree.ListedArgument)pa).getExpression().getTerm())) == null) continue;
                ret.add(text);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private static String toString(Tree.Term t) {
        if (t instanceof Tree.Literal) {
            return ((Tree.Literal)t).getText();
        }
        if (t instanceof Tree.StaticMemberOrTypeExpression) {
            Tree.StaticMemberOrTypeExpression mte = (Tree.StaticMemberOrTypeExpression)t;
            String id = mte.getIdentifier().getText();
            if (mte instanceof Tree.QualifiedMemberOrTypeExpression) {
                Tree.QualifiedMemberOrTypeExpression qmte = (Tree.QualifiedMemberOrTypeExpression)mte;
                Tree.Primary p = qmte.getPrimary();
                if (p instanceof Tree.StaticMemberOrTypeExpression) {
                    Tree.StaticMemberOrTypeExpression smte = (Tree.StaticMemberOrTypeExpression)p;
                    return TreeUtil.toString(smte) + '.' + id;
                }
                return null;
            }
            return id;
        }
        if (t instanceof Tree.TypeLiteral) {
            Tree.TypeLiteral tl = (Tree.TypeLiteral)t;
            Tree.StaticType type = tl.getType();
            if (type != null) {
                return TreeUtil.toString(type);
            }
            if (t instanceof Tree.InterfaceLiteral) {
                return "interface";
            }
            if (t instanceof Tree.ClassLiteral) {
                return "class";
            }
            return null;
        }
        if (t instanceof Tree.MemberLiteral) {
            Tree.MemberLiteral ml = (Tree.MemberLiteral)t;
            Tree.Identifier id = ml.getIdentifier();
            Tree.StaticType type = ml.getType();
            if (type != null) {
                String qualifier = TreeUtil.toString(type);
                if (qualifier != null && id != null) {
                    return qualifier + "." + id.getText();
                }
                return null;
            }
            return id.getText();
        }
        if (t instanceof Tree.ModuleLiteral) {
            Tree.ModuleLiteral ml = (Tree.ModuleLiteral)t;
            String importPath = TreeUtil.toString(ml.getImportPath());
            return importPath == null ? "module" : "module " + importPath;
        }
        if (t instanceof Tree.PackageLiteral) {
            Tree.PackageLiteral pl = (Tree.PackageLiteral)t;
            String importPath = TreeUtil.toString(pl.getImportPath());
            return importPath == null ? "package" : "package " + importPath;
        }
        return null;
    }

    private static String toString(Tree.ImportPath importPath) {
        if (importPath != null) {
            StringBuilder sb = new StringBuilder();
            if (importPath.getIdentifiers() != null) {
                for (Tree.Identifier identifier : importPath.getIdentifiers()) {
                    if (sb.length() != 0) {
                        sb.append(".");
                    }
                    sb.append(identifier.getText());
                }
            }
            return sb.toString();
        }
        return null;
    }

    private static String toString(Tree.StaticType type) {
        if (type instanceof Tree.BaseType) {
            Tree.BaseType bt = (Tree.BaseType)type;
            return bt.getIdentifier().getText();
        }
        if (type instanceof Tree.QualifiedType) {
            Tree.QualifiedType qt = (Tree.QualifiedType)type;
            String qualifier = TreeUtil.toString(qt.getOuterType());
            if (qualifier != null) {
                Tree.SimpleType st = (Tree.SimpleType)type;
                return qualifier + "." + st.getIdentifier().getText();
            }
            return null;
        }
        return null;
    }

    public static boolean isSelfReference(Tree.Primary that) {
        return that instanceof Tree.This || that instanceof Tree.Outer;
    }

    public static boolean isEffectivelyBaseMemberExpression(Tree.Term term) {
        return term instanceof Tree.BaseMemberExpression || term instanceof Tree.QualifiedMemberExpression && TreeUtil.isSelfReference(((Tree.QualifiedMemberExpression)term).getPrimary());
    }

    public static boolean isInstantiationExpression(Tree.Expression e) {
        Tree.Term term = e.getTerm();
        if (term instanceof Tree.InvocationExpression) {
            Tree.QualifiedMemberExpression qme;
            Tree.InvocationExpression ie = (Tree.InvocationExpression)term;
            Tree.Primary p = ie.getPrimary();
            if (p instanceof Tree.BaseTypeExpression || p instanceof Tree.QualifiedTypeExpression) {
                return true;
            }
            if (p instanceof Tree.QualifiedMemberExpression && (qme = (Tree.QualifiedMemberExpression)p).getStaticMethodReference() && ModelUtil.isConstructor(qme.getDeclaration())) {
                return true;
            }
        }
        return false;
    }
}

