/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.AccessFlags;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.Dependency;
import com.redhat.ceylon.langtools.classfile.Descriptor;
import com.redhat.ceylon.langtools.classfile.Exceptions_attribute;
import com.redhat.ceylon.langtools.classfile.Field;
import com.redhat.ceylon.langtools.classfile.Method;
import com.redhat.ceylon.langtools.classfile.RuntimeAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeParameterAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.Signature;
import com.redhat.ceylon.langtools.classfile.Signature_attribute;
import com.redhat.ceylon.langtools.classfile.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Dependencies {
    private Dependency.Filter filter;
    private Dependency.Finder finder;

    public static Dependency.Finder getDefaultFinder() {
        return new APIDependencyFinder(2);
    }

    public static Dependency.Finder getAPIFinder(int access) {
        return new APIDependencyFinder(access);
    }

    public static Dependency.Finder getClassDependencyFinder() {
        return new ClassDependencyFinder();
    }

    public Dependency.Finder getFinder() {
        if (this.finder == null) {
            this.finder = Dependencies.getDefaultFinder();
        }
        return this.finder;
    }

    public void setFinder(Dependency.Finder f) {
        f.getClass();
        this.finder = f;
    }

    public static Dependency.Filter getDefaultFilter() {
        return DefaultFilter.instance();
    }

    public static Dependency.Filter getRegexFilter(Pattern pattern) {
        return new TargetRegexFilter(pattern);
    }

    public static Dependency.Filter getPackageFilter(Set<String> packageNames, boolean matchSubpackages) {
        return new TargetPackageFilter(packageNames, matchSubpackages);
    }

    public Dependency.Filter getFilter() {
        if (this.filter == null) {
            this.filter = Dependencies.getDefaultFilter();
        }
        return this.filter;
    }

    public void setFilter(Dependency.Filter f) {
        f.getClass();
        this.filter = f;
    }

    public Set<Dependency> findAllDependencies(ClassFileReader classFinder, Set<String> rootClassNames, boolean transitiveClosure) throws ClassFileNotFoundException {
        final HashSet<Dependency> results = new HashSet<Dependency>();
        Recorder r = new Recorder(){

            @Override
            public void addDependency(Dependency d) {
                results.add(d);
            }
        };
        this.findAllDependencies(classFinder, rootClassNames, transitiveClosure, r);
        return results;
    }

    public void findAllDependencies(ClassFileReader classFinder, Set<String> rootClassNames, boolean transitiveClosure, Recorder recorder) throws ClassFileNotFoundException {
        String className;
        HashSet<String> doneClasses = new HashSet<String>();
        this.getFinder();
        this.getFilter();
        LinkedList<String> deque = new LinkedList<String>(rootClassNames);
        while ((className = (String)deque.poll()) != null) {
            assert (!doneClasses.contains(className));
            doneClasses.add(className);
            ClassFile cf = classFinder.getClassFile(className);
            for (Dependency dependency : this.finder.findDependencies(cf)) {
                String cn;
                recorder.addDependency(dependency);
                if (!transitiveClosure || !this.filter.accepts(dependency) || doneClasses.contains(cn = dependency.getTarget().getClassName())) continue;
                deque.add(cn);
            }
        }
    }

    static abstract class BasicDependencyFinder
    implements Dependency.Finder {
        private Map<String, Dependency.Location> locations = new HashMap<String, Dependency.Location>();

        BasicDependencyFinder() {
        }

        Dependency.Location getLocation(String className) {
            Dependency.Location l = this.locations.get(className);
            if (l == null) {
                l = new SimpleLocation(className);
                this.locations.put(className, l);
            }
            return l;
        }

        class Visitor
        implements ConstantPool.Visitor<Void, Void>,
        Type.Visitor<Void, Void> {
            private ConstantPool constant_pool;
            private Dependency.Location origin;
            Set<Dependency> deps;

            Visitor(ClassFile classFile) {
                try {
                    this.constant_pool = classFile.constant_pool;
                    this.origin = BasicDependencyFinder.this.getLocation(classFile.getName());
                    this.deps = new HashSet<Dependency>();
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            void scan(Descriptor d, Attributes attrs) {
                try {
                    this.scan(new Signature(d.index).getType(this.constant_pool));
                    this.scan(attrs);
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            void scan(ConstantPool.CPInfo cpInfo) {
                cpInfo.accept(this, null);
            }

            void scan(Type t) {
                t.accept(this, null);
            }

            void scan(Attributes attrs) {
                try {
                    Signature_attribute sa = (Signature_attribute)attrs.get("Signature");
                    if (sa != null) {
                        this.scan(sa.getParsedSignature().getType(this.constant_pool));
                    }
                    this.scan((RuntimeVisibleAnnotations_attribute)attrs.get("RuntimeVisibleAnnotations"));
                    this.scan((RuntimeVisibleParameterAnnotations_attribute)attrs.get("RuntimeVisibleParameterAnnotations"));
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            private void scan(RuntimeAnnotations_attribute attr) throws ConstantPoolException {
                if (attr == null) {
                    return;
                }
                for (int i = 0; i < attr.annotations.length; ++i) {
                    int index = attr.annotations[i].type_index;
                    this.scan(new Signature(index).getType(this.constant_pool));
                }
            }

            private void scan(RuntimeParameterAnnotations_attribute attr) throws ConstantPoolException {
                if (attr == null) {
                    return;
                }
                for (int param = 0; param < attr.parameter_annotations.length; ++param) {
                    for (int i = 0; i < attr.parameter_annotations[param].length; ++i) {
                        int index = attr.parameter_annotations[param][i].type_index;
                        this.scan(new Signature(index).getType(this.constant_pool));
                    }
                }
            }

            void addClass(int index) throws ConstantPoolException {
                String name;
                if (index != 0 && (name = this.constant_pool.getClassInfo(index).getBaseName()) != null) {
                    this.addDependency(name);
                }
            }

            void addClasses(int[] indices) throws ConstantPoolException {
                for (int i : indices) {
                    this.addClass(i);
                }
            }

            private void addDependency(String name) {
                this.deps.add(new SimpleDependency(this.origin, BasicDependencyFinder.this.getLocation(name)));
            }

            @Override
            public Void visitClass(ConstantPool.CONSTANT_Class_info info, Void p) {
                try {
                    if (info.getName().startsWith("[")) {
                        new Signature(info.name_index).getType(this.constant_pool).accept(this, null);
                    } else {
                        this.addDependency(info.getBaseName());
                    }
                    return null;
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            @Override
            public Void visitDouble(ConstantPool.CONSTANT_Double_info info, Void p) {
                return null;
            }

            @Override
            public Void visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, Void p) {
                return this.visitRef(info, p);
            }

            @Override
            public Void visitFloat(ConstantPool.CONSTANT_Float_info info, Void p) {
                return null;
            }

            @Override
            public Void visitInteger(ConstantPool.CONSTANT_Integer_info info, Void p) {
                return null;
            }

            @Override
            public Void visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, Void p) {
                return this.visitRef(info, p);
            }

            @Override
            public Void visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, Void p) {
                return null;
            }

            @Override
            public Void visitLong(ConstantPool.CONSTANT_Long_info info, Void p) {
                return null;
            }

            @Override
            public Void visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, Void p) {
                return null;
            }

            @Override
            public Void visitMethodType(ConstantPool.CONSTANT_MethodType_info info, Void p) {
                return null;
            }

            @Override
            public Void visitMethodref(ConstantPool.CONSTANT_Methodref_info info, Void p) {
                return this.visitRef(info, p);
            }

            @Override
            public Void visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, Void p) {
                try {
                    new Signature(info.type_index).getType(this.constant_pool).accept(this, null);
                    return null;
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            @Override
            public Void visitString(ConstantPool.CONSTANT_String_info info, Void p) {
                return null;
            }

            @Override
            public Void visitUtf8(ConstantPool.CONSTANT_Utf8_info info, Void p) {
                return null;
            }

            private Void visitRef(ConstantPool.CPRefInfo info, Void p) {
                try {
                    this.visitClass(info.getClassInfo(), p);
                    return null;
                }
                catch (ConstantPoolException e) {
                    throw new ClassFileError(e);
                }
            }

            private void findDependencies(Type t) {
                if (t != null) {
                    t.accept(this, null);
                }
            }

            private void findDependencies(List<? extends Type> ts) {
                if (ts != null) {
                    for (Type type : ts) {
                        type.accept(this, null);
                    }
                }
            }

            @Override
            public Void visitSimpleType(Type.SimpleType type, Void p) {
                return null;
            }

            @Override
            public Void visitArrayType(Type.ArrayType type, Void p) {
                this.findDependencies(type.elemType);
                return null;
            }

            @Override
            public Void visitMethodType(Type.MethodType type, Void p) {
                this.findDependencies(type.paramTypes);
                this.findDependencies(type.returnType);
                this.findDependencies(type.throwsTypes);
                this.findDependencies(type.typeParamTypes);
                return null;
            }

            @Override
            public Void visitClassSigType(Type.ClassSigType type, Void p) {
                this.findDependencies(type.superclassType);
                this.findDependencies(type.superinterfaceTypes);
                return null;
            }

            @Override
            public Void visitClassType(Type.ClassType type, Void p) {
                this.findDependencies(type.outerType);
                this.addDependency(type.getBinaryName());
                this.findDependencies(type.typeArgs);
                return null;
            }

            @Override
            public Void visitTypeParamType(Type.TypeParamType type, Void p) {
                this.findDependencies(type.classBound);
                this.findDependencies(type.interfaceBounds);
                return null;
            }

            @Override
            public Void visitWildcardType(Type.WildcardType type, Void p) {
                this.findDependencies(type.boundType);
                return null;
            }
        }
    }

    static class APIDependencyFinder
    extends BasicDependencyFinder {
        private int showAccess;

        APIDependencyFinder(int access) {
            switch (access) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    this.showAccess = access;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid access 0x" + Integer.toHexString(access));
                }
            }
        }

        @Override
        public Iterable<? extends Dependency> findDependencies(ClassFile classfile) {
            try {
                BasicDependencyFinder.Visitor v = new BasicDependencyFinder.Visitor(classfile);
                v.addClass(classfile.super_class);
                v.addClasses(classfile.interfaces);
                for (Field f : classfile.fields) {
                    if (!this.checkAccess(f.access_flags)) continue;
                    v.scan(f.descriptor, f.attributes);
                }
                for (Method m : classfile.methods) {
                    if (!this.checkAccess(m.access_flags)) continue;
                    v.scan(m.descriptor, m.attributes);
                    Exceptions_attribute e = (Exceptions_attribute)m.attributes.get("Exceptions");
                    if (e == null) continue;
                    v.addClasses(e.exception_index_table);
                }
                return v.deps;
            }
            catch (ConstantPoolException e) {
                throw new ClassFileError(e);
            }
        }

        boolean checkAccess(AccessFlags flags) {
            boolean isPackage;
            boolean isPublic = flags.is(1);
            boolean isProtected = flags.is(4);
            boolean isPrivate = flags.is(2);
            boolean bl = isPackage = !isPublic && !isProtected && !isPrivate;
            if (this.showAccess == 1 && (isProtected || isPrivate || isPackage)) {
                return false;
            }
            if (this.showAccess == 4 && (isPrivate || isPackage)) {
                return false;
            }
            return this.showAccess != 0 || !isPrivate;
        }
    }

    static class ClassDependencyFinder
    extends BasicDependencyFinder {
        ClassDependencyFinder() {
        }

        @Override
        public Iterable<? extends Dependency> findDependencies(ClassFile classfile) {
            BasicDependencyFinder.Visitor v = new BasicDependencyFinder.Visitor(classfile);
            for (ConstantPool.CPInfo cpInfo : classfile.constant_pool.entries()) {
                v.scan(cpInfo);
            }
            try {
                v.addClass(classfile.super_class);
                v.addClasses(classfile.interfaces);
                v.scan(classfile.attributes);
                for (Field f : classfile.fields) {
                    v.scan(f.descriptor, f.attributes);
                }
                for (Method m : classfile.methods) {
                    v.scan(m.descriptor, m.attributes);
                    Exceptions_attribute e = (Exceptions_attribute)m.attributes.get("Exceptions");
                    if (e == null) continue;
                    v.addClasses(e.exception_index_table);
                }
            }
            catch (ConstantPoolException e) {
                throw new ClassFileError(e);
            }
            return v.deps;
        }
    }

    static class TargetPackageFilter
    implements Dependency.Filter {
        private final Set<String> packageNames;
        private final boolean matchSubpackages;

        TargetPackageFilter(Set<String> packageNames, boolean matchSubpackages) {
            for (String pn : packageNames) {
                if (pn.length() != 0) continue;
                throw new IllegalArgumentException();
            }
            this.packageNames = packageNames;
            this.matchSubpackages = matchSubpackages;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            String pn = dependency.getTarget().getPackageName();
            if (this.packageNames.contains(pn)) {
                return true;
            }
            if (this.matchSubpackages) {
                for (String n : this.packageNames) {
                    if (!pn.startsWith(n + ".")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class TargetRegexFilter
    implements Dependency.Filter {
        private final Pattern pattern;

        TargetRegexFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            return this.pattern.matcher(dependency.getTarget().getClassName()).matches();
        }
    }

    static class DefaultFilter
    implements Dependency.Filter {
        private static DefaultFilter instance;

        DefaultFilter() {
        }

        static DefaultFilter instance() {
            if (instance == null) {
                instance = new DefaultFilter();
            }
            return instance;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            return true;
        }
    }

    static class SimpleDependency
    implements Dependency {
        private Dependency.Location origin;
        private Dependency.Location target;

        public SimpleDependency(Dependency.Location origin, Dependency.Location target) {
            this.origin = origin;
            this.target = target;
        }

        @Override
        public Dependency.Location getOrigin() {
            return this.origin;
        }

        @Override
        public Dependency.Location getTarget() {
            return this.target;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleDependency)) {
                return false;
            }
            SimpleDependency o = (SimpleDependency)other;
            return this.origin.equals(o.origin) && this.target.equals(o.target);
        }

        public int hashCode() {
            return this.origin.hashCode() * 31 + this.target.hashCode();
        }

        public String toString() {
            return this.origin + ":" + this.target;
        }
    }

    static class SimpleLocation
    implements Dependency.Location {
        private String name;
        private String className;

        public SimpleLocation(String name) {
            this.name = name;
            this.className = name.replace('/', '.');
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getPackageName() {
            int i = this.name.lastIndexOf(47);
            return i > 0 ? this.name.substring(0, i).replace('/', '.') : "";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleLocation)) {
                return false;
            }
            return this.name.equals(((SimpleLocation)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Recorder {
        public void addDependency(Dependency var1);
    }

    public static interface ClassFileReader {
        public ClassFile getClassFile(String var1) throws ClassFileNotFoundException;
    }

    public static class ClassFileError
    extends Error {
        private static final long serialVersionUID = 4111110813961313203L;

        public ClassFileError(Throwable cause) {
            this.initCause(cause);
        }
    }

    public static class ClassFileNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3632265927794475048L;
        public final String className;

        public ClassFileNotFoundException(String className) {
            super(className);
            this.className = className;
        }

        public ClassFileNotFoundException(String className, Throwable cause) {
            this(className);
            this.initCause(cause);
        }
    }
}

