/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.classfile;

import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.Code_attribute;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.Instruction;
import com.redhat.ceylon.langtools.classfile.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ReferenceFinder {
    private final Filter filter;
    private final Visitor visitor;
    private ConstantPool.Visitor<Boolean, ConstantPool> cpVisitor = new ConstantPool.Visitor<Boolean, ConstantPool>(){

        @Override
        public Boolean visitClass(ConstantPool.CONSTANT_Class_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, ConstantPool cpool) {
            return ReferenceFinder.this.filter.accept(cpool, info);
        }

        @Override
        public Boolean visitMethodref(ConstantPool.CONSTANT_Methodref_info info, ConstantPool cpool) {
            return ReferenceFinder.this.filter.accept(cpool, info);
        }

        @Override
        public Boolean visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, ConstantPool cpool) {
            return ReferenceFinder.this.filter.accept(cpool, info);
        }

        @Override
        public Boolean visitDouble(ConstantPool.CONSTANT_Double_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitFloat(ConstantPool.CONSTANT_Float_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitInteger(ConstantPool.CONSTANT_Integer_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitLong(ConstantPool.CONSTANT_Long_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitMethodType(ConstantPool.CONSTANT_MethodType_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitString(ConstantPool.CONSTANT_String_info info, ConstantPool cpool) {
            return false;
        }

        @Override
        public Boolean visitUtf8(ConstantPool.CONSTANT_Utf8_info info, ConstantPool cpool) {
            return false;
        }
    };
    private Instruction.KindVisitor<Integer, List<Integer>> codeVisitor = new Instruction.KindVisitor<Integer, List<Integer>>(){

        @Override
        public Integer visitNoOperands(Instruction instr, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitArrayType(Instruction instr, Instruction.TypeKind kind, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitBranch(Instruction instr, int offset, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitConstantPoolRef(Instruction instr, int index, List<Integer> p) {
            return p.contains(index) ? index : 0;
        }

        @Override
        public Integer visitConstantPoolRefAndValue(Instruction instr, int index, int value, List<Integer> p) {
            return p.contains(index) ? index : 0;
        }

        @Override
        public Integer visitLocal(Instruction instr, int index, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitLocalAndValue(Instruction instr, int index, int value, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitLookupSwitch(Instruction instr, int default_2, int npairs, int[] matches, int[] offsets, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitTableSwitch(Instruction instr, int default_2, int low, int high, int[] offsets, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitValue(Instruction instr, int value, List<Integer> p) {
            return 0;
        }

        @Override
        public Integer visitUnknown(Instruction instr, List<Integer> p) {
            return 0;
        }
    };

    public ReferenceFinder(Filter filter, Visitor visitor) {
        this.filter = Objects.requireNonNull(filter);
        this.visitor = Objects.requireNonNull(visitor);
    }

    public boolean parse(ClassFile cf) throws ConstantPoolException {
        ArrayList<Integer> cprefs = new ArrayList<Integer>();
        int index = 1;
        for (ConstantPool.CPInfo cpInfo : cf.constant_pool.entries()) {
            if (cpInfo.accept(this.cpVisitor, cf.constant_pool).booleanValue()) {
                cprefs.add(index);
            }
            index += cpInfo.size();
        }
        if (cprefs.isEmpty()) {
            return false;
        }
        for (Method m : cf.methods) {
            HashSet<Integer> ids = new HashSet<Integer>();
            Code_attribute c_attr = (Code_attribute)m.attributes.get("Code");
            if (c_attr != null) {
                for (Instruction instr : c_attr.getInstructions()) {
                    int idx = instr.accept(this.codeVisitor, cprefs);
                    if (idx <= 0) continue;
                    ids.add(idx);
                }
            }
            if (ids.size() <= 0) continue;
            ArrayList<ConstantPool.CPRefInfo> refInfos = new ArrayList<ConstantPool.CPRefInfo>(ids.size());
            Iterator i$ = ids.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                refInfos.add((ConstantPool.CPRefInfo)ConstantPool.CPRefInfo.class.cast(cf.constant_pool.get(id)));
            }
            this.visitor.visit(cf, m, refInfos);
        }
        return true;
    }

    public static interface Visitor {
        public void visit(ClassFile var1, Method var2, List<ConstantPool.CPRefInfo> var3);
    }

    public static interface Filter {
        public boolean accept(ConstantPool var1, ConstantPool.CPRefInfo var2);
    }
}

