/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.code;

import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.code.Attribute;
import com.redhat.ceylon.langtools.tools.javac.code.Symbol;
import com.redhat.ceylon.langtools.tools.javac.code.TypeAnnotationPosition;
import com.redhat.ceylon.langtools.tools.javac.comp.Annotate;
import com.redhat.ceylon.langtools.tools.javac.comp.AttrContext;
import com.redhat.ceylon.langtools.tools.javac.comp.Env;
import com.redhat.ceylon.langtools.tools.javac.util.Assert;
import com.redhat.ceylon.langtools.tools.javac.util.List;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import java.util.Map;

public class SymbolMetadata {
    private static final List<Attribute.Compound> DECL_NOT_STARTED = List.of(null);
    private static final List<Attribute.Compound> DECL_IN_PROGRESS = List.of(null);
    private List<Attribute.Compound> attributes = DECL_NOT_STARTED;
    private List<Attribute.TypeCompound> type_attributes = List.nil();
    private List<Attribute.TypeCompound> init_type_attributes = List.nil();
    private List<Attribute.TypeCompound> clinit_type_attributes = List.nil();
    private final Symbol sym;

    public SymbolMetadata(Symbol sym) {
        this.sym = sym;
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.filterDeclSentinels(this.attributes);
    }

    public List<Attribute.TypeCompound> getTypeAttributes() {
        return this.type_attributes;
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.init_type_attributes;
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.clinit_type_attributes;
    }

    public void setDeclarationAttributes(List<Attribute.Compound> a) {
        Assert.check(this.pendingCompletion() || !this.isStarted());
        if (a == null) {
            throw new NullPointerException();
        }
        this.attributes = a;
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.type_attributes = a;
    }

    public void setInitTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.init_type_attributes = a;
    }

    public void setClassInitTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.clinit_type_attributes = a;
    }

    public void setAttributes(SymbolMetadata other) {
        if (other == null) {
            throw new NullPointerException();
        }
        this.setDeclarationAttributes(other.getDeclarationAttributes());
        this.setTypeAttributes(other.getTypeAttributes());
        this.setInitTypeAttributes(other.getInitTypeAttributes());
        this.setClassInitTypeAttributes(other.getClassInitTypeAttributes());
    }

    public void setDeclarationAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.Compound> ctx) {
        Assert.check(this.pendingCompletion() || !this.isStarted() && this.sym.kind == 1);
        this.setDeclarationAttributes(this.getAttributesForCompletion(ctx));
    }

    public void appendTypeAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.TypeCompound> ctx) {
        this.appendUniqueTypes(this.getAttributesForCompletion(ctx));
    }

    private <T extends Attribute.Compound> List<T> getAttributesForCompletion(final Annotate.AnnotateRepeatedContext<T> ctx) {
        Map annotated = ctx.annotated;
        boolean atLeastOneRepeated = false;
        List<Object> buf = List.nil();
        for (ListBuffer lb : annotated.values()) {
            Placeholder<T> ph;
            if (lb.size() == 1) {
                buf = buf.prepend(lb.first());
                continue;
            }
            Placeholder<T> res = ph = new Placeholder<T>(ctx, lb.toList(), this.sym);
            buf = buf.prepend(res);
            atLeastOneRepeated = true;
        }
        if (atLeastOneRepeated) {
            ctx.annotateRepeated(new Annotate.Worker(){

                @Override
                public String toString() {
                    return "repeated annotation pass of: " + SymbolMetadata.this.sym + " in: " + ((SymbolMetadata)SymbolMetadata.this).sym.owner;
                }

                @Override
                public void run() {
                    SymbolMetadata.this.complete(ctx);
                }
            });
        }
        return buf.reverse();
    }

    public SymbolMetadata reset() {
        this.attributes = DECL_IN_PROGRESS;
        return this;
    }

    public boolean isEmpty() {
        return !this.isStarted() || this.pendingCompletion() || this.attributes.isEmpty();
    }

    public boolean isTypesEmpty() {
        return this.type_attributes.isEmpty();
    }

    public boolean pendingCompletion() {
        return this.attributes == DECL_IN_PROGRESS;
    }

    public SymbolMetadata append(List<Attribute.Compound> l) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!l.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? l : this.attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata appendUniqueTypes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            if (this.type_attributes.isEmpty()) {
                this.type_attributes = l;
            } else {
                for (Attribute.TypeCompound tc : l) {
                    if (this.type_attributes.contains(tc)) continue;
                    this.type_attributes = this.type_attributes.append(tc);
                }
            }
        }
        return this;
    }

    public SymbolMetadata appendInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            this.init_type_attributes = this.init_type_attributes.isEmpty() ? l : this.init_type_attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata appendClassInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            this.clinit_type_attributes = this.clinit_type_attributes.isEmpty() ? l : this.clinit_type_attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata prepend(List<Attribute.Compound> l) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!l.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? l : this.attributes.prependList(l);
        }
        return this;
    }

    private List<Attribute.Compound> filterDeclSentinels(List<Attribute.Compound> a) {
        return a == DECL_IN_PROGRESS || a == DECL_NOT_STARTED ? List.nil() : a;
    }

    private boolean isStarted() {
        return this.attributes != DECL_NOT_STARTED;
    }

    private List<Attribute.Compound> getPlaceholders() {
        List<Attribute.Compound> res = List.nil();
        for (Attribute.Compound a : this.filterDeclSentinels(this.attributes)) {
            if (!(a instanceof Placeholder)) continue;
            res = res.prepend(a);
        }
        return res.reverse();
    }

    private List<Attribute.TypeCompound> getTypePlaceholders() {
        List<Attribute.TypeCompound> res = List.nil();
        for (Attribute.TypeCompound a : this.type_attributes) {
            if (!(a instanceof Placeholder)) continue;
            res = res.prepend(a);
        }
        return res.reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Attribute.Compound> void complete(Annotate.AnnotateRepeatedContext<T> ctx) {
        Log log = ctx.log;
        Env<AttrContext> env = ctx.env;
        JavaFileObject oldSource = log.useSource(env.toplevel.sourcefile);
        try {
            if (ctx.isTypeCompound) {
                Assert.check(!this.isTypesEmpty());
                if (this.isTypesEmpty()) {
                    return;
                }
                List<Object> result = List.nil();
                for (Attribute.TypeCompound a : this.getTypeAttributes()) {
                    if (a instanceof Placeholder) {
                        Placeholder ph = (Placeholder)a;
                        Attribute.TypeCompound replacement = (Attribute.TypeCompound)this.replaceOne(ph, ph.getRepeatedContext());
                        if (null == replacement) continue;
                        result = result.prepend(replacement);
                        continue;
                    }
                    result = result.prepend(a);
                }
                this.type_attributes = result.reverse();
                Assert.check(this.getTypePlaceholders().isEmpty());
            } else {
                Assert.check(!this.pendingCompletion());
                if (this.isEmpty()) {
                    return;
                }
                List<Object> result = List.nil();
                for (Attribute.Compound a : this.getDeclarationAttributes()) {
                    if (a instanceof Placeholder) {
                        T replacement = this.replaceOne((Placeholder)a, ctx);
                        if (null == replacement) continue;
                        result = result.prepend(replacement);
                        continue;
                    }
                    result = result.prepend(a);
                }
                this.attributes = result.reverse();
                Assert.check(this.getPlaceholders().isEmpty());
            }
        }
        finally {
            log.useSource(oldSource);
        }
    }

    private <T extends Attribute.Compound> T replaceOne(Placeholder<T> placeholder, Annotate.AnnotateRepeatedContext<T> ctx) {
        ListBuffer manualContainer;
        Log log = ctx.log;
        T validRepeated = ctx.processRepeatedAnnotations(placeholder.getPlaceholderFor(), this.sym);
        if (validRepeated != null && (manualContainer = ctx.annotated.get(((Attribute.Compound)validRepeated).type.tsym)) != null) {
            log.error(ctx.pos.get(manualContainer.first()), "invalid.repeatable.annotation.repeated.and.container.present", ((Attribute.Compound)manualContainer.first()).type.tsym);
        }
        return validRepeated;
    }

    private static class Placeholder<T extends Attribute.Compound>
    extends Attribute.TypeCompound {
        private final Annotate.AnnotateRepeatedContext<T> ctx;
        private final List<T> placeholderFor;
        private final Symbol on;

        public Placeholder(Annotate.AnnotateRepeatedContext<T> ctx, List<T> placeholderFor, Symbol on) {
            super(on.type, List.nil(), ctx.isTypeCompound ? ((Attribute.TypeCompound)placeholderFor.head).position : new TypeAnnotationPosition());
            this.ctx = ctx;
            this.placeholderFor = placeholderFor;
            this.on = on;
        }

        @Override
        public String toString() {
            return "<placeholder: " + this.placeholderFor + " on: " + this.on + ">";
        }

        public List<T> getPlaceholderFor() {
            return this.placeholderFor;
        }

        public Annotate.AnnotateRepeatedContext<T> getRepeatedContext() {
            return this.ctx;
        }
    }
}

