/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.code;

import com.redhat.ceylon.langtools.tools.javac.util.Assert;

public final class TargetType
extends Enum<TargetType> {
    public static final /* enum */ TargetType CLASS_TYPE_PARAMETER;
    public static final /* enum */ TargetType METHOD_TYPE_PARAMETER;
    public static final /* enum */ TargetType CLASS_EXTENDS;
    public static final /* enum */ TargetType CLASS_TYPE_PARAMETER_BOUND;
    public static final /* enum */ TargetType METHOD_TYPE_PARAMETER_BOUND;
    public static final /* enum */ TargetType FIELD;
    public static final /* enum */ TargetType METHOD_RETURN;
    public static final /* enum */ TargetType METHOD_RECEIVER;
    public static final /* enum */ TargetType METHOD_FORMAL_PARAMETER;
    public static final /* enum */ TargetType THROWS;
    public static final /* enum */ TargetType LOCAL_VARIABLE;
    public static final /* enum */ TargetType RESOURCE_VARIABLE;
    public static final /* enum */ TargetType EXCEPTION_PARAMETER;
    public static final /* enum */ TargetType INSTANCEOF;
    public static final /* enum */ TargetType NEW;
    public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE;
    public static final /* enum */ TargetType METHOD_REFERENCE;
    public static final /* enum */ TargetType CAST;
    public static final /* enum */ TargetType CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT;
    public static final /* enum */ TargetType METHOD_INVOCATION_TYPE_ARGUMENT;
    public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT;
    public static final /* enum */ TargetType METHOD_REFERENCE_TYPE_ARGUMENT;
    public static final /* enum */ TargetType UNKNOWN;
    private static final int MAXIMUM_TARGET_TYPE_VALUE = 75;
    private final int targetTypeValue;
    private final boolean isLocal;
    private static final TargetType[] targets;
    private static final /* synthetic */ TargetType[] $VALUES;

    public static TargetType[] values() {
        return (TargetType[])$VALUES.clone();
    }

    public static TargetType valueOf(String name) {
        return Enum.valueOf(TargetType.class, name);
    }

    private TargetType(int targetTypeValue) {
        this(targetTypeValue, false);
    }

    private TargetType(int targetTypeValue, boolean isLocal) {
        if (targetTypeValue < 0 || targetTypeValue > 255) {
            Assert.error("Attribute type value needs to be an unsigned byte: " + String.format("0x%02X", targetTypeValue));
        }
        this.targetTypeValue = targetTypeValue;
        this.isLocal = isLocal;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public int targetTypeValue() {
        return this.targetTypeValue;
    }

    public static boolean isValidTargetTypeValue(int tag) {
        if (tag == TargetType.UNKNOWN.targetTypeValue) {
            return true;
        }
        return tag >= 0 && tag < targets.length;
    }

    public static TargetType fromTargetTypeValue(int tag) {
        if (tag == TargetType.UNKNOWN.targetTypeValue) {
            return UNKNOWN;
        }
        if (tag < 0 || tag >= targets.length) {
            Assert.error("Unknown TargetType: " + tag);
        }
        return targets[tag];
    }

    static {
        TargetType[] alltargets;
        CLASS_TYPE_PARAMETER = new TargetType(0);
        METHOD_TYPE_PARAMETER = new TargetType(1);
        CLASS_EXTENDS = new TargetType(16);
        CLASS_TYPE_PARAMETER_BOUND = new TargetType(17);
        METHOD_TYPE_PARAMETER_BOUND = new TargetType(18);
        FIELD = new TargetType(19);
        METHOD_RETURN = new TargetType(20);
        METHOD_RECEIVER = new TargetType(21);
        METHOD_FORMAL_PARAMETER = new TargetType(22);
        THROWS = new TargetType(23);
        LOCAL_VARIABLE = new TargetType(64, true);
        RESOURCE_VARIABLE = new TargetType(65, true);
        EXCEPTION_PARAMETER = new TargetType(66, true);
        INSTANCEOF = new TargetType(67, true);
        NEW = new TargetType(68, true);
        CONSTRUCTOR_REFERENCE = new TargetType(69, true);
        METHOD_REFERENCE = new TargetType(70, true);
        CAST = new TargetType(71, true);
        CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = new TargetType(72, true);
        METHOD_INVOCATION_TYPE_ARGUMENT = new TargetType(73, true);
        CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = new TargetType(74, true);
        METHOD_REFERENCE_TYPE_ARGUMENT = new TargetType(75, true);
        UNKNOWN = new TargetType(255);
        $VALUES = new TargetType[]{CLASS_TYPE_PARAMETER, METHOD_TYPE_PARAMETER, CLASS_EXTENDS, CLASS_TYPE_PARAMETER_BOUND, METHOD_TYPE_PARAMETER_BOUND, FIELD, METHOD_RETURN, METHOD_RECEIVER, METHOD_FORMAL_PARAMETER, THROWS, LOCAL_VARIABLE, RESOURCE_VARIABLE, EXCEPTION_PARAMETER, INSTANCEOF, NEW, CONSTRUCTOR_REFERENCE, METHOD_REFERENCE, CAST, CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, METHOD_INVOCATION_TYPE_ARGUMENT, CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, METHOD_REFERENCE_TYPE_ARGUMENT, UNKNOWN};
        targets = new TargetType[76];
        for (TargetType target : alltargets = TargetType.values()) {
            if (target.targetTypeValue == TargetType.UNKNOWN.targetTypeValue) continue;
            TargetType.targets[target.targetTypeValue] = target;
        }
        for (int i = 0; i <= 75; ++i) {
            if (targets[i] != null) continue;
            TargetType.targets[i] = UNKNOWN;
        }
    }
}

