/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.langtools.tools.javac.parser;

import com.redhat.ceylon.langtools.tools.javac.parser.JavaTokenizer;
import com.redhat.ceylon.langtools.tools.javac.parser.ScannerFactory;
import com.redhat.ceylon.langtools.tools.javac.parser.Tokens;
import com.redhat.ceylon.langtools.tools.javac.parser.UnicodeReader;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import java.nio.CharBuffer;

public class JavadocTokenizer
extends JavaTokenizer {
    protected JavadocTokenizer(ScannerFactory fac, CharBuffer buffer) {
        super(fac, buffer);
    }

    protected JavadocTokenizer(ScannerFactory fac, char[] input, int inputLength) {
        super(fac, input, inputLength);
    }

    @Override
    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        char[] buf = this.reader.getRawCharacters(pos, endPos);
        return new JavadocComment(new DocReader(this.fac, buf, buf.length, pos), style);
    }

    @Override
    public Position.LineMap getLineMap() {
        char[] buf = this.reader.getRawCharacters();
        return Position.makeLineMap(buf, buf.length, true);
    }

    protected static class JavadocComment
    extends JavaTokenizer.BasicComment<DocReader> {
        private String docComment = null;
        private int[] docPosns = null;

        JavadocComment(DocReader reader, Tokens.Comment.CommentStyle cs) {
            super(reader, cs);
        }

        @Override
        public String getText() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.docComment;
        }

        @Override
        public int getSourcePos(int pos) {
            if (pos == -1) {
                return -1;
            }
            if (pos < 0 || pos > this.docComment.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(pos));
            }
            if (this.docPosns == null) {
                return -1;
            }
            int start = 0;
            int end = this.docPosns.length;
            while (start < end - 2) {
                int index = (start + end) / 4 * 2;
                if (this.docPosns[index] < pos) {
                    start = index;
                    continue;
                }
                if (this.docPosns[index] == pos) {
                    return this.docPosns[index + 1];
                }
                end = index;
            }
            return this.docPosns[start + 1] + (pos - this.docPosns[start]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void scanDocComment() {
            try {
                boolean firstLine = true;
                ((DocReader)this.comment_reader).scanCommentChar();
                ((DocReader)this.comment_reader).scanCommentChar();
                while (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen && ((DocReader)this.comment_reader).ch == '*') {
                    ((DocReader)this.comment_reader).scanCommentChar();
                }
                if (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen && ((DocReader)this.comment_reader).ch == '/') {
                    this.docComment = "";
                    return;
                }
                if (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen) {
                    if (((DocReader)this.comment_reader).ch == '\n') {
                        ((DocReader)this.comment_reader).scanCommentChar();
                        firstLine = false;
                    } else if (((DocReader)this.comment_reader).ch == '\r') {
                        ((DocReader)this.comment_reader).scanCommentChar();
                        if (((DocReader)this.comment_reader).ch == '\n') {
                            ((DocReader)this.comment_reader).scanCommentChar();
                            firstLine = false;
                        }
                    }
                }
                block20: while (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen) {
                    int begin_bp = ((DocReader)this.comment_reader).bp;
                    char begin_ch = ((DocReader)this.comment_reader).ch;
                    block21: while (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen) {
                        switch (((DocReader)this.comment_reader).ch) {
                            case ' ': {
                                ((DocReader)this.comment_reader).scanCommentChar();
                                continue block21;
                            }
                            case '\t': {
                                ((DocReader)this.comment_reader).col = (((DocReader)this.comment_reader).col - 1) / 8 * 8 + 8;
                                ((DocReader)this.comment_reader).scanCommentChar();
                                continue block21;
                            }
                            case '\f': {
                                ((DocReader)this.comment_reader).col = 0;
                                ((DocReader)this.comment_reader).scanCommentChar();
                                continue block21;
                            }
                        }
                    }
                    if (((DocReader)this.comment_reader).ch == '*') {
                        do {
                            ((DocReader)this.comment_reader).scanCommentChar();
                        } while (((DocReader)this.comment_reader).ch == '*');
                        if (((DocReader)this.comment_reader).ch == '/') {
                            break;
                        }
                    } else if (!firstLine) {
                        ((DocReader)this.comment_reader).bp = begin_bp;
                        ((DocReader)this.comment_reader).ch = begin_ch;
                    }
                    block23: while (((DocReader)this.comment_reader).bp < ((DocReader)this.comment_reader).buflen) {
                        switch (((DocReader)this.comment_reader).ch) {
                            case '*': {
                                ((DocReader)this.comment_reader).scanCommentChar();
                                if (((DocReader)this.comment_reader).ch == '/') break block20;
                                ((DocReader)this.comment_reader).putChar('*', false);
                                continue block23;
                            }
                            case '\t': 
                            case ' ': {
                                ((DocReader)this.comment_reader).putChar(((DocReader)this.comment_reader).ch, false);
                                ((DocReader)this.comment_reader).scanCommentChar();
                                continue block23;
                            }
                            case '\f': {
                                ((DocReader)this.comment_reader).scanCommentChar();
                                break block23;
                            }
                            case '\r': {
                                ((DocReader)this.comment_reader).scanCommentChar();
                                if (((DocReader)this.comment_reader).ch != '\n') {
                                    ((DocReader)this.comment_reader).putChar('\n', false);
                                    break block23;
                                }
                            }
                            case '\n': {
                                ((DocReader)this.comment_reader).putChar(((DocReader)this.comment_reader).ch, false);
                                ((DocReader)this.comment_reader).scanCommentChar();
                                break block23;
                            }
                            default: {
                                ((DocReader)this.comment_reader).putChar(((DocReader)this.comment_reader).ch, false);
                                ((DocReader)this.comment_reader).scanCommentChar();
                                continue block23;
                            }
                        }
                    }
                    firstLine = false;
                }
                if (((DocReader)this.comment_reader).sp > 0) {
                    int i;
                    block24: for (i = ((DocReader)this.comment_reader).sp - 1; i > -1; --i) {
                        switch (((DocReader)this.comment_reader).sbuf[i]) {
                            case '*': {
                                continue block24;
                            }
                        }
                    }
                    ((DocReader)this.comment_reader).sp = i + 1;
                    this.docComment = ((DocReader)this.comment_reader).chars();
                    this.docPosns = new int[((DocReader)this.comment_reader).pp];
                    System.arraycopy(((DocReader)this.comment_reader).pbuf, 0, this.docPosns, 0, this.docPosns.length);
                } else {
                    this.docComment = "";
                }
            }
            finally {
                this.scanned = true;
                this.comment_reader = null;
                if (this.docComment != null && this.docComment.matches("(?sm).*^\\s*@deprecated( |$).*")) {
                    this.deprecatedFlag = true;
                }
            }
        }
    }

    static class DocReader
    extends UnicodeReader {
        int col;
        int startPos;
        int[] pbuf = new int[128];
        int pp = 0;

        DocReader(ScannerFactory fac, char[] input, int inputLength, int startPos) {
            super(fac, input, inputLength);
            this.startPos = startPos;
        }

        @Override
        protected void convertUnicode() {
            if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.ch = this.buf[this.bp];
                ++this.col;
                if (this.ch == 'u') {
                    do {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        ++this.col;
                    } while (this.ch == 'u');
                    int limit = this.bp + 3;
                    if (limit < this.buflen) {
                        int d;
                        int code = d = this.digit(this.bp, 16);
                        while (this.bp < limit && d >= 0) {
                            ++this.bp;
                            this.ch = this.buf[this.bp];
                            ++this.col;
                            d = this.digit(this.bp, 16);
                            code = (code << 4) + d;
                        }
                        if (d >= 0) {
                            this.ch = (char)code;
                            this.unicodeConversionBp = this.bp;
                            return;
                        }
                    }
                } else {
                    --this.bp;
                    this.ch = (char)92;
                    --this.col;
                }
            }
        }

        @Override
        protected void scanCommentChar() {
            this.scanChar();
            if (this.ch == '\\') {
                if (this.peekChar() == '\\' && !this.isUnicode()) {
                    this.putChar(this.ch, false);
                    ++this.bp;
                    ++this.col;
                } else {
                    this.convertUnicode();
                }
            }
        }

        @Override
        protected void scanChar() {
            ++this.bp;
            this.ch = this.buf[this.bp];
            switch (this.ch) {
                case '\r': {
                    this.col = 0;
                    break;
                }
                case '\n': {
                    if (this.bp != 0 && this.buf[this.bp - 1] == '\r') break;
                    this.col = 0;
                    break;
                }
                case '\t': {
                    this.col = this.col / 8 * 8 + 8;
                    break;
                }
                case '\\': {
                    ++this.col;
                    this.convertUnicode();
                    break;
                }
                default: {
                    ++this.col;
                }
            }
        }

        @Override
        public void putChar(char ch, boolean scan) {
            if (this.pp == 0 || this.sp - this.pbuf[this.pp - 2] != this.startPos + this.bp - this.pbuf[this.pp - 1]) {
                if (this.pp + 1 >= this.pbuf.length) {
                    int[] new_pbuf = new int[this.pbuf.length * 2];
                    System.arraycopy(this.pbuf, 0, new_pbuf, 0, this.pbuf.length);
                    this.pbuf = new_pbuf;
                }
                this.pbuf[this.pp] = this.sp;
                this.pbuf[this.pp + 1] = this.startPos + this.bp;
                this.pp += 2;
            }
            super.putChar(ch, scan);
        }
    }
}

