/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.loader.impl.reflect.mirror;

import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionType;
import com.redhat.ceylon.model.loader.impl.reflect.mirror.ReflectionUtils;
import com.redhat.ceylon.model.loader.mirror.AnnotationMirror;
import com.redhat.ceylon.model.loader.mirror.FieldMirror;
import com.redhat.ceylon.model.loader.mirror.TypeMirror;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;

public class ReflectionField
implements FieldMirror {
    private Field field;
    private ReflectionType type;
    private Map<String, AnnotationMirror> annotations;

    public ReflectionField(Field field) {
        this.field = field;
    }

    @Override
    public AnnotationMirror getAnnotation(String type) {
        return this.getAnnotations().get(type);
    }

    private Map<String, AnnotationMirror> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = ReflectionUtils.getAnnotations(this.field);
        }
        return this.annotations;
    }

    @Override
    public Set<String> getAnnotationNames() {
        return this.getAnnotations().keySet();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    @Override
    public boolean isDefaultAccess() {
        return !Modifier.isPrivate(this.field.getModifiers()) && !Modifier.isPublic(this.field.getModifiers()) && !Modifier.isProtected(this.field.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public TypeMirror getType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = new ReflectionType(this.field.getGenericType());
        return this.type;
    }

    public String toString() {
        return "[ReflectionField: " + this.field.toString() + "]";
    }
}

